/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.GraphSlicer;
import com.ibm.wala.util.graph.impl.DelegatingGraph;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialCallGraph
extends DelegatingGraph<CGNode>
implements CallGraph {
    protected final CallGraph cg;
    protected final Collection<CGNode> partialRoots;

    protected PartialCallGraph(CallGraph callGraph, Collection<CGNode> collection, Graph<CGNode> graph) {
        super(graph);
        this.cg = callGraph;
        this.partialRoots = collection;
    }

    public static PartialCallGraph make(CallGraph callGraph, Collection<CGNode> collection, final Collection<CGNode> collection2) {
        Graph<CGNode> graph = GraphSlicer.prune(callGraph, new Filter<CGNode>(){

            @Override
            public boolean accepts(CGNode cGNode) {
                return collection2.contains(cGNode);
            }
        });
        return new PartialCallGraph(callGraph, collection, graph);
    }

    public static PartialCallGraph make(CallGraph callGraph, Collection<CGNode> collection) {
        final Set<CGNode> set = DFS.getReachableNodes(callGraph, collection);
        Graph<CGNode> graph = GraphSlicer.prune(callGraph, new Filter<CGNode>(){

            @Override
            public boolean accepts(CGNode cGNode) {
                return set.contains(cGNode);
            }
        });
        return new PartialCallGraph(callGraph, collection, graph);
    }

    @Override
    public CGNode getFakeRootNode() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<CGNode> getEntrypointNodes() {
        return this.partialRoots;
    }

    @Override
    public CGNode getNode(IMethod iMethod, Context context) {
        CGNode cGNode = this.cg.getNode(iMethod, context);
        if (cGNode == null) {
            return null;
        }
        return this.containsNode(cGNode) ? cGNode : null;
    }

    @Override
    public Set<CGNode> getNodes(MethodReference methodReference) {
        HashSet<CGNode> hashSet = HashSetFactory.make();
        for (CGNode cGNode : this.cg.getNodes(methodReference)) {
            if (!this.containsNode(cGNode)) continue;
            hashSet.add(cGNode);
        }
        return hashSet;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cg.getClassHierarchy();
    }

    @Override
    public Iterator<CGNode> iterateNodes(IntSet intSet) {
        return new FilterIterator<CGNode>(this.cg.iterateNodes(intSet), new Filter(){

            public boolean accepts(Object object) {
                return PartialCallGraph.this.containsNode((CGNode)object);
            }
        });
    }

    @Override
    public int getMaxNumber() {
        return this.cg.getMaxNumber();
    }

    @Override
    public CGNode getNode(int n) {
        CGNode cGNode = (CGNode)this.cg.getNode(n);
        return this.containsNode(cGNode) ? cGNode : null;
    }

    @Override
    public int getNumber(CGNode cGNode) {
        return this.containsNode(cGNode) ? this.cg.getNumber(cGNode) : -1;
    }

    @Override
    public IntSet getSuccNodeNumbers(CGNode cGNode) {
        assert (this.containsNode(cGNode));
        MutableIntSet mutableIntSet = IntSetUtil.make();
        Iterator<CGNode> iterator = this.getSuccNodes(cGNode);
        while (iterator.hasNext()) {
            CGNode cGNode2 = iterator.next();
            if (!this.containsNode(cGNode2)) continue;
            mutableIntSet.add(this.getNumber(cGNode2));
        }
        return mutableIntSet;
    }

    @Override
    public IntSet getPredNodeNumbers(CGNode cGNode) {
        assert (this.containsNode(cGNode));
        MutableIntSet mutableIntSet = IntSetUtil.make();
        Iterator<CGNode> iterator = this.getPredNodes(cGNode);
        while (iterator.hasNext()) {
            CGNode cGNode2 = iterator.next();
            if (!this.containsNode(cGNode2)) continue;
            mutableIntSet.add(this.getNumber(cGNode2));
        }
        return mutableIntSet;
    }

    @Override
    public int getNumberOfTargets(CGNode cGNode, CallSiteReference callSiteReference) {
        return this.containsNode(cGNode) ? this.getPossibleTargets(cGNode, callSiteReference).size() : -1;
    }

    @Override
    public Iterator<CallSiteReference> getPossibleSites(CGNode cGNode, CGNode cGNode2) {
        return this.containsNode(cGNode) && this.containsNode(cGNode2) ? this.cg.getPossibleSites(cGNode, cGNode2) : null;
    }

    @Override
    public Set<CGNode> getPossibleTargets(CGNode cGNode, CallSiteReference callSiteReference) {
        if (!this.containsNode(cGNode)) {
            return null;
        }
        HashSet<CGNode> hashSet = HashSetFactory.make();
        for (CGNode cGNode2 : this.cg.getPossibleTargets(cGNode, callSiteReference)) {
            if (!this.containsNode(cGNode2)) continue;
            hashSet.add(cGNode2);
        }
        return hashSet;
    }
}

