/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.FakeRootClass;
import com.ibm.wala.ipa.callgraph.propagation.rta.RTAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.SyntheticIR;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractRootMethod
extends SyntheticMethod {
    protected final ArrayList<SSAInstruction> statements = new ArrayList();
    private Map<ConstantValue, Integer> constant2ValueNumber = HashMapFactory.make();
    protected int nextLocal = 2;
    protected final IClassHierarchy cha;
    private final AnalysisOptions options;
    protected final AnalysisCache cache;
    protected final SSAInstructionFactory insts;

    public AbstractRootMethod(MethodReference methodReference, IClass iClass, IClassHierarchy iClassHierarchy, AnalysisOptions analysisOptions, AnalysisCache analysisCache) {
        super(methodReference, iClass, true, false);
        this.cha = iClassHierarchy;
        this.options = analysisOptions;
        this.cache = analysisCache;
        this.insts = iClass.getClassLoader().getInstructionFactory();
        if (analysisCache == null) {
            throw new IllegalArgumentException("null cache");
        }
        if (iClass instanceof FakeRootClass) {
            ((FakeRootClass)iClass).addMethod(this);
        }
    }

    public AbstractRootMethod(MethodReference methodReference, IClassHierarchy iClassHierarchy, AnalysisOptions analysisOptions, AnalysisCache analysisCache) {
        this(methodReference, new FakeRootClass(iClassHierarchy), iClassHierarchy, analysisOptions, analysisCache);
    }

    public SSAInstruction[] getStatements(SSAOptions sSAOptions) {
        SSAInstruction[] sSAInstructionArray = new SSAInstruction[this.statements.size()];
        int n = 0;
        Iterator<SSAInstruction> iterator = this.statements.iterator();
        while (iterator.hasNext()) {
            sSAInstructionArray[n++] = iterator.next();
        }
        return sSAInstructionArray;
    }

    public IR makeIR(Context context, SSAOptions sSAOptions) {
        SSAInstruction[] sSAInstructionArray = this.getStatements(sSAOptions);
        HashMap<Integer, ConstantValue> hashMap = null;
        if (!this.constant2ValueNumber.isEmpty()) {
            hashMap = HashMapFactory.make(this.constant2ValueNumber.size());
            for (ConstantValue object2 : this.constant2ValueNumber.keySet()) {
                int n = this.constant2ValueNumber.get(object2);
                hashMap.put(n, object2);
            }
        }
        InducedCFG inducedCFG = this.makeControlFlowGraph(sSAInstructionArray);
        return new SyntheticIR(this, Everywhere.EVERYWHERE, inducedCFG, sSAInstructionArray, sSAOptions, hashMap);
    }

    public int addLocal() {
        return this.nextLocal++;
    }

    public SSAInvokeInstruction addInvocation(int[] nArray, CallSiteReference callSiteReference) {
        if (callSiteReference == null) {
            throw new IllegalArgumentException("site is null");
        }
        CallSiteReference callSiteReference2 = CallSiteReference.make(this.statements.size(), callSiteReference.getDeclaredTarget(), callSiteReference.getInvocationCode());
        SSAInvokeInstruction sSAInvokeInstruction = null;
        sSAInvokeInstruction = callSiteReference2.getDeclaredTarget().getReturnType().equals(TypeReference.Void) ? this.insts.InvokeInstruction(nArray, this.nextLocal++, callSiteReference2) : this.insts.InvokeInstruction(this.nextLocal++, nArray, this.nextLocal++, callSiteReference2);
        this.statements.add(sSAInvokeInstruction);
        this.cache.invalidate(this, Everywhere.EVERYWHERE);
        return sSAInvokeInstruction;
    }

    public SSAReturnInstruction addReturn(int n, boolean bl) {
        SSAReturnInstruction sSAReturnInstruction = this.insts.ReturnInstruction(n, bl);
        this.statements.add(sSAReturnInstruction);
        this.cache.invalidate(this, Everywhere.EVERYWHERE);
        return sSAReturnInstruction;
    }

    public SSANewInstruction addAllocation(TypeReference typeReference) {
        return this.addAllocation(typeReference, true);
    }

    public SSANewInstruction add1DArrayAllocation(TypeReference typeReference, int n) {
        int n2 = this.nextLocal++;
        NewSiteReference newSiteReference = NewSiteReference.make(this.statements.size(), typeReference);
        assert (typeReference.isArrayType());
        assert (typeReference.getDimensionality() == 1);
        int[] nArray = new int[1];
        Arrays.fill(nArray, this.getValueNumberForIntConstant(n));
        SSANewInstruction sSANewInstruction = this.insts.NewInstruction(n2, newSiteReference, nArray);
        this.statements.add(sSANewInstruction);
        this.cache.invalidate(this, Everywhere.EVERYWHERE);
        return sSANewInstruction;
    }

    public SSANewInstruction addAllocationWithoutCtor(TypeReference typeReference) {
        return this.addAllocation(typeReference, false);
    }

    private SSANewInstruction addAllocation(TypeReference typeReference, boolean bl) {
        if (typeReference == null) {
            throw new IllegalArgumentException("T is null");
        }
        int n = this.nextLocal++;
        SSANewInstruction sSANewInstruction = null;
        if (typeReference.isReferenceType()) {
            IMethod iMethod;
            Object object;
            NewSiteReference newSiteReference = NewSiteReference.make(this.statements.size(), typeReference);
            if (typeReference.isArrayType()) {
                object = new int[typeReference.getDimensionality()];
                Arrays.fill((int[])object, this.getValueNumberForIntConstant(1));
                sSANewInstruction = this.insts.NewInstruction(n, newSiteReference, (int[])object);
            } else {
                sSANewInstruction = this.insts.NewInstruction(n, newSiteReference);
            }
            this.statements.add(sSANewInstruction);
            object = this.cha.lookupClass(typeReference);
            if (object == null) {
                Warnings.add(AllocationFailure.create(typeReference));
                return null;
            }
            if (object.isArrayClass()) {
                int n2 = sSANewInstruction.getDef();
                TypeReference typeReference2 = object.getReference().getArrayElementType();
                while (typeReference2 != null && !typeReference2.isPrimitiveType()) {
                    int n3;
                    Object object2;
                    NewSiteReference newSiteReference2 = NewSiteReference.make(this.statements.size(), typeReference2);
                    ++this.nextLocal;
                    SSANewInstruction sSANewInstruction2 = null;
                    if (typeReference2.isArrayType()) {
                        object2 = new int[typeReference.getDimensionality()];
                        Arrays.fill(object2, this.getValueNumberForIntConstant(1));
                        sSANewInstruction2 = this.insts.NewInstruction(n3, newSiteReference2, (int[])object2);
                    } else {
                        sSANewInstruction2 = this.insts.NewInstruction(n3, newSiteReference2);
                    }
                    this.statements.add(sSANewInstruction2);
                    object2 = this.insts.ArrayStoreInstruction(n2, this.getValueNumberForIntConstant(0), n3, typeReference2);
                    this.statements.add((SSAInstruction)object2);
                    typeReference2 = typeReference2.isArrayType() ? typeReference2.getArrayElementType() : null;
                    n2 = n3;
                }
            }
            if (bl && (iMethod = this.cha.resolveMethod((IClass)object, MethodReference.initSelector)) != null) {
                this.addInvocation(new int[]{n}, CallSiteReference.make(this.statements.size(), iMethod.getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.SPECIAL));
            }
        }
        this.cache.invalidate(this, Everywhere.EVERYWHERE);
        return sSANewInstruction;
    }

    protected int getValueNumberForIntConstant(int n) {
        ConstantValue constantValue = new ConstantValue(n);
        Integer n2 = this.constant2ValueNumber.get(constantValue);
        if (n2 == null) {
            n2 = this.nextLocal++;
            this.constant2ValueNumber.put(constantValue, n2);
        }
        return n2;
    }

    protected int getValueNumberForByteConstant(byte by) {
        ConstantValue constantValue = new ConstantValue(by);
        Integer n = this.constant2ValueNumber.get(constantValue);
        if (n == null) {
            n = this.nextLocal++;
            this.constant2ValueNumber.put(constantValue, n);
        }
        return n;
    }

    protected int getValueNumberForCharConstant(char c) {
        ConstantValue constantValue = new ConstantValue(c);
        Integer n = this.constant2ValueNumber.get(constantValue);
        if (n == null) {
            n = this.nextLocal++;
            this.constant2ValueNumber.put(constantValue, n);
        }
        return n;
    }

    public int addPhi(int[] nArray) {
        int n = this.nextLocal++;
        SSAPhiInstruction sSAPhiInstruction = this.insts.PhiInstruction(n, nArray);
        this.statements.add(sSAPhiInstruction);
        return n;
    }

    public int addGetInstance(FieldReference fieldReference, int n) {
        int n2 = this.nextLocal++;
        this.statements.add(this.insts.GetInstruction(n2, n, fieldReference));
        return n2;
    }

    public int addGetStatic(FieldReference fieldReference) {
        int n = this.nextLocal++;
        this.statements.add(this.insts.GetInstruction(n, fieldReference));
        return n;
    }

    public int addCheckcast(TypeReference[] typeReferenceArray, int n) {
        int n2 = this.nextLocal++;
        this.statements.add(this.insts.CheckCastInstruction(n2, n, typeReferenceArray));
        return n2;
    }

    public RTAContextInterpreter getInterpreter() {
        return new RTAContextInterpreter(){

            @Override
            public Iterator<NewSiteReference> iterateNewSites(CGNode cGNode) {
                ArrayList<NewSiteReference> arrayList = new ArrayList<NewSiteReference>();
                SSAInstruction[] sSAInstructionArray = AbstractRootMethod.this.getStatements(AbstractRootMethod.this.options.getSSAOptions());
                int n = 0;
                while (n < sSAInstructionArray.length) {
                    if (sSAInstructionArray[n] instanceof SSANewInstruction) {
                        SSANewInstruction sSANewInstruction = (SSANewInstruction)sSAInstructionArray[n];
                        arrayList.add(sSANewInstruction.getNewSite());
                    }
                    ++n;
                }
                return arrayList.iterator();
            }

            public Iterator<SSAInstruction> getInvokeStatements() {
                ArrayList<SSAInstruction> arrayList = new ArrayList<SSAInstruction>();
                SSAInstruction[] sSAInstructionArray = AbstractRootMethod.this.getStatements(AbstractRootMethod.this.options.getSSAOptions());
                int n = 0;
                while (n < sSAInstructionArray.length) {
                    if (sSAInstructionArray[n] instanceof SSAInvokeInstruction) {
                        arrayList.add(sSAInstructionArray[n]);
                    }
                    ++n;
                }
                return arrayList.iterator();
            }

            @Override
            public Iterator<CallSiteReference> iterateCallSites(CGNode cGNode) {
                final Iterator<SSAInstruction> iterator = this.getInvokeStatements();
                return new Iterator<CallSiteReference>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public CallSiteReference next() {
                        SSAInvokeInstruction sSAInvokeInstruction = (SSAInvokeInstruction)iterator.next();
                        return sSAInvokeInstruction.getCallSite();
                    }

                    @Override
                    public void remove() {
                        Assertions.UNREACHABLE();
                    }
                };
            }

            @Override
            public boolean understands(CGNode cGNode) {
                return cGNode.getMethod().getDeclaringClass().getReference().equals(FakeRootClass.FAKE_ROOT_CLASS);
            }

            @Override
            public boolean recordFactoryType(CGNode cGNode, IClass iClass) {
                return false;
            }

            @Override
            public Iterator<FieldReference> iterateFieldsRead(CGNode cGNode) {
                return EmptyIterator.instance();
            }

            @Override
            public Iterator<FieldReference> iterateFieldsWritten(CGNode cGNode) {
                return EmptyIterator.instance();
            }
        };
    }

    private static class AllocationFailure
    extends Warning {
        final TypeReference t;

        AllocationFailure(TypeReference typeReference) {
            super((byte)2);
            this.t = typeReference;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.t;
        }

        public static AllocationFailure create(TypeReference typeReference) {
            return new AllocationFailure(typeReference);
        }
    }
}

