/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph;

import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.BytecodeConstants;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Arrays;

public abstract class Entrypoint
implements BytecodeConstants {
    protected final IMethod method;

    protected Entrypoint(IMethod iMethod) {
        if (iMethod == null) {
            throw new IllegalArgumentException("method is null");
        }
        this.method = iMethod;
        assert (iMethod.getDeclaringClass() != null) : "null declaring class";
    }

    protected Entrypoint(MethodReference methodReference, IClassHierarchy iClassHierarchy) {
        if (iClassHierarchy == null) {
            throw new IllegalArgumentException("cha is null");
        }
        IMethod iMethod = iClassHierarchy.resolveMethod(methodReference);
        if (iMethod == null) {
            Assertions.UNREACHABLE("could not resolve " + methodReference);
        }
        this.method = iMethod;
    }

    public CallSiteReference makeSite(int n) {
        if (this.method.getSelector().equals(MethodReference.clinitSelector)) {
            assert (this.method.isStatic());
            return CallSiteReference.make(n, this.method.getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC);
        }
        if (this.method.getSelector().equals(MethodReference.initSelector)) {
            assert (!this.method.isStatic());
            return CallSiteReference.make(n, this.method.getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.SPECIAL);
        }
        if (this.method.getDeclaringClass().isInterface()) {
            return CallSiteReference.make(n, this.method.getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.INTERFACE);
        }
        if (this.method.isStatic()) {
            return CallSiteReference.make(n, this.method.getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC);
        }
        return CallSiteReference.make(n, this.method.getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.VIRTUAL);
    }

    protected int makeArgument(AbstractRootMethod abstractRootMethod, int n) {
        Object object;
        TypeReference[] typeReferenceArray = this.getParameterTypes(n);
        if (typeReferenceArray.length == 0) {
            return -1;
        }
        if (typeReferenceArray.length == 1) {
            if (typeReferenceArray[0].isPrimitiveType()) {
                return abstractRootMethod.addLocal();
            }
            SSANewInstruction sSANewInstruction = abstractRootMethod.addAllocation(typeReferenceArray[0]);
            return sSANewInstruction == null ? -1 : sSANewInstruction.getDef();
        }
        int[] nArray = new int[typeReferenceArray.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < typeReferenceArray.length) {
            int n4;
            object = abstractRootMethod.addAllocation(typeReferenceArray[n3]);
            int n5 = n4 = object == null ? -1 : ((SSANewInstruction)object).getDef();
            if (n4 == -1) {
                ++n2;
            } else {
                nArray[n3 - n2] = n4;
            }
            ++n3;
        }
        if (n2 > 0) {
            int[] nArray2 = nArray;
            nArray = new int[nArray2.length - n2];
            System.arraycopy(nArray2, 0, nArray, 0, nArray.length);
        }
        if (typeReferenceArray[0].isPrimitiveType()) {
            TypeAbstraction typeAbstraction = PrimitiveType.getPrimitive(typeReferenceArray[0]);
            n = 1;
            while (n < typeReferenceArray.length) {
                typeAbstraction = ((TypeAbstraction)typeAbstraction).meet(PrimitiveType.getPrimitive(typeReferenceArray[n]));
                ++n;
            }
        } else {
            object = abstractRootMethod.getClassHierarchy();
            IClass iClass = object.lookupClass(typeReferenceArray[0]);
            TypeAbstraction typeAbstraction = new ConeType(iClass);
            n = 1;
            while (n < typeReferenceArray.length) {
                IClass iClass2 = object.lookupClass(typeReferenceArray[n]);
                typeAbstraction = ((TypeAbstraction)typeAbstraction).meet(new ConeType(iClass2));
                ++n;
            }
        }
        return abstractRootMethod.addPhi(nArray);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public SSAAbstractInvokeInstruction addCall(AbstractRootMethod abstractRootMethod) {
        CallSiteReference callSiteReference = this.makeSite(0);
        if (callSiteReference == null) {
            return null;
        }
        int[] nArray = new int[this.getNumberOfParameters()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.makeArgument(abstractRootMethod, n);
            if (nArray[n] == -1) {
                return null;
            }
            ++n;
        }
        return abstractRootMethod.addInvocation(nArray, callSiteReference);
    }

    public IMethod getMethod() {
        return this.method;
    }

    public abstract TypeReference[] getParameterTypes(int var1);

    public abstract int getNumberOfParameters();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.method.toString());
        stringBuffer.append("(");
        int n = 0;
        while (n < this.getNumberOfParameters() - 1) {
            stringBuffer.append(Arrays.toString(this.getParameterTypes(n)));
            stringBuffer.append(",");
            ++n;
        }
        if (this.getNumberOfParameters() > 0) {
            stringBuffer.append(Arrays.toString(this.getParameterTypes(this.getNumberOfParameters() - 1)));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.method.hashCode() * 1009;
    }
}

