/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallGraphStats {
    public static CGStats getCGStats(CallGraph callGraph) {
        if (callGraph == null) {
            throw new IllegalArgumentException("cg is null");
        }
        Set<CGNode> set = DFS.getReachableNodes(callGraph, Collections.singleton(callGraph.getFakeRootNode()));
        int n = 0;
        int n2 = 0;
        for (CGNode cGNode : set) {
            ++n;
            n2 += callGraph.getSuccNodeCount(cGNode);
        }
        return new CGStats(n, n2, CallGraphStats.collectMethods(callGraph).size(), CallGraphStats.countBytecodeBytes(callGraph));
    }

    public static String getStats(CallGraph callGraph) {
        return CallGraphStats.getCGStats(callGraph).toString();
    }

    public static int countBytecodeBytes(CallGraph callGraph) {
        if (callGraph == null) {
            throw new IllegalArgumentException("cg is null");
        }
        int n = 0;
        HashSet hashSet = HashSetFactory.make();
        for (CGNode cGNode : callGraph) {
            byte[] byArray;
            IMethod iMethod = cGNode.getMethod();
            if (!hashSet.add(iMethod) || !(iMethod instanceof ShrikeCTMethod) || (byArray = ((ShrikeCTMethod)iMethod).getBytecodes()) == null) continue;
            n += byArray.length;
        }
        return n;
    }

    public static Set<MethodReference> collectMethods(CallGraph callGraph) {
        if (callGraph == null) {
            throw new IllegalArgumentException("cg is null");
        }
        HashSet<MethodReference> hashSet = HashSetFactory.make();
        for (CGNode cGNode : callGraph) {
            hashSet.add(cGNode.getMethod().getReference());
        }
        return hashSet;
    }

    public static class CGStats {
        private final int nNodes;
        private final int nEdges;
        private final int nMethods;
        private final int bytecodeBytes;

        private CGStats(int n, int n2, int n3, int n4) {
            this.nNodes = n;
            this.nEdges = n2;
            this.nMethods = n3;
            this.bytecodeBytes = n4;
        }

        public int getNNodes() {
            return this.nNodes;
        }

        public int getNEdges() {
            return this.nEdges;
        }

        public int getNMethods() {
            return this.nMethods;
        }

        public int getBytecodeBytes() {
            return this.bytecodeBytes;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.bytecodeBytes;
            n = 31 * n + this.nEdges;
            n = 31 * n + this.nMethods;
            n = 31 * n + this.nNodes;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CGStats cGStats = (CGStats)object;
            if (this.bytecodeBytes != cGStats.bytecodeBytes) {
                return false;
            }
            if (this.nEdges != cGStats.nEdges) {
                return false;
            }
            if (this.nMethods != cGStats.nMethods) {
                return false;
            }
            return this.nNodes == cGStats.nNodes;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Call graph stats:");
            stringBuffer.append("\n");
            stringBuffer.append("  Nodes: " + this.nNodes);
            stringBuffer.append("\n");
            stringBuffer.append("  Edges: " + this.nEdges);
            stringBuffer.append("\n");
            stringBuffer.append("  Methods: " + this.nMethods);
            stringBuffer.append("\n");
            stringBuffer.append("  Bytecode Bytes: " + this.bytecodeBytes);
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }
}

