/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.fixedpoint.impl;

import com.ibm.wala.fixedpoint.impl.AbstractOperator;
import com.ibm.wala.fixedpoint.impl.AbstractStatement;
import com.ibm.wala.fixedpoint.impl.BasicNullaryStatement;
import com.ibm.wala.fixedpoint.impl.GeneralStatement;
import com.ibm.wala.fixedpoint.impl.NullaryOperator;
import com.ibm.wala.fixedpoint.impl.UnaryOperator;
import com.ibm.wala.fixedpoint.impl.UnaryStatement;
import com.ibm.wala.fixedpoint.impl.Worklist;
import com.ibm.wala.fixpoint.FixedPointConstants;
import com.ibm.wala.fixpoint.IFixedPointSolver;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.debug.VerboseAction;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFixedPointSolver<T extends IVariable>
implements IFixedPointSolver<T>,
FixedPointConstants,
VerboseAction {
    static final boolean DEBUG = false;
    public static final boolean verbose = "true".equals(System.getProperty("com.ibm.wala.fixedpoint.impl.verbose"));
    public static final int DEFAULT_VERBOSE_INTERVAL = 100000;
    static final boolean MORE_VERBOSE = true;
    public static final int DEFAULT_PERIODIC_MAINTENANCE_INTERVAL = 100000;
    private int minSizeForTopSort = 0;
    private double topologicalGrowthFactor = 0.1;
    private int maxEvalBetweenTopo = 500000;
    private int evaluationsAtLastOrdering = 0;
    int topologicalCounter = 0;
    int nextOrderNumber = 1;
    private int nEvaluated = 0;
    private int nCreated = 0;
    protected Worklist workList = new Worklist();
    private boolean firstSolve = true;

    public void initForFirstSolve() {
        this.orderStatements();
        this.initializeVariables();
        this.initializeWorkList();
        this.firstSolve = false;
    }

    public boolean emptyWorkList() {
        return this.workList.isEmpty();
    }

    @Override
    public boolean solve(IProgressMonitor iProgressMonitor) throws CancelException {
        boolean bl = false;
        if (this.firstSolve) {
            this.initForFirstSolve();
        }
        while (!this.workList.isEmpty()) {
            MonitorUtil.throwExceptionIfCanceled(iProgressMonitor);
            this.orderStatements();
            AbstractStatement abstractStatement = this.workList.takeStatement();
            byte by = abstractStatement.evaluate();
            if (verbose) {
                ++this.nEvaluated;
                if (this.nEvaluated % this.getVerboseInterval() == 0) {
                    this.performVerboseAction();
                }
                if (this.nEvaluated % this.getPeriodicMaintainInterval() == 0) {
                    this.periodicMaintenance();
                }
            }
            if (AbstractFixedPointSolver.isChanged(by)) {
                bl = true;
                this.updateWorkList(abstractStatement);
            }
            if (!AbstractFixedPointSolver.isFixed(by)) continue;
            this.removeStatement(abstractStatement);
        }
        return bl;
    }

    @Override
    public void performVerboseAction() {
        System.err.println("Evaluated " + this.nEvaluated);
        System.err.println("Created   " + this.nCreated);
        System.err.println("Worklist  " + this.workList.size());
        if (!this.workList.isEmpty()) {
            AbstractStatement abstractStatement = this.workList.takeStatement();
            System.err.println("Peek      " + AbstractFixedPointSolver.lineBreak(abstractStatement.toString(), 132));
            if (abstractStatement instanceof VerboseAction) {
                ((VerboseAction)((Object)abstractStatement)).performVerboseAction();
            }
            this.workList.insertStatement(abstractStatement);
        }
    }

    public static String lineBreak(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("string is null");
        }
        if (string.length() > n) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < string.length()) {
                int n3 = Math.min(n2 + n, string.length());
                stringBuffer.append(string.substring(n2, n3));
                stringBuffer.append("\n  ");
                n2 = n3;
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public void removeStatement(AbstractStatement<T, ?> abstractStatement) {
        this.getFixedPointSystem().removeStatement(abstractStatement);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Fixed Point Sytem:\n");
        Iterator iterator = this.getStatements();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next()).append("\n");
        }
        return stringBuffer.toString();
    }

    public Iterator getStatements() {
        return this.getFixedPointSystem().getStatements();
    }

    public void addToWorkList(AbstractStatement abstractStatement) {
        this.workList.insertStatement(abstractStatement);
    }

    public void addAllStatementsToWorkList() {
        Iterator iterator = this.getStatements();
        while (iterator.hasNext()) {
            AbstractStatement abstractStatement = (AbstractStatement)iterator.next();
            this.addToWorkList(abstractStatement);
        }
    }

    public void changedVariable(T t) {
        Iterator iterator = this.getFixedPointSystem().getStatementsThatUse(t);
        while (iterator.hasNext()) {
            AbstractStatement abstractStatement = (AbstractStatement)iterator.next();
            this.addToWorkList(abstractStatement);
        }
    }

    public void newStatement(T t, NullaryOperator<T> nullaryOperator, boolean bl, boolean bl2) {
        if (t == null) {
            throw new IllegalArgumentException("lhs is null");
        }
        t.setOrderNumber(this.nextOrderNumber++);
        BasicNullaryStatement<T> basicNullaryStatement = new BasicNullaryStatement<T>(t, nullaryOperator);
        if (this.getFixedPointSystem().containsStatement(basicNullaryStatement)) {
            return;
        }
        ++this.nCreated;
        this.getFixedPointSystem().addStatement(basicNullaryStatement);
        this.incorporateNewStatement(bl, bl2, basicNullaryStatement);
        ++this.topologicalCounter;
    }

    private void incorporateNewStatement(boolean bl, boolean bl2, AbstractStatement abstractStatement) {
        if (bl2) {
            byte by = abstractStatement.evaluate();
            if (verbose) {
                ++this.nEvaluated;
                if (this.nEvaluated % this.getVerboseInterval() == 0) {
                    this.performVerboseAction();
                }
                if (this.nEvaluated % this.getPeriodicMaintainInterval() == 0) {
                    this.periodicMaintenance();
                }
            }
            if (AbstractFixedPointSolver.isChanged(by)) {
                this.updateWorkList(abstractStatement);
            }
            if (AbstractFixedPointSolver.isFixed(by)) {
                this.removeStatement(abstractStatement);
            }
        } else if (bl) {
            this.addToWorkList(abstractStatement);
        }
    }

    public boolean newStatement(T t, UnaryOperator<T> unaryOperator, T t2, boolean bl, boolean bl2) {
        if (unaryOperator == null) {
            throw new IllegalArgumentException("operator is null");
        }
        UnaryStatement<T> unaryStatement = unaryOperator.makeEquation(t, t2);
        if (this.getFixedPointSystem().containsStatement(unaryStatement)) {
            return false;
        }
        if (t != null) {
            t.setOrderNumber(this.nextOrderNumber++);
        }
        ++this.nCreated;
        this.getFixedPointSystem().addStatement(unaryStatement);
        this.incorporateNewStatement(bl, bl2, unaryStatement);
        ++this.topologicalCounter;
        return true;
    }

    public void newStatement(T t, AbstractOperator<T> abstractOperator, T t2, T t3, boolean bl, boolean bl2) {
        GeneralStatement<T> generalStatement = new GeneralStatement<T>(t, abstractOperator, t2, t3);
        if (this.getFixedPointSystem().containsStatement(generalStatement)) {
            return;
        }
        if (t != null) {
            t.setOrderNumber(this.nextOrderNumber++);
        }
        ++this.nCreated;
        this.getFixedPointSystem().addStatement(generalStatement);
        this.incorporateNewStatement(bl, bl2, generalStatement);
        ++this.topologicalCounter;
    }

    public void newStatement(T t, AbstractOperator<T> abstractOperator, T t2, T t3, T t4, boolean bl, boolean bl2) {
        if (t == null) {
            throw new IllegalArgumentException("lhs is null");
        }
        t.setOrderNumber(this.nextOrderNumber++);
        GeneralStatement<T> generalStatement = new GeneralStatement<T>(t, abstractOperator, t2, t3, t4);
        if (this.getFixedPointSystem().containsStatement(generalStatement)) {
            --this.nextOrderNumber;
            return;
        }
        ++this.nCreated;
        this.getFixedPointSystem().addStatement(generalStatement);
        this.incorporateNewStatement(bl, bl2, generalStatement);
        ++this.topologicalCounter;
    }

    public void newStatement(T t, AbstractOperator<T> abstractOperator, IVariable[] iVariableArray, boolean bl, boolean bl2) {
        if (t != null) {
            t.setOrderNumber(this.nextOrderNumber++);
        }
        GeneralStatement<T> generalStatement = new GeneralStatement<T>(t, abstractOperator, iVariableArray);
        if (this.getFixedPointSystem().containsStatement(generalStatement)) {
            --this.nextOrderNumber;
            return;
        }
        ++this.nCreated;
        this.getFixedPointSystem().addStatement(generalStatement);
        this.incorporateNewStatement(bl, bl2, generalStatement);
        ++this.topologicalCounter;
    }

    protected abstract void initializeVariables();

    protected abstract void initializeWorkList();

    private void updateWorkList(AbstractStatement<T, ?> abstractStatement) {
        Object t = abstractStatement.getLHS();
        if (t == null) {
            return;
        }
        this.changedVariable(t);
    }

    private void orderStatementsInternal() {
        if (verbose && this.nEvaluated > 0) {
            System.err.println("Reorder " + this.nEvaluated + " " + this.nCreated);
        }
        this.reorder();
        if (verbose && this.nEvaluated > 0) {
            System.err.println("Reorder finished " + this.nEvaluated + " " + this.nCreated);
        }
        this.topologicalCounter = 0;
        this.evaluationsAtLastOrdering = this.nEvaluated;
    }

    public void orderStatements() {
        if (this.nextOrderNumber > this.minSizeForTopSort && (double)this.topologicalCounter / (double)this.nextOrderNumber > this.topologicalGrowthFactor) {
            this.orderStatementsInternal();
            return;
        }
        if (this.nEvaluated - this.evaluationsAtLastOrdering > this.maxEvalBetweenTopo) {
            this.orderStatementsInternal();
            return;
        }
    }

    private void reorder() {
        LinkedList<AbstractStatement> linkedList = new LinkedList<AbstractStatement>();
        while (!this.workList.isEmpty()) {
            AbstractStatement abstractStatement = this.workList.takeStatement();
            linkedList.add(abstractStatement);
        }
        this.workList = new Worklist();
        this.getFixedPointSystem().reorder();
        for (AbstractStatement abstractStatement : linkedList) {
            this.workList.insertStatement(abstractStatement);
        }
    }

    public static boolean isChanged(byte by) {
        return (by & 1) != 0;
    }

    public static boolean isSideEffect(byte by) {
        return (by & 4) != 0;
    }

    public static boolean isFixed(byte by) {
        return (by & 2) != 0;
    }

    public int getMinSizeForTopSort() {
        return this.minSizeForTopSort;
    }

    public void setMinEquationsForTopSort(int n) {
        this.minSizeForTopSort = n;
    }

    public int getMaxEvalBetweenTopo() {
        return this.maxEvalBetweenTopo;
    }

    public double getTopologicalGrowthFactor() {
        return this.topologicalGrowthFactor;
    }

    public void setMaxEvalBetweenTopo(int n) {
        this.maxEvalBetweenTopo = n;
    }

    public void setTopologicalGrowthFactor(double d) {
        this.topologicalGrowthFactor = d;
    }

    public int getNumberOfEvaluations() {
        return this.nEvaluated;
    }

    public void incNumberOfEvaluations() {
        ++this.nEvaluated;
    }

    protected void periodicMaintenance() {
    }

    protected int getVerboseInterval() {
        return 100000;
    }

    protected int getPeriodicMaintainInterval() {
        return 100000;
    }
}

