/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.escape;

import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Set;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalLiveRangeAnalysis {
    public static boolean isLive(int n, int n2, IR iR, DefUse defUse) {
        if (defUse == null) {
            throw new IllegalArgumentException("du is null");
        }
        if (defUse.getNumberOfUses(n) == 0) {
            return false;
        }
        if (n2 < 0) {
            Assertions.UNREACHABLE();
        }
        ISSABasicBlock iSSABasicBlock = LocalLiveRangeAnalysis.findBlock(iR, n2);
        SSAInstruction sSAInstruction = defUse.getDef(n);
        final SSACFG.BasicBlock basicBlock = sSAInstruction == null ? null : LocalLiveRangeAnalysis.findBlock(iR, sSAInstruction);
        Collection<SSACFG.BasicBlock> collection = LocalLiveRangeAnalysis.findBlocks(iR, defUse.getUses(n));
        Filter filter = new Filter(){

            public boolean accepts(Object object) {
                return basicBlock == null || !basicBlock.equals(object);
            }
        };
        if (basicBlock != null && basicBlock.equals(iSSABasicBlock)) {
            return true;
        }
        Collection<ISSABasicBlock> collection2 = DFS.getReachableNodes(iR.getControlFlowGraph(), Collections.singleton(iSSABasicBlock), filter);
        collection.retainAll(collection2);
        if (collection.isEmpty()) {
            return false;
        }
        if (collection.size() == 1 && collection.iterator().next().equals(iSSABasicBlock)) {
            if (n2 == iSSABasicBlock.getLastInstructionIndex()) {
                return iR.getInstructions()[n2] instanceof SSAReturnInstruction;
            }
            return true;
        }
        return true;
    }

    private static Collection<SSACFG.BasicBlock> findBlocks(IR iR, Iterator<SSAInstruction> iterator) {
        Iterator2Set<SSAInstruction> iterator2Set = Iterator2Collection.toSet(iterator);
        HashSet<SSACFG.BasicBlock> hashSet = HashSetFactory.make();
        block0: for (SSACFG.BasicBlock basicBlock : iR.getControlFlowGraph()) {
            for (SSAInstruction sSAInstruction : basicBlock) {
                if (!iterator2Set.contains(sSAInstruction)) continue;
                hashSet.add(basicBlock);
                continue block0;
            }
        }
        if (hashSet.isEmpty()) {
            Assertions.UNREACHABLE();
        }
        return hashSet;
    }

    private static SSACFG.BasicBlock findBlock(IR iR, SSAInstruction sSAInstruction) {
        if (sSAInstruction == null) {
            Assertions.UNREACHABLE();
        }
        for (SSACFG.BasicBlock basicBlock : iR.getControlFlowGraph()) {
            for (SSAInstruction sSAInstruction2 : basicBlock) {
                if (!sSAInstruction.equals(sSAInstruction2)) continue;
                return basicBlock;
            }
        }
        Assertions.UNREACHABLE("no block for " + sSAInstruction + " in IR " + iR);
        return null;
    }

    private static ISSABasicBlock findBlock(IR iR, int n) {
        for (SSACFG.BasicBlock basicBlock : iR.getControlFlowGraph()) {
            if (n < basicBlock.getFirstInstructionIndex() || n > basicBlock.getLastInstructionIndex()) continue;
            return basicBlock;
        }
        Assertions.UNREACHABLE("no block for " + n + " in IR " + iR);
        return null;
    }
}

