/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.util;

import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SymbolTable;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointerParamValueNumIterator
implements Iterator<Integer> {
    final TypeInference ti;
    final SymbolTable symbolTable;
    final int numParams;
    int paramInd;
    int nextParameter;

    public PointerParamValueNumIterator(CGNode cGNode) throws IllegalArgumentException {
        if (cGNode == null) {
            throw new IllegalArgumentException("node == null");
        }
        IR iR = cGNode.getIR();
        this.ti = TypeInference.make(iR, false);
        this.symbolTable = iR.getSymbolTable();
        this.numParams = this.symbolTable.getNumberOfParameters();
        this.paramInd = 0;
        this.setNextParameter();
    }

    private void setNextParameter() {
        int n = this.paramInd;
        while (n < this.numParams) {
            int n2 = this.symbolTable.getParameter(n);
            TypeAbstraction typeAbstraction = this.ti.getType(n2);
            if (typeAbstraction != null) {
                this.nextParameter = n2;
                break;
            }
            ++n;
        }
        this.paramInd = ++n;
    }

    @Override
    public boolean hasNext() {
        return this.paramInd <= this.numParams;
    }

    @Override
    public Integer next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int n = this.nextParameter;
        this.setNextParameter();
        return n;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

