/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.util;

import com.ibm.wala.classLoader.IField;
import com.ibm.wala.demandpa.util.MemoryAccess;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.SDG;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ipa.slicer.thin.CISlicer;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.debug.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PABasedMemoryAccessMap
implements MemoryAccessMap {
    private static final boolean DEBUG = false;
    private final PointerAnalysis pa;
    private final HeapModel heapModel;
    private final Map<PointerKey, Set<Statement>> invMod;
    private final Map<PointerKey, Set<Statement>> invRef;

    public PABasedMemoryAccessMap(CallGraph callGraph, PointerAnalysis pointerAnalysis) {
        this(callGraph, pointerAnalysis, new SDG(callGraph, pointerAnalysis, Slicer.DataDependenceOptions.NO_BASE_NO_HEAP_NO_EXCEPTIONS, Slicer.ControlDependenceOptions.NONE));
    }

    public PABasedMemoryAccessMap(CallGraph callGraph, PointerAnalysis pointerAnalysis, SDG sDG) {
        this(callGraph, pointerAnalysis, CISlicer.scanForMod(sDG, pointerAnalysis, true, ModRef.make()), CISlicer.scanForRef(sDG, pointerAnalysis));
    }

    public PABasedMemoryAccessMap(CallGraph callGraph, PointerAnalysis pointerAnalysis, Map<Statement, Set<PointerKey>> map, Map<Statement, Set<PointerKey>> map2) {
        if (pointerAnalysis == null) {
            throw new IllegalArgumentException("null pa");
        }
        this.pa = pointerAnalysis;
        this.heapModel = pointerAnalysis.getHeapModel();
        this.invMod = MapUtil.inverseMap(map);
        this.invRef = MapUtil.inverseMap(map2);
    }

    @Override
    public Collection<MemoryAccess> getArrayReads(PointerKey pointerKey) {
        ArrayList<MemoryAccess> arrayList = new ArrayList<MemoryAccess>();
        for (InstanceKey instanceKey : this.pa.getPointsToSet(pointerKey)) {
            PointerKey pointerKey2 = this.heapModel.getPointerKeyForArrayContents(instanceKey);
            this.convertStmtsToMemoryAccess((Collection<Statement>)this.invRef.get(pointerKey2), arrayList);
        }
        return arrayList;
    }

    @Override
    public Collection<MemoryAccess> getArrayWrites(PointerKey pointerKey) {
        ArrayList<MemoryAccess> arrayList = new ArrayList<MemoryAccess>();
        for (InstanceKey instanceKey : this.pa.getPointsToSet(pointerKey)) {
            PointerKey pointerKey2 = this.heapModel.getPointerKeyForArrayContents(instanceKey);
            this.convertStmtsToMemoryAccess((Collection<Statement>)this.invMod.get(pointerKey2), arrayList);
        }
        return arrayList;
    }

    @Override
    public Collection<MemoryAccess> getFieldReads(PointerKey pointerKey, IField iField) {
        ArrayList<MemoryAccess> arrayList = new ArrayList<MemoryAccess>();
        for (InstanceKey instanceKey : this.pa.getPointsToSet(pointerKey)) {
            PointerKey pointerKey2 = this.heapModel.getPointerKeyForInstanceField(instanceKey, iField);
            this.convertStmtsToMemoryAccess((Collection<Statement>)this.invRef.get(pointerKey2), arrayList);
        }
        return arrayList;
    }

    @Override
    public Collection<MemoryAccess> getFieldWrites(PointerKey pointerKey, IField iField) {
        ArrayList<MemoryAccess> arrayList = new ArrayList<MemoryAccess>();
        for (InstanceKey instanceKey : this.pa.getPointsToSet(pointerKey)) {
            PointerKey pointerKey2 = this.heapModel.getPointerKeyForInstanceField(instanceKey, iField);
            this.convertStmtsToMemoryAccess((Collection<Statement>)this.invMod.get(pointerKey2), arrayList);
        }
        return arrayList;
    }

    @Override
    public Collection<MemoryAccess> getStaticFieldReads(IField iField) {
        ArrayList<MemoryAccess> arrayList = new ArrayList<MemoryAccess>();
        this.convertStmtsToMemoryAccess((Collection<Statement>)this.invRef.get(this.heapModel.getPointerKeyForStaticField(iField)), arrayList);
        return arrayList;
    }

    @Override
    public Collection<MemoryAccess> getStaticFieldWrites(IField iField) {
        ArrayList<MemoryAccess> arrayList = new ArrayList<MemoryAccess>();
        this.convertStmtsToMemoryAccess((Collection<Statement>)this.invMod.get(this.heapModel.getPointerKeyForStaticField(iField)), arrayList);
        return arrayList;
    }

    private void convertStmtsToMemoryAccess(Collection<Statement> collection, Collection<MemoryAccess> collection2) {
        if (collection == null) {
            return;
        }
        for (Statement statement : collection) {
            switch (statement.getKind()) {
                case NORMAL: {
                    NormalStatement normalStatement = (NormalStatement)statement;
                    collection2.add(new MemoryAccess(normalStatement.getInstructionIndex(), normalStatement.getNode()));
                    break;
                }
                default: {
                    Assertions.UNREACHABLE();
                }
            }
        }
    }

    @Override
    public HeapModel getHeapModel() {
        return this.heapModel;
    }
}

