/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.util;

import com.ibm.wala.analysis.reflection.InstanceKeyWithNode;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AbstractLocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSiteInNode;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.MultiNewArrayInNode;
import com.ibm.wala.ipa.callgraph.propagation.NormalAllocationInNode;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ExceptionReturnValueKey;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.Set;

public class CallGraphMapUtil {
    public static CGNode mapCGNode(CGNode cGNode, CallGraph callGraph, CallGraph callGraph2) throws IllegalArgumentException {
        if (callGraph == null) {
            throw new IllegalArgumentException("fromCG == null");
        }
        if (cGNode == callGraph.getFakeRootNode()) {
            return callGraph2.getFakeRootNode();
        }
        MethodReference methodReference = cGNode.getMethod().getReference();
        if (methodReference.toString().equals("< Primordial, Ljava/lang/Object, clone()Ljava/lang/Object; >")) {
            CGNode cGNode2 = callGraph2.getNode(cGNode.getMethod(), cGNode.getContext());
            if (cGNode2 == null) {
                System.err.println("WEIRD can't map node " + cGNode);
            }
            return cGNode2;
        }
        Set<CGNode> set = callGraph2.getNodes(methodReference);
        int n = set.size();
        assert (n <= 1);
        return n == 0 ? null : set.iterator().next();
    }

    public static InstanceKey mapInstKey(InstanceKey instanceKey, CallGraph callGraph, CallGraph callGraph2, HeapModel heapModel) throws UnimplementedError, NullPointerException {
        Object object = null;
        if (instanceKey instanceof InstanceKeyWithNode) {
            CGNode cGNode = ((InstanceKeyWithNode)instanceKey).getNode();
            CGNode cGNode2 = CallGraphMapUtil.mapCGNode(cGNode, callGraph, callGraph2);
            if (cGNode2 == null) {
                return null;
            }
            if (instanceKey instanceof AllocationSiteInNode) {
                if (instanceKey instanceof NormalAllocationInNode) {
                    object = heapModel.getInstanceKeyForAllocation(cGNode2, ((AllocationSiteInNode)instanceKey).getSite());
                } else if (instanceKey instanceof MultiNewArrayInNode) {
                    MultiNewArrayInNode multiNewArrayInNode = (MultiNewArrayInNode)instanceKey;
                    object = heapModel.getInstanceKeyForMultiNewArray(cGNode2, multiNewArrayInNode.getSite(), multiNewArrayInNode.getDim());
                } else {
                    Assertions.UNREACHABLE();
                }
            } else {
                Assertions.UNREACHABLE();
            }
        } else {
            if (instanceKey instanceof ConcreteTypeKey) {
                return instanceKey;
            }
            Assertions.UNREACHABLE();
        }
        assert (object != null);
        assert (object.getClass() == instanceKey.getClass());
        return object;
    }

    public static PointerKey mapPointerKey(PointerKey pointerKey, CallGraph callGraph, CallGraph callGraph2, HeapModel heapModel) throws UnimplementedError {
        PointerKey pointerKey2 = null;
        if (pointerKey instanceof AbstractLocalPointerKey) {
            CGNode cGNode = ((AbstractLocalPointerKey)pointerKey).getNode();
            CGNode cGNode2 = CallGraphMapUtil.mapCGNode(cGNode, callGraph, callGraph2);
            if (cGNode2 == null) {
                return null;
            }
            if (pointerKey instanceof LocalPointerKey) {
                pointerKey2 = heapModel.getPointerKeyForLocal(cGNode2, ((LocalPointerKey)pointerKey).getValueNumber());
            } else if (pointerKey instanceof ReturnValueKey) {
                pointerKey2 = pointerKey instanceof ExceptionReturnValueKey ? heapModel.getPointerKeyForExceptionalReturnValue(cGNode2) : heapModel.getPointerKeyForReturnValue(cGNode2);
            } else {
                Assertions.UNREACHABLE();
            }
        } else {
            Assertions.UNREACHABLE();
        }
        assert (pointerKey2 != null);
        return pointerKey2;
    }
}

