/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.flowgraph;

import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.demandpa.util.MemoryAccess;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.ref.ReferenceCleanser;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDemandPointerFlowGraph
extends SlowSparseNumberedGraph<Object> {
    private static final boolean DEBUG = false;
    private static int wipeCount = 0;
    private final CallGraph cg;
    private final HeapModel heapModel;
    private final MemoryAccessMap fam;
    private final IClassHierarchy cha;
    final BitVectorIntSet cgNodesVisited = new BitVectorIntSet();
    final Map<PointerKey, IField> getFieldDefs = HashMapFactory.make();
    final Collection<PointerKey> arrayDefs = HashSetFactory.make();
    final Map<PointerKey, SSAInvokeInstruction> callDefs = HashMapFactory.make();
    final Map<PointerKey, CGNode> params = HashMapFactory.make();

    public SimpleDemandPointerFlowGraph(CallGraph callGraph, HeapModel heapModel, MemoryAccessMap memoryAccessMap, IClassHierarchy iClassHierarchy) {
        if (callGraph == null) {
            throw new IllegalArgumentException("null cg");
        }
        this.cg = callGraph;
        this.heapModel = heapModel;
        this.fam = memoryAccessMap;
        this.cha = iClassHierarchy;
    }

    public void addSubgraphForNode(CGNode cGNode) {
        int n = this.cg.getNumber(cGNode);
        if (!this.cgNodesVisited.contains(n)) {
            this.cgNodesVisited.add(n);
            this.unconditionallyAddConstraintsFromNode(cGNode);
            this.addNodesForParameters(cGNode);
        }
    }

    private void addNodesForParameters(CGNode cGNode) {
        IR iR = cGNode.getIR();
        TypeInference typeInference = TypeInference.make(iR, false);
        SymbolTable symbolTable = iR.getSymbolTable();
        int n = 0;
        while (n < symbolTable.getNumberOfParameters()) {
            int n2 = symbolTable.getParameter(n);
            TypeAbstraction typeAbstraction = typeInference.getType(n2);
            if (typeAbstraction != null) {
                PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(cGNode, n2);
                this.addNode(pointerKey);
                this.params.put(pointerKey, cGNode);
            }
            ++n;
        }
        this.addNode(this.heapModel.getPointerKeyForReturnValue(cGNode));
        this.addNode(this.heapModel.getPointerKeyForExceptionalReturnValue(cGNode));
    }

    protected HeapModel getHeapModel() {
        return this.heapModel;
    }

    @Override
    public IntSet getPredNodeNumbers(Object object) throws UnimplementedError {
        if (object instanceof StaticFieldKey) {
            Assertions.UNREACHABLE();
            return null;
        }
        return super.getPredNodeNumbers(object);
    }

    @Override
    public IntSet getSuccNodeNumbers(Object object) throws IllegalArgumentException {
        if (object instanceof StaticFieldKey) {
            throw new IllegalArgumentException("node instanceof com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey");
        }
        return super.getSuccNodeNumbers(object);
    }

    @Override
    public int getPredNodeCount(Object object) throws UnimplementedError {
        if (object instanceof StaticFieldKey) {
            Assertions.UNREACHABLE();
            return -1;
        }
        return super.getPredNodeCount(object);
    }

    @Override
    public Iterator<Object> getPredNodes(Object object) throws IllegalArgumentException {
        if (object instanceof StaticFieldKey) {
            throw new IllegalArgumentException("N instanceof com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey");
        }
        return super.getPredNodes(object);
    }

    @Override
    public int getSuccNodeCount(Object object) throws UnimplementedError {
        if (object instanceof StaticFieldKey) {
            Assertions.UNREACHABLE();
            return -1;
        }
        return super.getSuccNodeCount(object);
    }

    @Override
    public Iterator<Object> getSuccNodes(Object object) {
        if (object instanceof StaticFieldKey) {
            this.addNodesThatWriteToStaticField(((StaticFieldKey)object).getField());
        } else {
            IField iField = this.getFieldDefs.get(object);
            if (iField != null) {
                this.addMatchEdges((LocalPointerKey)object, iField);
            } else {
                SSAInvokeInstruction sSAInvokeInstruction = this.callDefs.get(object);
                if (sSAInvokeInstruction != null) {
                    this.addReturnEdges((LocalPointerKey)object, sSAInvokeInstruction);
                } else {
                    CGNode cGNode = this.params.get(object);
                    if (cGNode != null) {
                        this.addParamEdges((LocalPointerKey)object, cGNode);
                    } else if (this.arrayDefs.contains(object)) {
                        this.addArrayMatchEdges((LocalPointerKey)object);
                    }
                }
            }
        }
        return super.getSuccNodes(object);
    }

    private void addArrayMatchEdges(LocalPointerKey localPointerKey) {
        Collection<MemoryAccess> collection = this.fam.getArrayWrites(null);
        for (MemoryAccess memoryAccess : collection) {
            this.addSubgraphForNode(memoryAccess.getNode());
        }
        for (MemoryAccess memoryAccess : collection) {
            IR iR = memoryAccess.getNode().getIR();
            SSAArrayStoreInstruction sSAArrayStoreInstruction = (SSAArrayStoreInstruction)iR.getInstructions()[memoryAccess.getInstructionIndex()];
            PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(memoryAccess.getNode(), sSAArrayStoreInstruction.getValue());
            assert (this.containsNode(pointerKey));
            assert (this.containsNode(localPointerKey));
            this.addMatchEdge(localPointerKey, pointerKey);
        }
    }

    private void addParamEdges(LocalPointerKey localPointerKey, CGNode cGNode) {
        int n = localPointerKey.getValueNumber() - 1;
        for (CGNode cGNode2 : this.cg) {
            this.addSubgraphForNode(cGNode2);
            IR iR = cGNode2.getIR();
            Iterator<CallSiteReference> iterator = iR.iterateCallSites();
            while (iterator.hasNext()) {
                CallSiteReference callSiteReference = iterator.next();
                if (!this.cg.getPossibleTargets(cGNode2, callSiteReference).contains(cGNode)) continue;
                SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = iR.getCalls(callSiteReference);
                int n2 = 0;
                while (n2 < sSAAbstractInvokeInstructionArray.length) {
                    SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = sSAAbstractInvokeInstructionArray[n2];
                    PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(cGNode2, sSAAbstractInvokeInstruction.getUse(n));
                    assert (this.containsNode(pointerKey));
                    assert (this.containsNode(localPointerKey));
                    this.addEdge(localPointerKey, pointerKey);
                    ++n2;
                }
            }
        }
    }

    private void addReturnEdges(LocalPointerKey localPointerKey, SSAInvokeInstruction sSAInvokeInstruction) {
        boolean bl = localPointerKey.getValueNumber() == sSAInvokeInstruction.getException();
        Set<CGNode> set = this.cg.getPossibleTargets(localPointerKey.getNode(), sSAInvokeInstruction.getCallSite());
        for (CGNode cGNode : set) {
            PointerKey pointerKey;
            this.addSubgraphForNode(cGNode);
            PointerKey pointerKey2 = pointerKey = bl ? this.heapModel.getPointerKeyForExceptionalReturnValue(cGNode) : this.heapModel.getPointerKeyForReturnValue(cGNode);
            assert (this.containsNode(pointerKey));
            this.addEdge(localPointerKey, pointerKey);
        }
    }

    private void addMatchEdges(LocalPointerKey localPointerKey, IField iField) {
        Collection<MemoryAccess> collection = this.fam.getFieldWrites(null, iField);
        this.addMatchHelper(localPointerKey, collection);
    }

    private void addMatchHelper(LocalPointerKey localPointerKey, Collection<MemoryAccess> collection) {
        for (MemoryAccess memoryAccess : collection) {
            this.addSubgraphForNode(memoryAccess.getNode());
        }
        for (MemoryAccess memoryAccess : collection) {
            IR iR = memoryAccess.getNode().getIR();
            SSAPutInstruction sSAPutInstruction = (SSAPutInstruction)iR.getInstructions()[memoryAccess.getInstructionIndex()];
            PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(memoryAccess.getNode(), sSAPutInstruction.getVal());
            assert (this.containsNode(pointerKey));
            assert (this.containsNode(localPointerKey));
            this.addMatchEdge(localPointerKey, pointerKey);
        }
    }

    private void addMatchEdge(LocalPointerKey localPointerKey, PointerKey pointerKey) {
        this.addEdge(localPointerKey, pointerKey);
    }

    private void addNodesThatWriteToStaticField(IField iField) {
        Collection<MemoryAccess> collection = this.fam.getStaticFieldWrites(iField);
        for (MemoryAccess memoryAccess : collection) {
            this.addSubgraphForNode(memoryAccess.getNode());
        }
    }

    @Override
    public boolean hasEdge(PointerKey pointerKey, PointerKey pointerKey2) {
        return super.hasEdge(pointerKey, pointerKey2);
    }

    protected void unconditionallyAddConstraintsFromNode(CGNode cGNode) {
        if (++wipeCount >= 2500) {
            wipeCount = 0;
            ReferenceCleanser.clearSoftCaches();
        }
        IR iR = cGNode.getIR();
        this.debugPrintIR(iR);
        if (iR == null) {
            return;
        }
        DefUse defUse = cGNode.getDU();
        this.addNodeInstructionConstraints(cGNode, iR, defUse);
        this.addNodePassthruExceptionConstraints(cGNode, iR);
    }

    protected void addNodePassthruExceptionConstraints(CGNode cGNode, IR iR) {
        List<ProgramCounter> list = SSAPropagationCallGraphBuilder.getIncomingPEIs(iR, iR.getExitBlock());
        PointerKey pointerKey = this.heapModel.getPointerKeyForExceptionalReturnValue(cGNode);
        IClass iClass = cGNode.getClassHierarchy().lookupClass(TypeReference.JavaLangThrowable);
        this.addExceptionDefConstraints(iR, cGNode, list, pointerKey, Collections.singleton(iClass));
    }

    private void addExceptionDefConstraints(IR iR, CGNode cGNode, List<ProgramCounter> list, PointerKey pointerKey, Set<IClass> set) {
        for (ProgramCounter programCounter : list) {
            Object object;
            Object object2;
            SSAInstruction sSAInstruction = iR.getPEI(programCounter);
            if (sSAInstruction instanceof SSAAbstractInvokeInstruction) {
                object2 = (SSAAbstractInvokeInstruction)sSAInstruction;
                object = this.heapModel.getPointerKeyForLocal(cGNode, ((SSAAbstractInvokeInstruction)object2).getException());
                this.addNode(pointerKey);
                this.addNode(object);
                this.addEdge(pointerKey, object);
            } else if (sSAInstruction instanceof SSAAbstractThrowInstruction) {
                object2 = (SSAAbstractThrowInstruction)sSAInstruction;
                object = this.heapModel.getPointerKeyForLocal(cGNode, ((SSAAbstractThrowInstruction)object2).getException());
                this.addNode(pointerKey);
                this.addNode(object);
                this.addEdge(pointerKey, object);
            }
            object2 = sSAInstruction.getExceptionTypes();
            if (object2 == null) continue;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (TypeReference)iterator.next();
                if (object == null) continue;
                InstanceKey instanceKey = this.heapModel.getInstanceKeyForPEI(cGNode, programCounter, (TypeReference)object);
                assert (instanceKey instanceof ConcreteTypeKey) : "uh oh: need to implement getCaughtException constraints for instance " + instanceKey;
                ConcreteTypeKey concreteTypeKey = (ConcreteTypeKey)instanceKey;
                IClass iClass = concreteTypeKey.getType();
                if (!PropagationCallGraphBuilder.catches(set, iClass, this.cha)) continue;
                this.addNode(pointerKey);
                this.addNode(instanceKey);
                this.addEdge(pointerKey, instanceKey);
            }
        }
    }

    protected void addNodeInstructionConstraints(CGNode cGNode, IR iR, DefUse defUse) {
        StatementVisitor statementVisitor = this.makeVisitor((ExplicitCallGraph.ExplicitNode)cGNode, iR, defUse);
        SSACFG sSACFG = iR.getControlFlowGraph();
        for (ISSABasicBlock iSSABasicBlock : sSACFG) {
            this.addBlockInstructionConstraints(cGNode, sSACFG, iSSABasicBlock, statementVisitor);
        }
    }

    protected void addBlockInstructionConstraints(CGNode cGNode, ControlFlowGraph<SSAInstruction, ISSABasicBlock> controlFlowGraph, ISSABasicBlock iSSABasicBlock, StatementVisitor statementVisitor) {
        statementVisitor.setBasicBlock(iSSABasicBlock);
        for (SSAInstruction sSAInstruction : iSSABasicBlock) {
            if (sSAInstruction == null) continue;
            sSAInstruction.visit(statementVisitor);
        }
        this.addPhiConstraints(cGNode, controlFlowGraph, iSSABasicBlock);
    }

    private void addPhiConstraints(CGNode cGNode, ControlFlowGraph<SSAInstruction, ISSABasicBlock> controlFlowGraph, ISSABasicBlock iSSABasicBlock) {
        Iterator<ISSABasicBlock> iterator = controlFlowGraph.getSuccNodes(iSSABasicBlock);
        while (iterator.hasNext()) {
            ISSABasicBlock iSSABasicBlock2 = iterator.next();
            if (iSSABasicBlock2.isExitBlock()) continue;
            int n = 0;
            Iterator<Object> iterator2 = controlFlowGraph.getPredNodes(iSSABasicBlock2);
            while (iterator2.hasNext()) {
                if (iterator2.next() == iSSABasicBlock) break;
                ++n;
            }
            assert (n < controlFlowGraph.getPredNodeCount(iSSABasicBlock2));
            iterator2 = iSSABasicBlock2.iteratePhis();
            while (iterator2.hasNext()) {
                SSAPhiInstruction sSAPhiInstruction = (SSAPhiInstruction)iterator2.next();
                if (sSAPhiInstruction == null) continue;
                PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(cGNode, sSAPhiInstruction.getDef());
                if (sSAPhiInstruction.getUse(n) <= 0) continue;
                PointerKey pointerKey2 = this.heapModel.getPointerKeyForLocal(cGNode, sSAPhiInstruction.getUse(n));
                this.addNode(pointerKey);
                this.addNode(pointerKey2);
                this.addEdge(pointerKey, pointerKey2);
            }
        }
    }

    protected StatementVisitor makeVisitor(ExplicitCallGraph.ExplicitNode explicitNode, IR iR, DefUse defUse) {
        return new StatementVisitor(explicitNode, iR, defUse);
    }

    private void debugPrintIR(IR iR) {
    }

    protected class StatementVisitor
    extends SSAInstruction.Visitor {
        protected final CGNode node;
        protected final IR ir;
        private ISSABasicBlock basicBlock;
        protected final SymbolTable symbolTable;
        protected final DefUse du;

        public StatementVisitor(CGNode cGNode, IR iR, DefUse defUse) {
            this.node = cGNode;
            this.ir = iR;
            this.symbolTable = iR.getSymbolTable();
            assert (this.symbolTable != null);
            this.du = defUse;
        }

        public void visitArrayLoad(SSAArrayLoadInstruction sSAArrayLoadInstruction) {
            if (sSAArrayLoadInstruction.typeIsPrimitive()) {
                return;
            }
            PointerKey pointerKey = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSAArrayLoadInstruction.getDef());
            SimpleDemandPointerFlowGraph.this.arrayDefs.add(pointerKey);
        }

        public void visitArrayStore(SSAArrayStoreInstruction sSAArrayStoreInstruction) {
            if (sSAArrayStoreInstruction.typeIsPrimitive()) {
                return;
            }
            PointerKey pointerKey = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSAArrayStoreInstruction.getValue());
            SimpleDemandPointerFlowGraph.this.addNode(pointerKey);
        }

        public void visitCheckCast(SSACheckCastInstruction sSACheckCastInstruction) {
            Object object;
            HashSet<IClass> hashSet = HashSetFactory.make();
            TypeReference[] typeReferenceArray = sSACheckCastInstruction.getDeclaredResultTypes();
            int n = typeReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = typeReferenceArray[n2];
                IClass iClass = SimpleDemandPointerFlowGraph.this.cha.lookupClass((TypeReference)object);
                if (iClass == null) {
                    return;
                }
                hashSet.add(iClass);
                ++n2;
            }
            object = SimpleDemandPointerFlowGraph.this.heapModel.getFilteredPointerKeyForLocal(this.node, sSACheckCastInstruction.getResult(), new FilteredPointerKey.MultipleClassesFilter(hashSet.toArray(new IClass[hashSet.size()])));
            PointerKey pointerKey = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSACheckCastInstruction.getVal());
            SimpleDemandPointerFlowGraph.this.addNode(object);
            SimpleDemandPointerFlowGraph.this.addNode(pointerKey);
            SimpleDemandPointerFlowGraph.this.addEdge(object, pointerKey);
        }

        public void visitReturn(SSAReturnInstruction sSAReturnInstruction) {
            if (sSAReturnInstruction.returnsPrimitiveType() || sSAReturnInstruction.returnsVoid()) {
                return;
            }
            PointerKey pointerKey = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSAReturnInstruction.getResult());
            SimpleDemandPointerFlowGraph.this.addNode(pointerKey);
            PointerKey pointerKey2 = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForReturnValue(this.node);
            SimpleDemandPointerFlowGraph.this.addNode(pointerKey2);
            SimpleDemandPointerFlowGraph.this.addEdge(pointerKey2, pointerKey);
        }

        public void visitGet(SSAGetInstruction sSAGetInstruction) {
            this.visitGetInternal(sSAGetInstruction.getDef(), sSAGetInstruction.isStatic(), sSAGetInstruction.getDeclaredField());
        }

        protected void visitGetInternal(int n, boolean bl, FieldReference fieldReference) {
            if (fieldReference.getFieldType().isPrimitiveType()) {
                return;
            }
            IField iField = SimpleDemandPointerFlowGraph.this.cg.getClassHierarchy().resolveField(fieldReference);
            if (iField == null) {
                return;
            }
            PointerKey pointerKey = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, n);
            assert (pointerKey != null);
            if (bl) {
                PointerKey pointerKey2 = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForStaticField(iField);
                SimpleDemandPointerFlowGraph.this.addNode(pointerKey);
                SimpleDemandPointerFlowGraph.this.addNode(pointerKey2);
                SimpleDemandPointerFlowGraph.this.addEdge(pointerKey, pointerKey2);
            } else {
                SimpleDemandPointerFlowGraph.this.addNode(pointerKey);
                SimpleDemandPointerFlowGraph.this.getFieldDefs.put(pointerKey, iField);
            }
        }

        public void visitPut(SSAPutInstruction sSAPutInstruction) {
            this.visitPutInternal(sSAPutInstruction.getVal(), sSAPutInstruction.isStatic(), sSAPutInstruction.getDeclaredField());
        }

        public void visitPutInternal(int n, boolean bl, FieldReference fieldReference) {
            if (fieldReference.getFieldType().isPrimitiveType()) {
                return;
            }
            IField iField = SimpleDemandPointerFlowGraph.this.cg.getClassHierarchy().resolveField(fieldReference);
            if (iField == null) {
                return;
            }
            PointerKey pointerKey = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, n);
            assert (pointerKey != null);
            if (bl) {
                PointerKey pointerKey2 = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForStaticField(iField);
                SimpleDemandPointerFlowGraph.this.addNode(pointerKey);
                SimpleDemandPointerFlowGraph.this.addNode(pointerKey2);
                SimpleDemandPointerFlowGraph.this.addEdge(pointerKey2, pointerKey);
            } else {
                SimpleDemandPointerFlowGraph.this.addNode(pointerKey);
            }
        }

        public void visitInvoke(SSAInvokeInstruction sSAInvokeInstruction) {
            int n = 0;
            while (n < sSAInvokeInstruction.getNumberOfUses()) {
                PointerKey pointerKey = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSAInvokeInstruction.getUse(n));
                SimpleDemandPointerFlowGraph.this.addNode(pointerKey);
                ++n;
            }
            if (sSAInvokeInstruction.hasDef()) {
                PointerKey pointerKey = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSAInvokeInstruction.getDef());
                SimpleDemandPointerFlowGraph.this.addNode(pointerKey);
                SimpleDemandPointerFlowGraph.this.callDefs.put(pointerKey, sSAInvokeInstruction);
            }
            PointerKey pointerKey = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSAInvokeInstruction.getException());
            SimpleDemandPointerFlowGraph.this.addNode(pointerKey);
            SimpleDemandPointerFlowGraph.this.callDefs.put(pointerKey, sSAInvokeInstruction);
        }

        public void visitNew(SSANewInstruction sSANewInstruction) {
            InstanceKey instanceKey = SimpleDemandPointerFlowGraph.this.heapModel.getInstanceKeyForAllocation(this.node, sSANewInstruction.getNewSite());
            if (instanceKey == null) {
                return;
            }
            PointerKey pointerKey = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSANewInstruction.getDef());
            SimpleDemandPointerFlowGraph.this.addNode(instanceKey);
            SimpleDemandPointerFlowGraph.this.addNode(pointerKey);
            SimpleDemandPointerFlowGraph.this.addEdge(pointerKey, instanceKey);
        }

        public void visitThrow(SSAThrowInstruction sSAThrowInstruction) {
        }

        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction sSAGetCaughtExceptionInstruction) {
            List<ProgramCounter> list = SSAPropagationCallGraphBuilder.getIncomingPEIs(this.ir, this.getBasicBlock());
            PointerKey pointerKey = SimpleDemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSAGetCaughtExceptionInstruction.getDef());
            Set<IClass> set = SSAPropagationCallGraphBuilder.getCaughtExceptionTypes(sSAGetCaughtExceptionInstruction, this.ir);
            SimpleDemandPointerFlowGraph.this.addExceptionDefConstraints(this.ir, this.node, list, pointerKey, set);
        }

        public void visitPi(SSAPiInstruction sSAPiInstruction) {
            Assertions.UNREACHABLE();
        }

        public ISSABasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        public void setBasicBlock(ISSABasicBlock iSSABasicBlock) {
            this.basicBlock = iSSABasicBlock;
        }

        public void visitLoadMetadata(SSALoadMetadataInstruction sSALoadMetadataInstruction) {
            Assertions.UNREACHABLE();
        }
    }
}

