/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg.refinepolicy;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.demandpa.alg.refinepolicy.FieldRefinePolicy;
import com.ibm.wala.demandpa.alg.statemachine.StateMachine;
import com.ibm.wala.demandpa.flowgraph.IFlowLabel;
import com.ibm.wala.demandpa.util.ArrayContents;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;

public class TunedFieldRefinementPolicy
implements FieldRefinePolicy {
    private static final boolean DEBUG = false;
    private final IClassHierarchy cha;
    private final Collection<IClass> typesToRefine = HashSetFactory.make();
    private IClass firstSkippedClass = null;

    public boolean nextPass() {
        if (this.firstSkippedClass != null) {
            this.typesToRefine.add(this.firstSkippedClass);
            this.firstSkippedClass = null;
            return true;
        }
        return false;
    }

    public boolean shouldRefine(IField iField, PointerKey pointerKey, PointerKey pointerKey2, IFlowLabel iFlowLabel, StateMachine.State state) {
        if (iField == null) {
            throw new IllegalArgumentException("null field");
        }
        if (iField == ArrayContents.v()) {
            return true;
        }
        IClass iClass = this.removeInner(iField.getDeclaringClass());
        if (this.superOfAnyEncountered(iClass)) {
            return true;
        }
        if (this.firstSkippedClass == null) {
            this.firstSkippedClass = iClass;
        }
        return false;
    }

    private boolean superOfAnyEncountered(IClass iClass) {
        for (IClass iClass2 : this.typesToRefine) {
            if (!this.cha.isAssignableFrom(iClass, iClass2) && !this.cha.isAssignableFrom(iClass2, iClass)) continue;
            return true;
        }
        return false;
    }

    private IClass removeInner(IClass iClass) {
        ClassLoaderReference classLoaderReference = iClass.getClassLoader().getReference();
        String string = iClass.getName().toString();
        int n = string.indexOf(36);
        if (n == -1) {
            return iClass;
        }
        String string2 = string.substring(0, n);
        IClass iClass2 = this.cha.lookupClass(TypeReference.findOrCreate(classLoaderReference, string2));
        return iClass2 != null ? iClass2 : iClass;
    }

    public TunedFieldRefinementPolicy(IClassHierarchy iClassHierarchy) {
        this.cha = iClassHierarchy;
    }
}

