/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg.refinepolicy;

import com.ibm.wala.demandpa.alg.refinepolicy.CallGraphRefinePolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.FieldRefinePolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.RefinementPolicy;
import java.util.Arrays;

public abstract class AbstractRefinementPolicy
implements RefinementPolicy {
    protected static final int DEFAULT_NUM_PASSES = 4;
    protected static final int LONGER_PASS_BUDGET = 12000;
    private static final int SHORTER_PASS_BUDGET = 1000;
    private static final int[] DEFAULT_BUDGET_PER_PASS;
    protected final FieldRefinePolicy fieldRefinePolicy;
    protected final CallGraphRefinePolicy cgRefinePolicy;
    protected final int numPasses;
    protected final int[] budgetPerPass;

    static {
        int[] nArray = new int[4];
        nArray[0] = 1000;
        Arrays.fill(nArray, 1, 4, 12000);
        DEFAULT_BUDGET_PER_PASS = nArray;
    }

    public AbstractRefinementPolicy(FieldRefinePolicy fieldRefinePolicy, CallGraphRefinePolicy callGraphRefinePolicy, int n, int[] nArray) {
        this.fieldRefinePolicy = fieldRefinePolicy;
        this.cgRefinePolicy = callGraphRefinePolicy;
        this.numPasses = n;
        this.budgetPerPass = nArray;
    }

    public AbstractRefinementPolicy(FieldRefinePolicy fieldRefinePolicy, CallGraphRefinePolicy callGraphRefinePolicy) {
        this(fieldRefinePolicy, callGraphRefinePolicy, 4, DEFAULT_BUDGET_PER_PASS);
    }

    public int getBudgetForPass(int n) {
        return this.budgetPerPass[n];
    }

    public CallGraphRefinePolicy getCallGraphRefinePolicy() {
        return this.cgRefinePolicy;
    }

    public FieldRefinePolicy getFieldRefinePolicy() {
        return this.fieldRefinePolicy;
    }

    public int getNumPasses() {
        return this.numPasses;
    }

    public boolean nextPass() {
        boolean bl = this.fieldRefinePolicy.nextPass();
        boolean bl2 = this.cgRefinePolicy.nextPass();
        return bl || bl2;
    }
}

