/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg;

import com.ibm.wala.demandpa.alg.AbstractDemandPointsTo;
import com.ibm.wala.demandpa.flowgraph.SimpleDemandPointerFlowGraph;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.traverse.SlowDFSDiscoverTimeIterator;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDemandPointsTo
extends AbstractDemandPointsTo {
    private static final boolean VERBOSE = false;

    public SimpleDemandPointsTo(CallGraph callGraph, HeapModel heapModel, MemoryAccessMap memoryAccessMap, IClassHierarchy iClassHierarchy, AnalysisOptions analysisOptions) {
        super(callGraph, heapModel, memoryAccessMap, iClassHierarchy, analysisOptions);
    }

    @Override
    public Collection<InstanceKey> getPointsTo(PointerKey pointerKey) throws IllegalArgumentException, UnimplementedError {
        if (pointerKey == null) {
            throw new IllegalArgumentException("pk == null");
        }
        assert (pointerKey instanceof LocalPointerKey) : "we only handle locals";
        LocalPointerKey localPointerKey = (LocalPointerKey)pointerKey;
        SimpleDemandPointerFlowGraph simpleDemandPointerFlowGraph = new SimpleDemandPointerFlowGraph(this.cg, this.heapModel, this.mam, this.cha);
        CGNode cGNode = localPointerKey.getNode();
        simpleDemandPointerFlowGraph.addSubgraphForNode(cGNode);
        if (!simpleDemandPointerFlowGraph.containsNode(pointerKey)) {
            return Collections.emptySet();
        }
        Predicate predicate = new Predicate(){

            public boolean test(Object object) {
                return object instanceof InstanceKey;
            }
        };
        SlowDFSDiscoverTimeIterator<PointerKey> slowDFSDiscoverTimeIterator = new SlowDFSDiscoverTimeIterator<PointerKey>(simpleDemandPointerFlowGraph, pointerKey);
        return Predicate.filter(slowDFSDiscoverTimeIterator, predicate);
    }
}

