/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg;

import com.ibm.wala.analysis.reflection.InstanceKeyWithNode;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.demandpa.alg.AbstractDemandPointsTo;
import com.ibm.wala.demandpa.alg.BudgetExceededException;
import com.ibm.wala.demandpa.alg.InstanceFieldKeyAndState;
import com.ibm.wala.demandpa.alg.InstanceKeyAndState;
import com.ibm.wala.demandpa.alg.PointerKeyAndState;
import com.ibm.wala.demandpa.alg.ThisFilteringHeapModel;
import com.ibm.wala.demandpa.alg.WithState;
import com.ibm.wala.demandpa.alg.refinepolicy.NeverRefineCGPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.NeverRefineFieldsPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.RefinementPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.RefinementPolicyFactory;
import com.ibm.wala.demandpa.alg.refinepolicy.SinglePassRefinementPolicy;
import com.ibm.wala.demandpa.alg.statemachine.StateMachine;
import com.ibm.wala.demandpa.alg.statemachine.StateMachineFactory;
import com.ibm.wala.demandpa.alg.statemachine.StatesMergedException;
import com.ibm.wala.demandpa.flowgraph.AbstractFlowGraph;
import com.ibm.wala.demandpa.flowgraph.AbstractFlowLabelVisitor;
import com.ibm.wala.demandpa.flowgraph.AssignBarLabel;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalBarLabel;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalLabel;
import com.ibm.wala.demandpa.flowgraph.AssignLabel;
import com.ibm.wala.demandpa.flowgraph.DemandPointerFlowGraph;
import com.ibm.wala.demandpa.flowgraph.GetFieldLabel;
import com.ibm.wala.demandpa.flowgraph.IFlowGraph;
import com.ibm.wala.demandpa.flowgraph.IFlowLabel;
import com.ibm.wala.demandpa.flowgraph.IFlowLabelWithFilter;
import com.ibm.wala.demandpa.flowgraph.MatchBarLabel;
import com.ibm.wala.demandpa.flowgraph.MatchLabel;
import com.ibm.wala.demandpa.flowgraph.NewLabel;
import com.ibm.wala.demandpa.flowgraph.ParamBarLabel;
import com.ibm.wala.demandpa.flowgraph.ParamLabel;
import com.ibm.wala.demandpa.flowgraph.PutFieldLabel;
import com.ibm.wala.demandpa.flowgraph.ReturnBarLabel;
import com.ibm.wala.demandpa.flowgraph.ReturnLabel;
import com.ibm.wala.demandpa.genericutil.ArraySet;
import com.ibm.wala.demandpa.genericutil.ArraySetMultiMap;
import com.ibm.wala.demandpa.genericutil.HashSetMultiMap;
import com.ibm.wala.demandpa.genericutil.MultiMap;
import com.ibm.wala.demandpa.genericutil.Util;
import com.ibm.wala.demandpa.util.ArrayContents;
import com.ibm.wala.demandpa.util.MemoryAccess;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.demandpa.util.PointerParamValueNumIterator;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.propagation.AbstractLocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.NodeKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerSiteContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ExceptionReturnValueKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.Iterator2Set;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.functions.Function;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableIntSetFactory;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.MutableSparseIntSetFactory;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemandRefinementPointsTo
extends AbstractDemandPointsTo {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_TOPLEVEL = false;
    private static final boolean PARANOID = false;
    private static final boolean MEASURE_MEMORY_USAGE = false;
    protected final IFlowGraph g;
    private StateMachineFactory<IFlowLabel> stateMachineFactory;
    private StateMachine<IFlowLabel> stateMachine;
    protected RefinementPolicy refinementPolicy;
    private RefinementPolicyFactory refinementPolicyFactory;
    public long lastQueryMemoryUse;

    public RefinementPolicy getRefinementPolicy() {
        return this.refinementPolicy;
    }

    private DemandRefinementPointsTo(CallGraph callGraph, ThisFilteringHeapModel thisFilteringHeapModel, MemoryAccessMap memoryAccessMap, IClassHierarchy iClassHierarchy, AnalysisOptions analysisOptions, StateMachineFactory<IFlowLabel> stateMachineFactory, IFlowGraph iFlowGraph) {
        super(callGraph, thisFilteringHeapModel, memoryAccessMap, iClassHierarchy, analysisOptions);
        this.stateMachineFactory = stateMachineFactory;
        this.g = iFlowGraph;
        this.refinementPolicyFactory = new SinglePassRefinementPolicy.Factory(new NeverRefineFieldsPolicy(), new NeverRefineCGPolicy());
        this.sanityCheckCG();
    }

    private void sanityCheckCG() {
    }

    protected void startNewQuery() {
        this.refinementPolicy = this.refinementPolicyFactory.make();
        this.stateMachine = this.stateMachineFactory.make();
    }

    public Pair<PointsToResult, Collection<InstanceKey>> getPointsTo(PointerKey pointerKey, Predicate<InstanceKey> predicate) throws IllegalArgumentException {
        Pair<PointsToResult, Collection<InstanceKeyAndState>> pair = this.getPointsToWithStates(pointerKey, predicate);
        Collection collection = (Collection)pair.snd;
        Collection collection2 = DemandRefinementPointsTo.removeStates(collection);
        return Pair.make((PointsToResult)((Object)pair.fst), collection2);
    }

    private Pair<PointsToResult, Collection<InstanceKeyAndState>> getPointsToWithStates(PointerKey pointerKey, Predicate<InstanceKey> predicate) {
        if (!(pointerKey instanceof LocalPointerKey)) {
            throw new IllegalArgumentException("only locals for now");
        }
        LocalPointerKey localPointerKey = (LocalPointerKey)pointerKey;
        this.startNewQuery();
        Pair<PointsToResult, Collection<InstanceKeyAndState>> pair = this.outerRefinementLoop(new PointerKeyAndState(localPointerKey, this.stateMachine.getStartState()), predicate);
        return pair;
    }

    private static <T> Collection<T> removeStates(Collection<? extends WithState<T>> collection) {
        Iterator2Set iterator2Set = Iterator2Collection.toSet(new MapIterator(collection.iterator(), new Function<WithState<T>, T>(){

            @Override
            public T apply(WithState<T> withState) {
                return withState.getWrapped();
            }
        }));
        return iterator2Set;
    }

    public static DemandRefinementPointsTo makeWithDefaultFlowGraph(CallGraph callGraph, HeapModel heapModel, MemoryAccessMap memoryAccessMap, IClassHierarchy iClassHierarchy, AnalysisOptions analysisOptions, StateMachineFactory<IFlowLabel> stateMachineFactory) {
        ThisFilteringHeapModel thisFilteringHeapModel = new ThisFilteringHeapModel(heapModel, iClassHierarchy);
        return new DemandRefinementPointsTo(callGraph, thisFilteringHeapModel, memoryAccessMap, iClassHierarchy, analysisOptions, stateMachineFactory, new DemandPointerFlowGraph(callGraph, (HeapModel)thisFilteringHeapModel, memoryAccessMap, iClassHierarchy));
    }

    private Pair<PointsToResult, Collection<InstanceKeyAndState>> outerRefinementLoop(PointerKeyAndState pointerKeyAndState, Predicate<InstanceKey> predicate) {
        Object object;
        PointsToResult pointsToResult = null;
        boolean bl = false;
        int n = this.refinementPolicy.getNumPasses();
        int n2 = 0;
        while (n2 < n) {
            this.setNumNodesTraversed(0);
            this.setTraversalBudget(this.refinementPolicy.getBudgetForPass(n2));
            object = null;
            PointsToComputer pointsToComputer = null;
            boolean bl2 = false;
            try {
                while (true) {
                    try {
                        pointsToComputer = new PointsToComputer(pointerKeyAndState);
                        pointsToComputer.compute();
                        object = pointsToComputer.getComputedP2Set(pointerKeyAndState);
                        bl2 = true;
                    }
                    catch (StatesMergedException statesMergedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (BudgetExceededException budgetExceededException) {}
            if (object != null) {
                if (pointsToResult == null) {
                    pointsToResult = object;
                } else if (pointsToResult.size() > object.size()) {
                    assert (DemandRefinementPointsTo.removeStates(pointsToResult).containsAll(DemandRefinementPointsTo.removeStates(object)));
                    pointsToResult = object;
                } else assert (DemandRefinementPointsTo.removeStates(object).containsAll(DemandRefinementPointsTo.removeStates(pointsToResult)));
                if (object.isEmpty() || this.passesPred((Collection<InstanceKeyAndState>)object, predicate)) {
                    bl = true;
                    break;
                }
            }
            if (!this.refinementPolicy.nextPass()) break;
            ++n2;
        }
        object = null;
        object = bl ? PointsToResult.SUCCESS : (n2 == n ? PointsToResult.BUDGETEXCEEDED : (pointsToResult != null ? PointsToResult.NOMOREREFINE : PointsToResult.BUDGETEXCEEDED));
        return Pair.make(object, pointsToResult);
    }

    public PointsToResult pointsToPassesPred(PointerKey pointerKey, Predicate<InstanceKey> predicate, PointerAnalysis pointerAnalysis) throws IllegalArgumentException {
        if (!(pointerKey instanceof LocalPointerKey)) {
            throw new IllegalArgumentException("only locals for now");
        }
        LocalPointerKey localPointerKey = (LocalPointerKey)pointerKey;
        boolean bl = false;
        this.startNewQuery();
        int n = this.refinementPolicy.getNumPasses();
        int n2 = 0;
        boolean bl2 = false;
        while (n2 < n) {
            this.setNumNodesTraversed(0);
            this.setTraversalBudget(this.refinementPolicy.getBudgetForPass(n2));
            boolean bl3 = false;
            boolean bl4 = false;
            long l = 0L;
            try {
                while (true) {
                    try {
                        PointsToComputer pointsToComputer = new PointsToComputer(localPointerKey);
                        bl4 = this.doTopLevelTraversal(localPointerKey, predicate, pointsToComputer, pointerAnalysis);
                        bl3 = true;
                        bl2 = true;
                    }
                    catch (StatesMergedException statesMergedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (BudgetExceededException budgetExceededException) {}
            if (bl3 && bl4) {
                bl = true;
                break;
            }
            if (!this.refinementPolicy.nextPass()) break;
            ++n2;
        }
        PointsToResult pointsToResult = null;
        pointsToResult = bl ? PointsToResult.SUCCESS : (n2 == n ? PointsToResult.BUDGETEXCEEDED : (bl2 ? PointsToResult.NOMOREREFINE : PointsToResult.BUDGETEXCEEDED));
        return pointsToResult;
    }

    private boolean passesPred(Collection<InstanceKeyAndState> collection, final Predicate<InstanceKey> predicate) {
        return Util.forAll(collection, new Predicate<InstanceKeyAndState>(){

            @Override
            public boolean test(InstanceKeyAndState instanceKeyAndState) {
                return predicate.test(instanceKeyAndState.getInstanceKey());
            }
        });
    }

    @Override
    public Collection<InstanceKey> getPointsTo(PointerKey pointerKey) {
        return (Collection)this.getPointsTo((PointerKey)pointerKey, Predicate.<InstanceKey>falsePred()).snd;
    }

    public Collection<InstanceKeyAndState> getPointsToWithStates(PointerKey pointerKey) {
        return (Collection)this.getPointsToWithStates((PointerKey)pointerKey, Predicate.<InstanceKey>falsePred()).snd;
    }

    public Pair<PointsToResult, Collection<PointerKey>> getFlowsTo(InstanceKey instanceKey) {
        this.startNewQuery();
        return this.getFlowsToInternal(new InstanceKeyAndState(instanceKey, this.stateMachine.getStartState()));
    }

    public Pair<PointsToResult, Collection<PointerKey>> getFlowsTo(InstanceKeyAndState instanceKeyAndState) {
        this.startNewQuery();
        return this.getFlowsToInternal(instanceKeyAndState);
    }

    private Pair<PointsToResult, Collection<PointerKey>> getFlowsToInternal(InstanceKeyAndState instanceKeyAndState) {
        Object object;
        InstanceKey instanceKey = instanceKeyAndState.getInstanceKey();
        if (!(instanceKey instanceof InstanceKeyWithNode)) assert (false) : "TODO: handle " + instanceKey.getClass();
        PointsToResult pointsToResult = null;
        boolean bl = false;
        int n = this.refinementPolicy.getNumPasses();
        int n2 = 0;
        while (n2 < n) {
            this.setNumNodesTraversed(0);
            this.setTraversalBudget(this.refinementPolicy.getBudgetForPass(n2));
            object = null;
            FlowsToComputer flowsToComputer = null;
            try {
                while (true) {
                    try {
                        flowsToComputer = new FlowsToComputer(instanceKeyAndState);
                        flowsToComputer.compute();
                        object = flowsToComputer.getComputedFlowsToSet();
                    }
                    catch (StatesMergedException statesMergedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (BudgetExceededException budgetExceededException) {}
            if (object != null) {
                if (pointsToResult == null) {
                    pointsToResult = object;
                } else if (pointsToResult.size() > object.size()) {
                    assert (DemandRefinementPointsTo.removeStates(pointsToResult).containsAll(DemandRefinementPointsTo.removeStates(object)));
                    pointsToResult = object;
                }
                if (object.isEmpty()) {
                    bl = true;
                    break;
                }
            }
            if (!this.refinementPolicy.nextPass()) break;
            ++n2;
        }
        object = null;
        object = bl ? PointsToResult.SUCCESS : (n2 == n ? PointsToResult.BUDGETEXCEEDED : (pointsToResult != null ? PointsToResult.NOMOREREFINE : PointsToResult.BUDGETEXCEEDED));
        return Pair.make(object, pointsToResult == null ? null : DemandRefinementPointsTo.removeStates(pointsToResult));
    }

    private SSAAbstractInvokeInstruction[] getCallInstrs(CGNode cGNode, CallSiteReference callSiteReference) {
        return cGNode.getIR().getCalls(callSiteReference);
    }

    private boolean hasNullIR(CGNode cGNode) {
        boolean bl = cGNode.getMethod().isNative();
        assert (cGNode.getIR() != null || bl);
        return bl;
    }

    private Object doTransition(StateMachine.State state, IFlowLabel iFlowLabel, Function<StateMachine.State, Object> function) {
        StateMachine.State state2 = this.stateMachine.transition(state, iFlowLabel);
        Object object = null;
        if (state2 != StateMachine.ERROR) {
            object = function.apply(state2);
        }
        return object;
    }

    public StateMachineFactory<IFlowLabel> getStateMachineFactory() {
        return this.stateMachineFactory;
    }

    public void setStateMachineFactory(StateMachineFactory<IFlowLabel> stateMachineFactory) {
        this.stateMachineFactory = stateMachineFactory;
    }

    public RefinementPolicyFactory getRefinementPolicyFactory() {
        return this.refinementPolicyFactory;
    }

    public void setRefinementPolicyFactory(RefinementPolicyFactory refinementPolicyFactory) {
        this.refinementPolicyFactory = refinementPolicyFactory;
    }

    private boolean doTopLevelTraversal(PointerKey pointerKey, Predicate<InstanceKey> predicate, PointsToComputer pointsToComputer, PointerAnalysis pointerAnalysis) {
        HashSet hashSet = HashSetFactory.make();
        LinkedList linkedList = new LinkedList();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Helper {
            private final MultiMap<CallerSiteContext, IMethod> callToOTFTargets = ArraySetMultiMap.make();
            private final /* synthetic */ Set val$visited;
            private final /* synthetic */ LinkedList val$worklist;
            private final /* synthetic */ PointsToComputer val$ptoComputer;

            Helper(Set set, LinkedList linkedList, PointsToComputer pointsToComputer) {
                this.val$visited = set;
                this.val$worklist = linkedList;
                this.val$ptoComputer = pointsToComputer;
            }

            void propagate(PointerKeyAndState pointerKeyAndState) {
                if (this.val$visited.add(pointerKeyAndState)) {
                    if (!$assertionsDisabled && !this.graphContainsNode(pointerKeyAndState.getPointerKey())) {
                        throw new AssertionError();
                    }
                    this.val$worklist.addLast(pointerKeyAndState);
                }
            }

            private boolean graphContainsNode(PointerKey pointerKey) {
                if (pointerKey instanceof LocalPointerKey) {
                    LocalPointerKey localPointerKey = (LocalPointerKey)pointerKey;
                    return DemandRefinementPointsTo.this.g.hasSubgraphForNode(localPointerKey.getNode());
                }
                return true;
            }

            private Collection<IMethod> getOTFTargets(CallerSiteContext callerSiteContext, SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray, StateMachine.State state) {
                CallSiteReference callSiteReference = callerSiteContext.getCallSite();
                CGNode cGNode = callerSiteContext.getCaller();
                HashSet<IMethod> hashSet = HashSetFactory.make();
                SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray2 = sSAAbstractInvokeInstructionArray;
                int n = sSAAbstractInvokeInstructionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = sSAAbstractInvokeInstructionArray2[n2];
                    PointerKey pointerKey = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(cGNode, sSAAbstractInvokeInstruction.getUse(0));
                    PointerKeyAndState pointerKeyAndState = new PointerKeyAndState(pointerKey, state);
                    OrdinalSet<InstanceKeyAndState> ordinalSet = this.getPToSetFromComputer(this.val$ptoComputer, pointerKeyAndState);
                    for (InstanceKeyAndState instanceKeyAndState : ordinalSet) {
                        InstanceKey instanceKey = instanceKeyAndState.getInstanceKey();
                        IMethod iMethod = DemandRefinementPointsTo.this.options.getMethodTargetSelector().getCalleeTarget(cGNode, callSiteReference, instanceKey.getConcreteType());
                        if (iMethod == null) continue;
                        hashSet.add(iMethod);
                    }
                    ++n2;
                }
                return hashSet;
            }

            public void handleTopLevelForwInterproc(PointerKeyAndState pointerKeyAndState) {
                block9: {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    PointerKey pointerKey = pointerKeyAndState.getPointerKey();
                    StateMachine.State state = pointerKeyAndState.getState();
                    if (!(pointerKey instanceof LocalPointerKey)) break block9;
                    LocalPointerKey localPointerKey = (LocalPointerKey)pointerKey;
                    if (DemandRefinementPointsTo.this.g.isParam(localPointerKey)) {
                        object4 = localPointerKey.getNode();
                        int n = localPointerKey.getValueNumber() - 1;
                        for (CallerSiteContext callerSiteContext : DemandRefinementPointsTo.this.g.getPotentialCallers(localPointerKey)) {
                            object3 = callerSiteContext.getCaller();
                            object2 = callerSiteContext.getCallSite();
                            if (DemandRefinementPointsTo.this.hasNullIR((CGNode)object3)) continue;
                            object = ParamLabel.make(callerSiteContext);
                            DemandRefinementPointsTo.this.doTransition(pointerKeyAndState.getState(), (IFlowLabel)object, new Function<StateMachine.State, Object>((CGNode)object3, (CallSiteReference)object2, n, localPointerKey, state, (ParamLabel)object, callerSiteContext, (CGNode)object4){
                                private final /* synthetic */ CGNode val$caller;
                                private final /* synthetic */ CallSiteReference val$call;
                                private final /* synthetic */ int val$paramPos;
                                private final /* synthetic */ LocalPointerKey val$localPk;
                                private final /* synthetic */ StateMachine.State val$curState;
                                private final /* synthetic */ ParamLabel val$paramLabel;
                                private final /* synthetic */ CallerSiteContext val$callSiteAndCGNode;
                                private final /* synthetic */ CGNode val$callee;
                                {
                                    this.val$caller = cGNode;
                                    this.val$call = callSiteReference;
                                    this.val$paramPos = n;
                                    this.val$localPk = localPointerKey;
                                    this.val$curState = state;
                                    this.val$paramLabel = paramLabel;
                                    this.val$callSiteAndCGNode = callerSiteContext;
                                    this.val$callee = cGNode2;
                                }

                                private void propagateToCallee() {
                                    ((Helper)this).DemandRefinementPointsTo.this.g.addSubgraphForNode(this.val$caller);
                                    SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = DemandRefinementPointsTo.this.getCallInstrs(this.val$caller, this.val$call);
                                    int n = 0;
                                    while (n < sSAAbstractInvokeInstructionArray.length) {
                                        SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = sSAAbstractInvokeInstructionArray[n];
                                        final PointerKey pointerKey = ((Helper)this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(this.val$caller, sSAAbstractInvokeInstruction.getUse(this.val$paramPos));
                                        if (!$assertionsDisabled && !((Helper)this).DemandRefinementPointsTo.this.g.containsNode(pointerKey)) {
                                            throw new AssertionError();
                                        }
                                        if (!$assertionsDisabled && !((Helper)this).DemandRefinementPointsTo.this.g.containsNode(this.val$localPk)) {
                                            throw new AssertionError();
                                        }
                                        DemandRefinementPointsTo.this.doTransition(this.val$curState, this.val$paramLabel, new Function<StateMachine.State, Object>(){

                                            @Override
                                            public Object apply(StateMachine.State state) {
                                                this.propagate(new PointerKeyAndState(pointerKey, state));
                                                return null;
                                            }
                                        });
                                        ++n;
                                    }
                                }

                                @Override
                                public Object apply(StateMachine.State state) {
                                    SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = DemandRefinementPointsTo.this.getCallInstrs(this.val$caller, this.val$call);
                                    SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = sSAAbstractInvokeInstructionArray[0];
                                    PointerKey pointerKey = ((Helper)this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(this.val$caller, sSAAbstractInvokeInstruction.getUse(this.val$paramPos));
                                    Set<CGNode> set = ((Helper)this).DemandRefinementPointsTo.this.g.getPossibleTargets(this.val$caller, this.val$call, (LocalPointerKey)pointerKey);
                                    if (DemandRefinementPointsTo.this.noOnTheFlyNeeded(this.val$callSiteAndCGNode, set)) {
                                        this.propagateToCallee();
                                    } else {
                                        Collection collection = this.getOTFTargets(this.val$callSiteAndCGNode, sSAAbstractInvokeInstructionArray, state);
                                        if (collection.contains(this.val$callee.getMethod())) {
                                            this.propagateToCallee();
                                        }
                                    }
                                    return null;
                                }
                            });
                        }
                    }
                    if ((object4 = DemandRefinementPointsTo.this.g.getInstrReturningTo(localPointerKey)) != null) {
                        CGNode cGNode = localPointerKey.getNode();
                        boolean bl = localPointerKey.getValueNumber() == ((SSAAbstractInvokeInstruction)object4).getException();
                        CallSiteReference callSiteReference = ((SSAAbstractInvokeInstruction)object4).getCallSite();
                        object3 = new CallerSiteContext(cGNode, callSiteReference);
                        if (DemandRefinementPointsTo.this.noOnTheFlyNeeded((CallerSiteContext)object3, (Set)(object2 = DemandRefinementPointsTo.this.g.getPossibleTargets(cGNode, callSiteReference, localPointerKey)))) {
                            Iterator iterator = object2.iterator();
                            while (iterator.hasNext()) {
                                PointerKey pointerKey2;
                                object = (CGNode)iterator.next();
                                if (DemandRefinementPointsTo.this.hasNullIR(object)) continue;
                                DemandRefinementPointsTo.this.g.addSubgraphForNode((CGNode)object);
                                PointerKey pointerKey3 = pointerKey2 = bl ? DemandRefinementPointsTo.this.heapModel.getPointerKeyForExceptionalReturnValue((CGNode)object) : DemandRefinementPointsTo.this.heapModel.getPointerKeyForReturnValue((CGNode)object);
                                if (!$assertionsDisabled && !DemandRefinementPointsTo.this.g.containsNode(pointerKey2)) {
                                    throw new AssertionError();
                                }
                                DemandRefinementPointsTo.this.doTransition(state, ReturnLabel.make((CallerSiteContext)object3), new Function<StateMachine.State, Object>(){

                                    @Override
                                    public Object apply(StateMachine.State state) {
                                        this.propagate(new PointerKeyAndState(pointerKey2, state));
                                        return null;
                                    }
                                });
                            }
                        } else {
                            object = this.getOTFTargets((CallerSiteContext)object3, DemandRefinementPointsTo.this.getCallInstrs(cGNode, ((CallerSiteContext)object3).getCallSite()), pointerKeyAndState.getState());
                            Iterator iterator = object2.iterator();
                            while (iterator.hasNext()) {
                                PointerKey pointerKey4;
                                CGNode cGNode2 = (CGNode)iterator.next();
                                if (!object.contains(cGNode2.getMethod()) || DemandRefinementPointsTo.this.hasNullIR(cGNode2)) continue;
                                DemandRefinementPointsTo.this.g.addSubgraphForNode(cGNode2);
                                PointerKey pointerKey5 = pointerKey4 = bl ? DemandRefinementPointsTo.this.heapModel.getPointerKeyForExceptionalReturnValue(cGNode2) : DemandRefinementPointsTo.this.heapModel.getPointerKeyForReturnValue(cGNode2);
                                if (!$assertionsDisabled && !DemandRefinementPointsTo.this.g.containsNode(pointerKey4)) {
                                    throw new AssertionError();
                                }
                                DemandRefinementPointsTo.this.doTransition(state, ReturnLabel.make((CallerSiteContext)object3), new Function<StateMachine.State, Object>(){

                                    @Override
                                    public Object apply(StateMachine.State state) {
                                        this.propagate(new PointerKeyAndState(pointerKey4, state));
                                        return null;
                                    }
                                });
                            }
                        }
                    }
                }
            }

            private OrdinalSet<InstanceKeyAndState> getPToSetFromComputer(PointsToComputer pointsToComputer, PointerKeyAndState pointerKeyAndState) {
                Object object;
                if (pointerKeyAndState.getPointerKey() instanceof LocalPointerKey) {
                    object = (LocalPointerKey)pointerKeyAndState.getPointerKey();
                    DemandRefinementPointsTo.this.g.addSubgraphForNode(((LocalPointerKey)object).getNode());
                }
                pointsToComputer.addToInitWorklist(pointerKeyAndState);
                pointsToComputer.worklistLoop();
                object = pointsToComputer.pkToP2Set.get(pointerKeyAndState);
                if (object == null) {
                    return OrdinalSet.empty();
                }
                return pointsToComputer.makeOrdinalSet((IntSet)object);
            }

            private void computeFlowsTo(PointsToComputer pointsToComputer, OrdinalSet<InstanceKeyAndState> ordinalSet) {
                for (InstanceKeyAndState instanceKeyAndState : ordinalSet) {
                    pointsToComputer.addPredsOfIKeyAndStateToTrackedPointsTo(instanceKeyAndState);
                }
                if (!$assertionsDisabled && !pointsToComputer.initWorklist.isEmpty()) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !pointsToComputer.pointsToWorklist.isEmpty()) {
                    throw new AssertionError();
                }
                pointsToComputer.worklistLoop();
            }

            private Collection<StateMachine.State> getFlowedToStates(PointsToComputer pointsToComputer, OrdinalSet<InstanceKeyAndState> ordinalSet, PointerKey pointerKey) {
                HashSet<StateMachine.State> hashSet = HashSetFactory.make();
                Set set = pointsToComputer.trackedQueried.get(pointerKey);
                for (StateMachine.State state : set) {
                    PointerKeyAndState pointerKeyAndState = new PointerKeyAndState(pointerKey, state);
                    if (!pointsToComputer.makeOrdinalSet(pointsToComputer.pkToTrackedSet.get(pointerKeyAndState)).containsAny(ordinalSet)) continue;
                    hashSet.add(state);
                }
                return hashSet;
            }
        }
        Helper helper = new Helper(hashSet, linkedList, pointsToComputer);
        PointerKeyAndState pointerKeyAndState = new PointerKeyAndState(pointerKey, this.stateMachine.getStartState());
        if (pointerKey instanceof LocalPointerKey) {
            this.g.addSubgraphForNode(((LocalPointerKey)pointerKey).getNode());
        }
        helper.propagate(pointerKeyAndState);
        while (!linkedList.isEmpty()) {
            this.incrementNumNodesTraversed();
            PointerKeyAndState pointerKeyAndState2 = (PointerKeyAndState)linkedList.removeFirst();
            PointerKey pointerKey2 = pointerKeyAndState2.getPointerKey();
            StateMachine.State state = pointerKeyAndState2.getState();
            if (this.predHoldsForPk(pointerKey2, predicate, pointerAnalysis)) continue;
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class MyFlowLabelVisitor
            extends AbstractFlowLabelVisitor {
                boolean foundBadInstanceKey;
                private final /* synthetic */ PointerKey val$curPk;
                private final /* synthetic */ StateMachine.State val$curState;
                private final /* synthetic */ Helper val$h;
                private final /* synthetic */ PointsToComputer val$ptoComputer;
                private final /* synthetic */ Predicate val$pred;

                MyFlowLabelVisitor(PointerKey pointerKey, StateMachine.State state, Helper helper, PointsToComputer pointsToComputer, Predicate predicate) {
                    this.val$curPk = pointerKey;
                    this.val$curState = state;
                    this.val$h = helper;
                    this.val$ptoComputer = pointsToComputer;
                    this.val$pred = predicate;
                }

                @Override
                public void visitNew(NewLabel newLabel, Object object) {
                    final InstanceKey instanceKey = (InstanceKey)object;
                    DemandRefinementPointsTo.this.doTransition(this.val$curState, newLabel, new Function<StateMachine.State, Object>(){

                        @Override
                        public Object apply(StateMachine.State state) {
                            if (!val$pred.test(instanceKey)) {
                                foundBadInstanceKey = true;
                            }
                            return null;
                        }
                    });
                }

                @Override
                public void visitGetField(GetFieldLabel getFieldLabel, Object object) {
                    PointerKey pointerKey;
                    IField iField = getFieldLabel.getField();
                    if (DemandRefinementPointsTo.this.refineFieldAccesses(iField, pointerKey = (PointerKey)object, this.val$curPk, getFieldLabel, this.val$curState)) {
                        OrdinalSet ordinalSet = this.val$h.getPToSetFromComputer(this.val$ptoComputer, new PointerKeyAndState(pointerKey, this.val$curState));
                        this.val$h.computeFlowsTo(this.val$ptoComputer, ordinalSet);
                        for (MemoryAccess memoryAccess : this.getWrites(iField, pointerKey)) {
                            Collection<Pair<PointerKey, PointerKey>> collection = this.getBaseAndStored(memoryAccess, iField);
                            if (collection == null) continue;
                            for (Pair<PointerKey, PointerKey> pair : collection) {
                                PointerKey pointerKey2 = (PointerKey)pair.fst;
                                PointerKey pointerKey3 = (PointerKey)pair.snd;
                                Collection collection2 = this.val$h.getFlowedToStates(this.val$ptoComputer, ordinalSet, pointerKey2);
                                for (StateMachine.State state : collection2) {
                                    this.val$h.propagate(new PointerKeyAndState(pointerKey3, state));
                                }
                            }
                        }
                    } else {
                        Iterator<PointerKey> iterator = DemandRefinementPointsTo.this.g.getWritesToInstanceField(pointerKey, iField);
                        while (iterator.hasNext()) {
                            final PointerKey pointerKey4 = iterator.next();
                            DemandRefinementPointsTo.this.doTransition(this.val$curState, MatchLabel.v(), new Function<StateMachine.State, Object>(){
                                {
                                }

                                @Override
                                public Object apply(StateMachine.State state) {
                                    val$h.propagate(new PointerKeyAndState(pointerKey4, state));
                                    return null;
                                }
                            });
                        }
                    }
                }

                private Collection<Pair<PointerKey, PointerKey>> getBaseAndStored(MemoryAccess memoryAccess, IField iField) {
                    CGNode cGNode = memoryAccess.getNode();
                    if (!DemandRefinementPointsTo.this.g.hasSubgraphForNode(cGNode)) {
                        return null;
                    }
                    IR iR = cGNode.getIR();
                    PointerKey pointerKey = null;
                    PointerKey pointerKey2 = null;
                    if (iField == ArrayContents.v()) {
                        SSAInstruction sSAInstruction = iR.getInstructions()[memoryAccess.getInstructionIndex()];
                        if (sSAInstruction == null) {
                            return null;
                        }
                        if (sSAInstruction instanceof SSANewInstruction) {
                            return DemandPointerFlowGraph.getInfoForNewMultiDim((SSANewInstruction)((SSANewInstruction)sSAInstruction), (HeapModel)DemandRefinementPointsTo.this.heapModel, (CGNode)memoryAccess.getNode()).arrStoreInstrs;
                        }
                        SSAArrayStoreInstruction sSAArrayStoreInstruction = (SSAArrayStoreInstruction)sSAInstruction;
                        pointerKey = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(memoryAccess.getNode(), sSAArrayStoreInstruction.getArrayRef());
                        pointerKey2 = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(memoryAccess.getNode(), sSAArrayStoreInstruction.getValue());
                    } else {
                        SSAPutInstruction sSAPutInstruction = (SSAPutInstruction)iR.getInstructions()[memoryAccess.getInstructionIndex()];
                        if (sSAPutInstruction == null) {
                            return null;
                        }
                        pointerKey = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(memoryAccess.getNode(), sSAPutInstruction.getRef());
                        pointerKey2 = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(memoryAccess.getNode(), sSAPutInstruction.getVal());
                    }
                    return Collections.singleton(Pair.make(pointerKey, pointerKey2));
                }

                private Collection<MemoryAccess> getWrites(IField iField, PointerKey pointerKey) {
                    PointerKey pointerKey2 = DemandRefinementPointsTo.this.convertToHeapModel(pointerKey, DemandRefinementPointsTo.this.mam.getHeapModel());
                    if (iField == ArrayContents.v()) {
                        return DemandRefinementPointsTo.this.mam.getArrayWrites(pointerKey);
                    }
                    return DemandRefinementPointsTo.this.mam.getFieldWrites(pointerKey2, iField);
                }

                @Override
                public void visitAssignGlobal(AssignGlobalLabel assignGlobalLabel, Object object) {
                    Iterator<? extends Object> iterator = DemandRefinementPointsTo.this.g.getWritesToStaticField((StaticFieldKey)object);
                    while (iterator.hasNext()) {
                        final PointerKey pointerKey = (PointerKey)iterator.next();
                        DemandRefinementPointsTo.this.doTransition(this.val$curState, assignGlobalLabel, new Function<StateMachine.State, Object>(){
                            {
                            }

                            @Override
                            public Object apply(StateMachine.State state) {
                                val$h.propagate(new PointerKeyAndState(pointerKey, state));
                                return null;
                            }
                        });
                    }
                }

                @Override
                public void visitAssign(AssignLabel assignLabel, Object object) {
                    final PointerKey pointerKey = (PointerKey)object;
                    DemandRefinementPointsTo.this.doTransition(this.val$curState, assignLabel, new Function<StateMachine.State, Object>(){
                        {
                        }

                        @Override
                        public Object apply(StateMachine.State state) {
                            val$h.propagate(new PointerKeyAndState(pointerKey, state));
                            return null;
                        }
                    });
                }
            }
            MyFlowLabelVisitor myFlowLabelVisitor = new MyFlowLabelVisitor(pointerKey2, state, helper, pointsToComputer, predicate);
            this.g.visitSuccs(pointerKey2, myFlowLabelVisitor);
            if (myFlowLabelVisitor.foundBadInstanceKey) {
                return false;
            }
            helper.handleTopLevelForwInterproc(pointerKeyAndState2);
        }
        return true;
    }

    private boolean predHoldsForPk(PointerKey pointerKey, Predicate<InstanceKey> predicate, PointerAnalysis pointerAnalysis) {
        PointerKey pointerKey2 = this.convertToHeapModel(pointerKey, pointerAnalysis.getHeapModel());
        OrdinalSet<InstanceKey> ordinalSet = pointerAnalysis.getPointsToSet(pointerKey2);
        for (InstanceKey instanceKey : ordinalSet) {
            if (predicate.test(instanceKey)) continue;
            return false;
        }
        return true;
    }

    private PointerKey convertToHeapModel(PointerKey pointerKey, HeapModel heapModel) {
        return AbstractFlowGraph.convertPointerKeyToHeapModel(pointerKey, heapModel);
    }

    private boolean refineFieldAccesses(IField iField, PointerKey pointerKey, PointerKey pointerKey2, IFlowLabel iFlowLabel, StateMachine.State state) {
        boolean bl = this.refinementPolicy.getFieldRefinePolicy().shouldRefine(iField, pointerKey, pointerKey2, iFlowLabel, state);
        return bl;
    }

    private boolean noOnTheFlyNeeded(CallerSiteContext callerSiteContext, Set<CGNode> set) {
        if (!this.refinementPolicy.getCallGraphRefinePolicy().shouldRefine(callerSiteContext)) {
            return true;
        }
        HashSet<IMethod> hashSet = new HashSet<IMethod>();
        for (CGNode cGNode : set) {
            hashSet.add(cGNode.getMethod());
        }
        return hashSet.size() <= 1;
    }

    private static abstract class CopyHandler {
        private CopyHandler() {
        }

        abstract void handle(PointerKeyAndState var1, PointerKey var2, IFlowLabel var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FlowsToComputer
    extends PointsToComputer {
        private final InstanceKeyAndState queriedIkAndState;
        private final int queriedIkAndStateNum;
        private final Collection<PointerKeyAndState> theFlowsToSet;

        public FlowsToComputer(InstanceKeyAndState instanceKeyAndState) {
            this.theFlowsToSet = HashSetFactory.make();
            this.queriedIkAndState = instanceKeyAndState;
            this.queriedIkAndStateNum = this.ikAndStates.add(this.queriedIkAndState);
        }

        @Override
        protected void compute() {
            InstanceKey instanceKey = this.queriedIkAndState.getInstanceKey();
            DemandRefinementPointsTo.this.g.addSubgraphForNode(((InstanceKeyWithNode)instanceKey).getNode());
            for (InstanceKey instanceKey2 : Iterator2Iterable.make(DemandRefinementPointsTo.this.g.getPredNodes(instanceKey, NewLabel.v()))) {
                PointerKey pointerKey = (PointerKey)((Object)instanceKey2);
                PointerKeyAndState pointerKeyAndState = new PointerKeyAndState(pointerKey, this.queriedIkAndState.getState());
                this.theFlowsToSet.add(pointerKeyAndState);
                this.findOrCreate(this.pkToTrackedSet, pointerKeyAndState).add(this.queriedIkAndStateNum);
                this.addToTrackedPToWorklist(pointerKeyAndState);
            }
            this.worklistLoop();
        }

        public Collection<PointerKeyAndState> getComputedFlowsToSet() {
            return this.theFlowsToSet;
        }

        @Override
        protected boolean handleTrackedPred(MutableIntSet mutableIntSet, PointerKeyAndState pointerKeyAndState, IFlowLabel iFlowLabel) {
            boolean bl = super.handleTrackedPred(mutableIntSet, pointerKeyAndState, iFlowLabel);
            if (bl && this.find(this.pkToTrackedSet, pointerKeyAndState).contains(this.queriedIkAndStateNum)) {
                this.theFlowsToSet.add(pointerKeyAndState);
            }
            return bl;
        }
    }

    private static final class LoadEdge {
        final PointerKeyAndState base;
        final IField field;
        final PointerKeyAndState val;

        public String toString() {
            return this.val + " := " + this.base + ", field " + this.field;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.val.hashCode();
            n = 31 * n + this.field.hashCode();
            n = 31 * n + this.base.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            LoadEdge loadEdge = (LoadEdge)object;
            if (!this.val.equals(loadEdge.val)) {
                return false;
            }
            if (!this.field.equals(loadEdge.field)) {
                return false;
            }
            return this.base.equals(loadEdge.base);
        }

        public LoadEdge(PointerKeyAndState pointerKeyAndState, IField iField, PointerKeyAndState pointerKeyAndState2) {
            this.base = pointerKeyAndState;
            this.field = iField;
            this.val = pointerKeyAndState2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PointsToComputer {
        protected final PointerKeyAndState queriedPkAndState;
        private final MultiMap<PointerKey, StateMachine.State> pointsToQueried = HashSetMultiMap.make();
        private final MultiMap<PointerKey, StateMachine.State> trackedQueried = HashSetMultiMap.make();
        private final Collection<PointerKeyAndState> initWorklist = new LinkedHashSet<PointerKeyAndState>();
        private final Collection<PointerKeyAndState> pointsToWorklist = new LinkedHashSet<PointerKeyAndState>();
        private final Collection<PointerKeyAndState> trackedPointsToWorklist = new LinkedHashSet<PointerKeyAndState>();
        private final MultiMap<PointerKeyAndState, CallerSiteContext> pkToOTFCalls = HashSetMultiMap.make();
        private final MultiMap<CallerSiteContext, IMethod> callToOTFTargets = ArraySetMultiMap.make();
        private final MultiMap<InstanceKeyAndState, IField> forwInstKeyToFields = HashSetMultiMap.make();
        private final MultiMap<InstanceKeyAndState, IField> backInstKeyToFields = HashSetMultiMap.make();
        protected final Map<PointerKeyAndState, MutableIntSet> pkToP2Set = HashMapFactory.make();
        protected final Map<PointerKeyAndState, MutableIntSet> pkToTrackedSet = HashMapFactory.make();
        private final Map<InstanceFieldKeyAndState, MutableIntSet> instFieldKeyToP2Set = HashMapFactory.make();
        private final Map<InstanceFieldKeyAndState, MutableIntSet> instFieldKeyToTrackedSet = HashMapFactory.make();
        protected final OrdinalSetMapping<InstanceKeyAndState> ikAndStates = MutableMapping.make();
        private final MutableIntSetFactory intSetFactory = new MutableSparseIntSetFactory();
        private final HashSet<StoreEdge> encounteredStores = HashSetFactory.make();
        private final HashSet<LoadEdge> encounteredLoads = HashSetFactory.make();
        private final MutableIntSet emptySet = this.intSetFactory.make();

        protected PointsToComputer() {
            this.queriedPkAndState = null;
        }

        protected PointsToComputer(PointerKey pointerKey) {
            this.queriedPkAndState = new PointerKeyAndState(pointerKey, DemandRefinementPointsTo.this.stateMachine.getStartState());
        }

        protected PointsToComputer(PointerKeyAndState pointerKeyAndState) {
            this.queriedPkAndState = pointerKeyAndState;
        }

        private OrdinalSet<InstanceKeyAndState> makeOrdinalSet(IntSet intSet) {
            return new OrdinalSet<InstanceKeyAndState>((IntSet)this.intSetFactory.makeCopy(intSet), this.ikAndStates);
        }

        public Collection<InstanceKeyAndState> getComputedP2Set(PointerKeyAndState pointerKeyAndState) {
            return Iterator2Collection.toSet(this.makeOrdinalSet(this.find(this.pkToP2Set, pointerKeyAndState)).iterator());
        }

        protected boolean addAllToP2Set(Map<PointerKeyAndState, MutableIntSet> map, PointerKeyAndState pointerKeyAndState, IntSet intSet, IFlowLabel iFlowLabel) {
            FilteredPointerKey.TypeFilter typeFilter;
            PointerKey pointerKey = pointerKeyAndState.getPointerKey();
            if (pointerKey instanceof FilteredPointerKey) {
                typeFilter = ((FilteredPointerKey)pointerKey).getTypeFilter();
                intSet = this.updateValsForFilter(intSet, typeFilter);
            }
            if (iFlowLabel instanceof IFlowLabelWithFilter && (typeFilter = ((IFlowLabelWithFilter)iFlowLabel).getFilter()) != null) {
                intSet = this.updateValsForFilter(intSet, typeFilter);
            }
            boolean bl = this.findOrCreate(map, pointerKeyAndState).addAll(intSet);
            return bl;
        }

        private IntSet updateValsForFilter(IntSet intSet, final FilteredPointerKey.TypeFilter typeFilter) {
            if (typeFilter instanceof FilteredPointerKey.SingleClassFilter) {
                final IClass iClass = ((FilteredPointerKey.SingleClassFilter)typeFilter).getConcreteType();
                Object t = this.intSetFactory.make();
                intSet.foreach(new IntSetAction((MutableIntSet)t){
                    private final /* synthetic */ MutableIntSet val$tmp;
                    {
                        this.val$tmp = mutableIntSet;
                    }

                    public void act(int n) {
                        InstanceKeyAndState instanceKeyAndState = PointsToComputer.this.ikAndStates.getMappedObject(n);
                        if (((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.cha.isAssignableFrom(iClass, instanceKeyAndState.getInstanceKey().getConcreteType())) {
                            this.val$tmp.add(n);
                        }
                    }
                });
                intSet = t;
            } else if (typeFilter instanceof FilteredPointerKey.MultipleClassesFilter) {
                Object t = this.intSetFactory.make();
                intSet.foreach(new IntSetAction((MutableIntSet)t){
                    private final /* synthetic */ MutableIntSet val$tmp;
                    {
                        this.val$tmp = mutableIntSet;
                    }

                    public void act(int n) {
                        InstanceKeyAndState instanceKeyAndState = PointsToComputer.this.ikAndStates.getMappedObject(n);
                        IClass[] iClassArray = ((FilteredPointerKey.MultipleClassesFilter)typeFilter).getConcreteTypes();
                        int n2 = iClassArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            IClass iClass = iClassArray[n3];
                            if (((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.cha.isAssignableFrom(iClass, instanceKeyAndState.getInstanceKey().getConcreteType())) {
                                this.val$tmp.add(n);
                            }
                            ++n3;
                        }
                    }
                });
                intSet = t;
            } else if (typeFilter instanceof FilteredPointerKey.SingleInstanceFilter) {
                final InstanceKey instanceKey = ((FilteredPointerKey.SingleInstanceFilter)typeFilter).getInstance();
                Object t = this.intSetFactory.make();
                intSet.foreach(new IntSetAction((MutableIntSet)t){
                    private final /* synthetic */ MutableIntSet val$tmp;
                    {
                        this.val$tmp = mutableIntSet;
                    }

                    public void act(int n) {
                        InstanceKeyAndState instanceKeyAndState = PointsToComputer.this.ikAndStates.getMappedObject(n);
                        if (instanceKeyAndState.getInstanceKey().equals(instanceKey)) {
                            this.val$tmp.add(n);
                        }
                    }
                });
                intSet = t;
            } else {
                Assertions.UNREACHABLE();
            }
            return intSet;
        }

        protected void compute() {
            CGNode cGNode = ((LocalPointerKey)this.queriedPkAndState.getPointerKey()).getNode();
            if (DemandRefinementPointsTo.this.hasNullIR(cGNode)) {
                return;
            }
            DemandRefinementPointsTo.this.g.addSubgraphForNode(cGNode);
            this.addToInitWorklist(this.queriedPkAndState);
            this.worklistLoop();
        }

        protected void worklistLoop() {
            while (true) {
                if (!(this.initWorklist.isEmpty() && this.pointsToWorklist.isEmpty() && this.trackedPointsToWorklist.isEmpty())) {
                    this.handleInitWorklist();
                    this.handlePointsToWorklist();
                    this.handleTrackedPointsToWorklist();
                    continue;
                }
                this.makePassOverFieldStmts();
                if (this.initWorklist.isEmpty() && this.pointsToWorklist.isEmpty() && this.trackedPointsToWorklist.isEmpty()) break;
            }
        }

        void handleCopy(final PointerKeyAndState pointerKeyAndState, final PointerKey pointerKey, final IFlowLabel iFlowLabel) {
            assert (!iFlowLabel.isBarred());
            StateMachine.State state = pointerKeyAndState.getState();
            DemandRefinementPointsTo.this.doTransition(state, iFlowLabel, new Function<StateMachine.State, Object>(){

                @Override
                public Object apply(StateMachine.State state) {
                    PointerKeyAndState pointerKeyAndState2 = new PointerKeyAndState(pointerKey, state);
                    PointsToComputer.this.handleCopy(pointerKeyAndState, pointerKeyAndState2, iFlowLabel);
                    return null;
                }
            });
        }

        void handleCopy(PointerKeyAndState pointerKeyAndState, PointerKeyAndState pointerKeyAndState2, IFlowLabel iFlowLabel) {
            if (!this.addToInitWorklist(pointerKeyAndState2) && this.addAllToP2Set(this.pkToP2Set, pointerKeyAndState, this.find(this.pkToP2Set, pointerKeyAndState2), iFlowLabel)) {
                this.addToPToWorklist(pointerKeyAndState);
            }
        }

        void handleAllCopies(PointerKeyAndState pointerKeyAndState, Iterator<? extends Object> iterator, IFlowLabel iFlowLabel) {
            while (iterator.hasNext()) {
                this.handleCopy(pointerKeyAndState, (PointerKey)iterator.next(), iFlowLabel);
            }
        }

        protected Collection<PointerKeyAndState> matchingPToQueried(PointerKeyAndState pointerKeyAndState, PointerKey pointerKey, IFlowLabel iFlowLabel) {
            ArraySet<PointerKeyAndState> arraySet = ArraySet.make();
            assert (iFlowLabel.isBarred());
            IFlowLabel iFlowLabel2 = iFlowLabel.bar();
            StateMachine.State state = pointerKeyAndState.getState();
            Set<StateMachine.State> set = this.pointsToQueried.get(pointerKey);
            for (StateMachine.State state2 : set) {
                StateMachine.State state3 = DemandRefinementPointsTo.this.stateMachine.transition(state2, iFlowLabel2);
                if (!state3.equals(state)) continue;
                arraySet.add(new PointerKeyAndState(pointerKey, state2));
            }
            return arraySet;
        }

        Collection<PointerKeyAndState> matchingTrackedQueried(PointerKeyAndState pointerKeyAndState, PointerKey pointerKey, IFlowLabel iFlowLabel) {
            ArraySet<PointerKeyAndState> arraySet = ArraySet.make();
            assert (iFlowLabel.isBarred());
            StateMachine.State state = pointerKeyAndState.getState();
            Set<StateMachine.State> set = this.trackedQueried.get(pointerKey);
            for (StateMachine.State state2 : set) {
                StateMachine.State state3 = DemandRefinementPointsTo.this.stateMachine.transition(state2, iFlowLabel);
                if (!state3.equals(state)) continue;
                arraySet.add(new PointerKeyAndState(pointerKey, state2));
            }
            return arraySet;
        }

        protected void handleBackCopy(PointerKeyAndState pointerKeyAndState, PointerKey pointerKey, IFlowLabel iFlowLabel) {
            for (PointerKeyAndState pointerKeyAndState2 : this.matchingPToQueried(pointerKeyAndState, pointerKey, iFlowLabel)) {
                if (!this.addAllToP2Set(this.pkToP2Set, pointerKeyAndState2, this.find(this.pkToP2Set, pointerKeyAndState), iFlowLabel)) continue;
                this.addToPToWorklist(pointerKeyAndState2);
            }
        }

        void handleAllBackCopies(PointerKeyAndState pointerKeyAndState, Iterator<? extends Object> iterator, IFlowLabel iFlowLabel) {
            while (iterator.hasNext()) {
                this.handleBackCopy(pointerKeyAndState, (PointerKey)iterator.next(), iFlowLabel);
            }
        }

        void addToPToWorklist(PointerKeyAndState pointerKeyAndState) {
            this.pointsToWorklist.add(pointerKeyAndState);
            Set<CallerSiteContext> set = this.pkToOTFCalls.get(pointerKeyAndState);
            for (CallerSiteContext callerSiteContext : set) {
                this.propTargets(pointerKeyAndState, callerSiteContext);
            }
        }

        boolean addToInitWorklist(PointerKeyAndState pointerKeyAndState) {
            if (this.pointsToQueried.put(pointerKeyAndState.getPointerKey(), pointerKeyAndState.getState())) {
                CGNode cGNode;
                if (pointerKeyAndState.getPointerKey() instanceof AbstractLocalPointerKey && !DemandRefinementPointsTo.this.g.hasSubgraphForNode(cGNode = ((AbstractLocalPointerKey)pointerKeyAndState.getPointerKey()).getNode())) assert (false) : "missing constraints for " + cGNode;
                this.initWorklist.add(pointerKeyAndState);
                return true;
            }
            return false;
        }

        protected void addToTrackedPToWorklist(PointerKeyAndState pointerKeyAndState) {
            CGNode cGNode;
            if (pointerKeyAndState.getPointerKey() instanceof AbstractLocalPointerKey && !DemandRefinementPointsTo.this.g.hasSubgraphForNode(cGNode = ((AbstractLocalPointerKey)pointerKeyAndState.getPointerKey()).getNode())) assert (false) : "missing constraints for " + cGNode;
            this.trackedQueried.put(pointerKeyAndState.getPointerKey(), pointerKeyAndState.getState());
            this.trackedPointsToWorklist.add(pointerKeyAndState);
        }

        void propTargets(PointerKeyAndState pointerKeyAndState, CallerSiteContext callerSiteContext) {
            final CGNode cGNode = callerSiteContext.getCaller();
            CallSiteReference callSiteReference = callerSiteContext.getCallSite();
            final StateMachine.State state = pointerKeyAndState.getState();
            OrdinalSet<InstanceKeyAndState> ordinalSet = this.makeOrdinalSet(this.find(this.pkToP2Set, pointerKeyAndState));
            for (InstanceKeyAndState instanceKeyAndState : ordinalSet) {
                InstanceKey instanceKey = instanceKeyAndState.getInstanceKey();
                IMethod iMethod = DemandRefinementPointsTo.this.options.getMethodTargetSelector().getCalleeTarget(cGNode, callSiteReference, instanceKey.getConcreteType());
                if (iMethod == null || this.callToOTFTargets.get(callerSiteContext).contains(iMethod)) continue;
                this.callToOTFTargets.put(callerSiteContext, iMethod);
                Set<CGNode> set = DemandRefinementPointsTo.this.cg.getNodes(iMethod.getReference());
                for (final CGNode cGNode2 : set) {
                    SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray;
                    if (DemandRefinementPointsTo.this.hasNullIR(cGNode2)) continue;
                    DemandRefinementPointsTo.this.g.addSubgraphForNode(cGNode2);
                    SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray2 = sSAAbstractInvokeInstructionArray = DemandRefinementPointsTo.this.getCallInstrs(cGNode, callSiteReference);
                    int n = sSAAbstractInvokeInstructionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PointerKey pointerKey;
                        PointerKeyAndState pointerKeyAndState2;
                        final SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = sSAAbstractInvokeInstructionArray2[n2];
                        final ReturnLabel returnLabel = ReturnLabel.make(new CallerSiteContext(cGNode, callSiteReference));
                        if (sSAAbstractInvokeInstruction.hasDef()) {
                            pointerKeyAndState2 = new PointerKeyAndState(DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(cGNode, sSAAbstractInvokeInstruction.getDef()), state);
                            pointerKey = DemandRefinementPointsTo.this.heapModel.getPointerKeyForReturnValue(cGNode2);
                            DemandRefinementPointsTo.this.doTransition(state, returnLabel, new Function<StateMachine.State, Object>(){

                                @Override
                                public Object apply(StateMachine.State state) {
                                    PointsToComputer.this.repropCallArg(pointerKeyAndState2, new PointerKeyAndState(pointerKey, state), returnLabel.bar());
                                    return null;
                                }
                            });
                        }
                        pointerKeyAndState2 = new PointerKeyAndState(DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(cGNode, sSAAbstractInvokeInstruction.getException()), state);
                        pointerKey = DemandRefinementPointsTo.this.heapModel.getPointerKeyForExceptionalReturnValue(cGNode2);
                        DemandRefinementPointsTo.this.doTransition(state, returnLabel, new Function<StateMachine.State, Object>(){

                            @Override
                            public Object apply(StateMachine.State state) {
                                PointsToComputer.this.repropCallArg(pointerKeyAndState2, new PointerKeyAndState(pointerKey, state), returnLabel.bar());
                                return null;
                            }
                        });
                        PointerParamValueNumIterator pointerParamValueNumIterator = new PointerParamValueNumIterator(cGNode2);
                        while (pointerParamValueNumIterator.hasNext()) {
                            final int n3 = (Integer)pointerParamValueNumIterator.next();
                            final int n4 = n3 - 1;
                            final ParamBarLabel paramBarLabel = ParamBarLabel.make(new CallerSiteContext(cGNode, callSiteReference));
                            DemandRefinementPointsTo.this.doTransition(state, paramBarLabel, new Function<StateMachine.State, Object>(){

                                @Override
                                public Object apply(StateMachine.State state2) {
                                    PointsToComputer.this.repropCallArg(new PointerKeyAndState(((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(cGNode2, n3), state2), new PointerKeyAndState(((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(cGNode, sSAAbstractInvokeInstruction.getUse(n4)), state), paramBarLabel);
                                    return null;
                                }
                            });
                        }
                        ++n2;
                    }
                }
            }
        }

        private void repropCallArg(PointerKeyAndState pointerKeyAndState, PointerKeyAndState pointerKeyAndState2, IFlowLabel iFlowLabel) {
            for (PointerKeyAndState pointerKeyAndState3 : this.matchingPToQueried(pointerKeyAndState2, pointerKeyAndState.getPointerKey(), iFlowLabel)) {
                this.handleCopy(pointerKeyAndState3, pointerKeyAndState2, iFlowLabel.bar());
            }
            for (PointerKeyAndState pointerKeyAndState3 : this.matchingTrackedQueried(pointerKeyAndState, pointerKeyAndState2.getPointerKey(), iFlowLabel)) {
                MutableIntSet mutableIntSet = this.find(this.pkToTrackedSet, pointerKeyAndState3);
                if (mutableIntSet.isEmpty() || !this.findOrCreate(this.pkToTrackedSet, pointerKeyAndState).addAll(mutableIntSet)) continue;
                this.addToTrackedPToWorklist(pointerKeyAndState);
            }
        }

        void handleInitWorklist() {
            while (!this.initWorklist.isEmpty()) {
                DemandRefinementPointsTo.this.incrementNumNodesTraversed();
                final PointerKeyAndState pointerKeyAndState = this.initWorklist.iterator().next();
                this.initWorklist.remove(pointerKeyAndState);
                final PointerKey pointerKey = pointerKeyAndState.getPointerKey();
                final StateMachine.State state = pointerKeyAndState.getState();
                if (pointerKey instanceof LocalPointerKey) assert (DemandRefinementPointsTo.this.g.hasSubgraphForNode(((LocalPointerKey)pointerKey).getNode()));
                AbstractFlowLabelVisitor abstractFlowLabelVisitor = new AbstractFlowLabelVisitor(){

                    public void visitNew(NewLabel newLabel, Object object) {
                        final InstanceKey instanceKey = (InstanceKey)object;
                        DemandRefinementPointsTo.this.doTransition(state, newLabel, new Function<StateMachine.State, Object>(){

                            @Override
                            public Object apply(StateMachine.State state) {
                                InstanceKeyAndState instanceKeyAndState = new InstanceKeyAndState(instanceKey, state);
                                int n = (this).PointsToComputer.this.ikAndStates.add(instanceKeyAndState);
                                PointsToComputer.this.findOrCreate((this).PointsToComputer.this.pkToP2Set, pointerKeyAndState).add(n);
                                PointsToComputer.this.addToPToWorklist(pointerKeyAndState);
                                return null;
                            }
                        });
                    }

                    public void visitGetField(GetFieldLabel getFieldLabel, Object object) {
                        IField iField = getFieldLabel.getField();
                        PointerKey pointerKey2 = (PointerKey)object;
                        if (DemandRefinementPointsTo.this.refineFieldAccesses(iField, pointerKey2, pointerKey, getFieldLabel, state)) {
                            PointerKeyAndState pointerKeyAndState2 = new PointerKeyAndState(pointerKey2, state);
                            PointsToComputer.this.addEncounteredLoad(new LoadEdge(pointerKeyAndState2, iField, pointerKeyAndState));
                            if (!PointsToComputer.this.addToInitWorklist(pointerKeyAndState2)) {
                                for (InstanceKeyAndState instanceKeyAndState : PointsToComputer.this.makeOrdinalSet(PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, pointerKeyAndState2))) {
                                    PointsToComputer.this.trackInstanceField(instanceKeyAndState, iField, PointsToComputer.this.forwInstKeyToFields);
                                }
                            }
                        } else {
                            PointsToComputer.this.handleAllCopies(pointerKeyAndState, ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.getWritesToInstanceField(pointerKey2, iField), MatchLabel.v());
                        }
                    }

                    public void visitAssignGlobal(AssignGlobalLabel assignGlobalLabel, Object object) {
                        PointsToComputer.this.handleAllCopies(pointerKeyAndState, ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.getWritesToStaticField((StaticFieldKey)object), AssignGlobalLabel.v());
                    }

                    public void visitAssign(AssignLabel assignLabel, Object object) {
                        PointsToComputer.this.handleCopy(pointerKeyAndState, (PointerKey)object, (IFlowLabel)AssignLabel.noFilter());
                    }
                };
                DemandRefinementPointsTo.this.g.visitSuccs(pointerKey, abstractFlowLabelVisitor);
                this.handleForwInterproc(pointerKeyAndState, new CopyHandler(){

                    void handle(PointerKeyAndState pointerKeyAndState, PointerKey pointerKey, IFlowLabel iFlowLabel) {
                        PointsToComputer.this.handleCopy(pointerKeyAndState, pointerKey, iFlowLabel);
                    }
                });
            }
        }

        private void handleForwInterproc(PointerKeyAndState pointerKeyAndState, CopyHandler copyHandler) {
            PointerKey pointerKey = pointerKeyAndState.getPointerKey();
            if (pointerKey instanceof LocalPointerKey) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                LocalPointerKey localPointerKey = (LocalPointerKey)pointerKey;
                if (DemandRefinementPointsTo.this.g.isParam(localPointerKey)) {
                    object4 = localPointerKey.getNode();
                    int n = localPointerKey.getValueNumber() - 1;
                    for (CallerSiteContext callerSiteContext : DemandRefinementPointsTo.this.g.getPotentialCallers(localPointerKey)) {
                        object3 = callerSiteContext.getCaller();
                        object2 = callerSiteContext.getCallSite();
                        if (DemandRefinementPointsTo.this.hasNullIR((CGNode)object3)) continue;
                        object = ParamLabel.make(callerSiteContext);
                        DemandRefinementPointsTo.this.doTransition(pointerKeyAndState.getState(), (IFlowLabel)object, new Function<StateMachine.State, Object>((CGNode)object3, (CallSiteReference)object2, n, localPointerKey, copyHandler, pointerKeyAndState, (ParamLabel)object, callerSiteContext, (CGNode)object4){
                            private final /* synthetic */ CGNode val$caller;
                            private final /* synthetic */ CallSiteReference val$call;
                            private final /* synthetic */ int val$paramPos;
                            private final /* synthetic */ LocalPointerKey val$localPk;
                            private final /* synthetic */ CopyHandler val$handler;
                            private final /* synthetic */ PointerKeyAndState val$curPkAndState;
                            private final /* synthetic */ ParamLabel val$paramLabel;
                            private final /* synthetic */ CallerSiteContext val$callSiteAndCGNode;
                            private final /* synthetic */ CGNode val$callee;
                            {
                                this.val$caller = cGNode;
                                this.val$call = callSiteReference;
                                this.val$paramPos = n;
                                this.val$localPk = localPointerKey;
                                this.val$handler = copyHandler;
                                this.val$curPkAndState = pointerKeyAndState;
                                this.val$paramLabel = paramLabel;
                                this.val$callSiteAndCGNode = callerSiteContext;
                                this.val$callee = cGNode2;
                            }

                            private void propagateToCallee() {
                                ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.addSubgraphForNode(this.val$caller);
                                SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = DemandRefinementPointsTo.this.getCallInstrs(this.val$caller, this.val$call);
                                int n = 0;
                                while (n < sSAAbstractInvokeInstructionArray.length) {
                                    SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = sSAAbstractInvokeInstructionArray[n];
                                    PointerKey pointerKey = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(this.val$caller, sSAAbstractInvokeInstruction.getUse(this.val$paramPos));
                                    if (!$assertionsDisabled && !((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.containsNode(pointerKey)) {
                                        throw new AssertionError();
                                    }
                                    if (!$assertionsDisabled && !((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.containsNode(this.val$localPk)) {
                                        throw new AssertionError();
                                    }
                                    this.val$handler.handle(this.val$curPkAndState, pointerKey, this.val$paramLabel);
                                    ++n;
                                }
                            }

                            @Override
                            public Object apply(StateMachine.State state) {
                                SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = DemandRefinementPointsTo.this.getCallInstrs(this.val$caller, this.val$call);
                                SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = sSAAbstractInvokeInstructionArray[0];
                                PointerKey pointerKey = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(this.val$caller, sSAAbstractInvokeInstruction.getUse(this.val$paramPos));
                                Set<CGNode> set = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.getPossibleTargets(this.val$caller, this.val$call, (LocalPointerKey)pointerKey);
                                if (DemandRefinementPointsTo.this.noOnTheFlyNeeded(this.val$callSiteAndCGNode, set)) {
                                    this.propagateToCallee();
                                } else if (PointsToComputer.this.callToOTFTargets.get(this.val$callSiteAndCGNode).contains(this.val$callee.getMethod())) {
                                    this.propagateToCallee();
                                } else {
                                    PointsToComputer.this.queryCallTargets(this.val$callSiteAndCGNode, sSAAbstractInvokeInstructionArray, state);
                                }
                                return null;
                            }
                        });
                    }
                }
                if ((object4 = DemandRefinementPointsTo.this.g.getInstrReturningTo(localPointerKey)) != null) {
                    CGNode cGNode = localPointerKey.getNode();
                    boolean bl = localPointerKey.getValueNumber() == ((SSAAbstractInvokeInstruction)object4).getException();
                    CallSiteReference callSiteReference = ((SSAAbstractInvokeInstruction)object4).getCallSite();
                    object3 = new CallerSiteContext(cGNode, callSiteReference);
                    if (DemandRefinementPointsTo.this.noOnTheFlyNeeded((CallerSiteContext)object3, (Set)(object2 = DemandRefinementPointsTo.this.g.getPossibleTargets(cGNode, callSiteReference, localPointerKey)))) {
                        Iterator iterator = object2.iterator();
                        while (iterator.hasNext()) {
                            PointerKey pointerKey2;
                            object = (CGNode)iterator.next();
                            if (DemandRefinementPointsTo.this.hasNullIR((CGNode)object)) continue;
                            DemandRefinementPointsTo.this.g.addSubgraphForNode((CGNode)object);
                            PointerKey pointerKey3 = pointerKey2 = bl ? DemandRefinementPointsTo.this.heapModel.getPointerKeyForExceptionalReturnValue((CGNode)object) : DemandRefinementPointsTo.this.heapModel.getPointerKeyForReturnValue((CGNode)object);
                            assert (DemandRefinementPointsTo.this.g.containsNode(pointerKey2));
                            copyHandler.handle(pointerKeyAndState, pointerKey2, ReturnLabel.make((CallerSiteContext)object3));
                        }
                    } else if (this.callToOTFTargets.containsKey((CallerSiteContext)object3)) {
                        object = this.callToOTFTargets.get((CallerSiteContext)object3);
                        Iterator iterator = object2.iterator();
                        while (iterator.hasNext()) {
                            PointerKey pointerKey4;
                            CGNode cGNode2 = (CGNode)iterator.next();
                            if (!object.contains(cGNode2.getMethod()) || DemandRefinementPointsTo.this.hasNullIR(cGNode2)) continue;
                            DemandRefinementPointsTo.this.g.addSubgraphForNode(cGNode2);
                            PointerKey pointerKey5 = pointerKey4 = bl ? DemandRefinementPointsTo.this.heapModel.getPointerKeyForExceptionalReturnValue(cGNode2) : DemandRefinementPointsTo.this.heapModel.getPointerKeyForReturnValue(cGNode2);
                            assert (DemandRefinementPointsTo.this.g.containsNode(pointerKey4));
                            copyHandler.handle(pointerKeyAndState, pointerKey4, ReturnLabel.make((CallerSiteContext)object3));
                        }
                    } else {
                        this.queryCallTargets((CallerSiteContext)object3, DemandRefinementPointsTo.this.getCallInstrs(cGNode, ((CallerSiteContext)object3).getCallSite()), pointerKeyAndState.getState());
                    }
                }
            }
        }

        private void trackInstanceField(InstanceKeyAndState instanceKeyAndState, IField iField, MultiMap<InstanceKeyAndState, IField> multiMap) {
            multiMap.put(instanceKeyAndState, iField);
            this.addPredsOfIKeyAndStateToTrackedPointsTo(instanceKeyAndState);
        }

        private void addPredsOfIKeyAndStateToTrackedPointsTo(InstanceKeyAndState instanceKeyAndState) throws UnimplementedError {
            Iterator<InstanceKey> iterator = DemandRefinementPointsTo.this.g.getPredNodes(instanceKeyAndState.getInstanceKey(), NewLabel.v());
            while (iterator.hasNext()) {
                PointerKey pointerKey = (PointerKey)((Object)iterator.next());
                PointerKeyAndState pointerKeyAndState = new PointerKeyAndState(pointerKey, instanceKeyAndState.getState());
                int n = this.ikAndStates.getMappedIndex(instanceKeyAndState);
                assert (n != -1);
                if (!this.findOrCreate(this.pkToTrackedSet, pointerKeyAndState).add(n)) continue;
                this.addToTrackedPToWorklist(pointerKeyAndState);
            }
        }

        private void queryCallTargets(CallerSiteContext callerSiteContext, SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray, StateMachine.State state) {
            CGNode cGNode = callerSiteContext.getCaller();
            SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray2 = sSAAbstractInvokeInstructionArray;
            int n = sSAAbstractInvokeInstructionArray.length;
            int n2 = 0;
            while (n2 < n) {
                SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = sSAAbstractInvokeInstructionArray2[n2];
                PointerKey pointerKey = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(cGNode, sSAAbstractInvokeInstruction.getUse(0));
                PointerKeyAndState pointerKeyAndState = new PointerKeyAndState(pointerKey, state);
                if (this.pkToOTFCalls.put(pointerKeyAndState, callerSiteContext)) {
                    CGNode cGNode2 = ((LocalPointerKey)pointerKey).getNode();
                    if (DemandRefinementPointsTo.this.hasNullIR(cGNode2)) {
                        return;
                    }
                    DemandRefinementPointsTo.this.g.addSubgraphForNode(cGNode2);
                    if (!this.addToInitWorklist(pointerKeyAndState)) {
                        this.propTargets(pointerKeyAndState, callerSiteContext);
                    }
                } else {
                    this.propTargets(pointerKeyAndState, callerSiteContext);
                }
                ++n2;
            }
        }

        void handlePointsToWorklist() {
            while (!this.pointsToWorklist.isEmpty()) {
                DemandRefinementPointsTo.this.incrementNumNodesTraversed();
                final PointerKeyAndState pointerKeyAndState = this.pointsToWorklist.iterator().next();
                this.pointsToWorklist.remove(pointerKeyAndState);
                final PointerKey pointerKey = pointerKeyAndState.getPointerKey();
                final StateMachine.State state = pointerKeyAndState.getState();
                AbstractFlowLabelVisitor abstractFlowLabelVisitor = new AbstractFlowLabelVisitor(){

                    public void visitPutField(PutFieldLabel putFieldLabel, Object object) {
                        IField iField = putFieldLabel.getField();
                        PointerKey pointerKey2 = (PointerKey)object;
                        if (DemandRefinementPointsTo.this.refineFieldAccesses(iField, pointerKey2, pointerKey, putFieldLabel, state)) {
                            PointerKeyAndState pointerKeyAndState2 = new PointerKeyAndState(pointerKey2, state);
                            PointsToComputer.this.encounteredStores.add(new StoreEdge(pointerKeyAndState2, iField, pointerKeyAndState));
                            for (InstanceKeyAndState instanceKeyAndState : PointsToComputer.this.makeOrdinalSet(PointsToComputer.this.find(PointsToComputer.this.pkToTrackedSet, pointerKeyAndState2))) {
                                if (!PointsToComputer.this.forwInstKeyToFields.get(instanceKeyAndState).contains(iField)) continue;
                                InstanceFieldKeyAndState instanceFieldKeyAndState = PointsToComputer.this.getInstFieldKey(instanceKeyAndState, iField);
                                PointsToComputer.this.findOrCreate(PointsToComputer.this.instFieldKeyToP2Set, instanceFieldKeyAndState).addAll(PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, pointerKeyAndState));
                            }
                        } else {
                            PointsToComputer.this.handleAllBackCopies(pointerKeyAndState, ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.getReadsOfInstanceField(pointerKey2, iField), MatchBarLabel.v());
                        }
                    }

                    public void visitGetField(GetFieldLabel getFieldLabel, Object object) {
                        IField iField = getFieldLabel.getField();
                        PointerKey pointerKey2 = (PointerKey)object;
                        if (DemandRefinementPointsTo.this.refineFieldAccesses(iField, pointerKey, pointerKey2, getFieldLabel, state)) {
                            PointerKeyAndState pointerKeyAndState2 = new PointerKeyAndState(pointerKey2, state);
                            PointsToComputer.this.addEncounteredLoad(new LoadEdge(pointerKeyAndState, iField, pointerKeyAndState2));
                            if (PointsToComputer.this.pointsToQueried.get(pointerKey2).contains(state)) {
                                for (InstanceKeyAndState instanceKeyAndState : PointsToComputer.this.makeOrdinalSet(PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, pointerKeyAndState))) {
                                    PointsToComputer.this.trackInstanceField(instanceKeyAndState, iField, PointsToComputer.this.forwInstKeyToFields);
                                }
                            }
                        }
                    }

                    public void visitAssignGlobal(AssignGlobalLabel assignGlobalLabel, Object object) {
                        PointsToComputer.this.handleAllBackCopies(pointerKeyAndState, ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.getReadsOfStaticField((StaticFieldKey)object), assignGlobalLabel.bar());
                    }

                    public void visitAssign(AssignLabel assignLabel, Object object) {
                        PointsToComputer.this.handleBackCopy(pointerKeyAndState, (PointerKey)object, assignLabel.bar());
                    }
                };
                DemandRefinementPointsTo.this.g.visitPreds(pointerKey, abstractFlowLabelVisitor);
                AbstractFlowLabelVisitor abstractFlowLabelVisitor2 = new AbstractFlowLabelVisitor(){

                    public void visitPutField(PutFieldLabel putFieldLabel, Object object) {
                        IField iField = putFieldLabel.getField();
                        PointerKey pointerKey2 = (PointerKey)object;
                        if (DemandRefinementPointsTo.this.refineFieldAccesses(iField, pointerKey, pointerKey2, putFieldLabel.bar(), state)) {
                            PointerKeyAndState pointerKeyAndState2 = new PointerKeyAndState(pointerKey2, state);
                            PointsToComputer.this.encounteredStores.add(new StoreEdge(pointerKeyAndState, iField, pointerKeyAndState2));
                            MutableIntSet mutableIntSet = PointsToComputer.this.find(PointsToComputer.this.pkToTrackedSet, pointerKeyAndState2);
                            if (!mutableIntSet.isEmpty()) {
                                for (InstanceKeyAndState instanceKeyAndState : PointsToComputer.this.makeOrdinalSet(PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, pointerKeyAndState))) {
                                    InstanceFieldKeyAndState instanceFieldKeyAndState = PointsToComputer.this.getInstFieldKey(instanceKeyAndState, iField);
                                    PointsToComputer.this.findOrCreate(PointsToComputer.this.instFieldKeyToTrackedSet, instanceFieldKeyAndState).addAll(mutableIntSet);
                                    PointsToComputer.this.trackInstanceField(instanceKeyAndState, iField, PointsToComputer.this.backInstKeyToFields);
                                }
                            }
                        }
                    }
                };
                DemandRefinementPointsTo.this.g.visitSuccs(pointerKey, abstractFlowLabelVisitor2);
                this.handleBackInterproc(pointerKeyAndState, new CopyHandler(){

                    void handle(PointerKeyAndState pointerKeyAndState, PointerKey pointerKey, IFlowLabel iFlowLabel) {
                        PointsToComputer.this.handleBackCopy(pointerKeyAndState, pointerKey, iFlowLabel);
                    }
                }, false);
            }
        }

        private void handleBackInterproc(PointerKeyAndState pointerKeyAndState, CopyHandler copyHandler, boolean bl) {
            Object object;
            Object object2;
            ContextItem contextItem;
            CGNode cGNode;
            AbstractLocalPointerKey abstractLocalPointerKey;
            PointerKey pointerKey = pointerKeyAndState.getPointerKey();
            StateMachine.State state = pointerKeyAndState.getState();
            if (pointerKey instanceof ReturnValueKey) {
                abstractLocalPointerKey = (ReturnValueKey)pointerKey;
                cGNode = ((NodeKey)abstractLocalPointerKey).getNode();
                boolean bl2 = abstractLocalPointerKey instanceof ExceptionReturnValueKey;
                for (CallerSiteContext object3 : DemandRefinementPointsTo.this.g.getPotentialCallers(abstractLocalPointerKey)) {
                    contextItem = object3.getCaller();
                    if (DemandRefinementPointsTo.this.hasNullIR(contextItem)) continue;
                    object2 = object3.getCallSite();
                    if (this.calleeSubGraphMissingAndShouldNotBeAdded(bl, cGNode, pointerKeyAndState)) continue;
                    object = ReturnBarLabel.make(object3);
                    DemandRefinementPointsTo.this.doTransition(state, (IFlowLabel)object, new Function<StateMachine.State, Object>((CallSiteReference)object2, bl2, (ReturnValueKey)abstractLocalPointerKey, copyHandler, pointerKeyAndState, (ReturnBarLabel)object, object3, cGNode){
                        private final /* synthetic */ CallSiteReference val$call;
                        private final /* synthetic */ boolean val$isExceptional;
                        private final /* synthetic */ ReturnValueKey val$returnKey;
                        private final /* synthetic */ CopyHandler val$handler;
                        private final /* synthetic */ PointerKeyAndState val$curPkAndState;
                        private final /* synthetic */ ReturnBarLabel val$returnBarLabel;
                        private final /* synthetic */ CallerSiteContext val$callSiteAndCGNode;
                        private final /* synthetic */ CGNode val$callee;
                        {
                            this.val$call = callSiteReference;
                            this.val$isExceptional = bl;
                            this.val$returnKey = returnValueKey;
                            this.val$handler = copyHandler;
                            this.val$curPkAndState = pointerKeyAndState;
                            this.val$returnBarLabel = returnBarLabel;
                            this.val$callSiteAndCGNode = callerSiteContext;
                            this.val$callee = cGNode2;
                        }

                        private void propagateToCaller() {
                            ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.addSubgraphForNode(contextItem);
                            SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = DemandRefinementPointsTo.this.getCallInstrs(contextItem, this.val$call);
                            int n = 0;
                            while (n < sSAAbstractInvokeInstructionArray.length) {
                                SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = sSAAbstractInvokeInstructionArray[n];
                                PointerKey pointerKey = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(contextItem, this.val$isExceptional ? sSAAbstractInvokeInstruction.getException() : sSAAbstractInvokeInstruction.getDef());
                                if (!$assertionsDisabled && !((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.containsNode(pointerKey)) {
                                    throw new AssertionError();
                                }
                                if (!$assertionsDisabled && !((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.containsNode(this.val$returnKey)) {
                                    throw new AssertionError();
                                }
                                this.val$handler.handle(this.val$curPkAndState, pointerKey, this.val$returnBarLabel);
                                ++n;
                            }
                        }

                        @Override
                        public Object apply(StateMachine.State state) {
                            SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = DemandRefinementPointsTo.this.getCallInstrs(contextItem, this.val$call);
                            SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = sSAAbstractInvokeInstructionArray[0];
                            PointerKey pointerKey = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(contextItem, this.val$isExceptional ? sSAAbstractInvokeInstruction.getException() : sSAAbstractInvokeInstruction.getDef());
                            Set<CGNode> set = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.getPossibleTargets(contextItem, this.val$call, (LocalPointerKey)pointerKey);
                            if (DemandRefinementPointsTo.this.noOnTheFlyNeeded(this.val$callSiteAndCGNode, set)) {
                                this.propagateToCaller();
                            } else if (PointsToComputer.this.callToOTFTargets.get(this.val$callSiteAndCGNode).contains(this.val$callee.getMethod())) {
                                this.propagateToCaller();
                            } else {
                                PointsToComputer.this.queryCallTargets(this.val$callSiteAndCGNode, sSAAbstractInvokeInstructionArray, state);
                            }
                            return null;
                        }
                    });
                }
            }
            if (pointerKey instanceof LocalPointerKey) {
                abstractLocalPointerKey = (LocalPointerKey)pointerKey;
                cGNode = ((LocalPointerKey)abstractLocalPointerKey).getNode();
                Iterator<SSAInvokeInstruction> iterator = DemandRefinementPointsTo.this.g.getInstrsPassingParam((LocalPointerKey)abstractLocalPointerKey);
                while (iterator.hasNext()) {
                    SSAInvokeInstruction sSAInvokeInstruction = iterator.next();
                    int n = 0;
                    while (n < sSAInvokeInstruction.getNumberOfUses()) {
                        if (((LocalPointerKey)abstractLocalPointerKey).getValueNumber() == sSAInvokeInstruction.getUse(n)) {
                            Object object3;
                            Object object4;
                            Object object5;
                            contextItem = sSAInvokeInstruction.getCallSite();
                            object2 = new CallerSiteContext(cGNode, (CallSiteReference)contextItem);
                            if (DemandRefinementPointsTo.this.noOnTheFlyNeeded((CallerSiteContext)object2, (Set)(object = DemandRefinementPointsTo.this.g.getPossibleTargets(cGNode, (CallSiteReference)contextItem, (LocalPointerKey)abstractLocalPointerKey)))) {
                                object5 = object.iterator();
                                while (object5.hasNext()) {
                                    object4 = (CGNode)object5.next();
                                    if (this.calleeSubGraphMissingAndShouldNotBeAdded(bl, (CGNode)object4, pointerKeyAndState) || DemandRefinementPointsTo.this.hasNullIR((CGNode)object4)) continue;
                                    DemandRefinementPointsTo.this.g.addSubgraphForNode((CGNode)object4);
                                    object3 = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal((CGNode)object4, n + 1);
                                    assert (DemandRefinementPointsTo.this.g.containsNode(object3));
                                    copyHandler.handle(pointerKeyAndState, (PointerKey)object3, ParamBarLabel.make((CallerSiteContext)object2));
                                }
                            } else if (this.callToOTFTargets.containsKey((CallerSiteContext)object2)) {
                                object4 = this.callToOTFTargets.get((CallerSiteContext)object2);
                                object3 = object.iterator();
                                while (object3.hasNext()) {
                                    object5 = (CGNode)object3.next();
                                    if (!object4.contains(object5.getMethod()) || DemandRefinementPointsTo.this.hasNullIR((CGNode)object5)) continue;
                                    DemandRefinementPointsTo.this.g.addSubgraphForNode((CGNode)object5);
                                    PointerKey pointerKey2 = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal((CGNode)object5, n + 1);
                                    assert (DemandRefinementPointsTo.this.g.containsNode(pointerKey2));
                                    copyHandler.handle(pointerKeyAndState, pointerKey2, ParamBarLabel.make((CallerSiteContext)object2));
                                }
                            } else {
                                this.queryCallTargets((CallerSiteContext)object2, DemandRefinementPointsTo.this.getCallInstrs(cGNode, ((CallerSiteContext)object2).getCallSite()), state);
                            }
                        }
                        ++n;
                    }
                }
            }
        }

        protected boolean calleeSubGraphMissingAndShouldNotBeAdded(boolean bl, CGNode cGNode, PointerKeyAndState pointerKeyAndState) {
            return !bl && !DemandRefinementPointsTo.this.g.hasSubgraphForNode(cGNode);
        }

        public void handleTrackedPointsToWorklist() {
            while (!this.trackedPointsToWorklist.isEmpty()) {
                DemandRefinementPointsTo.this.incrementNumNodesTraversed();
                final PointerKeyAndState pointerKeyAndState = this.trackedPointsToWorklist.iterator().next();
                this.trackedPointsToWorklist.remove(pointerKeyAndState);
                final PointerKey pointerKey = pointerKeyAndState.getPointerKey();
                final StateMachine.State state = pointerKeyAndState.getState();
                final MutableIntSet mutableIntSet = this.find(this.pkToTrackedSet, pointerKeyAndState);
                AbstractFlowLabelVisitor abstractFlowLabelVisitor = new AbstractFlowLabelVisitor(){

                    public void visitPutField(PutFieldLabel putFieldLabel, Object object) {
                        IField iField = putFieldLabel.getField();
                        PointerKey pointerKey2 = (PointerKey)object;
                        if (DemandRefinementPointsTo.this.refineFieldAccesses(iField, pointerKey, pointerKey2, putFieldLabel, state)) {
                            for (InstanceKeyAndState instanceKeyAndState : PointsToComputer.this.makeOrdinalSet(mutableIntSet)) {
                                boolean bl = PointsToComputer.this.forwInstKeyToFields.get(instanceKeyAndState).contains(iField);
                                PointerKeyAndState pointerKeyAndState2 = new PointerKeyAndState(pointerKey2, state);
                                PointsToComputer.this.encounteredStores.add(new StoreEdge(pointerKeyAndState, iField, pointerKeyAndState2));
                                if (!bl || PointsToComputer.this.addToInitWorklist(pointerKeyAndState2)) continue;
                                InstanceFieldKeyAndState instanceFieldKeyAndState = PointsToComputer.this.getInstFieldKey(instanceKeyAndState, iField);
                                PointsToComputer.this.findOrCreate(PointsToComputer.this.instFieldKeyToP2Set, instanceFieldKeyAndState).addAll(PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, pointerKeyAndState2));
                            }
                        }
                    }
                };
                DemandRefinementPointsTo.this.g.visitSuccs(pointerKey, abstractFlowLabelVisitor);
                AbstractFlowLabelVisitor abstractFlowLabelVisitor2 = new AbstractFlowLabelVisitor(){

                    public void visitAssignGlobal(AssignGlobalLabel assignGlobalLabel, Object object) {
                        Iterator<? extends Object> iterator = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.getReadsOfStaticField((StaticFieldKey)object);
                        while (iterator.hasNext()) {
                            final PointerKey pointerKey2 = (PointerKey)iterator.next();
                            DemandRefinementPointsTo.this.doTransition(state, AssignGlobalBarLabel.v(), new Function<StateMachine.State, Object>(){

                                @Override
                                public Object apply(StateMachine.State state) {
                                    PointerKeyAndState pointerKeyAndState = new PointerKeyAndState(pointerKey2, state);
                                    PointsToComputer.this.handleTrackedPred(mutableIntSet, pointerKeyAndState, AssignGlobalBarLabel.v());
                                    return null;
                                }
                            });
                        }
                    }

                    public void visitPutField(PutFieldLabel putFieldLabel, Object object) {
                        block3: {
                            PointerKey pointerKey3;
                            IField iField;
                            block2: {
                                iField = putFieldLabel.getField();
                                pointerKey3 = (PointerKey)object;
                                if (!DemandRefinementPointsTo.this.refineFieldAccesses(iField, pointerKey3, pointerKey, putFieldLabel.bar(), state)) break block2;
                                PointerKeyAndState pointerKeyAndState2 = new PointerKeyAndState(pointerKey3, state);
                                PointsToComputer.this.encounteredStores.add(new StoreEdge(pointerKeyAndState2, iField, pointerKeyAndState));
                                if (PointsToComputer.this.addToInitWorklist(pointerKeyAndState2)) break block3;
                                for (InstanceKeyAndState instanceKeyAndState : PointsToComputer.this.makeOrdinalSet(PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, pointerKeyAndState2))) {
                                    InstanceFieldKeyAndState instanceFieldKeyAndState = PointsToComputer.this.getInstFieldKey(instanceKeyAndState, iField);
                                    PointsToComputer.this.findOrCreate(PointsToComputer.this.instFieldKeyToTrackedSet, instanceFieldKeyAndState).addAll(mutableIntSet);
                                    PointsToComputer.this.trackInstanceField(instanceKeyAndState, iField, PointsToComputer.this.backInstKeyToFields);
                                }
                                break block3;
                            }
                            Iterator<PointerKey> iterator = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.g.getReadsOfInstanceField(pointerKey3, iField);
                            while (iterator.hasNext()) {
                                final PointerKey pointerKey2 = iterator.next();
                                DemandRefinementPointsTo.this.doTransition(state, MatchBarLabel.v(), new Function<StateMachine.State, Object>(){

                                    @Override
                                    public Object apply(StateMachine.State state) {
                                        PointerKeyAndState pointerKeyAndState = new PointerKeyAndState(pointerKey2, state);
                                        PointsToComputer.this.handleTrackedPred(mutableIntSet, pointerKeyAndState, MatchBarLabel.v());
                                        return null;
                                    }
                                });
                            }
                        }
                    }

                    public void visitGetField(GetFieldLabel getFieldLabel, Object object) {
                        IField iField = getFieldLabel.getField();
                        PointerKey pointerKey2 = (PointerKey)object;
                        if (DemandRefinementPointsTo.this.refineFieldAccesses(iField, pointerKey, pointerKey2, getFieldLabel.bar(), state)) {
                            for (InstanceKeyAndState instanceKeyAndState : PointsToComputer.this.makeOrdinalSet(mutableIntSet)) {
                                boolean bl = PointsToComputer.this.backInstKeyToFields.get(instanceKeyAndState).contains(iField);
                                PointerKeyAndState pointerKeyAndState2 = new PointerKeyAndState(pointerKey2, state);
                                PointsToComputer.this.addEncounteredLoad(new LoadEdge(pointerKeyAndState, iField, pointerKeyAndState2));
                                if (!bl) continue;
                                InstanceFieldKeyAndState instanceFieldKeyAndState = PointsToComputer.this.getInstFieldKey(instanceKeyAndState, iField);
                                PointsToComputer.this.handleTrackedPred(PointsToComputer.this.find(PointsToComputer.this.instFieldKeyToTrackedSet, instanceFieldKeyAndState), pointerKeyAndState2, AssignBarLabel.noFilter());
                            }
                        }
                    }

                    public void visitAssign(final AssignLabel assignLabel, Object object) {
                        final PointerKey pointerKey2 = (PointerKey)object;
                        DemandRefinementPointsTo.this.doTransition(state, assignLabel.bar(), new Function<StateMachine.State, Object>(){

                            @Override
                            public Object apply(StateMachine.State state) {
                                PointerKeyAndState pointerKeyAndState = new PointerKeyAndState(pointerKey2, state);
                                PointsToComputer.this.handleTrackedPred(mutableIntSet, pointerKeyAndState, assignLabel.bar());
                                return null;
                            }
                        });
                    }
                };
                DemandRefinementPointsTo.this.g.visitPreds(pointerKey, abstractFlowLabelVisitor2);
                this.handleBackInterproc(pointerKeyAndState, new CopyHandler(){

                    void handle(PointerKeyAndState pointerKeyAndState2, final PointerKey pointerKey, final IFlowLabel iFlowLabel) {
                        if (!$assertionsDisabled && pointerKeyAndState2 != pointerKeyAndState) {
                            throw new AssertionError();
                        }
                        DemandRefinementPointsTo.this.doTransition(state, iFlowLabel, new Function<StateMachine.State, Object>(){

                            @Override
                            public Object apply(StateMachine.State state) {
                                PointerKeyAndState pointerKeyAndState = new PointerKeyAndState(pointerKey, state);
                                PointsToComputer.this.handleTrackedPred(mutableIntSet, pointerKeyAndState, iFlowLabel);
                                return null;
                            }
                        });
                    }
                }, true);
            }
        }

        private void addEncounteredLoad(LoadEdge loadEdge) {
            this.encounteredLoads.add(loadEdge);
        }

        public void makePassOverFieldStmts() {
            Object object;
            Object object2;
            Object object3;
            IField iField;
            PointerKeyAndState pointerKeyAndState;
            for (StoreEdge object4 : this.encounteredStores) {
                pointerKeyAndState = object4.val;
                iField = object4.field;
                object3 = object4.base;
                object2 = this.find(this.pkToTrackedSet, object3);
                for (InstanceKeyAndState instanceKeyAndState : this.makeOrdinalSet((IntSet)object2)) {
                    if (!this.forwInstKeyToFields.get(instanceKeyAndState).contains(iField) || this.addToInitWorklist(pointerKeyAndState)) continue;
                    object = this.getInstFieldKey(instanceKeyAndState, iField);
                    this.findOrCreate(this.instFieldKeyToP2Set, object).addAll(this.find(this.pkToP2Set, pointerKeyAndState));
                }
            }
            for (LoadEdge loadEdge : this.encounteredLoads) {
                pointerKeyAndState = loadEdge.val;
                iField = loadEdge.field;
                object3 = loadEdge.base.getPointerKey();
                object2 = pointerKeyAndState.getState();
                PointerKeyAndState pointerKeyAndState2 = new PointerKeyAndState((PointerKey)object3, (StateMachine.State)object2);
                boolean bl = this.pointsToQueried.get((PointerKey)object3).contains(object2) || !this.pointsToQueried.get(pointerKeyAndState.getPointerKey()).contains(object2) || this.initWorklist.contains(pointerKeyAndState);
                object = this.find(this.pkToP2Set, pointerKeyAndState2);
                for (InstanceKeyAndState instanceKeyAndState : this.makeOrdinalSet((IntSet)object)) {
                    InstanceFieldKeyAndState instanceFieldKeyAndState = this.getInstFieldKey(instanceKeyAndState, iField);
                    if (!this.pointsToQueried.get(pointerKeyAndState.getPointerKey()).contains(pointerKeyAndState.getState()) || !this.addAllToP2Set(this.pkToP2Set, pointerKeyAndState, this.find(this.instFieldKeyToP2Set, instanceFieldKeyAndState), AssignLabel.noFilter())) continue;
                    this.addToPToWorklist(pointerKeyAndState);
                }
                PointerKeyAndState pointerKeyAndState3 = loadEdge.base;
                for (InstanceKeyAndState instanceKeyAndState : this.makeOrdinalSet(this.find(this.pkToTrackedSet, pointerKeyAndState3))) {
                    if (!this.backInstKeyToFields.get(instanceKeyAndState).contains(iField)) continue;
                    InstanceFieldKeyAndState instanceFieldKeyAndState = this.getInstFieldKey(instanceKeyAndState, iField);
                    if (!this.findOrCreate(this.pkToTrackedSet, pointerKeyAndState).addAll(this.find(this.instFieldKeyToTrackedSet, instanceFieldKeyAndState))) continue;
                    this.addToTrackedPToWorklist(pointerKeyAndState);
                }
            }
        }

        private InstanceFieldKeyAndState getInstFieldKey(InstanceKeyAndState instanceKeyAndState, IField iField) {
            return new InstanceFieldKeyAndState(new InstanceFieldKey(instanceKeyAndState.getInstanceKey(), iField), instanceKeyAndState.getState());
        }

        protected <K> MutableIntSet findOrCreate(Map<K, MutableIntSet> map, K k) {
            MutableIntSet mutableIntSet = map.get(k);
            if (mutableIntSet == null) {
                mutableIntSet = this.intSetFactory.make();
                map.put(k, mutableIntSet);
            }
            return mutableIntSet;
        }

        protected <K> MutableIntSet find(Map<K, MutableIntSet> map, K k) {
            MutableIntSet mutableIntSet = map.get(k);
            if (mutableIntSet == null) {
                mutableIntSet = this.emptySet;
            }
            return mutableIntSet;
        }

        protected boolean handleTrackedPred(MutableIntSet mutableIntSet, PointerKeyAndState pointerKeyAndState, IFlowLabel iFlowLabel) {
            if (this.addAllToP2Set(this.pkToTrackedSet, pointerKeyAndState, mutableIntSet, iFlowLabel)) {
                this.addToTrackedPToWorklist(pointerKeyAndState);
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PointsToResult {
        SUCCESS,
        NOMOREREFINE,
        BUDGETEXCEEDED;

    }

    private static final class StoreEdge {
        final PointerKeyAndState base;
        final IField field;
        final PointerKeyAndState val;

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.val.hashCode();
            n = 31 * n + this.field.hashCode();
            n = 31 * n + this.base.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            StoreEdge storeEdge = (StoreEdge)object;
            if (!this.val.equals(storeEdge.val)) {
                return false;
            }
            if (!this.field.equals(storeEdge.field)) {
                return false;
            }
            return this.base.equals(storeEdge.base);
        }

        public StoreEdge(PointerKeyAndState pointerKeyAndState, IField iField, PointerKeyAndState pointerKeyAndState2) {
            this.base = pointerKeyAndState;
            this.field = iField;
            this.val = pointerKeyAndState2;
        }
    }
}

