/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg;

import com.ibm.wala.demandpa.alg.BudgetExceededException;
import com.ibm.wala.demandpa.alg.IDemandPointerAnalysis;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.cha.IClassHierarchy;

public abstract class AbstractDemandPointsTo
implements IDemandPointerAnalysis {
    protected final CallGraph cg;
    protected final HeapModel heapModel;
    protected final MemoryAccessMap mam;
    protected final IClassHierarchy cha;
    protected final AnalysisOptions options;
    protected int numNodesTraversed;
    private int traversalBudget = Integer.MAX_VALUE;

    public int getTraversalBudget() {
        return this.traversalBudget;
    }

    protected void setTraversalBudget(int n) {
        this.traversalBudget = n;
    }

    public AbstractDemandPointsTo(CallGraph callGraph, HeapModel heapModel, MemoryAccessMap memoryAccessMap, IClassHierarchy iClassHierarchy, AnalysisOptions analysisOptions) {
        this.cg = callGraph;
        this.heapModel = heapModel;
        this.mam = memoryAccessMap;
        this.cha = iClassHierarchy;
        this.options = analysisOptions;
    }

    public HeapModel getHeapModel() {
        return this.heapModel;
    }

    protected void incrementNumNodesTraversed() {
        if (this.numNodesTraversed > this.traversalBudget) {
            throw new BudgetExceededException();
        }
        ++this.numNodesTraversed;
    }

    protected void setNumNodesTraversed(int n) {
        this.numNodesTraversed = n;
    }

    public int getNumNodesTraversed() {
        return this.numNodesTraversed;
    }

    public CallGraph getBaseCallGraph() {
        return this.cg;
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }
}

