/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.graph;

import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixedpoint.impl.DefaultFixedPointSolver;
import com.ibm.wala.fixedpoint.impl.UnaryOperator;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.ObjectArrayMapping;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.intset.IntegerUnionFind;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataflowSolver<T, V extends IVariable>
extends DefaultFixedPointSolver<V> {
    private final IKilldallFramework<T, V> problem;
    private final Map<Object, V> node2In = HashMapFactory.make();
    private final Map<Object, V> node2Out = HashMapFactory.make();
    private final Map<Object, V> edge2Var = HashMapFactory.make();

    public DataflowSolver(IKilldallFramework<T, V> iKilldallFramework) {
        super(2);
        this.problem = iKilldallFramework;
    }

    protected abstract V makeNodeVariable(T var1, boolean var2);

    protected abstract V makeEdgeVariable(T var1, T var2);

    @Override
    protected void initializeVariables() {
        Graph graph = this.problem.getFlowGraph();
        ITransferFunctionProvider<T, V> iTransferFunctionProvider = this.problem.getTransferFunctionProvider();
        for (Object t : graph) {
            assert (t != null);
            V v = this.makeNodeVariable(t, true);
            this.node2In.put(t, v);
            if (iTransferFunctionProvider.hasNodeTransferFunctions()) {
                v = this.makeNodeVariable(t, false);
                this.node2Out.put(t, v);
            }
            if (!iTransferFunctionProvider.hasEdgeTransferFunctions()) continue;
            Iterator iterator = graph.getSuccNodes(t);
            while (iterator.hasNext()) {
                Object t2 = iterator.next();
                v = this.makeEdgeVariable(t, t2);
                this.edge2Var.put(Pair.make(t, t2), v);
            }
        }
    }

    @Override
    protected void initializeWorkList() {
        this.buildEquations(true, false);
    }

    public V getOut(Object object) {
        assert (object != null);
        IVariable iVariable = (IVariable)this.node2Out.get(object);
        assert (iVariable != null);
        return (V)iVariable;
    }

    public V getIn(Object object) {
        return (V)((IVariable)this.node2In.get(object));
    }

    public V getEdge(Object object) {
        return (V)((IVariable)this.edge2Var.get(object));
    }

    public V getEdge(Object object, Object object2) {
        assert (object != null);
        assert (object2 != null);
        V v = this.getEdge(Pair.make(object, object2));
        assert (v != null);
        return v;
    }

    protected void buildEquations(boolean bl, boolean bl2) {
        Object object;
        ITransferFunctionProvider<Object, V> iTransferFunctionProvider = this.problem.getTransferFunctionProvider();
        Graph graph = this.problem.getFlowGraph();
        AbstractMeetOperator<V> abstractMeetOperator = iTransferFunctionProvider.getMeetOperator();
        UnionFind unionFind = new UnionFind();
        if (abstractMeetOperator.isUnaryNoOp()) {
            this.shortCircuitUnaryMeets(graph, iTransferFunctionProvider, unionFind);
        }
        this.shortCircuitIdentities(graph, iTransferFunctionProvider, unionFind);
        this.fixShortCircuits(unionFind);
        int n = abstractMeetOperator.isUnaryNoOp() ? 2 : 1;
        for (Object t : graph) {
            int n2 = graph.getPredNodeCount(t);
            if (n2 < n) continue;
            object = new IVariable[n2];
            int n3 = 0;
            Iterator iterator = graph.getPredNodes(t);
            while (iterator.hasNext()) {
                Object object2 = object[n3++] = iTransferFunctionProvider.hasEdgeTransferFunctions() ? this.getEdge(iterator.next(), t) : this.getOut(iterator.next());
            }
            this.newStatement(this.getIn(t), abstractMeetOperator, (IVariable[])object, bl, bl2);
        }
        if (iTransferFunctionProvider.hasNodeTransferFunctions()) {
            for (Object t : graph) {
                UnaryOperator<V> unaryOperator = iTransferFunctionProvider.getNodeTransferFunction(t);
                if (unaryOperator.isIdentity()) continue;
                this.newStatement(this.getOut(t), unaryOperator, this.getIn(t), bl, bl2);
            }
        }
        if (iTransferFunctionProvider.hasEdgeTransferFunctions()) {
            for (Object t : graph) {
                Iterator iterator = graph.getSuccNodes(t);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    UnaryOperator<V> unaryOperator = iTransferFunctionProvider.getEdgeTransferFunction(t, object);
                    if (unaryOperator.isIdentity()) continue;
                    this.newStatement(this.getEdge(t, object), unaryOperator, iTransferFunctionProvider.hasNodeTransferFunctions() ? this.getOut(t) : this.getIn(t), bl, bl2);
                }
            }
        }
    }

    private void shortCircuitIdentities(Graph<T> graph, ITransferFunctionProvider<T, V> iTransferFunctionProvider, UnionFind unionFind) {
        UnaryOperator<V> unaryOperator;
        if (iTransferFunctionProvider.hasNodeTransferFunctions()) {
            for (Object t : graph) {
                unaryOperator = iTransferFunctionProvider.getNodeTransferFunction(t);
                if (!unaryOperator.isIdentity()) continue;
                unionFind.union(this.getIn(t), this.getOut(t));
            }
        }
        if (iTransferFunctionProvider.hasEdgeTransferFunctions()) {
            for (Object t : graph) {
                unaryOperator = graph.getSuccNodes(t);
                while (unaryOperator.hasNext()) {
                    Object e = unaryOperator.next();
                    UnaryOperator<V> unaryOperator2 = iTransferFunctionProvider.getEdgeTransferFunction(t, e);
                    if (!unaryOperator2.isIdentity()) continue;
                    unionFind.union(this.getEdge(t, e), iTransferFunctionProvider.hasNodeTransferFunctions() ? this.getOut(t) : this.getIn(t));
                }
            }
        }
    }

    private void fixShortCircuits(UnionFind unionFind) {
        if (unionFind.didSomething) {
            int n = 0;
            while (n < unionFind.size()) {
                int n2 = unionFind.find(n);
                if (n != n2) {
                    Object object = unionFind.getKey(n);
                    Object object2 = unionFind.getKey(n2);
                    if (unionFind.isIn(n)) {
                        if (unionFind.isIn(n2)) {
                            this.node2In.put(object, this.getIn(object2));
                        } else if (unionFind.isOut(n2)) {
                            this.node2In.put(object, this.getOut(object2));
                        } else {
                            this.node2In.put(object, this.getEdge(object2));
                        }
                    } else if (unionFind.isOut(n)) {
                        if (unionFind.isIn(n2)) {
                            this.node2Out.put(object, this.getIn(object2));
                        } else if (unionFind.isOut(n2)) {
                            this.node2Out.put(object, this.getOut(object2));
                        } else {
                            this.node2Out.put(object, this.getEdge(object2));
                        }
                    } else if (unionFind.isIn(n2)) {
                        this.edge2Var.put(object, this.getIn(object2));
                    } else if (unionFind.isOut(n2)) {
                        this.edge2Var.put(object, this.getOut(object2));
                    } else {
                        this.edge2Var.put(object, this.getEdge(object2));
                    }
                }
                ++n;
            }
        }
    }

    private void shortCircuitUnaryMeets(Graph<T> graph, ITransferFunctionProvider iTransferFunctionProvider, UnionFind unionFind) {
        for (Object t : graph) {
            assert (t != null);
            int n = graph.getPredNodeCount(t);
            if (n != 1) continue;
            Object t2 = graph.getPredNodes(t).next();
            assert (t2 != null);
            unionFind.union(this.getIn(t), iTransferFunctionProvider.hasEdgeTransferFunctions() ? this.getEdge(t2, t) : this.getOut(t2));
        }
    }

    public IKilldallFramework getProblem() {
        return this.problem;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnionFind {
        final IntegerUnionFind uf;
        final ObjectArrayMapping map;
        boolean didSomething = false;
        private final Object[] allKeys;

        private int mapIt(int n, Object[] objectArray, Map<Object, V> map) {
            Iterator<Object> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                this.allKeys[n] = object = iterator.next();
                objectArray[n++] = map.get(object);
            }
            return n;
        }

        UnionFind() {
            this.allKeys = new Object[DataflowSolver.this.node2In.size() + DataflowSolver.this.node2Out.size() + DataflowSolver.this.edge2Var.size()];
            Object[] objectArray = new Object[DataflowSolver.this.node2In.size() + DataflowSolver.this.node2Out.size() + DataflowSolver.this.edge2Var.size()];
            int n = this.mapIt(0, objectArray, DataflowSolver.this.node2In);
            n = this.mapIt(n, objectArray, DataflowSolver.this.node2Out);
            this.mapIt(n, objectArray, DataflowSolver.this.edge2Var);
            this.uf = new IntegerUnionFind(objectArray.length);
            this.map = new ObjectArrayMapping<Object>(objectArray);
        }

        public void union(Object object, Object object2) {
            assert (object != null);
            assert (object2 != null);
            int n = this.map.getMappedIndex(object);
            int n2 = this.map.getMappedIndex(object2);
            this.uf.union(n, n2);
            this.didSomething = true;
        }

        public int size() {
            return this.map.getSize();
        }

        public int find(int n) {
            return this.uf.find(n);
        }

        public boolean isIn(int n) {
            return n < DataflowSolver.this.node2In.size();
        }

        public boolean isOut(int n) {
            return !this.isIn(n) && n < DataflowSolver.this.node2In.size() + DataflowSolver.this.node2Out.size();
        }

        public Object getKey(int n) {
            return this.allKeys[n];
        }
    }
}

