/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PathEdge<T> {
    final T entry;
    final int d1;
    final T target;
    final int d2;

    public static <T> PathEdge<T> createPathEdge(T t, int n, T t2, int n2) {
        if (t == null) {
            throw new IllegalArgumentException("null s_p");
        }
        if (t2 == null) {
            throw new IllegalArgumentException("null n");
        }
        return new PathEdge<T>(t, n, t2, n2);
    }

    private PathEdge(T t, int n, T t2, int n2) {
        this.entry = t;
        this.d1 = n;
        this.target = t2;
        this.d2 = n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.entry.toString());
        stringBuffer.append(",");
        stringBuffer.append(this.d1);
        stringBuffer.append("> -> <");
        stringBuffer.append(this.target.toString());
        stringBuffer.append(",");
        stringBuffer.append(this.d2);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.d1;
        n = 31 * n + this.d2;
        n = 31 * n + (this.target == null ? 0 : this.target.hashCode());
        n = 31 * n + (this.entry == null ? 0 : this.entry.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PathEdge pathEdge = (PathEdge)object;
        if (this.d1 != pathEdge.d1) {
            return false;
        }
        if (this.d2 != pathEdge.d2) {
            return false;
        }
        if (this.target == null ? pathEdge.target != null : !this.target.equals(pathEdge.target)) {
            return false;
        }
        return !(this.entry == null ? pathEdge.entry != null : !this.entry.equals(pathEdge.entry));
    }

    public int getD1() {
        return this.d1;
    }

    public int getD2() {
        return this.d2;
    }

    public T getEntry() {
        return this.entry;
    }

    public T getTarget() {
        return this.target;
    }
}

