/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.dataflow.IFDS.IFlowFunction;
import com.ibm.wala.dataflow.IFDS.IUnaryFlowFunction;
import com.ibm.wala.dataflow.IFDS.PartiallyBalancedTabulationProblem;
import com.ibm.wala.dataflow.IFDS.PathEdge;
import com.ibm.wala.dataflow.IFDS.TabulationSolver;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartiallyBalancedTabulationSolver<T, P, F>
extends TabulationSolver<T, P, F> {
    private final Collection<Pair<T, Integer>> unbalancedSeeds = HashSetFactory.make();

    public static <T, P, F> PartiallyBalancedTabulationSolver<T, P, F> createPartiallyBalancedTabulationSolver(PartiallyBalancedTabulationProblem<T, P, F> partiallyBalancedTabulationProblem, IProgressMonitor iProgressMonitor) {
        return new PartiallyBalancedTabulationSolver<T, P, F>(partiallyBalancedTabulationProblem, iProgressMonitor);
    }

    protected PartiallyBalancedTabulationSolver(PartiallyBalancedTabulationProblem<T, P, F> partiallyBalancedTabulationProblem, IProgressMonitor iProgressMonitor) {
        super(partiallyBalancedTabulationProblem, iProgressMonitor);
    }

    @Override
    protected boolean propagate(T t, int n, T t2, int n2) {
        boolean bl = super.propagate(t, n, t2, n2);
        if (bl && this.wasUsedAsUnbalancedSeed(t, n) && this.supergraph.isExit(t2)) {
            Iterator<T> iterator = this.supergraph.getSuccNodes(t2);
            while (iterator.hasNext()) {
                T t3 = iterator.next();
                PartiallyBalancedTabulationProblem partiallyBalancedTabulationProblem = (PartiallyBalancedTabulationProblem)this.getProblem();
                IFlowFunction iFlowFunction = partiallyBalancedTabulationProblem.getFunctionMap().getUnbalancedReturnFlowFunction(t2, t3);
                if (iFlowFunction instanceof IUnaryFlowFunction) {
                    IUnaryFlowFunction iUnaryFlowFunction = (IUnaryFlowFunction)iFlowFunction;
                    IntSet intSet = iUnaryFlowFunction.getTargets(n2);
                    if (intSet == null) continue;
                    IntIterator intIterator = intSet.intIterator();
                    while (intIterator.hasNext()) {
                        int n3 = intIterator.next();
                        T t4 = partiallyBalancedTabulationProblem.getFakeEntry(t3);
                        PathEdge<T> pathEdge = PathEdge.createPathEdge(t4, n3, t3, n3);
                        this.addSeed(pathEdge);
                    }
                    continue;
                }
                Assertions.UNREACHABLE("Partially balanced logic not supported for binary return flow functions");
            }
        }
        return bl;
    }

    @Override
    public void addSeed(PathEdge<T> pathEdge) {
        if (this.getSeeds().contains(pathEdge)) {
            return;
        }
        this.unbalancedSeeds.add(Pair.make(pathEdge.entry, pathEdge.d1));
        super.addSeed(pathEdge);
    }

    private boolean wasUsedAsUnbalancedSeed(T t, int n) {
        return this.unbalancedSeeds.contains(Pair.make(t, n));
    }
}

