/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.intset.IntSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackwardsSupergraph<T, P>
implements ISupergraph<T, P> {
    static final int DEBUG_LEVEL = 0;
    private final ISupergraph<T, P> delegate;
    private final ExitFilter exitFilter = new ExitFilter();

    protected BackwardsSupergraph(ISupergraph<T, P> iSupergraph) {
        if (iSupergraph == null) {
            throw new IllegalArgumentException("null forwardGraph");
        }
        this.delegate = iSupergraph;
    }

    public static <T, P> BackwardsSupergraph<T, P> make(ISupergraph<T, P> iSupergraph) {
        return new BackwardsSupergraph<T, P>(iSupergraph);
    }

    @Override
    public Graph<? extends P> getProcedureGraph() {
        return this.delegate.getProcedureGraph();
    }

    @Override
    public boolean isCall(T t) {
        return this.delegate.isReturn(t);
    }

    @Override
    public Iterator<T> getCalledNodes(T t) {
        return new FilterIterator(this.getSuccNodes(t), this.exitFilter);
    }

    @Override
    public Iterator<T> getNormalSuccessors(final T t) {
        Iterator<T> iterator = this.delegate.getPredNodes(t);
        Filter filter = new Filter<T>(){

            @Override
            public boolean accepts(T t2) {
                return BackwardsSupergraph.this.getProcOf(t).equals(BackwardsSupergraph.this.getProcOf(t2)) && !BackwardsSupergraph.this.delegate.isExit(t2);
            }
        };
        FilterIterator filterIterator = new FilterIterator(iterator, filter);
        Filter filter2 = new Filter<T>(){

            @Override
            public boolean accepts(T t) {
                return !BackwardsSupergraph.this.delegate.isCall(t);
            }
        };
        return new FilterIterator(filterIterator, filter2);
    }

    @Override
    public Iterator<? extends T> getReturnSites(T t, P p) {
        return this.delegate.getCallSites(t, p);
    }

    @Override
    public boolean isExit(T t) {
        return this.delegate.isEntry(t);
    }

    @Override
    public P getProcOf(T t) {
        return this.delegate.getProcOf(t);
    }

    @Override
    public void removeNodeAndEdges(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int getNumberOfNodes() {
        return this.delegate.getNumberOfNodes();
    }

    @Override
    public void addNode(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNode(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsNode(T t) {
        return this.delegate.containsNode(t);
    }

    @Override
    public Iterator<T> getPredNodes(T t) {
        return this.delegate.getSuccNodes(t);
    }

    @Override
    public int getPredNodeCount(T t) {
        return this.delegate.getSuccNodeCount(t);
    }

    @Override
    public Iterator<T> getSuccNodes(T t) {
        return this.delegate.getPredNodes(t);
    }

    @Override
    public boolean hasEdge(T t, T t2) {
        return this.delegate.hasEdge(t2, t);
    }

    @Override
    public int getSuccNodeCount(T t) {
        return this.delegate.getPredNodeCount(t);
    }

    @Override
    public void addEdge(Object object, Object object2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEdge(Object object, Object object2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAllIncidentEdges(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public T[] getEntriesForProcedure(P p) {
        return this.delegate.getExitsForProcedure(p);
    }

    @Override
    public T[] getExitsForProcedure(P p) {
        return this.delegate.getEntriesForProcedure(p);
    }

    @Override
    public boolean isReturn(T t) throws UnimplementedError {
        return this.delegate.isCall(t);
    }

    @Override
    public Iterator<? extends T> getCallSites(T t, P p) {
        return this.delegate.getReturnSites(t, p);
    }

    @Override
    public boolean isEntry(T t) {
        return this.delegate.isExit(t);
    }

    @Override
    public byte classifyEdge(T t, T t2) {
        byte by = this.delegate.classifyEdge(t2, t);
        switch (by) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
        }
        Assertions.UNREACHABLE();
        return -1;
    }

    public String toString() {
        return "Backwards of delegate\n" + this.delegate;
    }

    @Override
    public void removeIncomingEdges(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeOutgoingEdges(T t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumberOfBlocks(P p) {
        return this.delegate.getNumberOfBlocks(p);
    }

    @Override
    public int getLocalBlockNumber(T t) {
        return this.delegate.getLocalBlockNumber(t);
    }

    @Override
    public T getLocalBlock(P p, int n) {
        return this.delegate.getLocalBlock(p, n);
    }

    @Override
    public int getNumber(T t) {
        return this.delegate.getNumber(t);
    }

    @Override
    public T getNode(int n) {
        return this.delegate.getNode(n);
    }

    @Override
    public int getMaxNumber() {
        return this.delegate.getMaxNumber();
    }

    @Override
    public Iterator<T> iterateNodes(IntSet intSet) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getSuccNodeNumbers(T t) {
        return this.delegate.getPredNodeNumbers(t);
    }

    @Override
    public IntSet getPredNodeNumbers(Object object) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    private class ExitFilter
    implements Filter {
        private ExitFilter() {
        }

        public boolean accepts(Object object) {
            return BackwardsSupergraph.this.delegate.isExit(object);
        }
    }
}

