/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.FieldImpl;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.JVMClass;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.InnerClassesReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.RuntimeInvisibleAnnotationsReader;
import com.ibm.wala.shrikeCT.RuntimeVisibleAnnotationsReader;
import com.ibm.wala.shrikeCT.SignatureReader;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.types.generics.ClassSignature;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.shrike.ShrikeClassReaderHandle;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.ImmutableByteArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShrikeClass
extends JVMClass<IClassLoader> {
    static final boolean DEBUG = false;
    private final ShrikeClassReaderHandle reader;

    public ShrikeClass(ShrikeClassReaderHandle shrikeClassReaderHandle, IClassLoader iClassLoader, IClassHierarchy iClassHierarchy) throws InvalidClassFileException {
        super(iClassLoader, iClassHierarchy);
        if (shrikeClassReaderHandle == null) {
            throw new IllegalArgumentException("reader is null");
        }
        this.reader = shrikeClassReaderHandle;
        this.computeTypeReference();
        this.hashCode = 2161 * this.getReference().hashCode();
        this.computeSuperName();
        this.computeModifiers();
        this.computeInterfaceNames();
        this.computeFields();
    }

    private void computeFields() throws InvalidClassFileException {
        ClassReader classReader = this.reader.get();
        int n = classReader.getFieldCount();
        ArrayList<FieldImpl> arrayList = new ArrayList<FieldImpl>(n);
        ArrayList<FieldImpl> arrayList2 = new ArrayList<FieldImpl>(n);
        try {
            int n2 = 0;
            while (n2 < n) {
                int n3 = classReader.getFieldAccessFlags(n2);
                Atom atom = Atom.findOrCreateUnicodeAtom(classReader.getFieldName(n2));
                ImmutableByteArray immutableByteArray = ImmutableByteArray.make(classReader.getFieldType(n2));
                Collection<Annotation> collection = null;
                try {
                    collection = this.getRuntimeInvisibleAnnotations(n2);
                    collection = collection.isEmpty() ? null : collection;
                }
                catch (AnnotationsReader.UnimplementedException unimplementedException) {
                    unimplementedException.printStackTrace();
                }
                if ((n3 & 8) == 0) {
                    this.addFieldToList(arrayList, atom, immutableByteArray, n3, collection);
                } else {
                    this.addFieldToList(arrayList2, atom, immutableByteArray, n3, collection);
                }
                ++n2;
            }
            this.instanceFields = new IField[arrayList.size()];
            this.populateFieldArrayFromList(arrayList, this.instanceFields);
            this.staticFields = new IField[arrayList2.size()];
            this.populateFieldArrayFromList(arrayList2, this.staticFields);
        }
        catch (InvalidClassFileException invalidClassFileException) {
            invalidClassFileException.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    private void computeModifiers() throws InvalidClassFileException {
        this.modifiers = this.reader.get().getAccessFlags();
    }

    private void computeSuperName() {
        try {
            String string = this.reader.get().getSuperName();
            if (string != null) {
                this.superName = ImmutableByteArray.make("L" + string);
            }
        }
        catch (InvalidClassFileException invalidClassFileException) {
            Assertions.UNREACHABLE();
        }
    }

    private void computeInterfaceNames() {
        try {
            String[] stringArray = this.reader.get().getInterfaceNames();
            this.interfaceNames = new ImmutableByteArray[stringArray.length];
            int n = 0;
            while (n < this.interfaceNames.length) {
                this.interfaceNames[n] = ImmutableByteArray.make("L" + stringArray[n]);
                ++n;
            }
        }
        catch (InvalidClassFileException invalidClassFileException) {
            Assertions.UNREACHABLE();
        }
    }

    protected ShrikeCTMethod[] computeDeclaredMethods() throws InvalidClassFileException {
        int n = this.reader.get().getMethodCount();
        ShrikeCTMethod[] shrikeCTMethodArray = new ShrikeCTMethod[n];
        int n2 = 0;
        while (n2 < n) {
            ShrikeCTMethod shrikeCTMethod;
            shrikeCTMethodArray[n2] = shrikeCTMethod = new ShrikeCTMethod(this, n2);
            ++n2;
        }
        return shrikeCTMethodArray;
    }

    private void computeTypeReference() throws InvalidClassFileException {
        String string = "L" + this.reader.get().getName();
        ImmutableByteArray immutableByteArray = ImmutableByteArray.make(string);
        this.typeReference = TypeReference.findOrCreate(this.getClassLoader().getReference(), TypeName.findOrCreate(immutableByteArray));
    }

    public boolean equals(Object object) {
        if (object instanceof ShrikeClass) {
            return this.getReference().equals(((ShrikeClass)object).getReference());
        }
        return false;
    }

    public ClassReader getReader() {
        try {
            return this.reader.get();
        }
        catch (InvalidClassFileException invalidClassFileException) {
            invalidClassFileException.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    public void clearSoftCaches() {
        if (this.methodMap != null) {
            for (ShrikeCTMethod shrikeCTMethod : this.getDeclaredMethods()) {
                shrikeCTMethod.clearCaches();
            }
        }
        this.inheritCache = null;
        this.allInterfaces = null;
        this.reader.clear();
    }

    public Collection<Annotation> getRuntimeInvisibleAnnotations() throws InvalidClassFileException, AnnotationsReader.UnimplementedException {
        return this.getAnnotations(true);
    }

    public Collection<Annotation> getRuntimeVisibleAnnotations() throws InvalidClassFileException, AnnotationsReader.UnimplementedException {
        return this.getAnnotations(false);
    }

    public Collection<Annotation> getAnnotations(boolean bl) throws InvalidClassFileException, AnnotationsReader.UnimplementedException {
        AnnotationsReader annotationsReader = this.getAnnotationsReader(bl);
        if (annotationsReader != null) {
            int[] nArray = annotationsReader.getAnnotationOffsets();
            HashSet<Annotation> hashSet = HashSetFactory.make();
            int[] nArray2 = nArray;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray2[n2];
                String string = annotationsReader.getAnnotationType(n3);
                string = string.replaceAll(";", "");
                TypeReference typeReference = TypeReference.findOrCreate(this.getClassLoader().getReference(), string);
                hashSet.add(Annotation.make(typeReference));
                ++n2;
            }
            return hashSet;
        }
        return Collections.emptySet();
    }

    private AnnotationsReader getAnnotationsReader(boolean bl) throws InvalidClassFileException {
        ClassReader classReader = this.reader.get();
        ClassReader.AttrIterator attrIterator = new ClassReader.AttrIterator();
        classReader.initClassAttributeIterator(attrIterator);
        RuntimeInvisibleAnnotationsReader runtimeInvisibleAnnotationsReader = null;
        try {
            while (attrIterator.isValid()) {
                if (bl) {
                    if (attrIterator.getName().equals("RuntimeInvisibleAnnotations")) {
                        runtimeInvisibleAnnotationsReader = new RuntimeInvisibleAnnotationsReader(attrIterator);
                        break;
                    }
                } else if (attrIterator.getName().equals("RuntimeVisibleAnnotations")) {
                    runtimeInvisibleAnnotationsReader = new RuntimeVisibleAnnotationsReader(attrIterator);
                    break;
                }
                attrIterator.advance();
            }
        }
        catch (InvalidClassFileException invalidClassFileException) {
            Assertions.UNREACHABLE();
        }
        return runtimeInvisibleAnnotationsReader;
    }

    private InnerClassesReader getInnerClassesReader() throws InvalidClassFileException {
        ClassReader classReader = this.reader.get();
        ClassReader.AttrIterator attrIterator = new ClassReader.AttrIterator();
        classReader.initClassAttributeIterator(attrIterator);
        InnerClassesReader innerClassesReader = null;
        try {
            while (attrIterator.isValid()) {
                if (attrIterator.getName().equals("InnerClasses")) {
                    innerClassesReader = new InnerClassesReader(attrIterator);
                    break;
                }
                attrIterator.advance();
            }
        }
        catch (InvalidClassFileException invalidClassFileException) {
            Assertions.UNREACHABLE();
        }
        return innerClassesReader;
    }

    private RuntimeInvisibleAnnotationsReader getRuntimeInvisibleAnnotationsReader(int n) throws InvalidClassFileException {
        ClassReader.AttrIterator attrIterator = new ClassReader.AttrIterator();
        this.reader.get().initFieldAttributeIterator(n, attrIterator);
        RuntimeInvisibleAnnotationsReader runtimeInvisibleAnnotationsReader = null;
        try {
            while (attrIterator.isValid()) {
                if (attrIterator.getName().toString().equals("RuntimeInvisibleAnnotations")) {
                    runtimeInvisibleAnnotationsReader = new RuntimeInvisibleAnnotationsReader(attrIterator);
                    break;
                }
                attrIterator.advance();
            }
        }
        catch (InvalidClassFileException invalidClassFileException) {
            Assertions.UNREACHABLE();
        }
        return runtimeInvisibleAnnotationsReader;
    }

    public Collection<Annotation> getRuntimeInvisibleAnnotations(int n) throws InvalidClassFileException, AnnotationsReader.UnimplementedException {
        RuntimeInvisibleAnnotationsReader runtimeInvisibleAnnotationsReader = this.getRuntimeInvisibleAnnotationsReader(n);
        if (runtimeInvisibleAnnotationsReader != null) {
            int[] nArray = runtimeInvisibleAnnotationsReader.getAnnotationOffsets();
            HashSet<Annotation> hashSet = HashSetFactory.make();
            int[] nArray2 = nArray;
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray2[n3];
                String string = runtimeInvisibleAnnotationsReader.getAnnotationType(n4);
                string = string.replaceAll(";", "");
                TypeReference typeReference = TypeReference.findOrCreate(this.getClassLoader().getReference(), string);
                hashSet.add(Annotation.make(typeReference));
                ++n3;
            }
            return hashSet;
        }
        return Collections.emptySet();
    }

    private SignatureReader getSignatureReader() throws InvalidClassFileException {
        ClassReader classReader = this.reader.get();
        ClassReader.AttrIterator attrIterator = new ClassReader.AttrIterator();
        classReader.initClassAttributeIterator(attrIterator);
        SignatureReader signatureReader = null;
        try {
            while (attrIterator.isValid()) {
                if (attrIterator.getName().toString().equals("Signature")) {
                    signatureReader = new SignatureReader(attrIterator);
                    break;
                }
                attrIterator.advance();
            }
        }
        catch (InvalidClassFileException invalidClassFileException) {
            Assertions.UNREACHABLE();
        }
        return signatureReader;
    }

    public ClassSignature getClassSignature() throws InvalidClassFileException {
        SignatureReader signatureReader = this.getSignatureReader();
        if (signatureReader == null) {
            return null;
        }
        return ClassSignature.make(signatureReader.getSignature());
    }

    public ModuleEntry getModuleEntry() {
        return this.reader.getModuleEntry();
    }

    public boolean isInnerClass() throws InvalidClassFileException {
        InnerClassesReader innerClassesReader = this.getInnerClassesReader();
        if (innerClassesReader != null) {
            String[] stringArray = innerClassesReader.getInnerClasses();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.equals(this.getName().toString().substring(1))) {
                    String string2 = innerClassesReader.getOuterClass(string);
                    return string2 != null;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isStaticInnerClass() throws InvalidClassFileException {
        InnerClassesReader innerClassesReader = this.getInnerClassesReader();
        if (innerClassesReader != null) {
            String[] stringArray = innerClassesReader.getInnerClasses();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string;
                String string2 = stringArray[n2];
                if (string2.equals(this.getName().toString().substring(1)) && (string = innerClassesReader.getOuterClass(string2)) != null) {
                    int n3 = innerClassesReader.getAccessFlags(string2);
                    boolean bl = (n3 & 8) != 0;
                    return bl;
                }
                ++n2;
            }
        }
        return false;
    }

    public TypeReference getOuterClass() throws InvalidClassFileException {
        if (!this.isInnerClass()) {
            return null;
        }
        InnerClassesReader innerClassesReader = this.getInnerClassesReader();
        String[] stringArray = innerClassesReader.getInnerClasses();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            String string2 = stringArray[n2];
            if (string2.equals(this.getName().toString().substring(1)) && (string = innerClassesReader.getOuterClass(string2)) != null) {
                return TypeReference.findOrCreate(this.getClassLoader().getReference(), "L" + string);
            }
            ++n2;
        }
        return null;
    }
}

