/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IBytecodeMethod;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeScanner {
    public static Collection<CallSiteReference> getCallSites(IMethod iMethod) throws InvalidClassFileException {
        if (iMethod == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (iMethod.isSynthetic()) {
            SyntheticMethod syntheticMethod = (SyntheticMethod)iMethod;
            return CodeScanner.getCallSites(syntheticMethod.getStatements());
        }
        return CodeScanner.getCallSitesFromShrikeBT((IBytecodeMethod)iMethod);
    }

    public static Collection<FieldReference> getFieldsRead(IMethod iMethod) throws InvalidClassFileException {
        if (iMethod == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (iMethod.isSynthetic()) {
            SyntheticMethod syntheticMethod = (SyntheticMethod)iMethod;
            return CodeScanner.getFieldsRead(syntheticMethod.getStatements());
        }
        return CodeScanner.getFieldsReadFromShrikeBT((ShrikeCTMethod)iMethod);
    }

    public static Collection<FieldReference> getFieldsWritten(IMethod iMethod) throws InvalidClassFileException {
        if (iMethod == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (iMethod.isSynthetic()) {
            SyntheticMethod syntheticMethod = (SyntheticMethod)iMethod;
            return CodeScanner.getFieldsWritten(syntheticMethod.getStatements());
        }
        return CodeScanner.getFieldsWrittenFromShrikeBT((ShrikeCTMethod)iMethod);
    }

    public static Collection<TypeReference> getArraysWritten(IMethod iMethod) throws InvalidClassFileException {
        if (iMethod == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (iMethod.isSynthetic()) {
            SyntheticMethod syntheticMethod = (SyntheticMethod)iMethod;
            return CodeScanner.getArraysWritten(syntheticMethod.getStatements());
        }
        return CodeScanner.getArraysWrittenFromShrikeBT((ShrikeCTMethod)iMethod);
    }

    public static Collection<NewSiteReference> getNewSites(IMethod iMethod) throws InvalidClassFileException {
        if (iMethod == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (iMethod.isSynthetic()) {
            SyntheticMethod syntheticMethod = (SyntheticMethod)iMethod;
            return CodeScanner.getNewSites(syntheticMethod.getStatements());
        }
        return CodeScanner.getNewSitesFromShrikeBT((ShrikeCTMethod)iMethod);
    }

    public static boolean hasObjectArrayLoad(IMethod iMethod) throws InvalidClassFileException {
        if (iMethod == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (iMethod.isSynthetic()) {
            SyntheticMethod syntheticMethod = (SyntheticMethod)iMethod;
            return CodeScanner.hasObjectArrayLoad(syntheticMethod.getStatements());
        }
        return CodeScanner.hasShrikeBTObjectArrayLoad((ShrikeCTMethod)iMethod);
    }

    public static boolean hasObjectArrayStore(IMethod iMethod) throws InvalidClassFileException {
        if (iMethod == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (iMethod.isSynthetic()) {
            SyntheticMethod syntheticMethod = (SyntheticMethod)iMethod;
            return CodeScanner.hasObjectArrayStore(syntheticMethod.getStatements());
        }
        return CodeScanner.hasShrikeBTObjectArrayStore((ShrikeCTMethod)iMethod);
    }

    public static Set getCaughtExceptions(IMethod iMethod) throws InvalidClassFileException {
        if (iMethod == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (iMethod.isSynthetic()) {
            SyntheticMethod syntheticMethod = (SyntheticMethod)iMethod;
            return CodeScanner.getCaughtExceptions(iMethod.getDeclaringClass().getClassLoader().getLanguage(), syntheticMethod.getStatements());
        }
        return CodeScanner.getShrikeBTCaughtExceptions((ShrikeCTMethod)iMethod);
    }

    public static Iterator iterateCastTypes(IMethod iMethod) throws InvalidClassFileException {
        if (iMethod == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (iMethod.isSynthetic()) {
            SyntheticMethod syntheticMethod = (SyntheticMethod)iMethod;
            return CodeScanner.iterateCastTypes(syntheticMethod.getStatements());
        }
        return CodeScanner.iterateShrikeBTCastTypes((ShrikeCTMethod)iMethod);
    }

    private static Iterator iterateShrikeBTCastTypes(ShrikeCTMethod shrikeCTMethod) throws InvalidClassFileException {
        return shrikeCTMethod.getCastTypes();
    }

    private static Set getShrikeBTCaughtExceptions(ShrikeCTMethod shrikeCTMethod) throws InvalidClassFileException {
        return shrikeCTMethod.getCaughtExceptionTypes();
    }

    private static boolean hasShrikeBTObjectArrayStore(ShrikeCTMethod shrikeCTMethod) throws InvalidClassFileException {
        Iterator<TypeReference> iterator = shrikeCTMethod.getArraysWritten();
        while (iterator.hasNext()) {
            TypeReference typeReference = iterator.next();
            if (!typeReference.isReferenceType()) continue;
            return true;
        }
        return false;
    }

    private static Collection<CallSiteReference> getCallSitesFromShrikeBT(IBytecodeMethod iBytecodeMethod) throws InvalidClassFileException {
        return iBytecodeMethod.getCallSites();
    }

    private static Collection<NewSiteReference> getNewSitesFromShrikeBT(ShrikeCTMethod shrikeCTMethod) throws InvalidClassFileException {
        return shrikeCTMethod.getNewSites();
    }

    private static List<FieldReference> getFieldsReadFromShrikeBT(ShrikeCTMethod shrikeCTMethod) throws InvalidClassFileException {
        LinkedList<FieldReference> linkedList = new LinkedList<FieldReference>();
        Iterator<FieldReference> iterator = shrikeCTMethod.getFieldsRead();
        while (iterator.hasNext()) {
            linkedList.add(iterator.next());
        }
        return linkedList;
    }

    private static List<FieldReference> getFieldsWrittenFromShrikeBT(ShrikeCTMethod shrikeCTMethod) throws InvalidClassFileException {
        LinkedList<FieldReference> linkedList = new LinkedList<FieldReference>();
        Iterator<FieldReference> iterator = shrikeCTMethod.getFieldsWritten();
        while (iterator.hasNext()) {
            linkedList.add(iterator.next());
        }
        return linkedList;
    }

    private static List<TypeReference> getArraysWrittenFromShrikeBT(ShrikeCTMethod shrikeCTMethod) throws InvalidClassFileException {
        LinkedList<TypeReference> linkedList = new LinkedList<TypeReference>();
        Iterator<TypeReference> iterator = shrikeCTMethod.getArraysWritten();
        while (iterator.hasNext()) {
            linkedList.add(iterator.next());
        }
        return linkedList;
    }

    private static boolean hasShrikeBTObjectArrayLoad(ShrikeCTMethod shrikeCTMethod) throws InvalidClassFileException {
        Iterator iterator = shrikeCTMethod.getArraysRead();
        while (iterator.hasNext()) {
            TypeReference typeReference = (TypeReference)iterator.next();
            if (!typeReference.isReferenceType()) continue;
            return true;
        }
        return false;
    }

    public static Set<TypeReference> getCaughtExceptions(Language language, SSAInstruction[] sSAInstructionArray) throws IllegalArgumentException {
        if (sSAInstructionArray == null) {
            throw new IllegalArgumentException("statements == null");
        }
        final HashSet<TypeReference> hashSet = HashSetFactory.make(10);
        SSAInstruction.Visitor visitor = new SSAInstruction.Visitor(){

            public void visitGetCaughtException(SSAGetCaughtExceptionInstruction sSAGetCaughtExceptionInstruction) {
                Collection<TypeReference> collection = sSAGetCaughtExceptionInstruction.getExceptionTypes();
                hashSet.addAll(collection);
            }
        };
        int n = 0;
        while (n < sSAInstructionArray.length) {
            SSAInstruction sSAInstruction = sSAInstructionArray[n];
            if (sSAInstruction != null) {
                sSAInstruction.visit(visitor);
            }
            ++n;
        }
        return hashSet;
    }

    public static Iterator<TypeReference> iterateCastTypes(SSAInstruction[] sSAInstructionArray) throws IllegalArgumentException {
        if (sSAInstructionArray == null) {
            throw new IllegalArgumentException("statements == null");
        }
        HashSet hashSet = HashSetFactory.make(10);
        int n = 0;
        while (n < sSAInstructionArray.length) {
            if (sSAInstructionArray[n] != null && sSAInstructionArray[n] instanceof SSACheckCastInstruction) {
                SSACheckCastInstruction sSACheckCastInstruction = (SSACheckCastInstruction)sSAInstructionArray[n];
                TypeReference[] typeReferenceArray = sSACheckCastInstruction.getDeclaredResultTypes();
                int n2 = typeReferenceArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    TypeReference typeReference = typeReferenceArray[n3];
                    hashSet.add(typeReference);
                    ++n3;
                }
            }
            ++n;
        }
        return hashSet.iterator();
    }

    private static List<CallSiteReference> getCallSites(SSAInstruction[] sSAInstructionArray) {
        final LinkedList<CallSiteReference> linkedList = new LinkedList<CallSiteReference>();
        SSAInstruction.Visitor visitor = new SSAInstruction.Visitor(){

            public void visitInvoke(SSAInvokeInstruction sSAInvokeInstruction) {
                linkedList.add(sSAInvokeInstruction.getCallSite());
            }
        };
        int n = 0;
        while (n < sSAInstructionArray.length) {
            SSAInstruction sSAInstruction = sSAInstructionArray[n];
            if (sSAInstruction != null) {
                sSAInstruction.visit(visitor);
            }
            ++n;
        }
        return linkedList;
    }

    private static List<NewSiteReference> getNewSites(SSAInstruction[] sSAInstructionArray) {
        final LinkedList<NewSiteReference> linkedList = new LinkedList<NewSiteReference>();
        SSAInstruction.Visitor visitor = new SSAInstruction.Visitor(){

            public void visitNew(SSANewInstruction sSANewInstruction) {
                linkedList.add(sSANewInstruction.getNewSite());
            }
        };
        int n = 0;
        while (n < sSAInstructionArray.length) {
            SSAInstruction sSAInstruction = sSAInstructionArray[n];
            if (sSAInstruction != null) {
                sSAInstruction.visit(visitor);
            }
            ++n;
        }
        return linkedList;
    }

    public static List<FieldReference> getFieldsRead(SSAInstruction[] sSAInstructionArray) throws IllegalArgumentException {
        if (sSAInstructionArray == null) {
            throw new IllegalArgumentException("statements == null");
        }
        final LinkedList<FieldReference> linkedList = new LinkedList<FieldReference>();
        SSAInstruction.Visitor visitor = new SSAInstruction.Visitor(){

            public void visitGet(SSAGetInstruction sSAGetInstruction) {
                linkedList.add(sSAGetInstruction.getDeclaredField());
            }
        };
        int n = 0;
        while (n < sSAInstructionArray.length) {
            SSAInstruction sSAInstruction = sSAInstructionArray[n];
            if (sSAInstruction != null) {
                sSAInstruction.visit(visitor);
            }
            ++n;
        }
        return linkedList;
    }

    public static List<FieldReference> getFieldsWritten(SSAInstruction[] sSAInstructionArray) throws IllegalArgumentException {
        if (sSAInstructionArray == null) {
            throw new IllegalArgumentException("statements == null");
        }
        final LinkedList<FieldReference> linkedList = new LinkedList<FieldReference>();
        SSAInstruction.Visitor visitor = new SSAInstruction.Visitor(){

            public void visitPut(SSAPutInstruction sSAPutInstruction) {
                linkedList.add(sSAPutInstruction.getDeclaredField());
            }
        };
        int n = 0;
        while (n < sSAInstructionArray.length) {
            SSAInstruction sSAInstruction = sSAInstructionArray[n];
            if (sSAInstruction != null) {
                sSAInstruction.visit(visitor);
            }
            ++n;
        }
        return linkedList;
    }

    public static List<TypeReference> getArraysWritten(SSAInstruction[] sSAInstructionArray) throws IllegalArgumentException {
        if (sSAInstructionArray == null) {
            throw new IllegalArgumentException("statements == null");
        }
        final LinkedList<TypeReference> linkedList = new LinkedList<TypeReference>();
        SSAInstruction.Visitor visitor = new SSAInstruction.Visitor(){

            public void visitArrayStore(SSAArrayStoreInstruction sSAArrayStoreInstruction) {
                linkedList.add(sSAArrayStoreInstruction.getElementType());
            }
        };
        int n = 0;
        while (n < sSAInstructionArray.length) {
            SSAInstruction sSAInstruction = sSAInstructionArray[n];
            if (sSAInstruction != null) {
                sSAInstruction.visit(visitor);
            }
            ++n;
        }
        return linkedList;
    }

    public static boolean hasObjectArrayLoad(SSAInstruction[] sSAInstructionArray) throws IllegalArgumentException {
        if (sSAInstructionArray == null) {
            throw new IllegalArgumentException("statements == null");
        }
        class ScanVisitor
        extends SSAInstruction.Visitor {
            boolean foundOne = false;

            ScanVisitor() {
            }

            public void visitArrayLoad(SSAArrayLoadInstruction sSAArrayLoadInstruction) {
                if (!sSAArrayLoadInstruction.typeIsPrimitive()) {
                    this.foundOne = true;
                }
            }
        }
        ScanVisitor scanVisitor = new ScanVisitor();
        int n = 0;
        while (n < sSAInstructionArray.length) {
            SSAInstruction sSAInstruction = sSAInstructionArray[n];
            if (sSAInstruction != null) {
                sSAInstruction.visit(scanVisitor);
            }
            if (scanVisitor.foundOne) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean hasObjectArrayStore(SSAInstruction[] sSAInstructionArray) throws IllegalArgumentException {
        if (sSAInstructionArray == null) {
            throw new IllegalArgumentException("statements == null");
        }
        class ScanVisitor
        extends SSAInstruction.Visitor {
            boolean foundOne = false;

            ScanVisitor() {
            }

            public void visitArrayStore(SSAArrayStoreInstruction sSAArrayStoreInstruction) {
                if (!sSAArrayStoreInstruction.typeIsPrimitive()) {
                    this.foundOne = true;
                }
            }
        }
        ScanVisitor scanVisitor = new ScanVisitor();
        int n = 0;
        while (n < sSAInstructionArray.length) {
            SSAInstruction sSAInstruction = sSAInstructionArray[n];
            if (sSAInstruction != null) {
                sSAInstruction.visit(scanVisitor);
            }
            if (scanVisitor.foundOne) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

