/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.FileModule;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.shrike.ShrikeClassReaderHandle;
import com.ibm.wala.util.strings.ImmutableByteArray;
import java.io.File;

public class ClassFileModule
extends FileModule {
    private final String className;

    public ClassFileModule(File file) {
        super(file);
        ShrikeClassReaderHandle shrikeClassReaderHandle = new ShrikeClassReaderHandle(this);
        ImmutableByteArray immutableByteArray = null;
        try {
            immutableByteArray = ImmutableByteArray.make(shrikeClassReaderHandle.get().getName());
        }
        catch (InvalidClassFileException invalidClassFileException) {
            System.err.println("Invalid class file: " + file.getAbsolutePath());
            invalidClassFileException.printStackTrace();
            Assertions.UNREACHABLE();
        }
        this.className = immutableByteArray.toString();
    }

    public String toString() {
        return "ClassFileModule:" + this.getFile();
    }

    public boolean isClassFile() {
        return true;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isSourceFile() {
        return false;
    }
}

