/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.FieldImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.ClassHierarchyWarning;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.cha.IClassHierarchyDweller;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.BimodalMap;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.SmallMap;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.ImmutableByteArray;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BytecodeClass<T extends IClassLoader>
implements IClass {
    protected ImmutableByteArray superName;
    protected ImmutableByteArray[] interfaceNames;
    protected final T loader;
    protected final IClassHierarchy cha;
    protected Map<Selector, IMethod> methodMap;
    protected Map<Selector, IMethod> inheritCache;
    protected TypeReference typeReference;
    protected IClass superClass;
    protected boolean superclassComputed = false;
    protected Collection<IClass> allInterfaces = null;
    protected IField[] instanceFields;
    protected IField[] staticFields;
    protected int hashCode;
    private final HashMap<Atom, IField> fieldMap = HashMapFactory.make(5);

    protected BytecodeClass(T t, IClassHierarchy iClassHierarchy) {
        this.loader = t;
        this.cha = iClassHierarchy;
    }

    @Override
    public IClassLoader getClassLoader() {
        return this.loader;
    }

    protected abstract IMethod[] computeDeclaredMethods() throws InvalidClassFileException;

    @Override
    public TypeReference getReference() {
        return this.typeReference;
    }

    @Override
    public String getSourceFileName() {
        return this.loader.getSourceFileName(this);
    }

    @Override
    public InputStream getSource() {
        return this.loader.getSource(this);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.getReference().toString();
    }

    @Override
    public boolean isArrayClass() {
        return false;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    @Override
    public TypeName getName() {
        return this.getReference().getName();
    }

    @Override
    public boolean isReferenceType() {
        return this.getReference().isReferenceType();
    }

    @Override
    public IField getField(Atom atom) {
        if (this.fieldMap.containsKey(atom)) {
            return this.fieldMap.get(atom);
        }
        IField iField = this.findDeclaredField(atom);
        if (iField != null) {
            this.fieldMap.put(atom, iField);
            return iField;
        }
        this.superClass = this.getSuperclass();
        if (this.superClass != null && (iField = this.superClass.getField(atom)) != null) {
            this.fieldMap.put(atom, iField);
            return iField;
        }
        for (IClass iClass : this.getAllImplementedInterfaces()) {
            iField = iClass.getField(atom);
            if (iField == null) continue;
            this.fieldMap.put(atom, iField);
            return iField;
        }
        return null;
    }

    private void computeSuperclass() {
        this.superclassComputed = true;
        if (this.superName == null) {
            if (!this.getReference().equals(this.loader.getLanguage().getRootType())) {
                this.superClass = this.loader.lookupClass(this.loader.getLanguage().getRootType().getName());
            }
            return;
        }
        this.superClass = this.loader.lookupClass(TypeName.findOrCreate(this.superName));
    }

    @Override
    public IClass getSuperclass() {
        if (!this.superclassComputed) {
            this.computeSuperclass();
        }
        if (this.superClass == null && !this.getReference().equals(TypeReference.JavaLangObject)) {
            throw new IllegalStateException("No superclass found for " + this + " Superclass name " + this.superName);
        }
        return this.superClass;
    }

    @Override
    public Collection<IField> getAllFields() {
        LinkedList<IField> linkedList = new LinkedList<IField>();
        linkedList.addAll(this.getAllInstanceFields());
        linkedList.addAll(this.getAllStaticFields());
        return linkedList;
    }

    @Override
    public Collection<IClass> getAllImplementedInterfaces() {
        if (this.allInterfaces != null) {
            return this.allInterfaces;
        }
        Collection<IClass> collection = this.computeAllInterfacesAsCollection();
        this.allInterfaces = Collections.unmodifiableCollection(collection);
        return this.allInterfaces;
    }

    @Override
    public Collection<IField> getDeclaredInstanceFields() {
        return Collections.unmodifiableList(Arrays.asList(this.instanceFields));
    }

    @Override
    public Collection<IField> getDeclaredStaticFields() {
        return Collections.unmodifiableList(Arrays.asList(this.staticFields));
    }

    @Override
    public Collection<IClass> getDirectInterfaces() {
        return this.array2IClassSet(this.interfaceNames);
    }

    @Override
    public Collection<IField> getAllInstanceFields() {
        LinkedList<IField> linkedList = new LinkedList<IField>(this.getDeclaredInstanceFields());
        IClass iClass = this.getSuperclass();
        while (iClass != null) {
            linkedList.addAll(iClass.getDeclaredInstanceFields());
            iClass = iClass.getSuperclass();
        }
        return linkedList;
    }

    @Override
    public Collection<IField> getAllStaticFields() {
        LinkedList<IField> linkedList = new LinkedList<IField>(this.getDeclaredStaticFields());
        IClass iClass = this.getSuperclass();
        while (iClass != null) {
            linkedList.addAll(iClass.getDeclaredStaticFields());
            iClass = iClass.getSuperclass();
        }
        return linkedList;
    }

    @Override
    public Collection<IMethod> getAllMethods() {
        IClass iClass2;
        LinkedList<IMethod> linkedList = new LinkedList<IMethod>();
        Iterator<IMethod> iterator = this.getDeclaredMethods().iterator();
        while (iterator.hasNext()) {
            linkedList.add(iterator.next());
        }
        if (this.isInterface()) {
            for (IClass iClass2 : this.getDirectInterfaces()) {
                linkedList.addAll(iClass2.getAllMethods());
            }
        }
        iClass2 = this.getSuperclass();
        while (iClass2 != null) {
            Iterator<IClassHierarchyDweller> iterator2 = iClass2.getDeclaredMethods().iterator();
            while (iterator2.hasNext()) {
                linkedList.add((IMethod)iterator2.next());
            }
            iClass2 = iClass2.getSuperclass();
        }
        return linkedList;
    }

    @Override
    public Collection<IMethod> getDeclaredMethods() {
        if (this.methodMap == null) {
            try {
                this.computeMethodMap();
            }
            catch (InvalidClassFileException invalidClassFileException) {
                invalidClassFileException.printStackTrace();
                Assertions.UNREACHABLE();
            }
        }
        return Collections.unmodifiableCollection(this.methodMap.values());
    }

    @Override
    public IMethod getMethod(Selector selector) {
        IMethod iClassHierarchyDweller2;
        Object object;
        IMethod iMethod;
        if (this.methodMap == null) {
            try {
                this.computeMethodMap();
            }
            catch (InvalidClassFileException invalidClassFileException) {
                invalidClassFileException.printStackTrace();
                Assertions.UNREACHABLE();
            }
        }
        if ((iMethod = this.methodMap.get(selector)) != null) {
            return iMethod;
        }
        if (this.inheritCache != null && (iMethod = this.inheritCache.get(selector)) != null) {
            return iMethod;
        }
        if (!selector.equals(MethodReference.clinitSelector) && !selector.equals(MethodReference.initSelector) && (object = this.getSuperclass()) != null && (iClassHierarchyDweller2 = object.getMethod(selector)) != null) {
            if (this.inheritCache == null) {
                this.inheritCache = new BimodalMap<Selector, IMethod>(5);
            }
            this.inheritCache.put(selector, iClassHierarchyDweller2);
            return iClassHierarchyDweller2;
        }
        if (this.isInterface() || this.isAbstract()) {
            for (IClass iClass : this.getAllImplementedInterfaces()) {
                iMethod = iClass.getMethod(selector);
                if (iMethod == null) continue;
                return iMethod;
            }
        }
        return null;
    }

    protected void populateFieldArrayFromList(List<FieldImpl> list, IField[] iFieldArray) {
        Iterator<FieldImpl> iterator = list.iterator();
        int n = 0;
        while (n < iFieldArray.length) {
            iFieldArray[n] = iterator.next();
            ++n;
        }
    }

    protected Collection<IClass> computeAllInterfacesAsCollection() {
        IClass iClass2;
        Collection<IClass> collection = this.getDirectInterfaces();
        HashSet<IClass> hashSet = HashSetFactory.make();
        for (IClass iClass2 : collection) {
            if (iClass2.isInterface()) {
                hashSet.add(iClass2);
                continue;
            }
            Warnings.add(ClassHierarchyWarning.create("expected an interface " + iClass2));
        }
        Object object = null;
        do {
            object = HashSetFactory.make(hashSet);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                iClass2 = (IClass)iterator.next();
                hashSet.addAll(iClass2.getDirectInterfaces());
            }
        } while (object.size() < hashSet.size());
        iClass2 = null;
        iClass2 = this.getSuperclass();
        if (iClass2 != null) {
            hashSet.addAll(iClass2.getAllImplementedInterfaces());
        }
        return hashSet;
    }

    private Collection<IClass> array2IClassSet(ImmutableByteArray[] immutableByteArrayArray) {
        ArrayList<IClass> arrayList = new ArrayList<IClass>(immutableByteArrayArray.length);
        int n = 0;
        while (n < immutableByteArrayArray.length) {
            ImmutableByteArray immutableByteArray = immutableByteArrayArray[n];
            IClass iClass = null;
            iClass = this.loader.lookupClass(TypeName.findOrCreate(immutableByteArray));
            if (iClass == null) {
                Warnings.add(ClassNotFoundWarning.create(immutableByteArray));
            } else {
                arrayList.add(iClass);
            }
            ++n;
        }
        return arrayList;
    }

    protected IField findDeclaredField(Atom atom) {
        int n;
        if (this.instanceFields != null) {
            n = 0;
            while (n < this.instanceFields.length) {
                if (this.instanceFields[n].getName() == atom) {
                    return this.instanceFields[n];
                }
                ++n;
            }
        }
        if (this.staticFields != null) {
            n = 0;
            while (n < this.staticFields.length) {
                if (this.staticFields[n].getName() == atom) {
                    return this.staticFields[n];
                }
                ++n;
            }
        }
        return null;
    }

    protected void addFieldToList(List<FieldImpl> list, Atom atom, ImmutableByteArray immutableByteArray, int n, Collection<Annotation> collection) {
        TypeName typeName = null;
        typeName = immutableByteArray.get(immutableByteArray.length() - 1) == 59 ? TypeName.findOrCreate(immutableByteArray, 0, immutableByteArray.length() - 1) : TypeName.findOrCreate(immutableByteArray);
        TypeReference typeReference = TypeReference.findOrCreate(this.getClassLoader().getReference(), typeName);
        FieldReference fieldReference = FieldReference.findOrCreate(this.getReference(), atom, typeReference);
        FieldImpl fieldImpl = new FieldImpl(this, fieldReference, n, collection);
        list.add(fieldImpl);
    }

    protected void computeMethodMap() throws InvalidClassFileException {
        if (this.methodMap == null) {
            IMethod[] iMethodArray = this.computeDeclaredMethods();
            this.methodMap = iMethodArray.length > 5 ? HashMapFactory.make(iMethodArray.length) : new SmallMap<Selector, IMethod>();
            int n = 0;
            while (n < iMethodArray.length) {
                IMethod iMethod = iMethodArray[n];
                this.methodMap.put(iMethod.getReference().getSelector(), iMethod);
                ++n;
            }
        }
    }

    private static class ClassNotFoundWarning
    extends Warning {
        final ImmutableByteArray className;

        ClassNotFoundWarning(ImmutableByteArray immutableByteArray) {
            super((byte)2);
            this.className = immutableByteArray;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.className;
        }

        public static ClassNotFoundWarning create(ImmutableByteArray immutableByteArray) {
            return new ClassNotFoundWarning(immutableByteArray);
        }
    }
}

