/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg.cdg;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.dominators.DominanceFrontiers;
import com.ibm.wala.util.graph.impl.GraphInverter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlDependenceGraph<I, T extends IBasicBlock<I>>
extends AbstractNumberedGraph<T> {
    private final ControlFlowGraph<I, T> cfg;
    private final EdgeManager<T> edgeManager;
    private Map<Pair, Set<Object>> edgeLabels;

    private Map<T, Set<T>> buildControlDependence(boolean bl) {
        HashMap hashMap = HashMapFactory.make(this.cfg.getNumberOfNodes());
        DominanceFrontiers dominanceFrontiers = new DominanceFrontiers(GraphInverter.invert(this.cfg), this.cfg.exit());
        if (bl) {
            this.edgeLabels = HashMapFactory.make();
        }
        Iterator iterator = this.cfg.iterator();
        while (iterator.hasNext()) {
            Iterable<Object> iterable = HashSetFactory.make(2);
            hashMap.put((IBasicBlock)iterator.next(), iterable);
        }
        for (Iterable<Object> iterable : this.cfg) {
            Iterator iterator2 = dominanceFrontiers.getDominanceFrontier(iterable);
            while (iterator2.hasNext()) {
                IBasicBlock iBasicBlock = (IBasicBlock)((Object)iterator2.next());
                ((Set)hashMap.get(iBasicBlock)).add(iterable);
                if (!bl) continue;
                HashSet hashSet = HashSetFactory.make();
                this.edgeLabels.put(Pair.make(iBasicBlock, iterable), hashSet);
                Iterator<IBasicBlock> iterator3 = this.cfg.getSuccNodes(iBasicBlock);
                while (iterator3.hasNext()) {
                    IBasicBlock iBasicBlock2 = iterator3.next();
                    if (!dominanceFrontiers.isDominatedBy(iBasicBlock2, iterable)) continue;
                    hashSet.add(iBasicBlock2);
                }
            }
        }
        return hashMap;
    }

    private EdgeManager<T> constructGraphEdges(final Map<T, Set<T>> map) {
        return new EdgeManager<T>(){
            Map<T, Set<T>> backwardEdges;
            {
                this.backwardEdges = HashMapFactory.make(map2.size());
                Iterator<Object> iterator = ControlDependenceGraph.this.cfg.iterator();
                while (iterator.hasNext()) {
                    Iterable<Object> iterable = HashSetFactory.make();
                    this.backwardEdges.put((Object)((IBasicBlock)iterator.next()), (Set)iterable);
                }
                for (Iterable<Object> iterable : map2.keySet()) {
                    for (Object e : (Set)map2.get(iterable)) {
                        this.backwardEdges.get(e).add(iterable);
                    }
                }
            }

            @Override
            public Iterator<T> getPredNodes(T t) {
                if (this.backwardEdges.containsKey(t)) {
                    return this.backwardEdges.get(t).iterator();
                }
                return EmptyIterator.instance();
            }

            @Override
            public int getPredNodeCount(T t) {
                if (this.backwardEdges.containsKey(t)) {
                    return this.backwardEdges.get(t).size();
                }
                return 0;
            }

            @Override
            public Iterator<T> getSuccNodes(T t) {
                if (map.containsKey(t)) {
                    return ((Set)map.get(t)).iterator();
                }
                return EmptyIterator.instance();
            }

            @Override
            public int getSuccNodeCount(T t) {
                if (map.containsKey(t)) {
                    return ((Set)map.get(t)).size();
                }
                return 0;
            }

            @Override
            public boolean hasEdge(T t, T t2) {
                return map.containsKey(t) && ((Set)map.get(t)).contains(t2);
            }

            @Override
            public void addEdge(T t, T t2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeEdge(T t, T t2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeAllIncidentEdges(T t) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeIncomingEdges(T t) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeOutgoingEdges(T t) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (IBasicBlock iBasicBlock : this) {
            stringBuffer.append(iBasicBlock.toString()).append("\n");
            Iterator<IBasicBlock> iterator = this.getSuccNodes(iBasicBlock);
            while (iterator.hasNext()) {
                IBasicBlock iBasicBlock2 = iterator.next();
                stringBuffer.append("  --> ").append(iBasicBlock2);
                if (this.edgeLabels != null) {
                    Iterator<Object> iterator2 = this.edgeLabels.get(Pair.make(iBasicBlock, iBasicBlock2)).iterator();
                    while (iterator2.hasNext()) {
                        stringBuffer.append("\n   label: ").append(iterator2.next());
                    }
                }
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public ControlDependenceGraph(ControlFlowGraph<I, T> controlFlowGraph, boolean bl) {
        if (controlFlowGraph == null) {
            throw new IllegalArgumentException("null cfg");
        }
        this.cfg = controlFlowGraph;
        this.edgeManager = this.constructGraphEdges(this.buildControlDependence(bl));
    }

    public ControlDependenceGraph(ControlFlowGraph<I, T> controlFlowGraph) {
        this(controlFlowGraph, false);
    }

    public ControlFlowGraph getControlFlowGraph() {
        return this.cfg;
    }

    public Set<Object> getEdgeLabels(Object object, Object object2) {
        return this.edgeLabels.get(Pair.make(object, object2));
    }

    @Override
    public NodeManager<T> getNodeManager() {
        return this.cfg;
    }

    @Override
    public EdgeManager<T> getEdgeManager() {
        return this.edgeManager;
    }

    public boolean controlEquivalent(T t, T t2) {
        if (this.getPredNodeCount(t) != this.getPredNodeCount(t2)) {
            return false;
        }
        Iterator<T> iterator = this.getPredNodes(t);
        while (iterator.hasNext()) {
            if (this.hasEdge((IBasicBlock)iterator.next(), t2)) continue;
            return false;
        }
        return true;
    }
}

