/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg;

import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import com.ibm.wala.util.warnings.WalaException;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFGSanitizer {
    public static Graph<ISSABasicBlock> sanitize(IR iR, IClassHierarchy iClassHierarchy) throws IllegalArgumentException, WalaException {
        Object object;
        Object object2;
        Object object32;
        if (iR == null) {
            throw new IllegalArgumentException("ir cannot be null");
        }
        SSACFG sSACFG = iR.getControlFlowGraph();
        SlowSparseNumberedGraph<ISSABasicBlock> slowSparseNumberedGraph = SlowSparseNumberedGraph.make();
        Object object4 = sSACFG.iterator();
        while (object4.hasNext()) {
            slowSparseNumberedGraph.addNode((ISSABasicBlock)object4.next());
        }
        for (Object object32 : sSACFG) {
            object2 = sSACFG.getSuccNodes(object32);
            while (object2.hasNext()) {
                object = object2.next();
                if (object.isExitBlock()) continue;
                slowSparseNumberedGraph.addEdge((ISSABasicBlock)object32, (ISSABasicBlock)object);
            }
        }
        object4 = (ISSABasicBlock)sSACFG.exit();
        object32 = sSACFG.getPredNodes(object4);
        while (object32.hasNext()) {
            IClass iClass;
            Object object5;
            object2 = (ISSABasicBlock)object32.next();
            object = iR.getInstructions()[object2.getLastInstructionIndex()];
            if (object == null) continue;
            if (object instanceof SSAReturnInstruction || object instanceof SSAThrowInstruction || sSACFG.getSuccNodeCount(object2) == 1) {
                slowSparseNumberedGraph.addEdge((ISSABasicBlock)object2, (ISSABasicBlock)object4);
                continue;
            }
            TypeReference[] typeReferenceArray = null;
            try {
                typeReferenceArray = CFGSanitizer.computeExceptions(iClassHierarchy, iR, (SSAInstruction)object);
            }
            catch (InvalidClassFileException invalidClassFileException) {
                invalidClassFileException.printStackTrace();
                Assertions.UNREACHABLE();
            }
            TypeReference[] typeReferenceArray2 = sSACFG.getSuccNodes(object2);
            while (typeReferenceArray2.hasNext()) {
                IBasicBlock iBasicBlock = (IBasicBlock)typeReferenceArray2.next();
                if (!iBasicBlock.isCatchBlock()) continue;
                SSACFG.ExceptionHandlerBasicBlock exceptionHandlerBasicBlock = (SSACFG.ExceptionHandlerBasicBlock)iBasicBlock;
                object5 = exceptionHandlerBasicBlock.getCaughtExceptionTypes();
                while (object5.hasNext()) {
                    TypeReference typeReference = object5.next();
                    iClass = iClassHierarchy.lookupClass(typeReference);
                    if (iClass == null) {
                        throw new WalaException("failed to find " + typeReference);
                    }
                    int n = 0;
                    while (n < typeReferenceArray.length) {
                        if (typeReferenceArray[n] != null) {
                            IClass iClass2 = iClassHierarchy.lookupClass(typeReferenceArray[n]);
                            if (iClass2 == null) {
                                throw new WalaException("failed to find " + typeReferenceArray[n]);
                            }
                            if (iClassHierarchy.isSubclassOf(iClass2, iClass)) {
                                typeReferenceArray[n] = null;
                            }
                        }
                        ++n;
                    }
                }
            }
            typeReferenceArray2 = null;
            try {
                typeReferenceArray2 = iR.getMethod().getDeclaredExceptions();
            }
            catch (InvalidClassFileException invalidClassFileException) {
                invalidClassFileException.printStackTrace();
                Assertions.UNREACHABLE();
            }
            if (typeReferenceArray2 == null || typeReferenceArray == null) continue;
            int n = 0;
            while (n < typeReferenceArray.length) {
                boolean bl = false;
                if (typeReferenceArray[n] != null) {
                    object5 = iClassHierarchy.lookupClass(typeReferenceArray[n]);
                    if (object5 == null) {
                        throw new WalaException("failed to find " + typeReferenceArray[n]);
                    }
                    int n2 = 0;
                    while (n2 < typeReferenceArray2.length) {
                        iClass = iClassHierarchy.lookupClass(typeReferenceArray2[n2]);
                        if (iClass == null) {
                            throw new WalaException("failed to find " + typeReferenceArray2[n2]);
                        }
                        if (iClassHierarchy.isSubclassOf((IClass)object5, iClass)) {
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                    if (bl) {
                        slowSparseNumberedGraph.addEdge((ISSABasicBlock)object2, (ISSABasicBlock)object4);
                    }
                }
                ++n;
            }
        }
        return slowSparseNumberedGraph;
    }

    private static TypeReference[] computeExceptions(IClassHierarchy iClassHierarchy, IR iR, SSAInstruction sSAInstruction) throws InvalidClassFileException {
        TypeReference[] typeReferenceArray;
        Collection<TypeReference> collection = null;
        Language language = iR.getMethod().getDeclaringClass().getClassLoader().getLanguage();
        if (sSAInstruction instanceof SSAInvokeInstruction) {
            typeReferenceArray = (TypeReference[])sSAInstruction;
            collection = language.inferInvokeExceptions(typeReferenceArray.getDeclaredTarget(), iClassHierarchy);
        } else {
            collection = sSAInstruction.getExceptionTypes();
        }
        if (collection == null) {
            return null;
        }
        typeReferenceArray = new TypeReference[collection.size()];
        Iterator<TypeReference> iterator = collection.iterator();
        int n = 0;
        while (n < typeReferenceArray.length) {
            typeReferenceArray[n] = iterator.next();
            ++n;
        }
        return typeReferenceArray;
    }
}

