/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.typeInference;

import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.HashMap;

public class JavaPrimitiveType
extends PrimitiveType {
    public static final PrimitiveType BOOLEAN = JavaPrimitiveType.makePrimitive(TypeReference.Boolean, 1);
    public static final PrimitiveType CHAR = JavaPrimitiveType.makePrimitive(TypeReference.Char, 16);
    public static final PrimitiveType BYTE = JavaPrimitiveType.makePrimitive(TypeReference.Byte, 8);
    public static final PrimitiveType SHORT = JavaPrimitiveType.makePrimitive(TypeReference.Short, 16);
    public static final PrimitiveType INT = JavaPrimitiveType.makePrimitive(TypeReference.Int, 32);
    public static final PrimitiveType LONG = JavaPrimitiveType.makePrimitive(TypeReference.Long, 64);
    public static final PrimitiveType FLOAT = JavaPrimitiveType.makePrimitive(TypeReference.Float, 32);
    public static final PrimitiveType DOUBLE = JavaPrimitiveType.makePrimitive(TypeReference.Double, 64);
    private static final HashMap<String, String> primitiveNameMap = HashMapFactory.make(9);

    static {
        primitiveNameMap.put("I", "int");
        primitiveNameMap.put("J", "long");
        primitiveNameMap.put("S", "short");
        primitiveNameMap.put("B", "byte");
        primitiveNameMap.put("C", "char");
        primitiveNameMap.put("D", "double");
        primitiveNameMap.put("F", "float");
        primitiveNameMap.put("Z", "boolean");
        primitiveNameMap.put("V", "void");
    }

    public static void init() {
    }

    private JavaPrimitiveType(TypeReference typeReference, int n) {
        super(typeReference, n);
    }

    private static PrimitiveType makePrimitive(TypeReference typeReference, int n) {
        return new JavaPrimitiveType(typeReference, n);
    }

    public String toString() {
        String string = primitiveNameMap.get(this.reference.getName().toString());
        return string != null ? string : this.reference.getName().toString();
    }
}

