/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.util.debug.Assertions;

public class JavaTypeContext
implements Context {
    private final TypeAbstraction type;

    public JavaTypeContext(TypeAbstraction typeAbstraction) {
        if (typeAbstraction == null) {
            throw new IllegalArgumentException("null type");
        }
        this.type = typeAbstraction;
    }

    public ContextItem get(ContextKey contextKey) {
        if (contextKey == ContextKey.RECEIVER) {
            return this.type;
        }
        if (contextKey == ContextKey.FILTER) {
            if (this.type instanceof PointType) {
                IClass iClass = ((PointType)this.type).getIClass();
                return new FilteredPointerKey.SingleClassFilter(iClass);
            }
            return null;
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public String toString() {
        return "JavaTypeContext<" + this.type + ">";
    }

    public int hashCode() {
        return 6367 * this.type.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass().equals(object.getClass())) {
            JavaTypeContext javaTypeContext = (JavaTypeContext)object;
            return this.type.equals(javaTypeContext.type);
        }
        return false;
    }

    public TypeAbstraction getType() {
        return this.type;
    }
}

