/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.reflection.JavaLangClassContextInterpreter;
import com.ibm.wala.analysis.reflection.JavaTypeContext;
import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;

class JavaLangClassContextSelector
implements ContextSelector {
    private static final Collection<MethodReference> UNDERSTOOD_METHOD_REFS = HashSetFactory.make();

    static {
        UNDERSTOOD_METHOD_REFS.add(JavaLangClassContextInterpreter.GET_CONSTRUCTOR);
        UNDERSTOOD_METHOD_REFS.add(JavaLangClassContextInterpreter.GET_CONSTRUCTORS);
        UNDERSTOOD_METHOD_REFS.add(JavaLangClassContextInterpreter.GET_METHOD);
        UNDERSTOOD_METHOD_REFS.add(JavaLangClassContextInterpreter.GET_METHODS);
        UNDERSTOOD_METHOD_REFS.add(JavaLangClassContextInterpreter.GET_DECLARED_CONSTRUCTOR);
        UNDERSTOOD_METHOD_REFS.add(JavaLangClassContextInterpreter.GET_DECLARED_CONSTRUCTORS);
        UNDERSTOOD_METHOD_REFS.add(JavaLangClassContextInterpreter.GET_DECLARED_METHOD);
        UNDERSTOOD_METHOD_REFS.add(JavaLangClassContextInterpreter.GET_DECLARED_METHODS);
    }

    public Context getCalleeTarget(CGNode cGNode, CallSiteReference callSiteReference, IMethod iMethod, InstanceKey instanceKey) {
        if (this.mayUnderstand(cGNode, callSiteReference, iMethod, instanceKey)) {
            return new JavaTypeContext(new PointType(this.getTypeConstant(instanceKey)));
        }
        return null;
    }

    private IClass getTypeConstant(InstanceKey instanceKey) {
        ConstantKey constantKey;
        if (instanceKey instanceof ConstantKey && (constantKey = (ConstantKey)instanceKey).getValue() instanceof IClass) {
            return (IClass)constantKey.getValue();
        }
        return null;
    }

    private boolean mayUnderstand(CGNode cGNode, CallSiteReference callSiteReference, IMethod iMethod, InstanceKey instanceKey) {
        return UNDERSTOOD_METHOD_REFS.contains(iMethod.getReference()) && this.getTypeConstant(instanceKey) != null;
    }
}

