/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.CodeScanner;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextUtil;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.summaries.SyntheticIR;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.strings.Atom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneInterpreter
implements SSAContextInterpreter {
    public static final Atom cloneAtom = Atom.findOrCreateUnicodeAtom("clone");
    private static final Descriptor cloneDesc = Descriptor.findOrCreateUTF8("()Ljava/lang/Object;");
    public static final MethodReference CLONE = MethodReference.findOrCreate(TypeReference.JavaLangObject, cloneAtom, cloneDesc);
    private static final TypeReference SYNTHETIC_SYSTEM = TypeReference.findOrCreate(ClassLoaderReference.Primordial, TypeName.string2TypeName("Lcom/ibm/wala/model/java/lang/System"));
    private static final Atom arraycopyAtom = Atom.findOrCreateUnicodeAtom("arraycopy");
    private static final Descriptor arraycopyDesc = Descriptor.findOrCreateUTF8("(Ljava/lang/Object;Ljava/lang/Object;)V");
    private static final MethodReference SYNTHETIC_ARRAYCOPY = MethodReference.findOrCreate(SYNTHETIC_SYSTEM, arraycopyAtom, arraycopyDesc);
    private static final int ARRAYCOPY_PC = 3;
    private static final CallSiteReference ARRAYCOPY_SITE = CallSiteReference.make(3, SYNTHETIC_ARRAYCOPY, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC);
    private static final int NEW_PC = 0;
    private final Map<TypeReference, IR> IRCache = HashMapFactory.make();
    private final SSAInstructionFactory insts = Language.JAVA.instructionFactory();

    @Override
    public IR getIR(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(cGNode));
        IClass iClass = ContextUtil.getConcreteClassFromContext(cGNode.getContext());
        IR iR = this.IRCache.get(iClass.getReference());
        if (iR == null) {
            iR = this.makeIR(cGNode.getMethod(), cGNode.getContext(), iClass);
            this.IRCache.put(iClass.getReference(), iR);
        }
        return iR;
    }

    @Override
    public int getNumberOfStatements(CGNode cGNode) {
        assert (this.understands(cGNode));
        return this.getIR(cGNode).getInstructions().length;
    }

    @Override
    public boolean understands(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        return cGNode.getMethod().getReference().equals(CLONE) && ContextUtil.getConcreteClassFromContext(cGNode.getContext()) != null;
    }

    @Override
    public Iterator<NewSiteReference> iterateNewSites(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(cGNode));
        IClass iClass = ContextUtil.getConcreteClassFromContext(cGNode.getContext());
        return new NonNullSingletonIterator<NewSiteReference>(NewSiteReference.make(0, iClass.getReference()));
    }

    @Override
    public Iterator<CallSiteReference> iterateCallSites(CGNode cGNode) {
        assert (this.understands(cGNode));
        return new NonNullSingletonIterator<CallSiteReference>(ARRAYCOPY_SITE);
    }

    private SSAInstruction[] makeStatements(IClass iClass) {
        int n;
        SSAInstruction[] sSAInstructionArray;
        Object object2;
        int n2;
        assert (iClass != null);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n3 = 2;
        int n4 = n3++;
        NewSiteReference newSiteReference = NewSiteReference.make(0, iClass.getReference());
        SSANewInstruction sSANewInstruction = null;
        if (iClass.isArrayClass()) {
            n2 = n3++;
            arrayList.add(this.insts.ArrayLengthInstruction(n2, 1));
            object2 = new int[iClass.getReference().getDimensionality()];
            Arrays.fill(object2, n2);
            sSANewInstruction = this.insts.NewInstruction(n4, newSiteReference, (int[])object2);
        } else {
            sSANewInstruction = this.insts.NewInstruction(n4, newSiteReference);
        }
        arrayList.add(sSANewInstruction);
        n2 = n3++;
        if (iClass.getReference().isArrayType()) {
            object2 = new int[]{1, n4};
            sSAInstructionArray = this.insts.InvokeInstruction((int[])object2, n2, ARRAYCOPY_SITE);
            arrayList.add(sSAInstructionArray);
        } else {
            object2 = iClass;
            while (object2 != null) {
                for (IField object3 : iClass.getDeclaredInstanceFields()) {
                    n = n3++;
                    SSAGetInstruction sSAGetInstruction = this.insts.GetInstruction(n, 1, object3.getReference());
                    arrayList.add(sSAGetInstruction);
                    SSAPutInstruction sSAPutInstruction = this.insts.PutInstruction(n4, n, object3.getReference());
                    arrayList.add(sSAPutInstruction);
                }
                object2 = object2.getSuperclass();
            }
        }
        object2 = this.insts.ReturnInstruction(n4, false);
        arrayList.add(object2);
        sSAInstructionArray = new SSAInstruction[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        n = 0;
        while (n < sSAInstructionArray.length) {
            sSAInstructionArray[n] = (SSAInstruction)iterator.next();
            ++n;
        }
        return sSAInstructionArray;
    }

    private IR makeIR(IMethod iMethod, Context context, IClass iClass) {
        assert (iClass != null);
        SSAInstruction[] sSAInstructionArray = this.makeStatements(iClass);
        return new SyntheticIR(iMethod, context, new InducedCFG(sSAInstructionArray, iMethod, context), sSAInstructionArray, SSAOptions.defaultOptions(), null);
    }

    @Override
    public boolean recordFactoryType(CGNode cGNode, IClass iClass) {
        return false;
    }

    @Override
    public Iterator<FieldReference> iterateFieldsRead(CGNode cGNode) {
        SSAInstruction[] sSAInstructionArray = this.getIR(cGNode).getInstructions();
        return CodeScanner.getFieldsRead(sSAInstructionArray).iterator();
    }

    @Override
    public Iterator<FieldReference> iterateFieldsWritten(CGNode cGNode) {
        SSAInstruction[] sSAInstructionArray = this.getIR(cGNode).getInstructions();
        return CodeScanner.getFieldsWritten(sSAInstructionArray).iterator();
    }

    public Set getCaughtExceptions(CGNode cGNode) {
        SSAInstruction[] sSAInstructionArray = this.getIR(cGNode).getInstructions();
        return CodeScanner.getCaughtExceptions(cGNode.getMethod().getDeclaringClass().getClassLoader().getLanguage(), sSAInstructionArray);
    }

    public boolean hasObjectArrayLoad(CGNode cGNode) {
        SSAInstruction[] sSAInstructionArray = this.getIR(cGNode).getInstructions();
        return CodeScanner.hasObjectArrayLoad(sSAInstructionArray);
    }

    public boolean hasObjectArrayStore(CGNode cGNode) {
        SSAInstruction[] sSAInstructionArray = this.getIR(cGNode).getInstructions();
        return CodeScanner.hasObjectArrayStore(sSAInstructionArray);
    }

    public Iterator iterateCastTypes(CGNode cGNode) {
        SSAInstruction[] sSAInstructionArray = this.getIR(cGNode).getInstructions();
        return CodeScanner.iterateCastTypes(sSAInstructionArray);
    }

    @Override
    public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG(CGNode cGNode) {
        return this.getIR(cGNode).getControlFlowGraph();
    }

    @Override
    public DefUse getDU(CGNode cGNode) {
        return new DefUse(this.getIR(cGNode));
    }
}

