/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.reflection.AbstractReflectionInterpreter;
import com.ibm.wala.analysis.reflection.JavaTypeContext;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.SyntheticIR;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.strings.Atom;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNewInstanceContextInterpreter
extends AbstractReflectionInterpreter {
    public static final Atom newInstanceAtom = Atom.findOrCreateUnicodeAtom("newInstance");
    private static final Descriptor classNewInstanceDescriptor = Descriptor.findOrCreateUTF8("()Ljava/lang/Object;");
    public static final MethodReference CLASS_NEW_INSTANCE_REF = MethodReference.findOrCreate(TypeReference.JavaLangClass, newInstanceAtom, classNewInstanceDescriptor);
    private static final Atom defCtorAtom = Atom.findOrCreateUnicodeAtom("<init>");
    private static final Descriptor defCtorDescriptor = Descriptor.findOrCreateUTF8("()V");
    private static final Selector defCtorSelector = new Selector(defCtorAtom, defCtorDescriptor);
    private final IClassHierarchy cha;

    public ClassNewInstanceContextInterpreter(IClassHierarchy iClassHierarchy) {
        this.cha = iClassHierarchy;
    }

    @Override
    public IR getIR(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(cGNode));
        IR iR = this.makeIR(cGNode.getMethod(), (JavaTypeContext)cGNode.getContext());
        return iR;
    }

    @Override
    public int getNumberOfStatements(CGNode cGNode) {
        assert (this.understands(cGNode));
        return this.getIR(cGNode).getInstructions().length;
    }

    @Override
    public boolean understands(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        if (!(cGNode.getContext() instanceof JavaTypeContext)) {
            return false;
        }
        return cGNode.getMethod().getReference().equals(CLASS_NEW_INSTANCE_REF);
    }

    @Override
    public Iterator<NewSiteReference> iterateNewSites(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(cGNode));
        JavaTypeContext javaTypeContext = (JavaTypeContext)cGNode.getContext();
        TypeReference typeReference = javaTypeContext.getType().getTypeReference();
        if (typeReference != null) {
            return new NonNullSingletonIterator<NewSiteReference>(NewSiteReference.make(0, typeReference));
        }
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<CallSiteReference> iterateCallSites(CGNode cGNode) {
        assert (this.understands(cGNode));
        return EmptyIterator.instance();
    }

    private IR makeIR(IMethod iMethod, JavaTypeContext javaTypeContext) {
        SSAInstructionFactory sSAInstructionFactory = javaTypeContext.getType().getType().getClassLoader().getInstructionFactory();
        TypeReference typeReference = javaTypeContext.getType().getTypeReference();
        if (typeReference != null) {
            SSAInstruction[] sSAInstructionArray;
            AbstractReflectionInterpreter.SpecializedMethod specializedMethod = (AbstractReflectionInterpreter)this.new AbstractReflectionInterpreter.SpecializedMethod(iMethod, iMethod.getDeclaringClass(), iMethod.isStatic(), false);
            IClass iClass = this.cha.lookupClass(typeReference);
            IMethod iMethod2 = this.getPublicDefaultCtor(iClass);
            if (iMethod2 != null) {
                specializedMethod.addStatementsForConcreteSimpleType(typeReference);
            } else if (iClass.getMethod(defCtorSelector) == null) {
                sSAInstructionArray = TypeReference.findOrCreateClass(ClassLoaderReference.Primordial, "java/lang", "InstantiationException");
                int n = iMethod.getNumberOfParameters() + 1;
                SSANewInstruction sSANewInstruction = sSAInstructionFactory.NewInstruction(n, NewSiteReference.make(2, (TypeReference)sSAInstructionArray));
                specializedMethod.addInstruction(typeReference, sSANewInstruction, true);
                SSAThrowInstruction sSAThrowInstruction = sSAInstructionFactory.ThrowInstruction(n);
                specializedMethod.addInstruction(typeReference, sSAThrowInstruction, false);
            } else {
                sSAInstructionArray = TypeReference.findOrCreateClass(ClassLoaderReference.Primordial, "java/lang", "IllegalAccessException");
                int n = iMethod.getNumberOfParameters() + 1;
                SSANewInstruction sSANewInstruction = sSAInstructionFactory.NewInstruction(n, NewSiteReference.make(2, (TypeReference)sSAInstructionArray));
                specializedMethod.addInstruction(typeReference, sSANewInstruction, true);
                SSAThrowInstruction sSAThrowInstruction = sSAInstructionFactory.ThrowInstruction(n);
                specializedMethod.addInstruction(typeReference, sSAThrowInstruction, false);
            }
            sSAInstructionArray = new SSAInstruction[specializedMethod.allInstructions.size()];
            specializedMethod.allInstructions.toArray(sSAInstructionArray);
            return new SyntheticIR(iMethod, javaTypeContext, new InducedCFG(sSAInstructionArray, iMethod, javaTypeContext), sSAInstructionArray, SSAOptions.defaultOptions(), null);
        }
        return null;
    }

    private IMethod getPublicDefaultCtor(IClass iClass) {
        IMethod iMethod = iClass.getMethod(defCtorSelector);
        if (iMethod != null && iMethod.isPublic()) {
            return iMethod;
        }
        return null;
    }

    @Override
    public boolean recordFactoryType(CGNode cGNode, IClass iClass) {
        return false;
    }

    @Override
    public Iterator<FieldReference> iterateFieldsRead(CGNode cGNode) {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<FieldReference> iterateFieldsWritten(CGNode cGNode) {
        return EmptyIterator.instance();
    }

    @Override
    public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG(CGNode cGNode) {
        return this.getIR(cGNode).getControlFlowGraph();
    }

    @Override
    public DefUse getDU(CGNode cGNode) {
        return new DefUse(this.getIR(cGNode));
    }
}

