/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.reflection.JavaTypeContext;
import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.StringStuff;

class ClassFactoryContextSelector
implements ContextSelector {
    public static final Atom forNameAtom = Atom.findOrCreateUnicodeAtom("forName");
    private static final Descriptor forNameDescriptor = Descriptor.findOrCreateUTF8("(Ljava/lang/String;)Ljava/lang/Class;");
    public static final MethodReference FOR_NAME_REF = MethodReference.findOrCreate(TypeReference.JavaLangClass, forNameAtom, forNameDescriptor);
    public static final Atom loadClassAtom = Atom.findOrCreateUnicodeAtom("loadClass");
    private static final Descriptor loadClassDescriptor = Descriptor.findOrCreateUTF8("(Ljava/lang/String;)Ljava/lang/Class;");
    private static final TypeReference CLASSLOADER = TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/ClassLoader");
    public static final MethodReference LOAD_CLASS_REF = MethodReference.findOrCreate(CLASSLOADER, loadClassAtom, loadClassDescriptor);

    public static boolean isClassFactory(IMethod iMethod) {
        if (iMethod.getReference().equals(FOR_NAME_REF)) {
            return true;
        }
        return iMethod.getReference().equals(LOAD_CLASS_REF);
    }

    public int getUseOfStringParameter(SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction) {
        if (sSAAbstractInvokeInstruction.isStatic()) {
            return sSAAbstractInvokeInstruction.getUse(0);
        }
        return sSAAbstractInvokeInstruction.getUse(1);
    }

    public Context getCalleeTarget(CGNode cGNode, CallSiteReference callSiteReference, IMethod iMethod, InstanceKey instanceKey) {
        if (ClassFactoryContextSelector.isClassFactory(iMethod)) {
            IR iR = cGNode.getIR();
            SymbolTable symbolTable = iR.getSymbolTable();
            SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = cGNode.getIR().getCalls(callSiteReference);
            if (sSAAbstractInvokeInstructionArray.length != 1) {
                return null;
            }
            int n = this.getUseOfStringParameter(sSAAbstractInvokeInstructionArray[0]);
            if (symbolTable.isStringConstant(n)) {
                String string = StringStuff.deployment2CanonicalTypeString(symbolTable.getStringValue(n));
                TypeReference typeReference = TypeReference.findOrCreate(cGNode.getMethod().getDeclaringClass().getClassLoader().getReference(), string);
                IClass iClass = cGNode.getClassHierarchy().lookupClass(typeReference);
                if (iClass != null) {
                    return new JavaTypeContext(new PointType(iClass));
                }
            }
        }
        return null;
    }

    public boolean mayUnderstand(CGNode cGNode, CallSiteReference callSiteReference, IMethod iMethod, InstanceKey instanceKey) {
        if (ClassFactoryContextSelector.isClassFactory(iMethod)) {
            IR iR = cGNode.getIR();
            SymbolTable symbolTable = iR.getSymbolTable();
            SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = cGNode.getIR().getCalls(callSiteReference);
            if (sSAAbstractInvokeInstructionArray.length != 1) {
                return false;
            }
            int n = this.getUseOfStringParameter(sSAAbstractInvokeInstructionArray[0]);
            if (symbolTable.isStringConstant(n)) {
                return true;
            }
        }
        return false;
    }
}

