/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.reflection.ClassFactoryContextSelector;
import com.ibm.wala.analysis.reflection.JavaTypeContext;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.summaries.SyntheticIR;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFactoryContextInterpreter
implements SSAContextInterpreter {
    private static final boolean DEBUG = false;

    @Override
    public IR getIR(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(cGNode));
        IR iR = this.makeIR(cGNode.getMethod(), (JavaTypeContext)cGNode.getContext());
        return iR;
    }

    @Override
    public int getNumberOfStatements(CGNode cGNode) {
        assert (this.understands(cGNode));
        return this.getIR(cGNode).getInstructions().length;
    }

    @Override
    public boolean understands(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        if (!(cGNode.getContext() instanceof JavaTypeContext)) {
            return false;
        }
        return ClassFactoryContextSelector.isClassFactory(cGNode.getMethod());
    }

    @Override
    public Iterator<NewSiteReference> iterateNewSites(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(cGNode));
        JavaTypeContext javaTypeContext = (JavaTypeContext)cGNode.getContext();
        TypeReference typeReference = javaTypeContext.getType().getTypeReference();
        if (typeReference != null) {
            return new NonNullSingletonIterator<NewSiteReference>(NewSiteReference.make(0, typeReference));
        }
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<CallSiteReference> iterateCallSites(CGNode cGNode) {
        assert (this.understands(cGNode));
        return EmptyIterator.instance();
    }

    private SSAInstruction[] makeStatements(JavaTypeContext javaTypeContext) {
        SSAInstruction[] sSAInstructionArray;
        SSAInstructionFactory sSAInstructionFactory = javaTypeContext.getType().getType().getClassLoader().getInstructionFactory();
        ArrayList<SSAInstruction> arrayList = new ArrayList<SSAInstruction>();
        int n = 2;
        TypeReference typeReference = javaTypeContext.getType().getTypeReference();
        if (typeReference != null) {
            sSAInstructionArray = sSAInstructionFactory.LoadMetadataInstruction(n, TypeReference.JavaLangClass, typeReference);
            arrayList.add((SSAInstruction)sSAInstructionArray);
            SSAReturnInstruction sSAReturnInstruction = sSAInstructionFactory.ReturnInstruction(n, false);
            arrayList.add(sSAReturnInstruction);
        } else {
            sSAInstructionArray = sSAInstructionFactory.ThrowInstruction(n);
            arrayList.add((SSAInstruction)sSAInstructionArray);
        }
        sSAInstructionArray = new SSAInstruction[arrayList.size()];
        arrayList.toArray(sSAInstructionArray);
        return sSAInstructionArray;
    }

    private IR makeIR(IMethod iMethod, JavaTypeContext javaTypeContext) {
        SSAInstruction[] sSAInstructionArray = this.makeStatements(javaTypeContext);
        return new SyntheticIR(iMethod, javaTypeContext, new InducedCFG(sSAInstructionArray, iMethod, javaTypeContext), sSAInstructionArray, SSAOptions.defaultOptions(), null);
    }

    @Override
    public boolean recordFactoryType(CGNode cGNode, IClass iClass) {
        return false;
    }

    @Override
    public Iterator<FieldReference> iterateFieldsRead(CGNode cGNode) {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<FieldReference> iterateFieldsWritten(CGNode cGNode) {
        return EmptyIterator.instance();
    }

    @Override
    public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG(CGNode cGNode) {
        return this.getIR(cGNode).getControlFlowGraph();
    }

    @Override
    public DefUse getDU(CGNode cGNode) {
        return new DefUse(this.getIR(cGNode));
    }
}

