/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.util;

import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;

public class CAstPrinter {
    private static CAstPrinter instance = new CAstPrinter();

    public static void setPrinter(CAstPrinter cAstPrinter) {
        instance = cAstPrinter;
    }

    public static String kindAsString(int n) {
        return instance.getKindAsString(n);
    }

    public String getKindAsString(int n) {
        switch (n) {
            case 1: {
                return "SWITCH";
            }
            case 2: {
                return "LOOP";
            }
            case 3: {
                return "BLOCK";
            }
            case 4: {
                return "TRY";
            }
            case 5: {
                return "EXPR_STMT";
            }
            case 6: {
                return "DECL_STMT";
            }
            case 7: {
                return "RETURN";
            }
            case 8: {
                return "GOTO";
            }
            case 9: {
                return "BREAK";
            }
            case 10: {
                return "CONTINUE";
            }
            case 11: {
                return "IF_STMT";
            }
            case 12: {
                return "THROW";
            }
            case 13: {
                return "FUNCTION_STMT";
            }
            case 14: {
                return "ASSIGN";
            }
            case 15: {
                return "ASSIGN_PRE_OP";
            }
            case 16: {
                return "ASSIGN_POST_OP";
            }
            case 17: {
                return "LABEL_STMT";
            }
            case 18: {
                return "IFGOTO";
            }
            case 19: {
                return "EMPTY";
            }
            case 20: {
                return "RET_WO_BRANCH";
            }
            case 21: {
                return "CATCH";
            }
            case 22: {
                return "UNWIND";
            }
            case 23: {
                return "MONITOR_ENTER";
            }
            case 24: {
                return "MONITOR_EXIT";
            }
            case 25: {
                return "ECHO";
            }
            case 100: {
                return "FUNCTION_EXPR";
            }
            case 101: {
                return "EXPR_LIST";
            }
            case 102: {
                return "CALL";
            }
            case 103: {
                return "EXCEPTION";
            }
            case 104: {
                return "BLOCK_EXPR";
            }
            case 105: {
                return "BINARY_EXPR";
            }
            case 106: {
                return "UNARY_EXPR";
            }
            case 107: {
                return "IF_EXPR";
            }
            case 108: {
                return "ANDOR_EXPR";
            }
            case 109: {
                return "NEW";
            }
            case 130: {
                return "NEW_ENCLOSING";
            }
            case 110: {
                return "OBJECT_LITERAL";
            }
            case 111: {
                return "VAR";
            }
            case 112: {
                return "OBJECT_REF";
            }
            case 113: {
                return "CHOICE_EXPR";
            }
            case 114: {
                return "CHOICE_CASE";
            }
            case 115: {
                return "SUPER";
            }
            case 116: {
                return "THIS";
            }
            case 117: {
                return "ARRAY_LITERAL";
            }
            case 118: {
                return "CAST";
            }
            case 119: {
                return "INSTANCEOF";
            }
            case 120: {
                return "ARRAY_REF";
            }
            case 121: {
                return "ARRAY_LENGTH";
            }
            case 122: {
                return "TYPE_OF";
            }
            case 123: {
                return "EACH_ELEMENT_HAS_NEXT";
            }
            case 124: {
                return "EACH_ELEMENT_GET";
            }
            case 125: {
                return "LIST_EXPR";
            }
            case 126: {
                return "EMPTY_LIST_EXPR";
            }
            case 200: {
                return "SCOPE";
            }
            case 300: {
                return "CONSTANT";
            }
            case 301: {
                return "OPERATOR";
            }
            case 400: {
                return "PRIMITIVE";
            }
            case 402: {
                return "VOID";
            }
            case 401: {
                return "ERROR";
            }
            case 403: {
                return "ASSERT";
            }
        }
        return "UNKNOWN(" + n + ")";
    }

    public static String print(CAstNode cAstNode) {
        return instance.doPrint(cAstNode);
    }

    public String doPrint(CAstNode cAstNode) {
        return CAstPrinter.print(cAstNode, null);
    }

    public static String print(CAstNode cAstNode, CAstSourcePositionMap cAstSourcePositionMap) {
        return instance.doPrint(cAstNode, cAstSourcePositionMap);
    }

    public String doPrint(CAstNode cAstNode, CAstSourcePositionMap cAstSourcePositionMap) {
        StringWriter stringWriter = new StringWriter();
        CAstPrinter.printTo(cAstNode, cAstSourcePositionMap, stringWriter);
        return stringWriter.toString();
    }

    public String doPrint(CAstEntity cAstEntity) {
        StringWriter stringWriter = new StringWriter();
        CAstPrinter.printTo(cAstEntity, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public static String print(CAstEntity cAstEntity) {
        return instance.doPrint(cAstEntity);
    }

    public static void printTo(CAstNode cAstNode, Writer writer) {
        instance.doPrintTo(cAstNode, writer);
    }

    public void doPrintTo(CAstNode cAstNode, Writer writer) {
        CAstPrinter.printTo(cAstNode, null, writer, 0, false);
    }

    public static void printTo(CAstNode cAstNode, CAstSourcePositionMap cAstSourcePositionMap, Writer writer) {
        instance.doPrintTo(cAstNode, cAstSourcePositionMap, writer);
    }

    public void doPrintTo(CAstNode cAstNode, CAstSourcePositionMap cAstSourcePositionMap, Writer writer) {
        CAstPrinter.printTo(cAstNode, cAstSourcePositionMap, writer, 0, false);
    }

    public static void xmlTo(CAstNode cAstNode, Writer writer) {
        instance.doXmlTo(cAstNode, writer);
    }

    public void doXmlTo(CAstNode cAstNode, Writer writer) {
        CAstPrinter.printTo(cAstNode, null, writer, 0, true);
    }

    public static void xmlTo(CAstNode cAstNode, CAstSourcePositionMap cAstSourcePositionMap, Writer writer) {
        instance.doXmlTo(cAstNode, cAstSourcePositionMap, writer);
    }

    private void doXmlTo(CAstNode cAstNode, CAstSourcePositionMap cAstSourcePositionMap, Writer writer) {
        CAstPrinter.printTo(cAstNode, cAstSourcePositionMap, writer, 0, true);
    }

    private static String escapeForXML(String string, char c, String string2) {
        return string.indexOf(c) != -1 ? string.replaceAll(Character.toString(c), string2) : string;
    }

    public static String escapeForXML(String string) {
        return CAstPrinter.escapeForXML(CAstPrinter.escapeForXML(CAstPrinter.escapeForXML(CAstPrinter.escapeForXML(string, '&', "&amp;"), '\"', "&quot;"), '<', "&lt;"), '>', "&gt;");
    }

    public static void printTo(CAstNode cAstNode, CAstSourcePositionMap cAstSourcePositionMap, Writer writer, int n, boolean bl) {
        instance.doPrintTo(cAstNode, cAstSourcePositionMap, writer, n, bl);
    }

    public void doPrintTo(CAstNode cAstNode, CAstSourcePositionMap cAstSourcePositionMap, Writer writer, int n, boolean bl) {
        try {
            CAstSourcePositionMap.Position position = cAstSourcePositionMap != null ? cAstSourcePositionMap.getPosition(cAstNode) : null;
            int n2 = 0;
            while (n2 < n) {
                writer.write("  ");
                ++n2;
            }
            if (cAstNode == null) {
                writer.write("(null)\n");
            } else if (cAstNode.getValue() != null) {
                if (bl) {
                    writer.write("<constant value=\"");
                    writer.write(CAstPrinter.escapeForXML(cAstNode.getValue().toString()));
                    writer.write("\" type=\"");
                    writer.write(cAstNode.getValue().getClass().toString());
                    writer.write("\"");
                } else {
                    writer.write("\"");
                    writer.write(cAstNode.getValue().toString());
                    writer.write("\"");
                }
                if (position != null) {
                    if (bl) {
                        writer.write(" lineNumber=\"" + position + "\"");
                    } else {
                        writer.write(" at " + position);
                    }
                }
                if (bl) {
                    writer.write("/>");
                }
                writer.write("\n");
            } else {
                if (bl) {
                    writer.write("<");
                }
                writer.write(CAstPrinter.kindAsString(cAstNode.getKind()));
                if (position != null) {
                    if (bl) {
                        writer.write(" position=\"" + position + "\"");
                    } else {
                        writer.write(" at " + position);
                    }
                }
                if (bl) {
                    writer.write(">");
                }
                writer.write("\n");
                n2 = 0;
                while (n2 < cAstNode.getChildCount()) {
                    this.doPrintTo(cAstNode.getChild(n2), cAstSourcePositionMap, writer, n + 1, bl);
                    ++n2;
                }
                if (bl) {
                    n2 = 0;
                    while (n2 < n) {
                        writer.write("  ");
                        ++n2;
                    }
                    writer.write("</" + CAstPrinter.kindAsString(cAstNode.getKind()) + ">\n");
                }
            }
        }
        catch (IOException iOException) {}
    }

    public static String entityKindAsString(int n) {
        return instance.getEntityKindAsString(n);
    }

    public String getEntityKindAsString(int n) {
        switch (n) {
            case 1: {
                return "function";
            }
            case 4: {
                return "field";
            }
            case 5: {
                return "unit";
            }
            case 3: {
                return "type";
            }
            case 2: {
                return "script";
            }
            case 6: {
                return "rule";
            }
        }
        return "<unknown entity kind>";
    }

    public static void printTo(CAstEntity cAstEntity, Writer writer) {
        if (writer != null) {
            instance.doPrintTo(cAstEntity, writer);
        }
    }

    protected void doPrintTo(CAstEntity cAstEntity, Writer writer) {
        try {
            Object object;
            writer.write(this.getEntityKindAsString(cAstEntity.getKind()));
            writer.write(": ");
            writer.write(cAstEntity.getName());
            writer.write(10);
            if (cAstEntity.getArgumentNames().length > 0) {
                writer.write("(");
                object = cAstEntity.getArgumentNames();
                int n = 0;
                while (n < ((Object)object).length) {
                    writer.write("  " + (String)object[n]);
                    ++n;
                }
                writer.write("  )\n");
            }
            if (cAstEntity.getAST() != null) {
                this.doPrintTo(cAstEntity.getAST(), cAstEntity.getSourceMap(), writer);
                writer.write(10);
            }
            object = cAstEntity.getAllScopedEntities().values().iterator();
            while (object.hasNext()) {
                Iterator iterator = ((Collection)object.next()).iterator();
                while (iterator.hasNext()) {
                    this.doPrintTo((CAstEntity)iterator.next(), writer);
                }
            }
            writer.flush();
        }
        catch (IOException iOException) {
            System.err.println("unexpected I/O exception " + iOException);
        }
    }
}

