/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.util;

import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.util.CAstPrinter;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CAstPattern {
    private static boolean DEBUG_PARSER = false;
    private static boolean DEBUG_MATCH = false;
    private static final int CHILD_KIND = -1;
    private static final int CHILDREN_KIND = -2;
    private static final int REPEATED_PATTERN_KIND = -3;
    private static final int ALTERNATIVE_PATTERN_KIND = -4;
    private static final int OPTIONAL_PATTERN_KIND = -5;
    private static final int REFERENCE_PATTERN_KIND = -6;
    private static final int IGNORE_KIND = -99;
    private final String name;
    private final int kind;
    private final String value;
    private final CAstPattern[] children;
    private final Map<String, CAstPattern> references;

    public CAstPattern(String string, int n, CAstPattern[] cAstPatternArray) {
        this.name = string;
        this.kind = n;
        this.value = null;
        this.children = cAstPatternArray;
        this.references = null;
    }

    public CAstPattern(String string, String string2) {
        this.name = string;
        this.kind = -99;
        this.value = string2;
        this.children = null;
        this.references = null;
    }

    public CAstPattern(String string, Map<String, CAstPattern> map) {
        this.name = null;
        this.kind = -6;
        this.value = string;
        this.references = map;
        this.children = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.name != null) {
            stringBuffer.append("<").append(this.name).append(">");
        }
        if (this.value != null) {
            if (this.kind == -6) {
                stringBuffer.append("ref:").append(this.value);
            } else {
                stringBuffer.append("literal:").append(this.value);
            }
        } else if (this.kind == -1) {
            stringBuffer.append("*");
        } else if (this.kind == -2) {
            stringBuffer.append("**");
        } else if (this.kind == -3) {
            stringBuffer.append("@");
        } else if (this.kind == -4) {
            stringBuffer.append("|");
        } else if (this.kind == -5) {
            stringBuffer.append("?");
        } else {
            stringBuffer.append(CAstPrinter.kindAsString(this.kind));
        }
        if (this.children != null) {
            stringBuffer.append("(");
            int n = 0;
            while (n < this.children.length) {
                stringBuffer.append(this.children[n].toString());
                if (n == this.children.length - 1) {
                    stringBuffer.append(")");
                } else {
                    stringBuffer.append(",");
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    private static boolean matchChildren(CAstNode cAstNode, int n, CAstPattern[] cAstPatternArray, int n2, Segments segments) {
        if (n >= cAstNode.getChildCount() && n2 >= cAstPatternArray.length) {
            return true;
        }
        if (n < cAstNode.getChildCount() && n2 >= cAstPatternArray.length) {
            return false;
        }
        if (n >= cAstNode.getChildCount() && n2 < cAstPatternArray.length) {
            switch (cAstPatternArray[n2].kind) {
                case -5: 
                case -3: 
                case -2: {
                    return CAstPattern.matchChildren(cAstNode, n, cAstPatternArray, n2 + 1, segments);
                }
            }
            return false;
        }
        if (cAstPatternArray[n2].kind == -1) {
            if (DEBUG_MATCH) {
                System.err.println("* matches " + CAstPrinter.print(cAstNode.getChild(n)));
            }
            if (segments != null && cAstPatternArray[n2].name != null) {
                segments.add(cAstPatternArray[n2].name, cAstNode.getChild(n));
            }
            return CAstPattern.matchChildren(cAstNode, n + 1, cAstPatternArray, n2 + 1, segments);
        }
        if (cAstPatternArray[n2].kind == -2) {
            if (CAstPattern.tryMatchChildren(cAstNode, n, cAstPatternArray, n2 + 1, segments)) {
                if (DEBUG_MATCH) {
                    System.err.println("** matches nothing");
                }
                return true;
            }
            if (DEBUG_MATCH) {
                System.err.println("** matches " + CAstPrinter.print(cAstNode.getChild(n)));
            }
            if (segments != null && cAstPatternArray[n2].name != null) {
                segments.add(cAstPatternArray[n2].name, cAstNode.getChild(n));
            }
            return CAstPattern.matchChildren(cAstNode, n + 1, cAstPatternArray, n2, segments);
        }
        if (cAstPatternArray[n2].kind == -3) {
            CAstPattern cAstPattern = cAstPatternArray[n2].children[0];
            if (cAstPattern.tryMatch(cAstNode.getChild(n), segments)) {
                if (segments != null && cAstPatternArray[n2].name != null) {
                    segments.add(cAstPatternArray[n2].name, cAstNode.getChild(n));
                }
                if (DEBUG_MATCH) {
                    System.err.println(cAstPatternArray[n2] + " matches " + CAstPrinter.print(cAstNode.getChild(n)));
                }
                return CAstPattern.matchChildren(cAstNode, n + 1, cAstPatternArray, n2, segments);
            }
            if (DEBUG_MATCH) {
                System.err.println(cAstPatternArray[n2] + " matches nothing");
            }
            return CAstPattern.matchChildren(cAstNode, n, cAstPatternArray, n2 + 1, segments);
        }
        if (cAstPatternArray[n2].kind == -5) {
            if (CAstPattern.tryMatchChildren(cAstNode, n, cAstPatternArray, n2 + 1, segments)) {
                if (DEBUG_MATCH) {
                    System.err.println(cAstPatternArray[n2] + " matches nothing");
                }
                return true;
            }
            CAstPattern cAstPattern = cAstPatternArray[n2].children[0];
            if (cAstPattern.tryMatch(cAstNode.getChild(n), segments)) {
                if (DEBUG_MATCH) {
                    System.err.println(cAstPatternArray[n2] + " matches " + CAstPrinter.print(cAstNode.getChild(n)));
                }
                return CAstPattern.matchChildren(cAstNode, n + 1, cAstPatternArray, n2 + 1, segments);
            }
            return false;
        }
        return cAstPatternArray[n2].match(cAstNode.getChild(n), segments) && CAstPattern.matchChildren(cAstNode, n + 1, cAstPatternArray, n2 + 1, segments);
    }

    public boolean match(CAstNode cAstNode, Segments segments) {
        if (DEBUG_MATCH) {
            System.err.println("matching " + this + " against " + CAstPrinter.print(cAstNode));
        }
        if (this.kind == -6) {
            return this.references.get(this.value).match(cAstNode, segments);
        }
        if (this.kind == -4) {
            int n = 0;
            while (n < this.children.length) {
                if (this.children[n].tryMatch(cAstNode, segments)) {
                    if (segments != null && this.name != null) {
                        segments.add(this.name, cAstNode);
                    }
                    return true;
                }
                ++n;
            }
            if (DEBUG_MATCH) {
                System.err.println("match failed (a)");
            }
            return false;
        }
        if (this.value == null ? cAstNode.getKind() != this.kind : cAstNode.getKind() != 300 || !this.value.equals(cAstNode.getValue().toString())) {
            if (DEBUG_MATCH) {
                System.err.println("match failed (b)");
            }
            return false;
        }
        if (segments != null && this.name != null) {
            segments.add(this.name, cAstNode);
        }
        if (this.children == null || this.children.length == 0) {
            if (DEBUG_MATCH && cAstNode.getChildCount() != 0) {
                System.err.println("match failed (c)");
            }
            return cAstNode.getChildCount() == 0;
        }
        return CAstPattern.matchChildren(cAstNode, 0, this.children, 0, segments);
    }

    private static boolean tryMatchChildren(CAstNode cAstNode, int n, CAstPattern[] cAstPatternArray, int n2, Segments segments) {
        if (segments == null) {
            return CAstPattern.matchChildren(cAstNode, n, cAstPatternArray, n2, segments);
        }
        Segments segments2 = new Segments();
        boolean bl = CAstPattern.matchChildren(cAstNode, n, cAstPatternArray, n2, segments2);
        if (bl) {
            segments.addAll(segments2);
        }
        return bl;
    }

    private boolean tryMatch(CAstNode cAstNode, Segments segments) {
        if (segments == null) {
            return this.match(cAstNode, segments);
        }
        Segments segments2 = new Segments();
        boolean bl = this.match(cAstNode, segments2);
        if (bl) {
            segments.addAll(segments2);
        }
        return bl;
    }

    public static Segments match(CAstPattern cAstPattern, CAstNode cAstNode) {
        Segments segments = new Segments();
        if (cAstPattern.match(cAstNode, segments)) {
            return segments;
        }
        return null;
    }

    public static CAstPattern parse(String string) {
        try {
            return new Parser(string).parse();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Assertions.UNREACHABLE((String)("no such kind in pattern: " + noSuchFieldException.getMessage()));
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            Assertions.UNREACHABLE((String)("internal error in CAstPattern" + illegalAccessException));
            return null;
        }
    }

    private static class Parser {
        private final Map<String, CAstPattern> namedPatterns = HashMapFactory.make();
        private final String patternString;
        private int start;
        private int end;

        private Parser(String string) {
            this.patternString = string;
        }

        private String parseName(boolean bl) {
            if (this.patternString.charAt(this.start) == (bl ? (char)'{' : '<')) {
                int n = this.start + 1;
                int n2 = this.patternString.indexOf(bl ? 125 : 62, n);
                this.start = n2 + 1;
                return this.patternString.substring(n, n2);
            }
            return null;
        }

        public CAstPattern parse() throws NoSuchFieldException, IllegalAccessException {
            CAstPattern cAstPattern;
            if (DEBUG_PARSER) {
                System.err.println("parsing " + this.patternString.substring(this.start));
            }
            String string = this.parseName(true);
            String string2 = this.parseName(false);
            if (this.patternString.charAt(this.start) == '`') {
                int n = this.patternString.indexOf(96, this.start + 1);
                this.end = n + 1;
                String string3 = this.patternString.substring(this.start + 1, n);
                assert (string == null);
                cAstPattern = new CAstPattern(string3, this.namedPatterns);
            } else if (this.patternString.charAt(this.start) == '\"') {
                int n = this.patternString.indexOf(34, this.start + 1);
                this.end = n + 1;
                cAstPattern = new CAstPattern(string2, this.patternString.substring(this.start + 1, n));
            } else if (this.patternString.startsWith("**", this.start)) {
                this.end = this.start + 2;
                cAstPattern = new CAstPattern(string2, -2, null);
            } else if (this.patternString.startsWith("*", this.start)) {
                this.end = this.start + 1;
                cAstPattern = new CAstPattern(string2, -1, null);
            } else if (this.patternString.startsWith("|(", this.start)) {
                ArrayList<CAstPattern> arrayList = new ArrayList<CAstPattern>();
                this.start += 2;
                do {
                    arrayList.add(this.parse());
                    this.start = this.end + 2;
                } while (this.patternString.startsWith("||", this.end));
                assert (this.patternString.startsWith(")|", this.end)) : this.patternString;
                this.end += 2;
                cAstPattern = new CAstPattern(string2, -4, arrayList.toArray(new CAstPattern[arrayList.size()]));
            } else if (this.patternString.startsWith("@(", this.start)) {
                this.start += 2;
                CAstPattern[] cAstPatternArray = new CAstPattern[]{this.parse()};
                assert (this.patternString.startsWith(")@", this.end));
                this.end += 2;
                if (DEBUG_PARSER) {
                    System.err.println("repeated pattern: " + cAstPatternArray[0]);
                }
                cAstPattern = new CAstPattern(string2, -3, cAstPatternArray);
            } else if (this.patternString.startsWith("?(", this.start)) {
                this.start += 2;
                CAstPattern[] cAstPatternArray = new CAstPattern[]{this.parse()};
                assert (this.patternString.startsWith(")?", this.end));
                this.end += 2;
                if (DEBUG_PARSER) {
                    System.err.println("optional pattern: " + cAstPatternArray[0]);
                }
                cAstPattern = new CAstPattern(string2, -5, cAstPatternArray);
            } else {
                int n = this.patternString.indexOf(40, this.start);
                String string4 = this.patternString.substring(this.start, n);
                Field field = CAstNode.class.getField(string4);
                int n2 = field.getInt(null);
                if (this.patternString.charAt(n + 1) == ')') {
                    this.end = n + 2;
                    cAstPattern = new CAstPattern(string2, n2, null);
                } else {
                    ArrayList<CAstPattern> arrayList = new ArrayList<CAstPattern>();
                    this.start = this.patternString.indexOf(40, this.start) + 1;
                    do {
                        arrayList.add(this.parse());
                        this.start = this.end + 1;
                        if (!DEBUG_PARSER) continue;
                        System.err.println("parsing children: " + this.patternString.substring(this.end));
                    } while (this.patternString.charAt(this.end) == ',');
                    assert (this.patternString.charAt(this.end) == ')');
                    ++this.end;
                    cAstPattern = new CAstPattern(string2, n2, arrayList.toArray(new CAstPattern[arrayList.size()]));
                }
            }
            if (string != null) {
                this.namedPatterns.put(string, cAstPattern);
            }
            return cAstPattern;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Segments
    extends TreeMap<String, Object> {
        public CAstNode getSingle(String string) {
            assert (this.containsKey(string)) : string;
            return (CAstNode)this.get(string);
        }

        public List<Object> getMultiple(String string) {
            if (!this.containsKey(string)) {
                return Collections.emptyList();
            }
            Object v = this.get(string);
            if (v instanceof CAstNode) {
                return Collections.singletonList(v);
            }
            assert (v instanceof List);
            return (List)v;
        }

        private void addAll(Segments segments) {
            for (Map.Entry entry : segments.entrySet()) {
                String string = (String)entry.getKey();
                if (entry.getValue() instanceof CAstNode) {
                    this.add(string, (CAstNode)entry.getValue());
                    continue;
                }
                Iterator iterator = ((List)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    this.add(string, (CAstNode)iterator.next());
                }
            }
        }

        private void add(String string, CAstNode cAstNode) {
            if (this.containsKey(string)) {
                Object v = this.get(string);
                if (v instanceof List) {
                    ((List)v).add(cAstNode);
                } else {
                    assert (v instanceof CAstNode);
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(v);
                    arrayList.add(cAstNode);
                    this.put(string, arrayList);
                }
            } else {
                this.put(string, cAstNode);
            }
        }
    }
}

