/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.loader;

import com.ibm.wala.cast.ir.translator.AstTranslator;
import com.ibm.wala.cast.tree.CAstQualifier;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.strings.Atom;
import java.util.Collection;

public abstract class AstMethod
implements IMethod {
    protected final IClass cls;
    private final Collection qualifiers;
    private final AbstractCFG cfg;
    private final SymbolTable symtab;
    private final MethodReference ref;
    private final boolean hasCatchBlock;
    private final boolean hasMonitorOp;
    private final TypeReference[][] catchTypes;
    private final AstTranslator.AstLexicalInformation lexicalInfo;
    private final DebuggingInformation debugInfo;

    protected AstMethod(IClass iClass, Collection collection, AbstractCFG abstractCFG, SymbolTable symbolTable, MethodReference methodReference, boolean bl, TypeReference[][] typeReferenceArray, boolean bl2, AstTranslator.AstLexicalInformation astLexicalInformation, DebuggingInformation debuggingInformation) {
        this.cls = iClass;
        this.cfg = abstractCFG;
        this.ref = methodReference;
        this.symtab = symbolTable;
        this.qualifiers = collection;
        this.catchTypes = typeReferenceArray;
        this.hasCatchBlock = bl;
        this.hasMonitorOp = bl2;
        this.lexicalInfo = astLexicalInformation;
        this.debugInfo = debuggingInformation;
    }

    protected AstMethod(IClass iClass, Collection collection, MethodReference methodReference) {
        this.cls = iClass;
        this.qualifiers = collection;
        this.ref = methodReference;
        this.cfg = null;
        this.symtab = null;
        this.catchTypes = null;
        this.hasCatchBlock = false;
        this.hasMonitorOp = false;
        this.lexicalInfo = null;
        this.debugInfo = null;
        assert (this.isAbstract());
    }

    public AbstractCFG cfg() {
        return this.cfg;
    }

    public boolean hasCatchBlock() {
        return this.hasCatchBlock();
    }

    public SymbolTable symbolTable() {
        return this.symtab;
    }

    public TypeReference[][] catchTypes() {
        return this.catchTypes;
    }

    public LexicalInformation cloneLexicalInfo() {
        return new AstTranslator.AstLexicalInformation(this.lexicalInfo);
    }

    public LexicalInformation lexicalInfo() {
        return this.lexicalInfo;
    }

    public DebuggingInformation debugInfo() {
        return this.debugInfo;
    }

    public abstract LexicalParent[] getParents();

    public IClass getDeclaringClass() {
        return this.cls;
    }

    public String getSignature() {
        return this.ref.getSignature();
    }

    public Selector getSelector() {
        return this.ref.getSelector();
    }

    public boolean isClinit() {
        return this.getSelector().equals((Object)MethodReference.clinitSelector);
    }

    public boolean isInit() {
        return this.getSelector().getName().equals((Object)MethodReference.initAtom);
    }

    public Atom getName() {
        return this.ref.getName();
    }

    public Descriptor getDescriptor() {
        return this.ref.getDescriptor();
    }

    public MethodReference getReference() {
        return this.ref;
    }

    public TypeReference getReturnType() {
        return this.ref.getReturnType();
    }

    public boolean isStatic() {
        return this.qualifiers.contains(CAstQualifier.STATIC);
    }

    public boolean isSynchronized() {
        return this.qualifiers.contains(CAstQualifier.SYNCHRONIZED);
    }

    public boolean isNative() {
        return this.qualifiers.contains(CAstQualifier.NATIVE);
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean isAbstract() {
        return this.qualifiers.contains(CAstQualifier.ABSTRACT);
    }

    public boolean isPrivate() {
        return this.qualifiers.contains(CAstQualifier.PRIVATE);
    }

    public boolean isProtected() {
        return this.qualifiers.contains(CAstQualifier.PROTECTED);
    }

    public boolean isPublic() {
        return this.qualifiers.contains(CAstQualifier.PUBLIC);
    }

    public boolean isFinal() {
        return this.qualifiers.contains(CAstQualifier.FINAL);
    }

    public boolean isBridge() {
        return this.qualifiers.contains(CAstQualifier.VOLATILE);
    }

    public ControlFlowGraph getControlFlowGraph() {
        return this.cfg;
    }

    public boolean hasExceptionHandler() {
        return this.hasCatchBlock;
    }

    public boolean hasMonitorOp() {
        return this.hasMonitorOp;
    }

    public int getNumberOfParameters() {
        return this.symtab.getParameterValueNumbers().length;
    }

    public int getLineNumber(int n) {
        CAstSourcePositionMap.Position position = this.debugInfo.getInstructionPosition(n);
        if (position == null) {
            return -1;
        }
        return position.getFirstLine();
    }

    public CAstSourcePositionMap.Position getSourcePosition() {
        return this.debugInfo.getCodeBodyPosition();
    }

    public CAstSourcePositionMap.Position getSourcePosition(int n) {
        return this.debugInfo.getInstructionPosition(n);
    }

    public static interface DebuggingInformation {
        public CAstSourcePositionMap.Position getCodeBodyPosition();

        public CAstSourcePositionMap.Position getInstructionPosition(int var1);

        public String[][] getSourceNamesForValues();
    }

    public static interface LexicalInformation {
        public int[] getExitExposedUses();

        public int[] getExposedUses(int var1);

        public IntSet getAllExposedUses();

        public Pair[] getExposedNames();

        public String[] getScopingParents();

        public void handleAlteration();
    }

    public abstract class LexicalParent {
        public abstract String getName();

        public abstract AstMethod getMethod();

        public int hashCode() {
            return this.getName().hashCode() * this.getMethod().hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof LexicalParent && this.getName().equals(((LexicalParent)object).getName()) && this.getMethod().equals(((LexicalParent)object).getMethod());
        }
    }
}

