/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.ssa;

import com.ibm.wala.cast.ir.ssa.AbstractSSAConversion;
import com.ibm.wala.cast.ir.ssa.AssignInstruction;
import com.ibm.wala.cast.ir.ssa.AstIRFactory;
import com.ibm.wala.cast.ir.ssa.analysis.LiveAnalysis;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class SSAConversion
extends AbstractSSAConversion {
    public static boolean DEBUG = false;
    public static boolean DEBUG_UNDO = false;
    public static boolean DEBUG_NAMES = false;
    public static boolean DUMP = false;
    private final AstIRFactory.AstIR ir;
    private int nextSSAValue;
    private final AstMethod.DebuggingInformation debugInfo;
    private final AstMethod.LexicalInformation lexicalInfo;
    private final SymbolTable symtab;
    private final LiveAnalysis.Result liveness;
    private IR.SSA2LocalMap computedLocalMap;
    private final Map<Object, CopyPropagationRecord> copyPropagationMap;
    private final Stack<CopyPropagationRecord>[] R;

    public static void undoCopyPropagation(AstIRFactory.AstIR astIR, int n, int n2) {
        SSAInformation sSAInformation = (SSAInformation)astIR.getLocalMap();
        sSAInformation.undoCopyPropagation(n, n2);
    }

    public static void copyUse(AstIRFactory.AstIR astIR, int n, int n2, int n3, int n4) {
        SSAInformation sSAInformation = (SSAInformation)astIR.getLocalMap();
        sSAInformation.copyUse(n, n2, n3, n4);
    }

    private CopyPropagationRecord topR(int n) {
        if (this.R[n] != null && !this.R[n].isEmpty()) {
            CopyPropagationRecord copyPropagationRecord = this.R[n].peek();
            if (this.top(n) == copyPropagationRecord.rhs) {
                return copyPropagationRecord;
            }
        }
        return null;
    }

    protected int getNumberOfDefs(SSAInstruction sSAInstruction) {
        return sSAInstruction.getNumberOfDefs();
    }

    protected int getDef(SSAInstruction sSAInstruction, int n) {
        return sSAInstruction.getDef(n);
    }

    protected int getNumberOfUses(SSAInstruction sSAInstruction) {
        return sSAInstruction.getNumberOfUses();
    }

    protected int getUse(SSAInstruction sSAInstruction, int n) {
        return sSAInstruction.getUse(n);
    }

    protected boolean isAssignInstruction(SSAInstruction sSAInstruction) {
        return sSAInstruction instanceof AssignInstruction;
    }

    protected int getMaxValueNumber() {
        return this.symtab.getMaxValueNumber();
    }

    protected boolean skip(int n) {
        return false;
    }

    protected boolean isLive(SSACFG.BasicBlock basicBlock, int n) {
        return this.liveness.isLiveEntry((ISSABasicBlock)basicBlock, n);
    }

    private void addPhi(SSACFG.BasicBlock basicBlock, SSAPhiInstruction sSAPhiInstruction) {
        basicBlock.addPhiForLocal(this.phiCounts[basicBlock.getGraphNodeId()], sSAPhiInstruction);
    }

    protected void placeNewPhiAt(int n, SSACFG.BasicBlock basicBlock) {
        int[] nArray = new int[this.CFG.getPredNodeCount((ISSABasicBlock)basicBlock)];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = n;
            ++n2;
        }
        SSAPhiInstruction sSAPhiInstruction = new SSAPhiInstruction(n, nArray);
        if (DEBUG) {
            System.err.println("Placing " + sSAPhiInstruction + " at " + basicBlock);
        }
        this.addPhi(basicBlock, sSAPhiInstruction);
    }

    protected SSAPhiInstruction getPhi(SSACFG.BasicBlock basicBlock, int n) {
        return basicBlock.getPhiForLocal(n);
    }

    protected void setPhi(SSACFG.BasicBlock basicBlock, int n, SSAPhiInstruction sSAPhiInstruction) {
        basicBlock.addPhiForLocal(n, sSAPhiInstruction);
    }

    protected SSAPhiInstruction repairPhiDefs(SSAPhiInstruction sSAPhiInstruction, int[] nArray) {
        return (SSAPhiInstruction)sSAPhiInstruction.copyForSSA(this.CFG.getMethod().getDeclaringClass().getClassLoader().getInstructionFactory(), nArray, null);
    }

    protected void repairPhiUse(SSACFG.BasicBlock basicBlock, int n, int n2, int n3) {
        SSAPhiInstruction sSAPhiInstruction = this.getPhi(basicBlock, n);
        int[] nArray = new int[this.getNumberOfUses((SSAInstruction)sSAPhiInstruction)];
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5;
            int n6 = this.getUse((SSAInstruction)sSAPhiInstruction, n4);
            nArray[n4] = n5 = n4 == n2 ? n3 : n6;
            if (n4 == n2 && this.topR(n6) != null) {
                this.topR(n6).addUse(basicBlock.getGraphNodeId(), n, n4);
            }
            ++n4;
        }
        sSAPhiInstruction.setValues(nArray);
    }

    protected void pushAssignment(SSAInstruction sSAInstruction, int n, int n2) {
        int n3 = this.getDef(sSAInstruction, 0);
        int n4 = this.getUse(sSAInstruction, 0);
        this.copyNames(n4, n3);
        CopyPropagationRecord copyPropagationRecord = new CopyPropagationRecord(n, n3, n2);
        this.R[n3].push(copyPropagationRecord);
        if (this.topR(n4) != null) {
            this.topR(n4).addChild(copyPropagationRecord);
        }
    }

    protected void repairInstructionUses(SSAInstruction sSAInstruction, int n, int[] nArray) {
        int n2 = 0;
        while (n2 < this.getNumberOfUses(sSAInstruction)) {
            if (this.topR(this.getUse(sSAInstruction, n2)) != null) {
                this.topR(this.getUse(sSAInstruction, n2)).addUse(n, n2);
            }
            ++n2;
        }
        int[] nArray2 = this.lexicalInfo.getExposedUses(n);
        if (nArray2 != null) {
            int n3 = 0;
            while (n3 < nArray2.length) {
                int n4 = nArray2[n3];
                if (n4 != -1 && !this.skip(n4)) {
                    if (this.S[n4].isEmpty()) {
                        nArray2[n3] = -1;
                    } else {
                        int n5;
                        nArray2[n3] = n5 = this.top(n4);
                        if (this.topR(n4) != null) {
                            this.topR(n4).addUse(n, -n3 - 1);
                        }
                    }
                }
                ++n3;
            }
        }
    }

    protected void repairInstructionDefs(SSAInstruction sSAInstruction, int n, int[] nArray, int[] nArray2) {
        this.instructions[n] = sSAInstruction.copyForSSA(this.CFG.getMethod().getDeclaringClass().getClassLoader().getInstructionFactory(), nArray, nArray2);
    }

    protected void popAssignment(SSAInstruction sSAInstruction, int n) {
        this.instructions[n] = null;
    }

    protected boolean isConstant(int n) {
        return this.symtab.isConstant(n);
    }

    protected boolean skipRepair(SSAInstruction sSAInstruction, int n) {
        if (!super.skipRepair(sSAInstruction, n)) {
            return false;
        }
        if (n == -1) {
            return true;
        }
        int[] nArray = this.lexicalInfo.getExposedUses(n);
        if (nArray != null) {
            int n2 = 0;
            while (n2 < nArray.length) {
                if (!this.skip(nArray[n2])) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private SSAConversion(AstMethod astMethod, AstIRFactory.AstIR astIR, SSAOptions sSAOptions) {
        super(astIR, sSAOptions);
        int n;
        SSACFG.BasicBlock basicBlock;
        HashMap hashMap = HashMapFactory.make();
        this.copyPropagationMap = astIR.getLocalMap() instanceof SSAInformation ? ((SSAInformation)astIR.getLocalMap()).getCopyHistory() : hashMap;
        this.ir = astIR;
        this.debugInfo = astMethod.debugInfo();
        this.lexicalInfo = astIR.lexicalInfo();
        this.symtab = astIR.getSymbolTable();
        this.R = new Stack[astIR.getSymbolTable().getMaxValueNumber() + 1];
        int n2 = 0;
        while (n2 < this.CFG.getNumberOfNodes()) {
            basicBlock = this.CFG.getNode(n2);
            if (basicBlock.hasPhi()) {
                n = 0;
                Iterator iterator = basicBlock.iteratePhis();
                while (iterator.hasNext()) {
                    iterator.next();
                    ++n;
                }
                this.phiCounts[n2] = n;
            }
            ++n2;
        }
        this.nextSSAValue = astIR.getNumberOfParameters() + 1;
        int[] nArray = this.lexicalInfo.getExitExposedUses();
        basicBlock = new BitVector();
        if (nArray != null) {
            n = 0;
            while (n < nArray.length) {
                basicBlock.set(nArray[n]);
                ++n;
            }
        }
        this.liveness = LiveAnalysis.perform((ControlFlowGraph<SSAInstruction, ISSABasicBlock>)this.CFG, this.symtab, (BitVector)basicBlock);
        if (DEBUG) {
            System.err.println(this.liveness);
        }
    }

    protected int getNextNewValueNumber() {
        while (this.symtab.isConstant(this.nextSSAValue) || this.skip(this.nextSSAValue)) {
            ++this.nextSSAValue;
        }
        this.symtab.ensureSymbol(this.nextSSAValue);
        int n = this.nextSSAValue++;
        return n;
    }

    private void copyNames(int n, int n2) {
        String[][] stringArray = this.debugInfo.getSourceNamesForValues();
        if (stringArray != null && stringArray.length > n2 && stringArray[n2] != null) {
            if (stringArray[n] == null) {
                stringArray[n] = stringArray[n2];
            } else {
                String[] stringArray2 = new String[stringArray[n2].length + stringArray[n].length];
                System.arraycopy(stringArray[n2], 0, stringArray2, 0, stringArray[n2].length);
                System.arraycopy(stringArray[n], 0, stringArray2, stringArray[n2].length, stringArray[n].length);
                stringArray[n] = stringArray2;
            }
        }
    }

    protected void initializeVariables() {
        int n = 1;
        while (n <= this.getMaxValueNumber()) {
            if (!this.skip(n)) {
                this.R[n] = new Stack();
            }
            ++n;
        }
        int[] nArray = this.symtab.getParameterValueNumbers();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (!this.skip(nArray[n2])) {
                this.S[nArray[n2]].push(nArray[n2]);
                this.valueMap[nArray[n2]] = nArray[n2];
            }
            ++n2;
        }
    }

    protected void repairExit() {
        int[] nArray = this.lexicalInfo.getExitExposedUses();
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length) {
                if (!this.skip(nArray[n])) {
                    assert (!this.S[nArray[n]].isEmpty());
                    nArray[n] = this.top(nArray[n]);
                }
                ++n;
            }
        }
    }

    protected void fail(int n) {
        System.err.println("during SSA conversion of the following IR:");
        System.err.println((Object)this.ir);
        super.fail(n);
    }

    public IR.SSA2LocalMap getComputedLocalMap() {
        return this.computedLocalMap;
    }

    public void perform() {
        super.perform();
        if (DUMP) {
            System.err.println((Object)this.ir);
            if (this.lexicalInfo != null) {
                int n = 0;
                while (n < this.instructions.length) {
                    int[] nArray = this.lexicalInfo.getExposedUses(n);
                    if (nArray != null) {
                        System.err.print("extra uses for " + this.instructions[n] + ": ");
                        int n2 = 0;
                        while (n2 < nArray.length) {
                            System.err.print(String.valueOf(new Integer(nArray[n2]).toString()) + " ");
                            ++n2;
                        }
                        System.err.println("");
                    }
                    ++n;
                }
            }
        }
        this.computedLocalMap = new SSAInformation();
    }

    private static IntSet valuesToConvert(AstIRFactory.AstIR astIR) {
        SSAInstruction[] sSAInstructionArray = astIR.getInstructions();
        BitVectorIntSet bitVectorIntSet = new BitVectorIntSet();
        BitVectorIntSet bitVectorIntSet2 = new BitVectorIntSet();
        int n = 0;
        while (n < sSAInstructionArray.length) {
            SSAInstruction sSAInstruction = sSAInstructionArray[n];
            if (sSAInstruction != null) {
                int n2 = 0;
                while (n2 < sSAInstruction.getNumberOfDefs()) {
                    int n3 = sSAInstruction.getDef(n2);
                    if (n3 != -1) {
                        if (bitVectorIntSet.contains(n3) || astIR.getSymbolTable().isConstant(n3) || n3 <= astIR.getNumberOfParameters() || sSAInstruction instanceof AssignInstruction) {
                            bitVectorIntSet2.add(n3);
                        } else {
                            bitVectorIntSet.add(n3);
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return bitVectorIntSet2;
    }

    public static IR.SSA2LocalMap convert(AstMethod astMethod, AstIRFactory.AstIR astIR, SSAOptions sSAOptions) {
        return SSAConversion.convert(astMethod, astIR, sSAOptions, SSAConversion.valuesToConvert(astIR));
    }

    public static IR.SSA2LocalMap convert(AstMethod astMethod, AstIRFactory.AstIR astIR, SSAOptions sSAOptions, final IntSet intSet) {
        try {
            if (DEBUG) {
                System.err.println("starting conversion for " + intSet);
                System.err.println((Object)astIR);
            }
            if (DEBUG_UNDO) {
                System.err.println(">>> starting " + astIR.getMethod());
            }
            SSAConversion sSAConversion = new SSAConversion(astMethod, astIR, sSAOptions, astIR){
                final int limit;
                {
                    super(astMethod, astIR, sSAOptions, null);
                    this.limit = astIR2.getSymbolTable().getMaxValueNumber();
                }

                protected boolean skip(int n) {
                    return n >= 0 && n <= this.limit && !intSet.contains(n);
                }
            };
            sSAConversion.perform();
            if (DEBUG_UNDO) {
                System.err.println("<<< done " + astIR.getMethod());
            }
            return sSAConversion.getComputedLocalMap();
        }
        catch (RuntimeException runtimeException) {
            System.err.println("exception " + runtimeException + " while converting:");
            System.err.println((Object)astIR);
            throw runtimeException;
        }
        catch (Error error) {
            System.err.println("error " + error + " while converting:");
            System.err.println((Object)astIR);
            throw error;
        }
    }

    /* synthetic */ SSAConversion(AstMethod astMethod, AstIRFactory.AstIR astIR, SSAOptions sSAOptions, SSAConversion sSAConversion) {
        this(astMethod, astIR, sSAOptions);
    }

    private class CopyPropagationRecord {
        final int lhs;
        final int rhs;
        final int instructionIndex;
        final Set<Object> renamedUses = HashSetFactory.make((int)2);
        private final Set<CopyPropagationRecord> childRecords = HashSetFactory.make((int)1);

        public int hashCode() {
            return this.instructionIndex;
        }

        public boolean equals(Object object) {
            return object instanceof CopyPropagationRecord && this.instructionIndex == ((CopyPropagationRecord)object).instructionIndex;
        }

        private CopyPropagationRecord(int n, int n2, int n3) {
            if (DEBUG_UNDO) {
                System.err.println("new copy record for instruction #" + n + ", rhs value is " + n3);
            }
            this.lhs = n2;
            this.rhs = n3;
            this.instructionIndex = n;
        }

        private void addChild(CopyPropagationRecord copyPropagationRecord) {
            if (DEBUG_UNDO) {
                System.err.println("(" + copyPropagationRecord.instructionIndex + "," + copyPropagationRecord.rhs + ") is a child of (" + this.instructionIndex + "," + this.rhs + ")");
            }
            this.childRecords.add(copyPropagationRecord);
        }

        private void addUse(int n, int n2) {
            if (DEBUG_UNDO) {
                System.err.println("propagated use of (" + this.instructionIndex + "," + this.rhs + ") at use #" + n2 + " of instruction #" + n);
            }
            UseRecord useRecord = new UseRecord(n, n2);
            SSAConversion.this.copyPropagationMap.put(useRecord, this);
            this.renamedUses.add(useRecord);
        }

        private void addUse(int n, int n2, int n3) {
            PhiUseRecord phiUseRecord = new PhiUseRecord(n, n2, n3);
            SSAConversion.this.copyPropagationMap.put(phiUseRecord, this);
            this.renamedUses.add(phiUseRecord);
        }

        private SSAInstruction undo(SSAInstruction sSAInstruction, int n, int n2) {
            int n3 = SSAConversion.this.getNumberOfUses(sSAInstruction);
            int[] nArray = new int[n3];
            int n4 = 0;
            while (n4 < n3) {
                nArray[n4] = n4 == n ? n2 : SSAConversion.this.getUse(sSAInstruction, n4);
                ++n4;
            }
            return sSAInstruction.copyForSSA(SSAConversion.this.CFG.getMethod().getDeclaringClass().getClassLoader().getInstructionFactory(), null, nArray);
        }

        private void undo(int n) {
            int n2 = SSAConversion.this.symtab.newSymbol();
            SSAConversion.this.instructions[this.instructionIndex] = new AssignInstruction(n2, n);
            if (DEBUG_UNDO) {
                System.err.println("recreating assignment at " + this.instructionIndex + " as " + n2 + " = " + n);
            }
            for (Object object : this.renamedUses) {
                int n3;
                Object object2;
                if (object instanceof UseRecord) {
                    object2 = (UseRecord)object;
                    n3 = ((UseRecord)object2).instructionIndex;
                    SSAInstruction sSAInstruction = SSAConversion.this.instructions[n3];
                    if (DEBUG_UNDO) {
                        System.err.println("Changing use #" + ((UseRecord)object2).useNumber + " of inst #" + n3 + " to val " + n2);
                    }
                    if (((UseRecord)object2).useNumber >= 0) {
                        SSAConversion.this.instructions[n3] = this.undo(sSAInstruction, ((UseRecord)object2).useNumber, n2);
                    } else {
                        ((SSAConversion)SSAConversion.this).lexicalInfo.getExposedUses((int)n3)[-((UseRecord)object2).useNumber - 1] = n2;
                    }
                    SSAConversion.this.copyPropagationMap.remove(object2);
                    continue;
                }
                object2 = (PhiUseRecord)object;
                n3 = ((PhiUseRecord)object2).BBnumber;
                int n4 = ((PhiUseRecord)object2).phiNumber;
                SSACFG.BasicBlock basicBlock = SSAConversion.this.CFG.getNode(n3);
                basicBlock.addPhiForLocal(n4, (SSAPhiInstruction)this.undo((SSAInstruction)basicBlock.getPhiForLocal(n4), ((PhiUseRecord)object2).useNumber, n2));
                SSAConversion.this.copyPropagationMap.remove(object2);
            }
            Iterator<Object> iterator = this.childRecords.iterator();
            while (iterator.hasNext()) {
                ((CopyPropagationRecord)iterator.next()).undo(n2);
            }
        }

        public void undo() {
            this.undo(this.rhs);
            SSAConversion.this.copyPropagationMap.remove(new UseRecord(this.instructionIndex, this.rhs));
        }
    }

    private class PhiUseRecord {
        final int BBnumber;
        final int phiNumber;
        final int useNumber;

        private PhiUseRecord(int n, int n2, int n3) {
            this.BBnumber = n;
            this.phiNumber = n2;
            this.useNumber = n3;
        }

        public int hashCode() {
            return this.phiNumber * this.BBnumber * this.useNumber;
        }

        public boolean equals(Object object) {
            return object instanceof PhiUseRecord && this.BBnumber == ((PhiUseRecord)object).BBnumber && this.phiNumber == ((PhiUseRecord)object).phiNumber && this.useNumber == ((PhiUseRecord)object).useNumber;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SSAInformation
    implements IR.SSA2LocalMap {
        private SSAInformation() {
        }

        public String[] getLocalNames(int n, int n2) {
            int n3 = SSAConversion.this.skip(n2) || n2 >= SSAConversion.this.valueMap.length ? n2 : SSAConversion.this.valueMap[n2];
            String[][] stringArray = SSAConversion.this.debugInfo.getSourceNamesForValues();
            if (stringArray == null || stringArray.length <= n3) {
                return new String[0];
            }
            return stringArray[n3];
        }

        private void undoCopyPropagation(int n, int n2) {
            if (DEBUG_UNDO) {
                System.err.println("undoing for use #" + n2 + " of inst #" + n);
            }
            UseRecord useRecord = new UseRecord(n, n2);
            if (SSAConversion.this.copyPropagationMap.containsKey(useRecord)) {
                ((CopyPropagationRecord)SSAConversion.this.copyPropagationMap.get(useRecord)).undo();
            }
        }

        private void copyUse(int n, int n2, int n3, int n4) {
            UseRecord useRecord = new UseRecord(n, n2);
            if (SSAConversion.this.copyPropagationMap.containsKey(useRecord)) {
                ((CopyPropagationRecord)SSAConversion.this.copyPropagationMap.get(useRecord)).addUse(n3, n4);
            }
        }

        private Map<Object, CopyPropagationRecord> getCopyHistory() {
            return SSAConversion.this.copyPropagationMap;
        }
    }

    private static class UseRecord {
        final int instructionIndex;
        final int useNumber;

        private UseRecord(int n, int n2) {
            this.useNumber = n2;
            this.instructionIndex = n;
        }

        public int hashCode() {
            return this.useNumber * this.instructionIndex;
        }

        public boolean equals(Object object) {
            return object instanceof UseRecord && this.instructionIndex == ((UseRecord)object).instructionIndex && this.useNumber == ((UseRecord)object).useNumber;
        }
    }
}

