/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.ssa;

import com.ibm.wala.cast.ir.cfg.Util;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.util.collections.ArrayIterator;
import com.ibm.wala.util.collections.IntStack;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.dominators.DominanceFrontiers;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSSAConversion {
    protected final SSACFG CFG;
    protected final DominanceFrontiers<ISSABasicBlock> DF;
    private final Graph<ISSABasicBlock> dominatorTree;
    protected final int[] phiCounts;
    protected final SSAInstruction[] instructions;
    private final int[] flags;
    protected final SymbolTable symbolTable;
    protected final SSAOptions.DefaultValues defaultValues;
    protected IntStack[] S;
    protected int[] C;
    protected int[] valueMap;
    private Set<SSACFG.BasicBlock>[] assignmentMap;

    protected abstract int getNumberOfDefs(SSAInstruction var1);

    protected abstract int getDef(SSAInstruction var1, int var2);

    protected abstract int getNumberOfUses(SSAInstruction var1);

    protected abstract int getUse(SSAInstruction var1, int var2);

    protected abstract boolean isAssignInstruction(SSAInstruction var1);

    protected abstract int getMaxValueNumber();

    protected abstract boolean isLive(SSACFG.BasicBlock var1, int var2);

    protected abstract boolean skip(int var1);

    protected abstract boolean isConstant(int var1);

    protected abstract int getNextNewValueNumber();

    protected abstract void initializeVariables();

    protected abstract void repairExit();

    protected abstract void placeNewPhiAt(int var1, SSACFG.BasicBlock var2);

    protected abstract SSAPhiInstruction getPhi(SSACFG.BasicBlock var1, int var2);

    protected abstract void setPhi(SSACFG.BasicBlock var1, int var2, SSAPhiInstruction var3);

    protected abstract SSAPhiInstruction repairPhiDefs(SSAPhiInstruction var1, int[] var2);

    protected abstract void repairPhiUse(SSACFG.BasicBlock var1, int var2, int var3, int var4);

    protected abstract void repairInstructionUses(SSAInstruction var1, int var2, int[] var3);

    protected abstract void repairInstructionDefs(SSAInstruction var1, int var2, int[] var3, int[] var4);

    protected abstract void pushAssignment(SSAInstruction var1, int var2, int var3);

    protected abstract void popAssignment(SSAInstruction var1, int var2);

    protected AbstractSSAConversion(IR iR, SSAOptions sSAOptions) {
        this.CFG = iR.getControlFlowGraph();
        this.DF = new DominanceFrontiers((Graph)iR.getControlFlowGraph(), (Object)iR.getControlFlowGraph().entry());
        this.dominatorTree = this.DF.dominatorTree();
        this.flags = new int[2 * iR.getControlFlowGraph().getNumberOfNodes()];
        this.instructions = this.getInstructions(iR);
        this.phiCounts = new int[this.CFG.getNumberOfNodes()];
        this.symbolTable = iR.getSymbolTable();
        this.defaultValues = sSAOptions.getDefaultValues();
    }

    protected void perform() {
        this.init();
        this.placePhiNodes();
        this.renameVariables();
    }

    protected SSAInstruction[] getInstructions(IR iR) {
        return iR.getInstructions();
    }

    protected final Iterator<SSAInstruction> iterateInstructions(IR iR) {
        return new ArrayIterator((Object[])this.getInstructions(iR));
    }

    protected void init() {
        this.S = new IntStack[this.getMaxValueNumber() + 1];
        this.C = new int[this.getMaxValueNumber() + 1];
        this.valueMap = new int[this.getMaxValueNumber() + 1];
        this.makeAssignmentMap();
    }

    private void makeAssignmentMap() {
        this.assignmentMap = new Set[this.getMaxValueNumber() + 1];
        for (SSACFG.BasicBlock basicBlock : this.CFG) {
            if (basicBlock.getFirstInstructionIndex() < 0) continue;
            for (SSAInstruction sSAInstruction : basicBlock) {
                if (sSAInstruction == null) continue;
                int n = 0;
                while (n < this.getNumberOfDefs(sSAInstruction)) {
                    this.addDefiningBlock(this.assignmentMap, basicBlock, this.getDef(sSAInstruction, n));
                    ++n;
                }
            }
        }
    }

    private void addDefiningBlock(Set<SSACFG.BasicBlock>[] setArray, SSACFG.BasicBlock basicBlock, int n) {
        if (!this.skip(n)) {
            if (setArray[n] == null) {
                setArray[n] = new LinkedHashSet<SSACFG.BasicBlock>(2);
            }
            setArray[n].add(basicBlock);
        }
    }

    protected void placePhiNodes() {
        int n = 0;
        for (SSACFG.BasicBlock basicBlock : this.CFG) {
            this.setHasAlready(basicBlock, 0);
            this.setWork(basicBlock, 0);
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        int n2 = 0;
        while (n2 < this.assignmentMap.length) {
            if (this.assignmentMap[n2] != null && !this.skip(n2)) {
                ++n;
                for (SSACFG.BasicBlock basicBlock : this.assignmentMap[n2]) {
                    this.setWork(basicBlock, n);
                    linkedHashSet.add(basicBlock);
                }
                while (!linkedHashSet.isEmpty()) {
                    SSACFG.BasicBlock basicBlock = (SSACFG.BasicBlock)linkedHashSet.iterator().next();
                    linkedHashSet.remove(basicBlock);
                    Iterator iterator = this.DF.getDominanceFrontier((Object)basicBlock);
                    while (iterator.hasNext()) {
                        SSACFG.BasicBlock basicBlock2 = (SSACFG.BasicBlock)iterator.next();
                        if (this.getHasAlready(basicBlock2) >= n) continue;
                        if (this.isLive(basicBlock2, n2)) {
                            this.placeNewPhiAt(n2, basicBlock2);
                            int n3 = basicBlock2.getGraphNodeId();
                            this.phiCounts[n3] = this.phiCounts[n3] + 1;
                        }
                        this.setHasAlready(basicBlock2, n);
                        if (this.getWork(basicBlock2) >= n) continue;
                        this.setWork(basicBlock2, n);
                        linkedHashSet.add(basicBlock2);
                    }
                }
            }
            ++n2;
        }
    }

    private int getWork(SSACFG.BasicBlock basicBlock) {
        return this.flags[basicBlock.getGraphNodeId() * 2 + 1];
    }

    private void setWork(SSACFG.BasicBlock basicBlock, int n) {
        this.flags[basicBlock.getGraphNodeId() * 2 + 1] = n;
    }

    private int getHasAlready(SSACFG.BasicBlock basicBlock) {
        return this.flags[basicBlock.getGraphNodeId() * 2];
    }

    private void setHasAlready(SSACFG.BasicBlock basicBlock, int n) {
        this.flags[basicBlock.getGraphNodeId() * 2] = n;
    }

    private void renameVariables() {
        int n = 1;
        while (n <= this.getMaxValueNumber()) {
            if (!this.skip(n)) {
                this.C[n] = 0;
                this.S[n] = new IntStack();
            }
            ++n;
        }
        this.initializeVariables();
        this.SEARCH(this.CFG.entry());
    }

    private void SEARCH(SSACFG.BasicBlock basicBlock) {
        Stack<Frame> stack = new Stack<Frame>();
        this.SearchPreRec(basicBlock);
        stack.push(new Frame(basicBlock, this.dominatorTree.getSuccNodes((Object)basicBlock)));
        while (!stack.isEmpty()) {
            Frame frame = (Frame)stack.peek();
            if (frame.i.hasNext()) {
                SSACFG.BasicBlock basicBlock2 = (SSACFG.BasicBlock)frame.i.next();
                this.SearchPreRec(basicBlock2);
                stack.push(new Frame(basicBlock2, this.dominatorTree.getSuccNodes((Object)basicBlock2)));
                continue;
            }
            this.SearchPostRec(frame.X);
            stack.pop();
        }
    }

    private void SearchPreRec(SSACFG.BasicBlock basicBlock) {
        int n;
        int n2;
        int n3;
        SSAPhiInstruction sSAPhiInstruction;
        int n4 = basicBlock.getGraphNodeId();
        int n5 = basicBlock.getFirstInstructionIndex();
        int n6 = 0;
        while (n6 < this.phiCounts[n4]) {
            sSAPhiInstruction = this.getPhi(basicBlock, n6);
            if (!this.skipRepair((SSAInstruction)sSAPhiInstruction, -1)) {
                this.setPhi(basicBlock, n6, this.repairPhiDefs(sSAPhiInstruction, this.makeNewDefs((SSAInstruction)sSAPhiInstruction)));
            }
            ++n6;
        }
        n6 = n5;
        while (n6 <= basicBlock.getLastInstructionIndex()) {
            sSAPhiInstruction = this.instructions[n6];
            if (this.isAssignInstruction((SSAInstruction)sSAPhiInstruction)) {
                n3 = this.getDef((SSAInstruction)sSAPhiInstruction, 0);
                n2 = this.getUse((SSAInstruction)sSAPhiInstruction, 0);
                n = this.skip(n2) ? n2 : this.top(n2);
                this.S[n3].push(n);
                this.pushAssignment((SSAInstruction)sSAPhiInstruction, n6, n);
            } else if (!this.skipRepair((SSAInstruction)sSAPhiInstruction, n6)) {
                int[] nArray = this.makeNewUses((SSAInstruction)sSAPhiInstruction);
                this.repairInstructionUses((SSAInstruction)sSAPhiInstruction, n6, nArray);
                int[] nArray2 = this.makeNewDefs((SSAInstruction)sSAPhiInstruction);
                this.repairInstructionDefs((SSAInstruction)sSAPhiInstruction, n6, nArray2, nArray);
            }
            ++n6;
        }
        if (basicBlock.isExitBlock()) {
            this.repairExit();
        }
        Iterator iterator = this.CFG.getSuccNodes((ISSABasicBlock)basicBlock);
        while (iterator.hasNext()) {
            sSAPhiInstruction = (SSACFG.BasicBlock)iterator.next();
            n3 = sSAPhiInstruction.getGraphNodeId();
            n2 = Util.whichPred(this.CFG, sSAPhiInstruction, basicBlock);
            n = 0;
            while (n < this.phiCounts[n3]) {
                SSAPhiInstruction sSAPhiInstruction2 = this.getPhi((SSACFG.BasicBlock)sSAPhiInstruction, n);
                int n7 = this.getUse((SSAInstruction)sSAPhiInstruction2, n2);
                int n8 = this.skip(n7) ? n7 : this.top(n7);
                this.repairPhiUse((SSACFG.BasicBlock)sSAPhiInstruction, n, n2, n8);
                ++n;
            }
        }
    }

    private void SearchPostRec(SSACFG.BasicBlock basicBlock) {
        int n;
        SSAPhiInstruction sSAPhiInstruction;
        int n2 = basicBlock.getGraphNodeId();
        int n3 = basicBlock.getFirstInstructionIndex();
        int n4 = 0;
        while (n4 < this.phiCounts[n2]) {
            sSAPhiInstruction = this.getPhi(basicBlock, n4);
            n = 0;
            while (n < this.getNumberOfDefs((SSAInstruction)sSAPhiInstruction)) {
                if (!this.skip(this.getDef((SSAInstruction)sSAPhiInstruction, n))) {
                    this.S[this.valueMap[this.getDef((SSAInstruction)sSAPhiInstruction, n)]].pop();
                }
                ++n;
            }
            ++n4;
        }
        n4 = n3;
        while (n4 <= basicBlock.getLastInstructionIndex()) {
            sSAPhiInstruction = this.instructions[n4];
            if (this.isAssignInstruction((SSAInstruction)sSAPhiInstruction)) {
                this.S[this.getDef((SSAInstruction)sSAPhiInstruction, 0)].pop();
                this.popAssignment((SSAInstruction)sSAPhiInstruction, n4);
            } else if (sSAPhiInstruction != null) {
                n = 0;
                while (n < this.getNumberOfDefs((SSAInstruction)sSAPhiInstruction)) {
                    if (!this.skip(this.getDef((SSAInstruction)sSAPhiInstruction, n))) {
                        this.S[this.valueMap[this.getDef((SSAInstruction)sSAPhiInstruction, n)]].pop();
                    }
                    ++n;
                }
            }
            ++n4;
        }
    }

    private int[] makeNewUses(SSAInstruction sSAInstruction) {
        int[] nArray = new int[this.getNumberOfUses(sSAInstruction)];
        int n = 0;
        while (n < this.getNumberOfUses(sSAInstruction)) {
            nArray[n] = this.skip(this.getUse(sSAInstruction, n)) ? this.getUse(sSAInstruction, n) : this.top(this.getUse(sSAInstruction, n));
            ++n;
        }
        return nArray;
    }

    private int[] makeNewDefs(SSAInstruction sSAInstruction) {
        int[] nArray = new int[this.getNumberOfDefs(sSAInstruction)];
        int n = 0;
        while (n < this.getNumberOfDefs(sSAInstruction)) {
            if (this.skip(this.getDef(sSAInstruction, n))) {
                nArray[n] = this.getDef(sSAInstruction, n);
            } else {
                int n2 = this.getNextNewValueNumber();
                if (this.valueMap.length <= n2) {
                    int[] nArray2 = new int[this.valueMap.length * 2 + n2 + 1];
                    System.arraycopy(this.valueMap, 0, nArray2, 0, this.valueMap.length);
                    this.valueMap = nArray2;
                }
                this.valueMap[n2] = this.getDef(sSAInstruction, n);
                this.S[this.getDef(sSAInstruction, n)].push(n2);
                nArray[n] = n2;
            }
            ++n;
        }
        return nArray;
    }

    protected boolean skipRepair(SSAInstruction sSAInstruction, int n) {
        if (sSAInstruction == null) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.getNumberOfDefs(sSAInstruction)) {
            if (!this.skip(this.getDef(sSAInstruction, n2))) {
                return false;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.getNumberOfUses(sSAInstruction)) {
            if (!this.skip(this.getUse(sSAInstruction, n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void fail(int n) {
        assert (this.isConstant(n) || !this.S[n].isEmpty()) : "bad stack for " + n + " while SSA converting";
    }

    protected boolean hasDefaultValue(int n) {
        return this.defaultValues != null && this.defaultValues.getDefaultValue(this.symbolTable, n) != -1;
    }

    protected int getDefaultValue(int n) {
        return this.defaultValues.getDefaultValue(this.symbolTable, n);
    }

    protected int top(int n) {
        if (!this.isConstant(n) && this.S[n].isEmpty()) {
            if (this.hasDefaultValue(n)) {
                return this.getDefaultValue(n);
            }
            this.fail(n);
        }
        try {
            return this.isConstant(n) ? n : this.S[n].peek();
        }
        catch (EmptyStackException emptyStackException) {
            throw new RuntimeException("while looking at " + n, emptyStackException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Frame {
        public final SSACFG.BasicBlock X;
        public final Iterator<ISSABasicBlock> i;

        public Frame(SSACFG.BasicBlock basicBlock, Iterator<ISSABasicBlock> iterator) {
            this.X = basicBlock;
            this.i = iterator;
        }
    }
}

