/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ipa.cha;

import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.ComposedIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossLanguageClassHierarchy
implements IClassHierarchy {
    private final ClassLoaderFactory loaderFactory;
    private final AnalysisScope analysisScope;
    private final Map<Atom, IClassHierarchy> hierarchies;

    public ClassLoaderFactory getFactory() {
        return this.loaderFactory;
    }

    public AnalysisScope getScope() {
        return this.analysisScope;
    }

    private IClassHierarchy getHierarchy(Atom atom) {
        return this.hierarchies.get(atom);
    }

    private IClassHierarchy getHierarchy(IClassLoader iClassLoader) {
        return this.getHierarchy(iClassLoader.getLanguage().getName());
    }

    private IClassHierarchy getHierarchy(ClassLoaderReference classLoaderReference) {
        return this.getHierarchy(classLoaderReference.getLanguage());
    }

    private IClassHierarchy getHierarchy(IClass iClass) {
        return this.getHierarchy(iClass.getClassLoader());
    }

    private IClassHierarchy getHierarchy(TypeReference typeReference) {
        return this.getHierarchy(typeReference.getClassLoader());
    }

    private IClassHierarchy getHierarchy(MethodReference methodReference) {
        return this.getHierarchy(methodReference.getDeclaringClass());
    }

    private IClassHierarchy getHierarchy(FieldReference fieldReference) {
        return this.getHierarchy(fieldReference.getDeclaringClass());
    }

    public IClassLoader[] getLoaders() {
        HashSet hashSet = HashSetFactory.make();
        Iterator iterator = this.analysisScope.getLoaders().iterator();
        while (iterator.hasNext()) {
            hashSet.add(this.getLoader((ClassLoaderReference)iterator.next()));
        }
        return hashSet.toArray(new IClassLoader[hashSet.size()]);
    }

    public IClassLoader getLoader(ClassLoaderReference classLoaderReference) {
        return this.getHierarchy(classLoaderReference).getLoader(classLoaderReference);
    }

    public boolean addClass(IClass iClass) {
        return this.getHierarchy(iClass).addClass(iClass);
    }

    public int getNumberOfClasses() {
        int n = 0;
        Iterator iterator = this.analysisScope.getLoaders().iterator();
        while (iterator.hasNext()) {
            n += this.getLoader((ClassLoaderReference)iterator.next()).getNumberOfClasses();
        }
        return n;
    }

    public boolean isRootClass(IClass iClass) {
        return this.getHierarchy(iClass).isRootClass(iClass);
    }

    public IClass getRootClass() {
        Assertions.UNREACHABLE();
        return null;
    }

    public int getNumber(IClass iClass) {
        return this.getHierarchy(iClass).getNumber(iClass);
    }

    public Collection<IMethod> getPossibleTargets(MethodReference methodReference) {
        return this.getHierarchy(methodReference).getPossibleTargets(methodReference);
    }

    public Set<IMethod> getPossibleTargets(IClass iClass, MethodReference methodReference) {
        return this.getHierarchy(methodReference).getPossibleTargets(iClass, methodReference);
    }

    public IMethod resolveMethod(MethodReference methodReference) {
        return this.getHierarchy(methodReference).resolveMethod(methodReference);
    }

    public IField resolveField(FieldReference fieldReference) {
        return this.getHierarchy(fieldReference).resolveField(fieldReference);
    }

    public IField resolveField(IClass iClass, FieldReference fieldReference) {
        return this.getHierarchy(iClass).resolveField(iClass, fieldReference);
    }

    public IMethod resolveMethod(IClass iClass, Selector selector) {
        return this.getHierarchy(iClass).resolveMethod(iClass, selector);
    }

    public IClass lookupClass(TypeReference typeReference) {
        return this.getHierarchy(typeReference).lookupClass(typeReference);
    }

    public boolean isInterface(TypeReference typeReference) {
        return this.getHierarchy(typeReference).isInterface(typeReference);
    }

    public IClass getLeastCommonSuperclass(IClass iClass, IClass iClass2) {
        return this.getHierarchy(iClass).getLeastCommonSuperclass(iClass, iClass2);
    }

    public TypeReference getLeastCommonSuperclass(TypeReference typeReference, TypeReference typeReference2) {
        return this.getHierarchy(typeReference).getLeastCommonSuperclass(typeReference, typeReference2);
    }

    public boolean isSubclassOf(IClass iClass, IClass iClass2) {
        return this.getHierarchy(iClass).isSubclassOf(iClass, iClass2);
    }

    public boolean implementsInterface(IClass iClass, IClass iClass2) {
        return this.getHierarchy(iClass).implementsInterface(iClass, iClass2);
    }

    public Collection<IClass> computeSubClasses(TypeReference typeReference) {
        return this.getHierarchy(typeReference).computeSubClasses(typeReference);
    }

    public Collection<TypeReference> getJavaLangRuntimeExceptionTypes() {
        return this.getHierarchy(TypeReference.JavaLangRuntimeException).getJavaLangErrorTypes();
    }

    public Collection<TypeReference> getJavaLangErrorTypes() {
        return this.getHierarchy(TypeReference.JavaLangError).getJavaLangErrorTypes();
    }

    public Set<IClass> getImplementors(TypeReference typeReference) {
        return this.getHierarchy(typeReference).getImplementors(typeReference);
    }

    public int getNumberOfImmediateSubclasses(IClass iClass) {
        return this.getHierarchy(iClass).getNumberOfImmediateSubclasses(iClass);
    }

    public Collection<IClass> getImmediateSubclasses(IClass iClass) {
        return this.getHierarchy(iClass).getImmediateSubclasses(iClass);
    }

    public boolean isAssignableFrom(IClass iClass, IClass iClass2) {
        return this.getHierarchy(iClass).isAssignableFrom(iClass, iClass2);
    }

    public Iterator<IClass> iterator() {
        return new ComposedIterator<ClassLoaderReference, IClass>(this.analysisScope.getLoaders().iterator()){

            public Iterator<IClass> makeInner(ClassLoaderReference classLoaderReference) {
                IClassLoader iClassLoader = CrossLanguageClassHierarchy.this.getLoader(classLoaderReference);
                return iClassLoader.iterateAllClasses();
            }
        };
    }

    private CrossLanguageClassHierarchy(AnalysisScope analysisScope, ClassLoaderFactory classLoaderFactory, Map<Atom, IClassHierarchy> map) {
        this.analysisScope = analysisScope;
        this.loaderFactory = classLoaderFactory;
        this.hierarchies = map;
    }

    public static CrossLanguageClassHierarchy make(AnalysisScope analysisScope, ClassLoaderFactory classLoaderFactory) throws ClassHierarchyException {
        Set set = analysisScope.getBaseLanguages();
        HashMap hashMap = HashMapFactory.make();
        for (Language language : set) {
            HashSet hashSet = HashSetFactory.make((Collection)language.getDerivedLanguages());
            hashSet.add(language);
            hashMap.put(language.getName(), ClassHierarchy.make((AnalysisScope)analysisScope, (ClassLoaderFactory)classLoaderFactory, (Set)hashSet));
        }
        return new CrossLanguageClassHierarchy(analysisScope, classLoaderFactory, hashMap);
    }
}

