/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ipa.callgraph;

import com.ibm.wala.cast.ipa.callgraph.AstCallGraph;
import com.ibm.wala.cast.ir.ssa.AstLexicalRead;
import com.ibm.wala.cast.util.TargetLanguageSelector;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.FakeRootMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossLanguageCallGraph
extends AstCallGraph {
    private final TargetLanguageSelector<AbstractRootMethod, CrossLanguageCallGraph> roots;
    private final Set<CGNode> languageRootNodes = HashSetFactory.make();
    private final Map<Atom, IMethod> languageRoots = HashMapFactory.make();

    public CrossLanguageCallGraph(TargetLanguageSelector<AbstractRootMethod, CrossLanguageCallGraph> targetLanguageSelector, IClassHierarchy iClassHierarchy, AnalysisOptions analysisOptions, AnalysisCache analysisCache) {
        super(iClassHierarchy, analysisOptions, analysisCache);
        this.roots = targetLanguageSelector;
    }

    public AbstractRootMethod getLanguageRoot(Atom atom) {
        if (!this.languageRoots.containsKey(atom)) {
            AbstractRootMethod abstractRootMethod = this.roots.get(atom, this);
            CGNode cGNode = null;
            try {
                cGNode = this.findOrCreateNode((IMethod)abstractRootMethod, (Context)Everywhere.EVERYWHERE);
            }
            catch (CancelException cancelException) {
                cancelException.printStackTrace();
                Assertions.UNREACHABLE();
            }
            this.languageRootNodes.add(cGNode);
            CallSiteReference callSiteReference = CallSiteReference.make((int)1, (MethodReference)abstractRootMethod.getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC);
            CGNode cGNode2 = this.getFakeRootNode();
            CrossLanguageFakeRoot crossLanguageFakeRoot = (CrossLanguageFakeRoot)cGNode2.getMethod();
            callSiteReference = crossLanguageFakeRoot.addInvocationInternal(new int[0], callSiteReference).getCallSite();
            cGNode2.addTarget(callSiteReference, cGNode);
            this.languageRoots.put(atom, (IMethod)abstractRootMethod);
        }
        return (AbstractRootMethod)this.languageRoots.get(atom);
    }

    Iterator getLanguageRoots() {
        return this.languageRootNodes.iterator();
    }

    @Override
    protected CGNode makeFakeRootNode() throws CancelException {
        return this.findOrCreateNode((IMethod)new CrossLanguageFakeRoot(this.cha, this.options, this.getAnalysisCache()), (Context)Everywhere.EVERYWHERE);
    }

    public class CrossLanguageFakeRoot
    extends AstCallGraph.ScriptFakeRoot {
        public CrossLanguageFakeRoot(IClass iClass, IClassHierarchy iClassHierarchy, AnalysisOptions analysisOptions, AnalysisCache analysisCache) {
            super(FakeRootMethod.rootMethod, iClass, iClassHierarchy, analysisOptions, analysisCache);
        }

        public CrossLanguageFakeRoot(IClassHierarchy iClassHierarchy, AnalysisOptions analysisOptions, AnalysisCache analysisCache) {
            super(FakeRootMethod.rootMethod, iClassHierarchy, analysisOptions, analysisCache);
        }

        public int addPhi(TypeReference typeReference, int[] nArray) {
            Atom atom = typeReference.getClassLoader().getLanguage();
            AbstractRootMethod abstractRootMethod = CrossLanguageCallGraph.this.getLanguageRoot(atom);
            return abstractRootMethod.addPhi(nArray);
        }

        public int addGetInstance(FieldReference fieldReference, int n) {
            TypeReference typeReference = fieldReference.getDeclaringClass();
            Atom atom = typeReference.getClassLoader().getLanguage();
            AbstractRootMethod abstractRootMethod = CrossLanguageCallGraph.this.getLanguageRoot(atom);
            return abstractRootMethod.addGetInstance(fieldReference, n);
        }

        public int addGetStatic(FieldReference fieldReference) {
            TypeReference typeReference = fieldReference.getDeclaringClass();
            Atom atom = typeReference.getClassLoader().getLanguage();
            AbstractRootMethod abstractRootMethod = CrossLanguageCallGraph.this.getLanguageRoot(atom);
            return abstractRootMethod.addGetStatic(fieldReference);
        }

        public int addCheckcast(TypeReference[] typeReferenceArray, int n) {
            Atom atom = typeReferenceArray[0].getClassLoader().getLanguage();
            AbstractRootMethod abstractRootMethod = CrossLanguageCallGraph.this.getLanguageRoot(atom);
            return abstractRootMethod.addCheckcast(typeReferenceArray, n);
        }

        public SSANewInstruction addAllocation(TypeReference typeReference) {
            Atom atom = typeReference.getClassLoader().getLanguage();
            AbstractRootMethod abstractRootMethod = CrossLanguageCallGraph.this.getLanguageRoot(atom);
            return abstractRootMethod.addAllocation(typeReference);
        }

        public SSAInvokeInstruction addInvocation(int[] nArray, CallSiteReference callSiteReference) {
            TypeReference typeReference = callSiteReference.getDeclaredTarget().getDeclaringClass();
            Atom atom = typeReference.getClassLoader().getLanguage();
            AbstractRootMethod abstractRootMethod = CrossLanguageCallGraph.this.getLanguageRoot(atom);
            return abstractRootMethod.addInvocation(nArray, callSiteReference);
        }

        public SSAInvokeInstruction addInvocationInternal(int[] nArray, CallSiteReference callSiteReference) {
            return super.addInvocation(nArray, callSiteReference);
        }

        public AstLexicalRead addGlobalRead(TypeReference typeReference, String string) {
            Atom atom = typeReference.getClassLoader().getLanguage();
            AbstractRootMethod abstractRootMethod = CrossLanguageCallGraph.this.getLanguageRoot(atom);
            return ((AstCallGraph.AstFakeRoot)abstractRootMethod).addGlobalRead(typeReference, string);
        }

        public SSAAbstractInvokeInstruction addDirectCall(int n, int[] nArray, CallSiteReference callSiteReference) {
            TypeReference typeReference = callSiteReference.getDeclaredTarget().getDeclaringClass();
            Atom atom = typeReference.getClassLoader().getLanguage();
            AbstractRootMethod abstractRootMethod = CrossLanguageCallGraph.this.getLanguageRoot(atom);
            return ((AstCallGraph.ScriptFakeRoot)abstractRootMethod).addDirectCall(n, nArray, callSiteReference);
        }
    }
}

