/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.ws.jaxme.sqls.BinaryColumn;
import org.apache.ws.jaxme.sqls.BooleanConstraint;
import org.apache.ws.jaxme.sqls.Case;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.ColumnReference;
import org.apache.ws.jaxme.sqls.CombinedConstraint;
import org.apache.ws.jaxme.sqls.ConstrainedStatement;
import org.apache.ws.jaxme.sqls.Constraint;
import org.apache.ws.jaxme.sqls.DeleteStatement;
import org.apache.ws.jaxme.sqls.Expression;
import org.apache.ws.jaxme.sqls.ForeignKey;
import org.apache.ws.jaxme.sqls.Function;
import org.apache.ws.jaxme.sqls.Index;
import org.apache.ws.jaxme.sqls.InsertStatement;
import org.apache.ws.jaxme.sqls.JoinReference;
import org.apache.ws.jaxme.sqls.RawSQLCode;
import org.apache.ws.jaxme.sqls.SQLGenerator;
import org.apache.ws.jaxme.sqls.Schema;
import org.apache.ws.jaxme.sqls.SelectStatement;
import org.apache.ws.jaxme.sqls.SelectTableReference;
import org.apache.ws.jaxme.sqls.SetStatement;
import org.apache.ws.jaxme.sqls.Statement;
import org.apache.ws.jaxme.sqls.StringColumn;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.TableReference;
import org.apache.ws.jaxme.sqls.UpdateStatement;
import org.apache.ws.jaxme.sqls.Value;
import org.apache.ws.jaxme.sqls.impl.StatementMetaData;
import org.apache.ws.jaxme.sqls.impl.ViewImpl;
import org.apache.ws.jaxme.sqls.impl.VirtualColumn;

public class SQLGeneratorImpl
implements SQLGenerator {
    private String statementTerminator;
    private String lineTerminator;

    public String getStatementTerminator() {
        return this.statementTerminator;
    }

    public void setStatementTerminator(String pStatementTerminator) {
        this.statementTerminator = pStatementTerminator;
    }

    public String getLineTerminator() {
        return this.lineTerminator;
    }

    public void setLineTerminator(String pLineTerminator) {
        this.lineTerminator = pLineTerminator;
    }

    protected String newStatement(String pStatement) {
        String s = this.getStatementTerminator();
        return s == null ? pStatement : pStatement + s;
    }

    public Collection getCreate(Schema pSchema) {
        if (pSchema.getName() == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.newStatement("CREATE SCHEMA " + pSchema.getName()));
        return result;
    }

    public Collection getDrop(Schema pSchema) {
        if (pSchema.getName() == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.newStatement("DROP SCHEMA " + pSchema.getName()));
        return result;
    }

    protected String getIndent() {
        return "  ";
    }

    protected String getTypeName(Column.Type pType) {
        if (pType.equals(Column.Type.BIGINT)) {
            return "BIGINT";
        }
        if (pType.equals(Column.Type.BINARY)) {
            return "BINARY";
        }
        if (pType.equals(Column.Type.BIT)) {
            return "BIT";
        }
        if (pType.equals(Column.Type.CHAR)) {
            return "CHAR";
        }
        if (pType.equals(Column.Type.DATE)) {
            return "DATE";
        }
        if (pType.equals(Column.Type.DOUBLE)) {
            return "DOUBLE";
        }
        if (pType.equals(Column.Type.FLOAT)) {
            return "FLOAT";
        }
        if (pType.equals(Column.Type.INTEGER)) {
            return "INT";
        }
        if (pType.equals(Column.Type.SMALLINT)) {
            return "SMALLINT";
        }
        if (pType.equals(Column.Type.TIME)) {
            return "TIME";
        }
        if (pType.equals(Column.Type.TIMESTAMP)) {
            return "TIMESTAMP";
        }
        if (pType.equals(Column.Type.TINYINT)) {
            return "TINYINT";
        }
        if (pType.equals(Column.Type.VARBINARY)) {
            return "VARBINARY";
        }
        if (pType.equals(Column.Type.VARCHAR)) {
            return "VARCHAR";
        }
        if (pType.equals(Column.Type.CLOB)) {
            return "CLOB";
        }
        if (pType.equals(Column.Type.BLOB)) {
            return "BLOB";
        }
        if (pType.equals(Column.Type.OTHER)) {
            return "BLOB";
        }
        throw new IllegalStateException("Unknown column type: " + pType);
    }

    protected String getCreate(Column pColumn) {
        StringBuffer sb = new StringBuffer();
        sb.append(pColumn.getName()).append(" ");
        Column.Type type = pColumn.getType();
        Long length = null;
        if (type.equals(Column.Type.BINARY) || type.equals(Column.Type.VARBINARY) || type.equals(Column.Type.BLOB) || type.equals(Column.Type.OTHER) ? (length = ((BinaryColumn)pColumn).getLength()) == null : (type.equals(Column.Type.CHAR) || type.equals(Column.Type.VARCHAR) || type.equals(Column.Type.CLOB)) && (length = ((StringColumn)pColumn).getLength()) == null) {
            throw new IllegalStateException("The length of column " + pColumn.getQName() + " is not set.");
        }
        sb.append(this.getTypeName(type));
        if (length != null) {
            sb.append("(").append(length).append(")");
        }
        if (!pColumn.isNullable()) {
            sb.append(" NOT NULL");
        }
        return sb.toString();
    }

    protected boolean isPrimaryKeyUniqueIndex() {
        return false;
    }

    protected boolean isPrimaryKeyPartOfCreateTable() {
        return false;
    }

    protected boolean isUniqueIndexPartOfCreateTable() {
        return false;
    }

    protected boolean isNonUniqueIndexPartOfCreateTable() {
        return false;
    }

    protected boolean isForeignKeyPartOfCreateTable() {
        return false;
    }

    protected String createPrimaryKeyAsPartOfCreateTable(Table pTable) {
        Index index = pTable.getPrimaryKey();
        if (index == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("PRIMARY KEY").append(" (");
        boolean first = true;
        Iterator iter = index.getColumns();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(((Column)iter.next()).getName().getName());
        }
        sb.append(")");
        return sb.toString();
    }

    protected String createIndexAsPartOfCreateTable(Index pIndex) {
        StringBuffer sb = new StringBuffer();
        sb.append(pIndex.isUnique() ? "UNIQUE" : "KEY").append(" (");
        boolean first = true;
        Iterator iter = pIndex.getColumns();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(((Column)iter.next()).getName().getName());
        }
        sb.append(")");
        return sb.toString();
    }

    protected String createForeignKeyAsPartOfCreateTable(ForeignKey pKey) {
        ForeignKey.Mode updateMode;
        ForeignKey.ColumnLink link;
        StringBuffer sb = new StringBuffer();
        sb.append("FOREIGN KEY (");
        boolean first = true;
        Iterator iter = pKey.getColumnLinks();
        if (!iter.hasNext()) {
            throw new IllegalStateException("Foreign key on " + pKey.getTable().getQName() + " referencing " + pKey.getReferencedTable().getQName() + " doesn't have any columns.");
        }
        while (iter.hasNext()) {
            link = (ForeignKey.ColumnLink)iter.next();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(link.getLocalColumn().getName().getName());
        }
        sb.append(") REFERENCES ");
        sb.append(pKey.getReferencedTable().getQName());
        sb.append(" (");
        first = true;
        iter = pKey.getColumnLinks();
        while (iter.hasNext()) {
            link = (ForeignKey.ColumnLink)iter.next();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(link.getReferencedColumn().getName().getName());
        }
        sb.append(")");
        ForeignKey.Mode deleteMode = pKey.getOnDelete();
        if (deleteMode != null) {
            if (ForeignKey.Mode.CASCADE.equals(deleteMode)) {
                sb.append(" ON DELETE CASCADE");
            } else if (ForeignKey.Mode.REJECT.equals(deleteMode)) {
                sb.append(" ON DELETE RESTRICT");
            } else if (ForeignKey.Mode.SETNULL.equals(deleteMode)) {
                sb.append(" ON DELETE SET NULL");
            } else {
                throw new IllegalStateException("Unknown foreign key mode for ON  DELETE: " + deleteMode);
            }
        }
        if ((updateMode = pKey.getOnUpdate()) != null) {
            if (ForeignKey.Mode.CASCADE.equals(updateMode)) {
                sb.append(" ON UPDATE CASCADE");
            } else if (ForeignKey.Mode.REJECT.equals(updateMode)) {
                sb.append(" ON UPDATE RESTRICT");
            } else {
                throw new IllegalStateException("Unknown foreign key mode for ON UPDATE: " + updateMode);
            }
        }
        return sb.toString();
    }

    protected String getCreateTableHeader(Table pTable) {
        return "CREATE TABLE " + pTable.getQName();
    }

    public Collection getCreate(Table pTable) {
        String st;
        String lf = this.getLineTerminator() == null ? "" : this.getLineTerminator();
        String indent = lf == null ? "" : this.getIndent();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getCreateTableHeader(pTable)).append(" (");
        String s = lf + indent;
        Iterator iter = pTable.getColumns();
        while (iter.hasNext()) {
            sb.append(s).append(this.getCreate((Column)iter.next()));
            s = "," + lf + indent;
        }
        iter = pTable.getIndexes();
        while (iter.hasNext()) {
            Index index = (Index)iter.next();
            if (index.isPrimaryKey() && !this.isPrimaryKeyUniqueIndex()) {
                if (!this.isPrimaryKeyPartOfCreateTable()) continue;
                st = this.createPrimaryKeyAsPartOfCreateTable(pTable);
            } else if (index.isUnique()) {
                if (!this.isUniqueIndexPartOfCreateTable()) continue;
                st = this.createIndexAsPartOfCreateTable(index);
            } else {
                if (!this.isNonUniqueIndexPartOfCreateTable()) continue;
                st = this.createIndexAsPartOfCreateTable(index);
            }
            if (st == null) continue;
            sb.append(s).append(st);
        }
        if (this.isForeignKeyPartOfCreateTable()) {
            iter = pTable.getForeignKeys();
            while (iter.hasNext()) {
                ForeignKey key = (ForeignKey)iter.next();
                st = this.createForeignKeyAsPartOfCreateTable(key);
                if (st == null) continue;
                sb.append(s).append(st);
            }
        }
        sb.append(lf).append(")").append(lf);
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.newStatement(sb.toString()));
        return result;
    }

    public Collection getDrop(Table pTable) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.newStatement("DROP TABLE " + pTable.getQName()));
        return result;
    }

    private ColumnReference[] getSetStatementsColumns(SetStatement pStatement) {
        ArrayList<ColumnReference> result = new ArrayList<ColumnReference>();
        Iterator iter = pStatement.getSetValues();
        while (iter.hasNext()) {
            SetStatement.SetValue setValue = (SetStatement.SetValue)iter.next();
            result.add(setValue.getColumnReference());
        }
        return result.toArray(new ColumnReference[result.size()]);
    }

    private ColumnReference[] getInsertStatementsColumns(InsertStatement pStatement) {
        SelectStatement subSelect = pStatement.getSubSelect();
        if (subSelect == null) {
            return this.getSetStatementsColumns(pStatement);
        }
        ArrayList<ColumnReference> result = new ArrayList<ColumnReference>();
        Iterator iter = subSelect.getResultColumns();
        while (iter.hasNext()) {
            ColumnReference cRef = (ColumnReference)iter.next();
            Column.Name name = cRef.getAlias() == null ? cRef.getColumn().getName() : cRef.getAlias();
            Column col = pStatement.getTableReference().getTable().getColumn(name);
            if (col == null) {
                throw new IllegalStateException("A result column " + name + " is used in the subselect, which is not present in the insert statements table.");
            }
            result.add(pStatement.getTableReference().newColumnReference(col));
        }
        return result.toArray(new ColumnReference[result.size()]);
    }

    private void addSetValuesToInsertStatement(StringBuffer pBuffer, StatementMetaData pData, InsertStatement pQuery) {
        pBuffer.append(" VALUES (");
        boolean first = true;
        Iterator iter = pQuery.getSetValues();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                pBuffer.append(", ");
            }
            SetStatement.SetValue setValue = (SetStatement.SetValue)iter.next();
            Object o = setValue.getValue();
            String s = this.getBooleanConstraintPart(pData, o);
            pBuffer.append(s);
        }
        pBuffer.append(")");
    }

    private void addSubSelectToInsertStatement(StringBuffer pBuffer, StatementMetaData pData, InsertStatement pStatement) {
        pBuffer.append(" (");
        pBuffer.append(this.getSelectQuery(pStatement.getSubSelect(), pData));
        pBuffer.append(")");
    }

    public String getInsertQuery(InsertStatement pQuery) {
        boolean hasSubselect;
        ColumnReference[] columns = this.getInsertStatementsColumns(pQuery);
        StatementMetaData smd = this.newStatementMetaData(pQuery, columns);
        StringBuffer result = new StringBuffer();
        result.append("INSERT INTO ");
        result.append(this.getTableAlias(smd, pQuery.getTableReference()));
        if (columns.length > 0) {
            result.append(" (");
            for (int i = 0; i < columns.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.getColumnAlias(smd, columns[i]));
            }
            result.append(")");
        }
        boolean hasSetValues = pQuery.getSetValues().hasNext();
        boolean bl = hasSubselect = pQuery.getSubSelect() != null;
        if (hasSetValues) {
            if (hasSubselect) {
                throw new IllegalStateException("Using values (InsertStatement.addFoo(..)) and subselects (InsertStatement.setSubSelect(...)) is mutually exclusive.");
            }
            this.addSetValuesToInsertStatement(result, smd, pQuery);
        } else if (hasSubselect) {
            this.addSubSelectToInsertStatement(result, smd, pQuery);
        } else {
            throw new IllegalStateException("Neither values (InsertStatement.addFoo(..)) nor a subselect (InsertStatement.setSubSelect(...)) are set.");
        }
        return this.newStatement(result.toString());
    }

    protected String getValue(Value pValue) {
        Value.Type type = pValue.getType();
        Object o = pValue.getValue();
        if (Value.Type.BOOLEAN.equals(type)) {
            return o == null ? "null" : ((Boolean)o != false ? "TRUE" : "FALSE");
        }
        if (Value.Type.BYTE.equals(type) || Value.Type.SHORT.equals(type) || Value.Type.INT.equals(type) || Value.Type.LONG.equals(type) || Value.Type.FLOAT.equals(type) || Value.Type.DOUBLE.equals(type)) {
            return o == null ? "null" : o.toString();
        }
        if (Value.Type.DATE.equals(type) || Value.Type.DATETIME.equals(type) || Value.Type.TIME.equals(type)) {
            throw new IllegalStateException("Date/time handling not yet implemented.");
        }
        if (Value.Type.DATE.equals(type)) {
            throw new IllegalStateException("Date handling not yet implemented.");
        }
        if (Value.Type.PLACEHOLDER.equals(type)) {
            return "?";
        }
        if (Value.Type.STRING.equals(type)) {
            return o == null ? "null" : this.getEscapedString(o.toString());
        }
        if (Value.Type.NULL.equals(type)) {
            return "null";
        }
        throw new IllegalStateException("Unknown value type: " + type);
    }

    protected String getUpdateQuery(UpdateStatement pQuery) {
        ColumnReference[] columns = this.getSetStatementsColumns(pQuery);
        StatementMetaData smd = this.newStatementMetaData(pQuery, columns);
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ");
        sb.append(this.getTableAlias(smd, pQuery.getTableReference()));
        sb.append(" SET ");
        boolean first = true;
        Iterator iter = pQuery.getSetValues();
        while (iter.hasNext()) {
            SetStatement.SetValue setValue = (SetStatement.SetValue)iter.next();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.getColumnAlias(smd, setValue.getColumnReference()));
            sb.append("=");
            sb.append(this.getBooleanConstraintPart(smd, setValue.getValue()));
        }
        String s = this.getWhereClause(smd, pQuery.getWhere());
        if (s != null) {
            sb.append(" WHERE ").append(s);
        }
        return this.newStatement(sb.toString());
    }

    protected String getDeleteQuery(DeleteStatement pQuery) {
        StatementMetaData smd = this.newStatementMetaData(pQuery);
        StringBuffer result = new StringBuffer("DELETE FROM ");
        result.append(this.getTableAlias(smd, pQuery.getTableReference()));
        String s = this.getWhereClause(smd, pQuery.getWhere());
        if (s != null) {
            result.append(" WHERE ");
            result.append(s);
        }
        return result.toString();
    }

    protected boolean isQualifiedColumn(StatementMetaData pData, ColumnReference pColumn) {
        if (pData == null) {
            return false;
        }
        Integer num = (Integer)pData.getColumnNames().get(pColumn.getColumn().getName().toString().toUpperCase());
        if (num == null) {
            throw new IllegalStateException("Column not in map of column counts: " + pColumn.getColumn().getName());
        }
        return num > 1;
    }

    protected String getFunction(StatementMetaData pData, Function f) {
        return f.getName() + '(' + this.getParts(pData, f.getParts()) + ')';
    }

    protected String getColumnAlias(StatementMetaData pData, ColumnReference pColumn) {
        Column col = pColumn.getColumn();
        String s = col.getName().toString();
        if (col.isVirtual()) {
            VirtualColumn virtCol = (VirtualColumn)col;
            Object o = virtCol.getValue();
            if (o instanceof SelectStatement) {
                return "(" + this.getSelectQuery((SelectStatement)o, pData) + ") AS " + s;
            }
            if (o instanceof Function) {
                return this.getFunction(pData, (Function)o) + " AS " + s;
            }
            if (o instanceof String) {
                return (String)o + " AS " + s;
            }
            throw new IllegalStateException("Invalid type of VirtualColumn: " + o);
        }
        if (this.isQualifiedColumn(pData, pColumn)) {
            TableReference tableReference = pColumn.getTableReference();
            s = tableReference.getAlias() != null ? tableReference.getAlias().getName() + "." + s : tableReference.getTable().getName() + "." + s;
        }
        if (pColumn.getAlias() != null) {
            s = s + " AS " + pColumn.getAlias().getName();
        }
        return s;
    }

    protected String getColumnAlias(StatementMetaData pData, ColumnReference[] pColumn) {
        StringBuffer sb = new StringBuffer("(");
        for (int i = 0; i < pColumn.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getColumnAlias(pData, pColumn[i]));
        }
        sb.append(")");
        return sb.toString();
    }

    protected boolean isTableAliasUsingAs() {
        return true;
    }

    protected String getTableAlias(StatementMetaData pData, TableReference pTable) {
        String tableName;
        Table t = pTable.getTable();
        Table.Name alias = pTable.getAlias();
        if (t instanceof ViewImpl) {
            ViewImpl v = (ViewImpl)t;
            tableName = "(" + this.getSelectQuery(v.getViewStatement(), pData) + ")";
        } else {
            tableName = pTable.getTable().getQName();
        }
        if (alias == null) {
            return tableName;
        }
        if (this.isTableAliasUsingAs()) {
            return tableName + " AS " + alias.getName();
        }
        return tableName + " " + alias.getName();
    }

    protected String getJoinAlias(StatementMetaData pData, JoinReference pJoinReference) {
        StringBuffer result = new StringBuffer();
        if (pJoinReference.isLeftOuterJoin()) {
            result.append(" LEFT OUTER JOIN ");
        } else if (pJoinReference.isJoin()) {
            result.append(" JOIN ");
        } else {
            throw new IllegalStateException("Unknown join type");
        }
        result.append(this.getTableAlias(pData, pJoinReference));
        String s = this.getWhereClause(pData, pJoinReference.getOn());
        if (s != null) {
            result.append(" ON ");
            result.append(s);
        }
        return result.toString();
    }

    protected String getEscapedString(String s) {
        if (s.indexOf(10) > -1 || s.indexOf(13) > -1 || s.indexOf(12) > -1) {
            throw new IllegalArgumentException("Don't know how to handle line or page terminators.");
        }
        if (s.indexOf(39) > -1) {
            throw new IllegalArgumentException("Don't know how to handle the char ' in strings.");
        }
        return "'" + s + "'";
    }

    protected String getParts(StatementMetaData pData, Iterator pParts) {
        StringBuffer sb = new StringBuffer();
        while (pParts.hasNext()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.getBooleanConstraintPart(pData, pParts.next()));
        }
        return sb.toString();
    }

    protected String getCase(StatementMetaData pData, Case pCase) {
        StringBuffer sb = new StringBuffer("CASE ");
        sb.append(this.getBooleanConstraintPart(pData, pCase.getCheckedValue()));
        Case.When[] whens = pCase.getWhens();
        for (int i = 0; i < whens.length; ++i) {
            Case.When when = whens[i];
            sb.append(" WHEN ");
            sb.append(this.getBooleanConstraintPart(pData, when.getCondition()));
            sb.append(" THEN ");
            sb.append(this.getBooleanConstraintPart(pData, when.getValue()));
        }
        Object o = pCase.getElseValue();
        if (o != null) {
            sb.append(" ELSE ");
            sb.append(this.getBooleanConstraintPart(pData, o));
        }
        sb.append(" END");
        return sb.toString();
    }

    protected String getBooleanConstraintPart(StatementMetaData pData, Object o) {
        if (o instanceof Value) {
            return this.getValue((Value)o);
        }
        if (o instanceof ColumnReference) {
            return this.getColumnAlias(pData, (ColumnReference)o);
        }
        if (o instanceof ColumnReference[]) {
            return this.getColumnAlias(pData, (ColumnReference[])o);
        }
        if (o instanceof SelectStatement) {
            return '(' + this.getSelectQuery((SelectStatement)o, pData) + ')';
        }
        if (o instanceof RawSQLCode) {
            return ((RawSQLCode)o).getRawSQL();
        }
        if (o instanceof Function) {
            return this.getFunction(pData, (Function)o);
        }
        if (o instanceof Case) {
            return this.getCase(pData, (Case)o);
        }
        if (o instanceof Expression) {
            return this.getExpression(pData, (Expression)o);
        }
        throw new IllegalArgumentException("Invalid part of a boolean constraint: " + o.getClass().getName());
    }

    protected String getExpression(StatementMetaData pData, Expression pExpr) {
        String sep;
        int minParts;
        int parts = pExpr.getNumParts();
        if (parts < (minParts = pExpr.getMinimumParts())) {
            throw new IllegalStateException("An expression of type " + pExpr.getType() + " must have at least " + minParts + " parts.");
        }
        int maxParts = pExpr.getMaximumParts();
        if (maxParts > 0 && parts > maxParts) {
            throw new IllegalStateException("An expression of type " + pExpr.getType() + " must have at least " + maxParts + " parts.");
        }
        Iterator iter = pExpr.getParts();
        if (parts == 1) {
            return this.getBooleanConstraintPart(pData, iter.next());
        }
        Expression.Type type = pExpr.getType();
        if (Expression.SUM.equals(type)) {
            sep = "+";
        } else if (Expression.PRODUCT.equals(type)) {
            sep = "*";
        } else if (Expression.DIFFERENCE.equals(type)) {
            sep = "-";
        } else if (Expression.QUOTIENT.equals(type)) {
            sep = "/";
        } else {
            throw new IllegalStateException("Invalid type: " + type);
        }
        StringBuffer result = new StringBuffer("(");
        for (int i = 0; i < parts; ++i) {
            if (i > 0) {
                result.append(sep);
            }
            result.append(this.getBooleanConstraintPart(pData, iter.next()));
        }
        result.append(")");
        return result.toString();
    }

    protected String getBooleanConstraintType(BooleanConstraint.Type pType) {
        if (BooleanConstraint.Type.EQ.equals(pType)) {
            return "=";
        }
        if (BooleanConstraint.Type.NE.equals(pType)) {
            return "<>";
        }
        if (BooleanConstraint.Type.GT.equals(pType)) {
            return ">";
        }
        if (BooleanConstraint.Type.LT.equals(pType)) {
            return "<";
        }
        if (BooleanConstraint.Type.GE.equals(pType)) {
            return ">=";
        }
        if (BooleanConstraint.Type.LE.equals(pType)) {
            return "<=";
        }
        if (BooleanConstraint.Type.LIKE.equals(pType)) {
            return " LIKE ";
        }
        throw new IllegalArgumentException("Invalid type: " + pType);
    }

    protected String getBooleanConstraint(StatementMetaData pData, BooleanConstraint pConstraint) {
        int expected;
        BooleanConstraint.Type type = pConstraint.getType();
        Iterator parts = pConstraint.getParts();
        if (!parts.hasNext()) {
            throw new NullPointerException("A boolean constraint must have its parts set.");
        }
        if (BooleanConstraint.Type.IN.equals(type)) {
            Object o = parts.next();
            return this.getBooleanConstraintPart(pData, o) + " IN (" + this.getParts(pData, parts) + ')';
        }
        StringBuffer result = new StringBuffer();
        if (BooleanConstraint.Type.EXISTS.equals(type)) {
            SelectStatement selectStatement = (SelectStatement)parts.next();
            result.append("EXISTS(");
            result.append(this.getSelectQuery(selectStatement, pData));
            result.append(")");
            expected = 1;
        } else if (BooleanConstraint.Type.BETWEEN.equals(type)) {
            expected = 3;
            if (pConstraint.getNumParts() >= 3) {
                result.append(this.getBooleanConstraintPart(pData, parts.next()));
                result.append(" BETWEEN ");
                result.append(this.getBooleanConstraintPart(pData, parts.next()));
                result.append(" AND ");
                result.append(this.getBooleanConstraintPart(pData, parts.next()));
            }
        } else {
            result.append(this.getBooleanConstraintPart(pData, parts.next()));
            if (BooleanConstraint.Type.EQ.equals(type) || BooleanConstraint.Type.NE.equals(type) || BooleanConstraint.Type.GT.equals(type) || BooleanConstraint.Type.LT.equals(type) || BooleanConstraint.Type.GE.equals(type) || BooleanConstraint.Type.LE.equals(type) || BooleanConstraint.Type.LIKE.equals(type)) {
                expected = 2;
                if (!parts.hasNext()) {
                    throw new NullPointerException("The boolean constraint " + type + " must have exactly two parts set.");
                }
                result.append(this.getBooleanConstraintType(type));
                result.append(this.getBooleanConstraintPart(pData, parts.next()));
            } else if (BooleanConstraint.Type.ISNULL.equals(type)) {
                expected = 1;
                result.append(" IS NULL");
            } else {
                throw new IllegalArgumentException("Invalid boolean constraint type: " + type);
            }
        }
        if (expected != 0 && parts.hasNext()) {
            throw new NullPointerException("The boolean constraint " + type + " must have exactly " + expected + " parts set, but has " + pConstraint.getNumParts());
        }
        return result.toString();
    }

    protected String getCombinedConstraint(StatementMetaData pData, CombinedConstraint pConstraint) {
        if (pConstraint.getNumParts() == 0) {
            return null;
        }
        ArrayList<String> parts = new ArrayList<String>();
        Iterator iter = pConstraint.getParts();
        while (iter.hasNext()) {
            String s;
            Object o = iter.next();
            if (o == null) {
                throw new NullPointerException("A CombinedConstraints part must not be null");
            }
            if (o instanceof CombinedConstraint) {
                s = this.getCombinedConstraint(pData, (CombinedConstraint)o);
            } else if (o instanceof BooleanConstraint) {
                s = this.getBooleanConstraint(pData, (BooleanConstraint)o);
            } else {
                throw new IllegalArgumentException("Invalid part: " + o.getClass().getName());
            }
            if (s == null) continue;
            parts.add(s);
        }
        switch (parts.size()) {
            case 0: {
                return null;
            }
            case 1: {
                if (pConstraint.isNOT()) {
                    return "NOT (" + parts.get(0) + ")";
                }
                return (String)parts.get(0);
            }
        }
        StringBuffer sb = new StringBuffer();
        if (pConstraint.isNOT()) {
            sb.append("(NOT ");
        }
        for (int i = 0; i < parts.size(); ++i) {
            if (i == 0) {
                sb.append("(");
            } else {
                sb.append(" ");
                sb.append(pConstraint.getType());
                sb.append(" ");
            }
            sb.append(parts.get(i));
        }
        sb.append(")");
        if (pConstraint.isNOT()) {
            sb.append(")");
        }
        return sb.toString();
    }

    public String getConstraint(StatementMetaData pData, Constraint pConstraint) {
        if (pConstraint instanceof CombinedConstraint) {
            return this.getWhereClause(pData, (CombinedConstraint)pConstraint);
        }
        if (pConstraint instanceof BooleanConstraint) {
            return this.getBooleanConstraint(pData, (BooleanConstraint)pConstraint);
        }
        throw new IllegalArgumentException("Unknown constraint type: " + pConstraint.getClass().getName());
    }

    protected String getWhereClause(StatementMetaData pData, CombinedConstraint pWhereClause) {
        return this.getCombinedConstraint(pData, pWhereClause);
    }

    protected String getSelectQuery(SelectStatement pQuery) {
        StatementMetaData selectStatementMetaData = this.newStatementMetaData(pQuery);
        return this.getSelectQuery(pQuery, selectStatementMetaData);
    }

    protected String getSelectQueryResultColumns(SelectStatement pQuery, StatementMetaData pData) {
        Iterator columnIter;
        StringBuffer sb = new StringBuffer();
        if (pQuery.isDistinct()) {
            sb.append(" DISTINCT");
        }
        if (!(columnIter = pQuery.getResultColumns()).hasNext()) {
            sb.append(" *");
        } else {
            boolean first = true;
            do {
                ColumnReference column = (ColumnReference)columnIter.next();
                if (first) {
                    sb.append(" ");
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(this.getColumnAlias(pData, column));
            } while (columnIter.hasNext());
        }
        return sb.toString();
    }

    protected String getSelectQueryFromClause(SelectStatement pQuery, StatementMetaData pData) {
        SelectTableReference selectTableReference = pQuery.getSelectTableReference();
        if (selectTableReference == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" FROM ");
        sb.append(this.getTableAlias(pData, selectTableReference));
        for (JoinReference joinReference = selectTableReference.getRightJoinedTableReference(); joinReference != null; joinReference = joinReference.getRightJoinedTableReference()) {
            sb.append(this.getJoinAlias(pData, joinReference));
        }
        return sb.toString();
    }

    protected String getSelectQueryConstraints(SelectStatement pQuery, StatementMetaData pData, StatementMetaData.LocalData pLocalData) {
        String s = this.getWhereClause(pData, pQuery.getWhere());
        if (pLocalData != null && s != null && s.length() > 0) {
            pLocalData.setWhereClause(true);
        }
        return s;
    }

    protected String getSelectQuery(SelectStatement pQuery, StatementMetaData pData) {
        StatementMetaData.LocalData localData;
        StringBuffer sb = new StringBuffer("SELECT");
        String s = this.getSelectQueryResultColumns(pQuery, pData);
        if (s != null) {
            sb.append(s);
        }
        if ((s = this.getSelectQueryFromClause(pQuery, pData)) != null) {
            sb.append(s);
        }
        if ((s = this.getSelectQueryConstraints(pQuery, pData, localData = new StatementMetaData.LocalData())) != null && s.length() > 0) {
            if (localData.hasWhereClause()) {
                sb.append(" WHERE ");
            }
            sb.append(s);
        }
        if ((s = this.getSelectQueryOrderClause(pData, pQuery)) != null) {
            sb.append(s);
        }
        return sb.toString();
    }

    protected String getOrderColumn(StatementMetaData pData, SelectStatement.OrderColumn pColumn) {
        String s = this.getBooleanConstraintPart(pData, pColumn.getColumn());
        if (pColumn.isDescending()) {
            s = s + " DESC";
        }
        return s;
    }

    protected String getSelectQueryOrderClause(StatementMetaData pData, SelectStatement pQuery) {
        StringBuffer sb = new StringBuffer();
        Iterator iter = pQuery.getOrderColumns();
        while (iter.hasNext()) {
            SelectStatement.OrderColumn col = (SelectStatement.OrderColumn)iter.next();
            if (sb.length() == 0) {
                sb.append(" ORDER BY ");
            } else {
                sb.append(", ");
            }
            sb.append(this.getOrderColumn(pData, col));
        }
        return sb.toString();
    }

    public String getQuery(Statement pStatement) {
        String s;
        if (pStatement instanceof InsertStatement) {
            s = this.getInsertQuery((InsertStatement)pStatement);
        } else if (pStatement instanceof UpdateStatement) {
            s = this.getUpdateQuery((UpdateStatement)pStatement);
        } else if (pStatement instanceof DeleteStatement) {
            s = this.getDeleteQuery((DeleteStatement)pStatement);
        } else if (pStatement instanceof SelectStatement) {
            s = this.getSelectQuery((SelectStatement)pStatement);
        } else {
            throw new IllegalArgumentException("The Statement is neither an INSERT, UPDATE, DELETE nor a SELECT statement.");
        }
        return this.newStatement(s);
    }

    public Collection getCreate(Schema pSchema, boolean pAll) {
        if (!pAll) {
            return this.getCreate(pSchema);
        }
        ArrayList result = new ArrayList();
        result.addAll(this.getCreate(pSchema));
        Iterator iter = pSchema.getTables();
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            result.addAll(this.getCreate(table, true));
        }
        return result;
    }

    public Collection getDrop(Schema pSchema, boolean pAll) {
        if (!pAll) {
            return this.getDrop(pSchema);
        }
        ArrayList result = new ArrayList();
        ArrayList tables = new ArrayList();
        Iterator iter = pSchema.getTables();
        while (iter.hasNext()) {
            tables.add(iter.next());
        }
        Collections.reverse(tables);
        iter = tables.iterator();
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            result.addAll(this.getDrop(table, true));
        }
        result.addAll(this.getDrop(pSchema));
        return result;
    }

    public Collection getCreate(Table pTable, boolean pAll) {
        if (!pAll) {
            return this.getCreate(pTable);
        }
        ArrayList result = new ArrayList();
        result.addAll(this.getCreate(pTable));
        Iterator iter = pTable.getIndexes();
        while (iter.hasNext()) {
            Index index = (Index)iter.next();
            if (index.isPrimaryKey() && !this.isPrimaryKeyUniqueIndex() ? this.isPrimaryKeyPartOfCreateTable() : (index.isUnique() ? this.isUniqueIndexPartOfCreateTable() : this.isNonUniqueIndexPartOfCreateTable())) continue;
            result.addAll(this.getCreate(index));
        }
        if (!this.isForeignKeyPartOfCreateTable()) {
            iter = pTable.getForeignKeys();
            while (iter.hasNext()) {
                ForeignKey key = (ForeignKey)iter.next();
                result.addAll(this.getCreate(key));
            }
        }
        return result;
    }

    public Collection getDrop(Table pTable, boolean pAll) {
        if (!pAll) {
            return this.getDrop(pTable);
        }
        ArrayList result = new ArrayList();
        Iterator iter = pTable.getIndexes();
        while (iter.hasNext()) {
            Index index = (Index)iter.next();
            result.addAll(this.getDrop(index));
        }
        iter = pTable.getForeignKeys();
        while (iter.hasNext()) {
            ForeignKey key = (ForeignKey)iter.next();
            result.addAll(this.getDrop(key));
        }
        result.addAll(this.getDrop(pTable));
        return result;
    }

    public Collection getCreate(Index pIndex) {
        ArrayList<String> result = new ArrayList<String>();
        String s = this.createIndexAsPartOfCreateTable(pIndex);
        if (s != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("CREATE");
            if (pIndex.isUnique()) {
                sb.append(" UNIQUE");
            }
            sb.append(" INDEX");
            sb.append(" ");
            sb.append(pIndex.getName());
            sb.append(" ON ").append(pIndex.getTable().getQName()).append(" (");
            boolean first = true;
            Iterator iter = pIndex.getColumns();
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(((Column)iter.next()).getName().getName());
            }
            sb.append(")");
            result.add(this.newStatement(sb.toString()));
        }
        return result;
    }

    public Collection getDrop(Index pIndex) {
        return Collections.EMPTY_SET;
    }

    public Collection getCreate(ForeignKey pKey) {
        ArrayList<String> result = new ArrayList<String>();
        String s = this.createForeignKeyAsPartOfCreateTable(pKey);
        if (s != null) {
            result.add(this.newStatement("CREATE " + s));
        }
        return result;
    }

    public Collection getDrop(ForeignKey pKey) {
        return Collections.EMPTY_SET;
    }

    protected StatementMetaData newStatementMetaData(SelectStatement pQuery) {
        return new StatementMetaData(pQuery);
    }

    protected StatementMetaData newStatementMetaData(DeleteStatement pQuery) {
        return new StatementMetaData(pQuery);
    }

    protected StatementMetaData newStatementMetaData(UpdateStatement pQuery, ColumnReference[] pColumns) {
        return new StatementMetaData(pQuery, pColumns);
    }

    protected StatementMetaData newStatementMetaData(InsertStatement pQuery, ColumnReference[] pColumns) {
        return new StatementMetaData(pQuery, pColumns);
    }

    public String getWhereClause(SelectStatement pQuery) {
        StatementMetaData metaData = this.newStatementMetaData(pQuery);
        StringBuffer sb = new StringBuffer();
        StatementMetaData.LocalData localData = new StatementMetaData.LocalData();
        String s = this.getSelectQueryConstraints(pQuery, metaData, localData);
        if (s != null) {
            sb.append(s);
        }
        if ((s = this.getSelectQueryOrderClause(metaData, pQuery)) != null) {
            sb.append(s);
        }
        return sb.toString();
    }

    public String getConstraint(Constraint pConstraint) {
        if (pConstraint instanceof CombinedConstraint) {
            CombinedConstraint cc = (CombinedConstraint)pConstraint;
            ConstrainedStatement st = cc.getConstrainedStatement();
            if (st instanceof SelectStatement) {
                StatementMetaData selectStatementMetaData = this.newStatementMetaData((SelectStatement)st);
                return this.getCombinedConstraint(selectStatementMetaData, cc);
            }
            return this.getCombinedConstraint(null, cc);
        }
        if (pConstraint instanceof BooleanConstraint) {
            BooleanConstraint bc = (BooleanConstraint)pConstraint;
            ConstrainedStatement st = bc.getConstrainedStatement();
            if (st instanceof SelectStatement) {
                StatementMetaData selectStatementMetaData = this.newStatementMetaData((SelectStatement)st);
                return this.getBooleanConstraint(selectStatementMetaData, bc);
            }
            return this.getBooleanConstraint(null, bc);
        }
        throw new IllegalStateException("Invalid type of Constraint: " + pConstraint);
    }
}

