/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsSplitPaneDivider;
import com.pagosoft.plaf.PlafOptions;
import com.pagosoft.swing.ShadowBorder;
import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class PgsSplitPaneUI
extends BasicSplitPaneUI {
    private SplitPaneContainerListener splitPaneContainerListener;
    private MyPropertyChangeHandler propertyChangeHandler;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PgsSplitPaneUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.maybeSetShadowBorder(this.splitPane.getLeftComponent());
        this.maybeSetShadowBorder(this.splitPane.getRightComponent());
    }

    public void uninstallDefaults() {
        super.uninstallDefaults();
        this.maybeRemoveShadowBorder(this.splitPane.getLeftComponent());
        this.maybeRemoveShadowBorder(this.splitPane.getRightComponent());
    }

    protected boolean isShadowBorder() {
        if (this.splitPane.getClientProperty("pgs.shadowBorder") != null) {
            return Boolean.TRUE.equals(this.splitPane.getClientProperty("pgs.shadowBorder"));
        }
        return PlafOptions.isShadowBorderUsed();
    }

    protected void maybeSetShadowBorder(Component component) {
        if (component instanceof JComponent && this.isShadowBorder()) {
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("pgs.savedBorder", jComponent.getBorder());
            if (jComponent.getBorder() instanceof BorderUIResource) {
                jComponent.setBorder(ShadowBorder.getInstance());
            } else {
                jComponent.setBorder(BorderFactory.createCompoundBorder(ShadowBorder.getInstance(), jComponent.getBorder()));
            }
        }
    }

    protected void maybeRemoveShadowBorder(Component component) {
        if (component instanceof JComponent && !this.isShadowBorder()) {
            ((JComponent)component).setBorder((Border)((JComponent)component).getClientProperty("pgs.savedBorder"));
        }
    }

    public void installListeners() {
        super.installListeners();
        if (this.splitPaneContainerListener == null) {
            this.splitPaneContainerListener = new SplitPaneContainerListener();
        }
        if (this.propertyChangeHandler == null) {
            this.propertyChangeHandler = new MyPropertyChangeHandler();
        }
        this.splitPane.addContainerListener(this.splitPaneContainerListener);
        this.splitPane.addPropertyChangeListener("pgs.shadowBorder", this.propertyChangeHandler);
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        this.splitPane.removeContainerListener(this.splitPaneContainerListener);
        this.splitPane.removePropertyChangeListener("pgs.shadowBorder", this.propertyChangeHandler);
    }

    public BasicSplitPaneDivider createDefaultDivider() {
        return new PgsSplitPaneDivider(this);
    }

    protected class MyPropertyChangeHandler
    implements PropertyChangeListener {
        protected MyPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!propertyChangeEvent.getNewValue().equals(propertyChangeEvent.getOldValue())) {
                boolean bl = propertyChangeEvent.getOldValue() != null ? (Boolean)propertyChangeEvent.getOldValue() : PlafOptions.isShadowBorderUsed();
                if (bl) {
                    PgsSplitPaneUI.this.maybeRemoveShadowBorder(PgsSplitPaneUI.this.splitPane.getLeftComponent());
                    PgsSplitPaneUI.this.maybeRemoveShadowBorder(PgsSplitPaneUI.this.splitPane.getRightComponent());
                }
                if (bl = ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                    PgsSplitPaneUI.this.maybeSetShadowBorder(PgsSplitPaneUI.this.splitPane.getLeftComponent());
                    PgsSplitPaneUI.this.maybeSetShadowBorder(PgsSplitPaneUI.this.splitPane.getRightComponent());
                }
            }
        }
    }

    protected class SplitPaneContainerListener
    implements ContainerListener {
        protected SplitPaneContainerListener() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            PgsSplitPaneUI.this.maybeSetShadowBorder(containerEvent.getChild());
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            PgsSplitPaneUI.this.maybeRemoveShadowBorder(containerEvent.getChild());
        }
    }
}

