/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.classes;

import com.horstmann.violet.framework.diagram.Grid;
import com.horstmann.violet.framework.diagram.MultiLineString;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.framework.diagram.RectangularNode;
import com.horstmann.violet.framework.util.GeometryUtils;
import com.horstmann.violet.product.diagram.classes.ClassNode;
import com.horstmann.violet.product.diagram.classes.InterfaceNode;
import com.horstmann.violet.product.diagram.common.NoteNode;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Collection;
import java.util.List;
import javax.swing.JLabel;

public class PackageNode
extends RectangularNode {
    private String name = "";
    private MultiLineString contents = new MultiLineString();
    private transient Rectangle2D top;
    private transient Rectangle2D bot;
    private static int DEFAULT_TOP_WIDTH = 60;
    private static int DEFAULT_TOP_HEIGHT = 20;
    private static int DEFAULT_WIDTH = 100;
    private static int DEFAULT_HEIGHT = 80;
    private static final int NAME_GAP = 3;
    private static final int DEFAULT_XGAP = 5;
    private static final int DEFAULT_YGAP = 5;
    private static JLabel label = new JLabel();

    public PackageNode() {
        this.setBounds(new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_HEIGHT));
        this.top = new Rectangle2D.Double(0.0, 0.0, DEFAULT_TOP_WIDTH, DEFAULT_TOP_HEIGHT);
        this.bot = new Rectangle2D.Double(0.0, DEFAULT_TOP_HEIGHT, DEFAULT_WIDTH, DEFAULT_HEIGHT - DEFAULT_TOP_HEIGHT);
    }

    @Override
    public void translate(double dx, double dy) {
        GeometryUtils.translate(this.top, dx, dy);
        GeometryUtils.translate(this.bot, dx, dy);
        if (this.getChildren().size() == 0) {
            super.translate(dx, dy);
        } else {
            for (Node childNode : this.getChildren()) {
                childNode.translate(dx, dy);
            }
        }
    }

    @Override
    public void draw(Graphics2D g2) {
        super.draw(g2);
        Rectangle2D bounds = this.getBounds();
        label.setText("<html>" + this.name + "</html>");
        label.setFont(g2.getFont());
        Dimension d = label.getPreferredSize();
        label.setBounds(0, 0, d.width, d.height);
        g2.draw(this.top);
        double textX = bounds.getX() + 3.0;
        double textY = bounds.getY() + (this.top.getHeight() - d.getHeight()) / 2.0;
        g2.translate(textX, textY);
        label.paint(g2);
        g2.translate(-textX, -textY);
        g2.draw(this.bot);
        this.contents.draw(g2, this.bot);
    }

    @Override
    public Shape getShape() {
        GeneralPath path = new GeneralPath();
        path.append(this.top, false);
        path.append(this.bot, false);
        return path;
    }

    @Override
    public Point2D getLocation() {
        if (this.getChildren().size() > 0) {
            return new Point2D.Double(this.getBounds().getX(), this.getBounds().getY());
        }
        return super.getLocation();
    }

    @Override
    public void layout(Graphics2D g2, Grid grid) {
        label.setText("<html>" + this.name + "</html>");
        label.setFont(g2.getFont());
        Dimension d = label.getPreferredSize();
        double topWidth = Math.max(d.getWidth() + 6.0, (double)DEFAULT_TOP_WIDTH);
        double topHeight = Math.max(d.getHeight(), (double)DEFAULT_TOP_HEIGHT);
        double xgap = Math.max(5.0, grid.getX());
        double ygap = Math.max(5.0, grid.getY());
        RectangularShape childBounds = null;
        List<Node> children = this.getChildren();
        for (Node child : children) {
            child.setZ(this.getZ() + 1);
            child.layout(g2, grid);
            if (childBounds == null) {
                childBounds = child.getBounds();
                continue;
            }
            ((Rectangle2D)childBounds).add(child.getBounds());
        }
        Rectangle2D contentsBounds = this.contents.getBounds(g2);
        if (childBounds == null) {
            this.snapBounds(grid, Math.max(topWidth + (double)DEFAULT_WIDTH - (double)DEFAULT_TOP_WIDTH, Math.max((double)DEFAULT_WIDTH, contentsBounds.getWidth())), topHeight + Math.max((double)(DEFAULT_HEIGHT - DEFAULT_TOP_HEIGHT), contentsBounds.getHeight()));
        } else {
            this.setBounds(new Rectangle2D.Double(childBounds.getX() - xgap, childBounds.getY() - topHeight - ygap, Math.max(topWidth, childBounds.getWidth() + 2.0 * xgap), topHeight + childBounds.getHeight() + 2.0 * ygap));
        }
        Rectangle2D b = this.getBounds();
        this.top = new Rectangle2D.Double(b.getX(), b.getY(), topWidth, topHeight);
        this.bot = new Rectangle2D.Double(b.getX(), b.getY() + topHeight, b.getWidth(), b.getHeight() - topHeight);
    }

    public void setName(String newValue) {
        this.name = newValue;
    }

    public String getName() {
        return this.name;
    }

    public void setContents(MultiLineString newValue) {
        this.contents = newValue;
    }

    public MultiLineString getContents() {
        return this.contents;
    }

    @Override
    public boolean checkAddNode(Node n, Point2D p) {
        if (n instanceof ClassNode || n instanceof InterfaceNode || n instanceof PackageNode) {
            this.addChild(this.getChildren().size(), n);
            return true;
        }
        return n instanceof NoteNode;
    }

    @Override
    public boolean checkPasteChildren(Collection<Node> children) {
        for (Node n : children) {
            if (n instanceof ClassNode || n instanceof InterfaceNode || n instanceof PackageNode) continue;
            return false;
        }
        for (Node n : children) {
            int GAP = 6;
            n.translate(this.bot.getX() + 6.0, this.bot.getY() + 6.0);
            this.addChild(this.getChildren().size(), n);
        }
        return true;
    }

    @Override
    public PackageNode clone() {
        PackageNode cloned = (PackageNode)super.clone();
        cloned.contents = this.contents.clone();
        this.top = (Rectangle2D)this.top.clone();
        this.bot = (Rectangle2D)this.bot.clone();
        return cloned;
    }
}

