/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.activity;

import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Grid;
import com.horstmann.violet.framework.diagram.MultiLineString;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.framework.diagram.RectangularNode;
import com.horstmann.violet.product.diagram.common.PointNode;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;

public class DecisionNode
extends RectangularNode {
    private MultiLineString condition = new MultiLineString();
    private static int DEFAULT_WIDTH = 30;
    private static int DEFAULT_HEIGHT = 20;

    public DecisionNode() {
        this.setBounds(new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_HEIGHT));
    }

    @Override
    public boolean checkAddEdge(Edge e, Point2D p1, Point2D p2) {
        return e.getEnd() != null && this != e.getEnd();
    }

    @Override
    public void draw(Graphics2D g2) {
        super.draw(g2);
        Rectangle2D shapeRect = this.getBounds();
        Rectangle2D textRect = this.condition.getBounds(g2);
        textRect.setRect(shapeRect.getCenterX() - textRect.getWidth() / 2.0, shapeRect.getCenterY() - textRect.getHeight() / 2.0, textRect.getWidth(), textRect.getHeight());
        g2.draw(this.getShape());
        this.condition.draw(g2, textRect);
    }

    @Override
    public Shape getShape() {
        Rectangle2D shapeRect = this.getBounds();
        GeneralPath diamond = new GeneralPath();
        float x1 = (float)shapeRect.getX();
        float y1 = (float)shapeRect.getCenterY();
        float x2 = (float)shapeRect.getCenterX();
        float y2 = (float)shapeRect.getY();
        float x3 = (float)(shapeRect.getX() + shapeRect.getWidth());
        float y3 = (float)shapeRect.getCenterY();
        float x4 = (float)shapeRect.getCenterX();
        float y4 = (float)(shapeRect.getY() + shapeRect.getHeight());
        diamond.moveTo(x1, y1);
        diamond.lineTo(x2, y2);
        diamond.lineTo(x3, y3);
        diamond.lineTo(x4, y4);
        diamond.lineTo(x1, y1);
        return diamond;
    }

    @Override
    public void layout(Graphics2D g2, Grid grid) {
        Rectangle2D b = this.condition.getBounds(g2);
        Rectangle2D.Double textRect = new Rectangle2D.Double(0.0, 0.0, Math.max((double)DEFAULT_WIDTH, b.getWidth()), Math.max((double)DEFAULT_HEIGHT, b.getHeight()));
        double w1 = ((RectangularShape)textRect).getWidth() / 2.0;
        double h1 = ((RectangularShape)textRect).getHeight() / 2.0;
        double w2 = Math.tan(Math.toRadians(60.0)) * h1;
        double h2 = Math.tan(Math.toRadians(30.0)) * w1;
        double shapeWidth = (w1 + w2) * 2.0;
        double shapeHeight = (h1 + h2) * 2.0;
        this.snapBounds(grid, shapeWidth, shapeHeight);
    }

    @Override
    public List<Node> getAncestors() {
        return super.getAncestors();
    }

    @Override
    public boolean checkAddNode(Node n, Point2D p) {
        return n instanceof PointNode;
    }

    public void setCondition(MultiLineString newValue) {
        this.condition = newValue;
    }

    public MultiLineString getCondition() {
        return this.condition;
    }
}

