/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.swingextension;

import com.horstmann.violet.framework.swingextension.CustomToggleButton;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicPanelUI;

public class CustomToggleButtonUI
extends BasicPanelUI {
    private Color unselectedColor;
    private Color selectedColor;
    private Color selectedBorderColor;

    public CustomToggleButtonUI(Color selectedColor, Color selectedBorderColor, Color unselectedColor) {
        this.unselectedColor = unselectedColor;
        this.selectedColor = selectedColor;
        this.selectedBorderColor = selectedBorderColor;
    }

    @Override
    protected void installDefaults(JPanel p) {
        p.setOpaque(false);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (c instanceof CustomToggleButton) {
            boolean isSelected = ((CustomToggleButton)c).isSelected();
            if (isSelected) {
                this.paintSelectedBg(g, c);
                this.paintSelectedBorder(g, c);
            }
            if (!isSelected) {
                this.paintUnselectedBg(g, c);
            }
        }
        super.paint(g, c);
    }

    private void paintSelectedBg(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g;
        Paint currentPaint = g2.getPaint();
        GradientPaint paint = new GradientPaint(c.getWidth() / 2, -c.getHeight() / 4, this.selectedColor.brighter().brighter(), c.getWidth() / 2, c.getHeight() + c.getHeight() / 4, this.selectedColor);
        g2.setPaint(paint);
        g2.fillRect(0, 0, c.getWidth(), c.getHeight());
        g2.setPaint(currentPaint);
    }

    private void paintUnselectedBg(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g;
        Color currentColor = g2.getColor();
        g2.setColor(this.unselectedColor);
        g2.fillRect(0, 0, c.getWidth(), c.getHeight());
        g2.setColor(currentColor);
    }

    private void paintSelectedBorder(Graphics g, JComponent c) {
        Color currentColor = g.getColor();
        g.setColor(this.selectedBorderColor);
        g.drawRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
        g.setColor(currentColor);
    }
}

