/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.network.receiver;

import com.horstmann.violet.framework.network.receiver.HTTPReceiver;
import com.horstmann.violet.framework.network.receiver.HTTPServer;
import com.horstmann.violet.framework.network.receiver.IReceiver;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ReceiverFactory {
    private static ReceiverFactory instance;
    private Map<Integer, HTTPServer> httpServers = new HashMap<Integer, HTTPServer>();

    private ReceiverFactory() {
    }

    public static ReceiverFactory getInstance() {
        if (instance == null) {
            instance = new ReceiverFactory();
        }
        return instance;
    }

    public IReceiver createReceiver(URL receiverURL) {
        String protocol = receiverURL.getProtocol();
        if (protocol == null) {
            throw new RuntimeException("Can't read network protocol");
        }
        if (protocol.toLowerCase().equals("http")) {
            int port = receiverURL.getPort();
            if (port <= 0) {
                throw new RuntimeException("Can't read network http port");
            }
            return this.getHTTPReceiver(receiverURL);
        }
        throw new RuntimeException("Unsupported network protocol");
    }

    private HTTPReceiver getHTTPReceiver(URL receiverURL) {
        int port = receiverURL.getPort();
        Integer portObj = new Integer(port);
        if (this.httpServers.containsKey(portObj)) {
            HTTPServer s = this.httpServers.get(portObj);
            return s.getReceiver();
        }
        try {
            HTTPReceiver r = new HTTPReceiver(receiverURL);
            HTTPServer s = new HTTPServer(r, port);
            this.httpServers.put(portObj, s);
            return r;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to start HTTP server on port " + port);
        }
    }
}

