/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui.theme;

import com.horstmann.violet.eclipseplugin.editors.EclipseColorPicker;
import com.horstmann.violet.framework.gui.theme.BasicTheme;
import com.horstmann.violet.framework.gui.theme.ClassicMetalTheme;
import com.horstmann.violet.framework.gui.theme.EclipseTheme;
import com.horstmann.violet.framework.gui.theme.Theme;
import com.horstmann.violet.framework.gui.theme.VistaBlueTheme;
import com.horstmann.violet.framework.preference.PreferencesConstant;
import com.horstmann.violet.framework.preference.PreferencesService;
import com.horstmann.violet.framework.preference.PreferencesServiceFactory;
import com.pagosoft.plaf.PgsLookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class ThemeManager {
    private static ThemeManager instance;
    private Theme currentTheme;
    private boolean isEclipseThemeAlreadySet = false;

    private ThemeManager() {
    }

    public static ThemeManager getInstance() {
        if (instance == null) {
            instance = new ThemeManager();
        }
        return instance;
    }

    public UIManager.LookAndFeelInfo[] getInstalledLookAndFeels() {
        UIManager.LookAndFeelInfo[] infos = UIManager.getInstalledLookAndFeels();
        PgsLookAndFeel pgsLaf = new PgsLookAndFeel();
        boolean isPgsSupported = pgsLaf.isSupportedLookAndFeel();
        if (isPgsSupported) {
            UIManager.LookAndFeelInfo vistaBlueInfo = new UIManager.LookAndFeelInfo("Blue Vista", VistaBlueTheme.class.getName());
            UIManager.LookAndFeelInfo[] newInfos = new UIManager.LookAndFeelInfo[infos.length + 1];
            System.arraycopy(infos, 0, newInfos, 1, infos.length);
            newInfos[0] = vistaBlueInfo;
            infos = newInfos;
        }
        return infos;
    }

    public void applyPreferedTheme() {
        String className = this.getPreferedLookAndFeel();
        if (VistaBlueTheme.class.getName().equals(className)) {
            this.switchToVistaBlueTheme();
            return;
        }
        if (MetalLookAndFeel.class.getName().equals(className)) {
            this.switchToClassicMetalTheme();
            return;
        }
        this.switchToBasicTheme(className);
    }

    public int getPreferedTheme() {
        PreferencesService pService = PreferencesServiceFactory.getInstance();
        String preferedLAF = pService.get(PreferencesConstant.LOOK_AND_FEEL, "0");
        return Integer.parseInt(preferedLAF);
    }

    public void setPreferedLookAndFeel(String className) {
        PreferencesService pService = PreferencesServiceFactory.getInstance();
        pService.put(PreferencesConstant.LOOK_AND_FEEL, className);
    }

    public String getPreferedLookAndFeel() {
        PreferencesService pService = PreferencesServiceFactory.getInstance();
        String preferedLAF = pService.get(PreferencesConstant.LOOK_AND_FEEL, VistaBlueTheme.class.getName());
        return preferedLAF;
    }

    public void switchToVistaBlueTheme() {
        this.currentTheme = new VistaBlueTheme();
        this.currentTheme.activate();
    }

    public void switchToClassicMetalTheme() {
        this.currentTheme = new ClassicMetalTheme();
        this.currentTheme.activate();
    }

    public void switchToBasicTheme(String className) {
        this.currentTheme = new BasicTheme(className);
        this.currentTheme.activate();
    }

    public void switchToEclipseTheme(EclipseColorPicker colorPicker) {
        if (!this.isEclipseThemeAlreadySet) {
            this.currentTheme = new EclipseTheme(colorPicker);
            this.currentTheme.activate();
            this.isEclipseThemeAlreadySet = true;
        }
    }

    public Theme getTheme() {
        return this.currentTheme;
    }
}

