/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.file;

import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.file.ExtensionFilter;
import com.horstmann.violet.framework.preference.PreferencesConstant;
import com.horstmann.violet.framework.preference.PreferencesService;
import com.horstmann.violet.framework.preference.PreferencesServiceFactory;
import com.horstmann.violet.product.diagram.activity.ActivityDiagramGraph;
import com.horstmann.violet.product.diagram.classes.ClassDiagramGraph;
import com.horstmann.violet.product.diagram.object.ObjectDiagramGraph;
import com.horstmann.violet.product.diagram.sequence.SequenceDiagramGraph;
import com.horstmann.violet.product.diagram.state.StateDiagramGraph;
import com.horstmann.violet.product.diagram.usecase.UseCaseDiagramGraph;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public abstract class FileService {
    private static final int DEFAULT_MAX_RECENT_FILES = 5;

    public static String editExtension(String original, String toBeRemoved, String desired) {
        String path;
        if (original == null) {
            return null;
        }
        int n = desired.indexOf(124);
        if (n >= 0) {
            desired = desired.substring(0, n);
        }
        if (!(path = original).toLowerCase().endsWith(desired.toLowerCase())) {
            if (toBeRemoved != null && path.toLowerCase().endsWith(toBeRemoved.toLowerCase())) {
                path = path.substring(0, path.length() - toBeRemoved.length());
            }
            path = path + desired;
        }
        return path;
    }

    private static Map<Class<? extends Graph>, ExtensionFilter> getExtensionFilters() {
        ResourceBundle appResources = ResourceBundle.getBundle("properties.FileStrings", Locale.getDefault());
        LinkedHashMap<Class<? extends Graph>, ExtensionFilter> result = new LinkedHashMap<Class<? extends Graph>, ExtensionFilter>();
        String defaultFilesExt = appResources.getString("files.global.extension");
        String defaultFilesExtName = appResources.getString("files.global.name");
        String classFilesExt = appResources.getString("files.class.extension");
        String classFilesExtName = appResources.getString("files.class.name");
        String objectFilesExt = appResources.getString("files.object.extension");
        String objectFilesExtName = appResources.getString("files.object.name");
        String seqFilesExt = appResources.getString("files.seq.extension");
        String seqFilesExtName = appResources.getString("files.seq.name");
        String activityFilesExt = appResources.getString("files.activity.extension");
        String activityFilesExtName = appResources.getString("files.activity.name");
        String stateFilesExt = appResources.getString("files.state.extension");
        String stateFilesExtName = appResources.getString("files.state.name");
        String usecaseFilesExt = appResources.getString("files.usecase.extension");
        String usecaseFilesExtName = appResources.getString("files.usecase.name");
        ExtensionFilter fileFilter0 = new ExtensionFilter(defaultFilesExtName, new String[]{defaultFilesExt});
        ExtensionFilter fileFilter1 = new ExtensionFilter(classFilesExtName, new String[]{classFilesExt});
        ExtensionFilter fileFilter2 = new ExtensionFilter(objectFilesExtName, new String[]{objectFilesExt});
        ExtensionFilter fileFilter3 = new ExtensionFilter(seqFilesExtName, new String[]{seqFilesExt});
        ExtensionFilter fileFilter4 = new ExtensionFilter(activityFilesExtName, new String[]{activityFilesExt});
        ExtensionFilter fileFilter5 = new ExtensionFilter(stateFilesExtName, new String[]{stateFilesExt});
        ExtensionFilter fileFilter6 = new ExtensionFilter(usecaseFilesExtName, new String[]{usecaseFilesExt});
        result.put(UseCaseDiagramGraph.class, fileFilter6);
        result.put(ClassDiagramGraph.class, fileFilter1);
        result.put(ActivityDiagramGraph.class, fileFilter4);
        result.put(SequenceDiagramGraph.class, fileFilter3);
        result.put(ObjectDiagramGraph.class, fileFilter2);
        result.put(StateDiagramGraph.class, fileFilter5);
        result.put(Graph.class, fileFilter0);
        return result;
    }

    public static ExtensionFilter[] getFileFilters() {
        Map<Class<? extends Graph>, ExtensionFilter> filters = FileService.getExtensionFilters();
        Collection<ExtensionFilter> values = filters.values();
        return values.toArray(new ExtensionFilter[values.size()]);
    }

    public static ExtensionFilter getExtensionFilter(Graph graph) {
        Map<Class<? extends Graph>, ExtensionFilter> filters = FileService.getExtensionFilters();
        ExtensionFilter filter = filters.get(graph.getClass());
        if (filter != null) {
            return filter;
        }
        return filters.get(Graph.class);
    }

    public static ExtensionFilter getImageExtensionFilter() {
        return FileService.getExtensionFilter("image");
    }

    public static String getImageFileExtension() {
        return FileService.getFileExtension("image");
    }

    public static ExtensionFilter getXMIExtensionFilter() {
        return FileService.getExtensionFilter("xmi");
    }

    public static String getXMIFileExtension() {
        return FileService.getFileExtension("xmi");
    }

    private static ExtensionFilter getExtensionFilter(String type) {
        ResourceBundle appResources = ResourceBundle.getBundle("properties.FileStrings", Locale.getDefault());
        String filterName = appResources.getString("files." + type + ".name");
        String fileExtension = appResources.getString("files." + type + ".extension");
        return new ExtensionFilter(filterName, fileExtension);
    }

    private static String getFileExtension(String type) {
        ResourceBundle appResources = ResourceBundle.getBundle("properties.FileStrings", Locale.getDefault());
        return appResources.getString("files." + type + ".extension");
    }

    public static List<String> getRecentFiles() {
        ArrayList<String> recentFiles = new ArrayList<String>();
        PreferencesService preferences = PreferencesServiceFactory.getInstance();
        String recent = preferences.get(PreferencesConstant.RECENT_FILES, "").trim();
        if (recent.length() > 0) {
            recentFiles.addAll(Arrays.asList(recent.split("[|]")));
        }
        return recentFiles;
    }

    public static void updateRecentFiles(List<String> recentFiles) {
        PreferencesService preferences = PreferencesServiceFactory.getInstance();
        String recent = "";
        for (int i = 0; i < Math.min(recentFiles.size(), 5); ++i) {
            if (recent.length() > 0) {
                recent = recent + "|";
            }
            recent = recent + recentFiles.get(i);
        }
        preferences.put(PreferencesConstant.RECENT_FILES, recent);
    }

    public static void addOpenedFile(String path) {
        boolean isPathFound = false;
        PreferencesService preferences = PreferencesServiceFactory.getInstance();
        String list = preferences.get(PreferencesConstant.OPENED_FILES_ON_WORKSPACE, "");
        StringTokenizer tokenizer = new StringTokenizer(list, PreferencesConstant.OPENED_FILES_SEPARATOR.toString());
        while (tokenizer.hasMoreTokens()) {
            String aPath = tokenizer.nextToken();
            if (!aPath.equals(path)) continue;
            isPathFound = true;
            break;
        }
        if (!isPathFound) {
            list = list + PreferencesConstant.OPENED_FILES_SEPARATOR + path;
            preferences.put(PreferencesConstant.OPENED_FILES_ON_WORKSPACE, list);
        }
    }

    public static void removeOpenedFile(String path) {
        boolean isPathFound = false;
        PreferencesService preferences = PreferencesServiceFactory.getInstance();
        String list = preferences.get(PreferencesConstant.OPENED_FILES_ON_WORKSPACE, "");
        StringTokenizer tokenizer = new StringTokenizer(list, PreferencesConstant.OPENED_FILES_SEPARATOR.toString());
        ArrayList<String> pathList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String aPath = tokenizer.nextToken();
            if (aPath.equals(path)) {
                isPathFound = true;
            }
            pathList.add(aPath);
        }
        if (isPathFound) {
            pathList.remove(path);
            Iterator iter = pathList.iterator();
            list = "";
            while (iter.hasNext()) {
                String aPath = (String)iter.next();
                list = list + PreferencesConstant.OPENED_FILES_SEPARATOR + aPath;
            }
            preferences.put(PreferencesConstant.OPENED_FILES_ON_WORKSPACE, list);
        }
    }

    public static String[] getOpenedFilesDuringLastSession() {
        PreferencesService preferences = PreferencesServiceFactory.getInstance();
        String list = preferences.get(PreferencesConstant.OPENED_FILES_ON_WORKSPACE, "");
        StringTokenizer tokenizer = new StringTokenizer(list, PreferencesConstant.OPENED_FILES_SEPARATOR.toString());
        ArrayList<String> realPathList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String aPath = tokenizer.nextToken();
            File aFile = new File(aPath);
            if (!aFile.exists()) continue;
            realPathList.add(aPath);
        }
        Iterator iter = realPathList.iterator();
        list = "";
        while (iter.hasNext()) {
            String aPath = (String)iter.next();
            list = list + PreferencesConstant.OPENED_FILES_SEPARATOR + aPath;
        }
        preferences.put(PreferencesConstant.OPENED_FILES_ON_WORKSPACE, list);
        return realPathList.toArray(new String[realPathList.size()]);
    }

    public static void setActiveDiagramFile(String path) {
        if (path != null) {
            PreferencesService pService = PreferencesServiceFactory.getInstance();
            pService.put(PreferencesConstant.ACTIVE_FILE, path);
        }
    }

    public static String getActiveDiagramFile() {
        PreferencesService pService = PreferencesServiceFactory.getInstance();
        String path = pService.get(PreferencesConstant.ACTIVE_FILE, null);
        return path;
    }

    public static File getLastDir() {
        List<String> recentFiles = FileService.getRecentFiles();
        File lastDir = new File(".");
        if (recentFiles.size() > 0) {
            lastDir = new File(recentFiles.get(0)).getParentFile();
        }
        return lastDir;
    }
}

