/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.diagram;

import com.horstmann.violet.framework.gui.theme.ThemeManager;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Grid {
    private double gridx;
    private double gridy;

    public Grid() {
        this.setGrid(0.0, 0.0);
    }

    public void setGrid(double x, double y) {
        this.gridx = x;
        this.gridy = y;
    }

    public void draw(Graphics2D g2, Rectangle2D bounds) {
        if (this.gridx == 0.0 || this.gridy == 0.0) {
            return;
        }
        Color oldColor = g2.getColor();
        g2.setColor(ThemeManager.getInstance().getTheme().getGRID_COLOR());
        Stroke oldStroke = g2.getStroke();
        for (double x = bounds.getX(); x < bounds.getMaxX(); x += this.gridx) {
            g2.draw(new Line2D.Double(x, bounds.getY(), x, bounds.getMaxY()));
        }
        for (double y = bounds.getY(); y < bounds.getMaxY(); y += this.gridy) {
            g2.draw(new Line2D.Double(bounds.getX(), y, bounds.getMaxX(), y));
        }
        g2.setStroke(oldStroke);
        g2.setColor(oldColor);
    }

    public void snap(Point2D p) {
        double x = this.gridx == 0.0 ? p.getX() : (double)Math.round(p.getX() / this.gridx) * this.gridx;
        double y = this.gridy == 0.0 ? p.getY() : (double)Math.round(p.getY() / this.gridy) * this.gridy;
        p.setLocation(x, y);
    }

    public Rectangle2D snap(Rectangle2D r) {
        double h;
        double y;
        double w;
        double x;
        if (this.gridx == 0.0) {
            x = r.getX();
            w = r.getWidth();
        } else {
            x = (double)Math.round(r.getX() / this.gridx) * this.gridx;
            w = Math.ceil(r.getWidth() / (2.0 * this.gridx)) * (2.0 * this.gridx);
        }
        if (this.gridy == 0.0) {
            y = r.getY();
            h = r.getHeight();
        } else {
            y = (double)Math.round(r.getY() / this.gridy) * this.gridy;
            h = Math.ceil(r.getHeight() / (2.0 * this.gridy)) * (2.0 * this.gridy);
        }
        r.setFrame(x, y, w, h);
        return r;
    }

    public double getX() {
        return this.gridx;
    }

    public double getY() {
        return this.gridy;
    }
}

