/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.diagram;

import com.horstmann.violet.UMLEditor;
import com.horstmann.violet.framework.diagram.AbstractNode;
import com.horstmann.violet.framework.diagram.ArrowHead;
import com.horstmann.violet.framework.diagram.BentStyle;
import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.diagram.Grid;
import com.horstmann.violet.framework.diagram.LineStyle;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.framework.file.CustomPersistenceDelegate;
import com.horstmann.violet.framework.file.FileFormatService;
import com.horstmann.violet.framework.network.NetworkMessage;
import com.horstmann.violet.framework.util.ClipboardPipe;
import com.horstmann.violet.product.diagram.classes.ClassDiagramGraph;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.Statement;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class GraphService {
    public static Graph deserializeGraph(ByteBuffer buffer) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(buffer.array());
        Graph g = GraphService.readGraph(bis);
        bis.close();
        return g;
    }

    public static ByteBuffer serializeGraph(Graph g) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GraphService.write(g, (OutputStream)bos);
        ByteBuffer buffer = ByteBuffer.wrap(bos.toByteArray());
        bos.close();
        return buffer;
    }

    public static Object cloneItem(Object o) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            XMLEncoder encoder = GraphService.getXMLEncoder(bos);
            encoder.writeObject(o);
            encoder.close();
            ByteBuffer buffer = ByteBuffer.wrap(bos.toByteArray());
            bos.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(buffer.array());
            XMLDecoder reader = new XMLDecoder(bis);
            Object cloned = reader.readObject();
            bis.close();
            return cloned;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Node cloneNode(Node n) {
        AbstractNode clone = (AbstractNode)GraphService.cloneItem(n);
        clone.changeId();
        return clone;
    }

    public static Edge cloneEdge(Edge e) {
        return (Edge)GraphService.cloneItem(e);
    }

    public static BufferedImage getImage(Graph graph) {
        BufferedImage dummy = new BufferedImage(1, 1, 1);
        Rectangle2D bounds = graph.getBounds((Graphics2D)dummy.getGraphics());
        BufferedImage image = new BufferedImage((int)bounds.getWidth() + 1, (int)bounds.getHeight() + 1, 1);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.translate(-bounds.getX(), -bounds.getY());
        g2.setColor(Color.WHITE);
        g2.fill(new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth() + 1.0, bounds.getHeight() + 1.0));
        g2.setColor(Color.BLACK);
        g2.setBackground(Color.WHITE);
        graph.draw(g2, new Grid());
        return image;
    }

    public static void exportToclipBoard(Graph graph) {
        BufferedImage bImage = GraphService.getImage(graph);
        ClipboardPipe pipe = new ClipboardPipe(bImage);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(pipe, null);
    }

    public static void exportToXMI(Graph graph, OutputStream out) {
        if (!(graph instanceof ClassDiagramGraph)) {
            return;
        }
        try {
            ResourceBundle fileResourceBundle = ResourceBundle.getBundle("properties.FileStrings", Locale.getDefault());
            URL xslResource1 = GraphService.class.getResource(fileResourceBundle.getString("files.xmi.step1.xsl"));
            URL xslResource2 = GraphService.class.getResource(fileResourceBundle.getString("files.xmi.step2.xsl"));
            ByteArrayOutputStream graphOut = new ByteArrayOutputStream();
            GraphService.write(graph, (OutputStream)graphOut);
            ByteArrayInputStream graphIn = new ByteArrayInputStream(graphOut.toByteArray());
            ByteArrayOutputStream xmiOut = new ByteArrayOutputStream();
            InputStream xslResource1InputStream = xslResource1.openStream();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(xslResource1InputStream));
            transformer.transform(new StreamSource(graphIn), new StreamResult(xmiOut));
            ByteArrayInputStream xmiIn = new ByteArrayInputStream(xmiOut.toByteArray());
            InputStream xslResource2InputStream = xslResource2.openStream();
            transformer = factory.newTransformer(new StreamSource(xslResource2InputStream));
            transformer.transform(new StreamSource(xmiIn), new StreamResult(out));
            xslResource1InputStream.close();
            xslResource2InputStream.close();
            graphOut.close();
            graphIn.close();
            xmiOut.close();
            xmiIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void write(Graph graph, OutputStream out) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ClassLoader pcl = UMLEditor.getInstance().getPluginClassLoader();
        if (pcl != null) {
            Thread.currentThread().setContextClassLoader(pcl);
        }
        XMLEncoder encoder = GraphService.getXMLEncoder(FileFormatService.convertToViolet016(out));
        encoder.writeObject(graph);
        encoder.close();
        if (pcl != null) {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static void write(NetworkMessage msg, OutputStream out) {
        XMLEncoder encoder = GraphService.getXMLEncoder(FileFormatService.convertToViolet016(out));
        NetworkMessage.setPersistenceDelegate(encoder);
        encoder.writeObject(msg);
        encoder.close();
    }

    public static Graph readGraph(InputStream in) throws IOException {
        XMLDecoder reader = new XMLDecoder(FileFormatService.convertFromViolet016(in), null, new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception e) {
                e.printStackTrace();
            }
        }, UMLEditor.getInstance().getPluginClassLoader());
        Graph graph = (Graph)reader.readObject();
        in.close();
        return graph;
    }

    public static NetworkMessage readNetworkMessage(InputStream in) throws IOException {
        XMLDecoder reader = new XMLDecoder(FileFormatService.convertFromViolet016(in));
        NetworkMessage msg = (NetworkMessage)reader.readObject();
        in.close();
        return msg;
    }

    public static XMLEncoder getXMLEncoder(OutputStream out) {
        XMLEncoder encoder = new XMLEncoder(out);
        encoder.setExceptionListener(new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception ex) {
                ex.printStackTrace();
            }
        });
        encoder.setPersistenceDelegate(Point2D.Double.class, new DefaultPersistenceDelegate(){

            @Override
            protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
                super.initialize(type, oldInstance, newInstance, out);
                Point2D p = (Point2D)oldInstance;
                out.writeStatement(new Statement(oldInstance, "setLocation", new Object[]{new Double(p.getX()), new Double(p.getY())}));
            }
        });
        encoder.setPersistenceDelegate(Line2D.class, new DefaultPersistenceDelegate(){

            @Override
            protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
                super.initialize(type, oldInstance, newInstance, out);
                Line2D l = (Line2D)oldInstance;
                out.writeStatement(new Statement(oldInstance, "setLine", new Object[]{new Double(l.getX1()), new Double(l.getY1()), new Double(l.getX2()), new Double(l.getY2())}));
            }
        });
        encoder.setPersistenceDelegate(Rectangle2D.class, new DefaultPersistenceDelegate(){

            @Override
            protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
                super.initialize(type, oldInstance, newInstance, out);
                Rectangle2D r = (Rectangle2D)oldInstance;
                out.writeStatement(new Statement(oldInstance, "setRect", new Object[]{new Double(r.getX()), new Double(r.getY()), new Double(r.getWidth()), new Double(r.getHeight())}));
            }
        });
        encoder.setPersistenceDelegate(BentStyle.class, new CustomPersistenceDelegate());
        encoder.setPersistenceDelegate(LineStyle.class, new CustomPersistenceDelegate());
        encoder.setPersistenceDelegate(ArrowHead.class, new CustomPersistenceDelegate());
        encoder.setPersistenceDelegate(URL.class, new DefaultPersistenceDelegate(new String[]{"protocol", "host", "port", "file"}));
        encoder.setPersistenceDelegate(Map.class, new DefaultPersistenceDelegate(){

            @Override
            protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
                super.initialize(type, oldInstance, newInstance, out);
                Map map = (Map)oldInstance;
                for (Object key : map.keySet()) {
                    Object value = map.get(key);
                    out.writeStatement(new Statement(oldInstance, "put", new Object[]{key, value}));
                }
            }
        });
        Graph.setPersistenceDelegate(encoder);
        AbstractNode.setPersistenceDelegate(encoder);
        return encoder;
    }
}

