/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.diagram;

import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.GraphModificationListener;
import com.horstmann.violet.framework.diagram.Grid;
import com.horstmann.violet.framework.diagram.Node;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.beans.Statement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class Graph
implements Serializable,
Cloneable {
    private ArrayList<Node> nodes;
    private ArrayList<Edge> edges;
    private transient ArrayList<Node> nodesToBeRemoved;
    private transient ArrayList<Edge> edgesToBeRemoved;
    private transient int recursiveRemoves;
    private transient Rectangle2D minBounds;
    private transient ArrayList<GraphModificationListener> listeners = new ArrayList();

    public Graph() {
        this.nodes = new ArrayList();
        this.edges = new ArrayList();
        this.nodesToBeRemoved = new ArrayList();
        this.edgesToBeRemoved = new ArrayList();
    }

    public boolean addEdgeAtPoints(Edge e, Point2D p1, Point2D p2) {
        Node n1 = this.findNode(p1);
        Node n2 = this.findNode(p2);
        if (n1 != null) {
            e.connect(n1, n2);
            if (n1.checkAddEdge(e, p1, p2) && e.getEnd() != null) {
                if (!this.nodes.contains(e.getEnd())) {
                    this.add(e.getEnd());
                }
                this.edges.add(e);
                this.fireEdgeAdded(e);
                return true;
            }
        }
        return false;
    }

    public boolean addNodeAtPoint(Node newNode, Point2D p) {
        newNode.translate(p.getX() - newNode.getLocation().getX(), p.getY() - newNode.getLocation().getY());
        boolean accepted = false;
        boolean insideANode = false;
        int maxZ = 0;
        for (Node n : this.nodes) {
            if (n.getZ() <= maxZ) continue;
            maxZ = n.getZ();
        }
        for (int z = maxZ; !accepted && z >= 0; --z) {
            for (int i = 0; !accepted && i < this.nodes.size(); ++i) {
                Node n = this.nodes.get(i);
                if (n.getZ() != z || !n.contains(p)) continue;
                insideANode = true;
                accepted = n.checkAddNode(newNode, p);
            }
        }
        if (insideANode && !accepted) {
            return false;
        }
        this.add(newNode);
        return true;
    }

    public Node findNode(Point2D p) {
        int maxZ = 0;
        for (Node n : this.nodes) {
            if (n.getZ() <= maxZ) continue;
            maxZ = n.getZ();
        }
        for (int z = maxZ; z >= 0; --z) {
            for (Node n : this.nodes) {
                if (n.getZ() != z || !n.contains(p)) continue;
                return n;
            }
        }
        return null;
    }

    public Node findNode(String id) {
        for (Node n : this.nodes) {
            if (!n.getId().equals(id)) continue;
            return n;
        }
        return null;
    }

    public Edge findEdge(Point2D p) {
        for (Edge e : this.edges) {
            if (!e.contains(p)) continue;
            return e;
        }
        return null;
    }

    public Edge findEdge(String id) {
        for (Edge e : this.edges) {
            if (!e.getId().equals(id)) continue;
            return e;
        }
        return null;
    }

    public void draw(Graphics2D g2, Grid g) {
        int count = 0;
        int z = 0;
        while (count < this.nodes.size()) {
            for (Node n : this.nodes) {
                if (n.getZ() != z) continue;
                n.draw(g2);
                ++count;
            }
            ++z;
        }
        for (int i = 0; i < this.edges.size(); ++i) {
            Edge e = this.edges.get(i);
            e.draw(g2);
        }
    }

    public void removeNodesAndEdges(Collection<? extends Node> nodesToRemove, Collection<? extends Edge> edgesToRemove) {
        ++this.recursiveRemoves;
        if (nodesToRemove != null) {
            for (Node node : nodesToRemove) {
                if (this.nodesToBeRemoved.contains(node)) continue;
                for (Node n2 : this.nodes) {
                    n2.checkRemoveNode(node);
                }
                this.nodesToBeRemoved.add(node);
            }
        }
        if (edgesToRemove != null) {
            for (Edge edge : edgesToRemove) {
                if (this.edgesToBeRemoved.contains(edge)) continue;
                for (Node n1 : this.nodes) {
                    n1.checkRemoveEdge(edge);
                }
                this.edgesToBeRemoved.add(edge);
            }
        }
        --this.recursiveRemoves;
        if (this.recursiveRemoves > 0) {
            return;
        }
        for (Edge edge : this.edges) {
            if (this.edgesToBeRemoved.contains(edge) || !this.nodesToBeRemoved.contains(edge.getStart()) && !this.nodesToBeRemoved.contains(edge.getEnd())) continue;
            this.edgesToBeRemoved.add(edge);
        }
        this.edges.removeAll(this.edgesToBeRemoved);
        for (Edge edge : this.edgesToBeRemoved) {
            this.fireEdgeRemoved(edge);
        }
        this.edgesToBeRemoved.clear();
        for (Node node : this.nodes) {
            if (this.nodesToBeRemoved.contains(node)) continue;
            try {
                for (PropertyDescriptor descriptor : Introspector.getBeanInfo(node.getClass()).getPropertyDescriptors()) {
                    if (!Node.class.isAssignableFrom(descriptor.getPropertyType())) continue;
                    Node value = (Node)descriptor.getReadMethod().invoke((Object)node, new Object[0]);
                    if (this.nodesToBeRemoved.contains(value)) {
                        descriptor.getWriteMethod().invoke((Object)node, new Object[]{null});
                    }
                    this.firePropertyChange(node, descriptor.getName(), value, null);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (Node node : this.nodesToBeRemoved) {
            for (int i = node.getChildren().size() - 1; i >= 0; --i) {
                node.removeChild(node.getChildren().get(i));
            }
        }
        for (Node node : this.nodesToBeRemoved) {
            if (node.getParent() != null) {
                node.getParent().removeChild(node);
            }
            node.setGraph(null);
        }
        this.nodes.removeAll(this.nodesToBeRemoved);
        for (Node node : this.nodesToBeRemoved) {
            this.fireNodeRemoved(node);
        }
        this.nodesToBeRemoved.clear();
    }

    public void layout(Graphics2D g2, Grid gr) {
        for (Node n : this.nodes) {
            if (n.getParent() != null) continue;
            n.layout(g2, gr);
        }
    }

    public Rectangle2D getBounds(Graphics2D g2) {
        Rectangle2D r = this.minBounds;
        for (Node n : this.nodes) {
            Rectangle2D b = n.getBounds();
            if (r == null) {
                r = b;
                continue;
            }
            r.add(b);
        }
        for (Edge e : this.edges) {
            r.add(e.getBounds(g2));
        }
        return r == null ? new Rectangle2D.Double() : new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth() + 4.0, r.getHeight() + 4.0);
    }

    public void setMinBounds(Rectangle2D newValue) {
        this.minBounds = newValue;
    }

    public abstract Node[] getNodePrototypes();

    public abstract Edge[] getEdgePrototypes();

    public static void setPersistenceDelegate(Encoder encoder) {
        encoder.setPersistenceDelegate(Graph.class, new DefaultPersistenceDelegate(){

            @Override
            protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
                int i;
                super.initialize(type, oldInstance, newInstance, out);
                Graph g = (Graph)oldInstance;
                for (i = 0; i < g.nodes.size(); ++i) {
                    Node n = (Node)g.nodes.get(i);
                    Point2D p = n.getLocation();
                    out.writeStatement(new Statement(oldInstance, "addNode", new Object[]{n, p}));
                }
                for (i = 0; i < g.edges.size(); ++i) {
                    Edge e = (Edge)g.edges.get(i);
                    out.writeStatement(new Statement(oldInstance, "connect", new Object[]{e, e.getStart(), e.getEnd()}));
                }
            }
        });
    }

    public Collection<Node> getNodes() {
        return Collections.unmodifiableCollection(this.nodes);
    }

    public Collection<Edge> getEdges() {
        return Collections.unmodifiableCollection(this.edges);
    }

    public void addNode(Node n, Point2D p) {
        n.translate(p.getX() - n.getLocation().getX(), p.getY() - n.getLocation().getY());
        this.add(n);
    }

    public void removeNode(Node n) {
        Node p = n.getParent();
        if (p != null) {
            p.removeChild(n);
        }
        this.nodes.remove(n);
        n.setGraph(null);
        this.fireNodeRemoved(n);
    }

    public void connect(Edge e, Node start, Node end) {
        if (!this.nodes.contains(start)) {
            this.add(start);
        }
        if (!this.nodes.contains(end)) {
            this.add(end);
        }
        e.connect(start, end);
        this.edges.add(e);
        this.fireEdgeAdded(e);
    }

    public void connect(Edge e, Node aStart, Point2D sPoint, Node anEnd, Point2D ePoint) {
        this.connect(e, aStart, anEnd);
    }

    public void removeEdge(Edge e) {
        this.edges.remove(e);
        this.fireEdgeRemoved(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGraphModificationListener(GraphModificationListener listener) {
        ArrayList<GraphModificationListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeGraphModificationListener(GraphModificationListener listener) {
        ArrayList<GraphModificationListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    private void add(Node n) {
        this.nodes.add(n);
        n.setGraph(this);
        this.fireNodeAdded(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GraphModificationListener> cloneListeners() {
        ArrayList<GraphModificationListener> arrayList = this.listeners;
        synchronized (arrayList) {
            return (List)this.listeners.clone();
        }
    }

    public void fireNodeAdded(Node n) {
        for (GraphModificationListener listener : this.cloneListeners()) {
            listener.nodeAdded(this, n);
        }
    }

    public void fireNodeRemoved(Node n) {
        for (GraphModificationListener listener : this.cloneListeners()) {
            listener.nodeRemoved(this, n);
        }
    }

    public void fireChildAttached(int index, Node p, Node c) {
        for (GraphModificationListener listener : this.cloneListeners()) {
            listener.childAttached(this, index, p, c);
        }
    }

    public void fireChildDetached(int index, Node p, Node c) {
        for (GraphModificationListener listener : this.cloneListeners()) {
            listener.childDetached(this, index, p, c);
        }
    }

    public void fireEdgeAdded(Edge e) {
        for (GraphModificationListener listener : this.cloneListeners()) {
            listener.edgeAdded(this, e);
        }
    }

    public void fireEdgeRemoved(Edge e) {
        for (GraphModificationListener listener : this.cloneListeners()) {
            listener.edgeRemoved(this, e);
        }
    }

    public void fireNodeMoved(Node node, double dx, double dy) {
        if (dx == 0.0 && dy == 0.0) {
            return;
        }
        for (GraphModificationListener listener : this.cloneListeners()) {
            listener.nodeMoved(this, node, dx, dy);
        }
    }

    public void firePropertyChange(Object obj, String propertyName, Object oldValue, Object newValue) {
        if (oldValue == newValue) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(obj, propertyName, oldValue, newValue);
        for (GraphModificationListener listener : this.cloneListeners()) {
            listener.propertyChange(event);
        }
    }
}

